/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.SymbolicJVMCIReference;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;

public abstract class Stamp
implements SpeculationReasonGroup.SpeculationContextObject {
    protected Stamp() {
    }

    public abstract ResolvedJavaType javaType(MetaAccessProvider var1);

    public boolean alwaysDistinct(Stamp other) {
        return this.join(other).isEmpty();
    }

    public abstract JavaKind getStackKind();

    public abstract LIRKind getLIRKind(LIRKindTool var1);

    public abstract Stamp meet(Stamp var1);

    public abstract Stamp join(Stamp var1);

    public abstract Stamp unrestricted();

    public abstract Stamp empty();

    public abstract Stamp constant(Constant var1, MetaAccessProvider var2);

    public abstract boolean isCompatible(Stamp var1);

    public abstract boolean isCompatible(Constant var1);

    public abstract boolean hasValues();

    public final boolean isEmpty() {
        return !this.hasValues();
    }

    public boolean isUnrestricted() {
        return this.equals(this.unrestricted());
    }

    public boolean isPointerStamp() {
        return this instanceof AbstractPointerStamp;
    }

    public boolean isIntegerStamp() {
        return this instanceof IntegerStamp;
    }

    public boolean isFloatStamp() {
        return this instanceof FloatStamp;
    }

    public boolean isObjectStamp() {
        return this instanceof AbstractObjectStamp;
    }

    public boolean isNonObjectPointerStamp() {
        return this.isPointerStamp() && !this.isObjectStamp();
    }

    public boolean isBottomArrayType() {
        if (this.isObjectStamp()) {
            ObjectStamp o = (ObjectStamp)this;
            return o.isAlwaysArray() && o.type() == null;
        }
        return false;
    }

    public Constant asConstant() {
        return null;
    }

    public abstract Constant readConstant(MemoryAccessProvider var1, Constant var2, long var3);

    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement, Stamp accessStamp) {
        if (this.equals(accessStamp)) {
            return this.readConstant(provider, base, displacement);
        }
        throw new IllegalArgumentException("Access mismatch:" + String.valueOf(this) + " != " + String.valueOf(accessStamp));
    }

    public abstract Stamp improveWith(Stamp var1);

    public boolean canBeImprovedWith(Stamp other) {
        return !this.improveWith(other).equals(this);
    }

    public final Stamp tryImproveWith(Stamp other) {
        Stamp improved = this.improveWith(other);
        if (improved.equals(this)) {
            return null;
        }
        return improved;
    }

    public boolean neverDistinct(Stamp other) {
        Constant constant = this.asConstant();
        if (constant != null) {
            Constant otherConstant = other.asConstant();
            return otherConstant != null && constant.equals((Object)otherConstant);
        }
        return false;
    }

    public TriState tryConstantFold(Condition condition, Constant x, Constant y, boolean unorderedIsTrue, ConstantReflectionProvider constantReflection) {
        if (x instanceof PrimitiveConstant) {
            PrimitiveConstant lp = (PrimitiveConstant)x;
            PrimitiveConstant rp = (PrimitiveConstant)y;
            return TriState.get((boolean)condition.foldCondition(lp, rp, unorderedIsTrue));
        }
        Boolean equal = constantReflection.constantEquals(x, y);
        if (equal == null) {
            return TriState.UNKNOWN;
        }
        switch (condition) {
            case EQ: {
                return TriState.get((boolean)equal);
            }
            case NE: {
                return TriState.get((equal == false ? 1 : 0) != 0);
            }
        }
        return TriState.UNKNOWN;
    }

    public SymbolicJVMCIReference<? extends Stamp> makeSymbolic() {
        return null;
    }

    public abstract String toString();
}

