/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.SymbolicJVMCIReference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;

public class ObjectStamp
extends AbstractObjectStamp {
    public ObjectStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, boolean alwaysArray) {
        super(type, exactType, nonNull, alwaysNull, alwaysArray);
    }

    @Override
    protected ObjectStamp copyWith(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, boolean alwaysArray) {
        return new ObjectStamp(type, exactType, nonNull, alwaysNull, alwaysArray);
    }

    @Override
    public Stamp unrestricted() {
        return StampFactory.object();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('a');
        this.appendString(str);
        return str.toString();
    }

    @Override
    public boolean isCompatible(Stamp other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObjectStamp;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof JavaConstant) {
            return ((JavaConstant)constant).getJavaKind().isObject();
        }
        return false;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getObjectKind();
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        try {
            return provider.readObjectConstant(base, displacement);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public SymbolicJVMCIReference<ObjectStamp> makeSymbolic() {
        if (this.type() == null) {
            return null;
        }
        return new SymbolicObjectStamp(this);
    }

    static class SymbolicObjectStamp
    implements SymbolicJVMCIReference<ObjectStamp> {
        UnresolvedJavaType type;
        private final boolean exactType;
        private final boolean nonNull;
        private final boolean alwaysNull;
        private final boolean alwaysArray;

        SymbolicObjectStamp(ObjectStamp stamp) {
            if (stamp.type() != null) {
                this.type = UnresolvedJavaType.create((String)stamp.type().getName());
            }
            this.exactType = stamp.isExactType();
            this.nonNull = stamp.nonNull();
            this.alwaysNull = stamp.alwaysNull();
            this.alwaysArray = stamp.isAlwaysArray();
        }

        @Override
        public ObjectStamp resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaType resolvedType = null;
            if (this.type != null && (resolvedType = this.type.resolve(accessingClass)) == null) {
                throw new NoClassDefFoundError("Can't resolve " + this.type.getName() + " with " + accessingClass.getName());
            }
            return new ObjectStamp(resolvedType, this.exactType, this.nonNull, this.alwaysNull, this.alwaysArray);
        }

        public String toString() {
            return "SymbolicObjectStamp{declaringType=" + String.valueOf(this.type) + ", exactType=" + this.exactType + ", nonNull=" + this.nonNull + ", alwaysNull=" + this.alwaysNull + ", alwaysArray=" + this.alwaysArray + "}";
        }
    }
}

