/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.calc.ReinterpretUtils;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;

public final class IntegerStamp
extends PrimitiveStamp {
    private final long lowerBound;
    private final long upperBound;
    private final long mustBeSet;
    private final long mayBeSet;
    private final boolean canBeZero;
    static final int ITERATION_LIMIT = 3;
    public static final ArithmeticOpTable OPS = new ArithmeticOpTable(new ArithmeticOpTable.UnaryOp.Neg(){

        @Override
        public Constant foldConstant(Constant value) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            return JavaConstant.forIntegerKind((JavaKind)c.getJavaKind(), (long)(-c.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            IntegerStamp stamp = (IntegerStamp)s;
            int bits = stamp.getBits();
            if (stamp.lowerBound == stamp.upperBound) {
                long value = CodeUtil.convert((long)(-stamp.lowerBound()), (int)stamp.getBits(), (boolean)false);
                return IntegerStamp.createConstant(stamp.getBits(), value);
            }
            long newMayBeSet = (CodeUtil.mask((int)Long.numberOfTrailingZeros(stamp.mayBeSet)) ^ 0xFFFFFFFFFFFFFFFFL) & CodeUtil.mask((int)bits);
            if (stamp.lowerBound() != CodeUtil.minValue((int)bits)) {
                return IntegerStamp.create(bits, -stamp.upperBound(), -stamp.lowerBound(), 0L, newMayBeSet);
            }
            return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
        }
    }, new ArithmeticOpTable.BinaryOp.Add(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() + b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            long newUpperBound;
            long newLowerBound;
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            int bits = a.getBits();
            assert (bits == b.getBits()) : String.format("stamp1.bits=%d, stamp2.bits=%d", bits, b.getBits());
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound) {
                long value = CodeUtil.convert((long)(a.lowerBound() + b.lowerBound()), (int)a.getBits(), (boolean)false);
                return IntegerStamp.createConstant(a.getBits(), value);
            }
            if (a.isUnrestricted()) {
                return a;
            }
            if (b.isUnrestricted()) {
                return b;
            }
            long defaultMask = CodeUtil.mask((int)bits);
            long variableBits = a.mustBeSet() ^ a.mayBeSet() | b.mustBeSet() ^ b.mayBeSet();
            long variableBitsWithCarry = variableBits | IntegerStamp.carryBits(a.mustBeSet(), b.mustBeSet()) ^ IntegerStamp.carryBits(a.mayBeSet(), b.mayBeSet());
            long newMustBeSet = a.mustBeSet() + b.mustBeSet() & (variableBitsWithCarry ^ 0xFFFFFFFFFFFFFFFFL);
            long newMayBeSet = a.mustBeSet() + b.mustBeSet() | variableBitsWithCarry;
            newMustBeSet &= defaultMask;
            newMayBeSet &= defaultMask;
            boolean lowerOverflowsPositively = IntegerStamp.addOverflowsPositively(a.lowerBound(), b.lowerBound(), bits);
            boolean upperOverflowsPositively = IntegerStamp.addOverflowsPositively(a.upperBound(), b.upperBound(), bits);
            boolean lowerOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.lowerBound(), b.lowerBound(), bits);
            boolean upperOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.upperBound(), b.upperBound(), bits);
            if (lowerOverflowsNegatively && !upperOverflowsNegatively || !lowerOverflowsPositively && upperOverflowsPositively) {
                newLowerBound = CodeUtil.minValue((int)bits);
                newUpperBound = CodeUtil.maxValue((int)bits);
            } else {
                newLowerBound = CodeUtil.signExtend((long)(a.lowerBound() + b.lowerBound() & defaultMask), (int)bits);
                newUpperBound = CodeUtil.signExtend((long)(a.upperBound() + b.upperBound() & defaultMask), (int)bits);
            }
            IntegerStamp limit = IntegerStamp.create(bits, newLowerBound, newUpperBound);
            newUpperBound = CodeUtil.signExtend((long)(newUpperBound & (newMayBeSet &= limit.mayBeSet())), (int)bits);
            return IntegerStamp.create(bits, newLowerBound |= (newMustBeSet |= limit.mustBeSet()), newUpperBound, newMustBeSet, newMayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }
    }, new ArithmeticOpTable.BinaryOp.Sub(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() - b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            return OPS.getAdd().foldStamp(a, OPS.getNeg().foldStamp(b));
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }

        @Override
        public Constant getZero(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            return JavaConstant.forPrimitiveInt((int)stamp.getBits(), (long)0L);
        }
    }, new ArithmeticOpTable.BinaryOp.Mul(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() * b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            long minCandidate;
            long maxCandidate;
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            int bits = a.getBits();
            assert (bits == b.getBits()) : Assertions.errorMessage(a, b);
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound) {
                long value = CodeUtil.convert((long)(a.lowerBound() * b.lowerBound()), (int)a.getBits(), (boolean)false);
                return IntegerStamp.createConstant(a.getBits(), value);
            }
            if (a.mayBeSet() == 0L) {
                return a;
            }
            if (b.mayBeSet() == 0L) {
                return b;
            }
            if (b.lowerBound == b.upperBound && NumUtil.isUnsignedPowerOf2(CodeUtil.mask((int)bits) & b.upperBound)) {
                int shiftAmount = NumUtil.unsignedLog2(CodeUtil.mask((int)bits) & b.upperBound);
                return OPS.getShl().foldStamp(a, IntegerStamp.createConstant(bits, shiftAmount));
            }
            if (a.lowerBound == a.upperBound && NumUtil.isUnsignedPowerOf2(CodeUtil.mask((int)bits) & a.upperBound)) {
                int shiftAmount = NumUtil.unsignedLog2(CodeUtil.mask((int)bits) & a.upperBound);
                return OPS.getShl().foldStamp(b, IntegerStamp.createConstant(bits, shiftAmount));
            }
            if (Long.numberOfTrailingZeros(a.mayBeSet) <= 0 && Long.numberOfTrailingZeros(b.mayBeSet) <= 0) {
                if (a.isUnrestricted()) {
                    return a;
                }
                if (b.isUnrestricted()) {
                    return b;
                }
            }
            long newLowerBound = Long.MAX_VALUE;
            long newUpperBound = Long.MIN_VALUE;
            long minNegA = a.lowerBound();
            long maxNegA = Math.min(0L, a.upperBound());
            long minPosA = Math.max(0L, a.lowerBound());
            long maxPosA = a.upperBound();
            long minNegB = b.lowerBound();
            long maxNegB = Math.min(0L, b.upperBound());
            long minPosB = Math.max(0L, b.lowerBound());
            long maxPosB = b.upperBound();
            long newMayBeSet = (CodeUtil.mask((int)Math.min(64, Long.numberOfTrailingZeros(a.mayBeSet) + Long.numberOfTrailingZeros(b.mayBeSet))) ^ 0xFFFFFFFFFFFFFFFFL) & CodeUtil.mask((int)bits);
            if (a.canBePositive()) {
                if (b.canBePositive()) {
                    if (IntegerStamp.multiplicationOverflows(maxPosA, maxPosB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    maxCandidate = maxPosA * maxPosB;
                    if (IntegerStamp.multiplicationOverflows(minPosA, minPosB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    minCandidate = minPosA * minPosB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
                if (b.canBeNegative()) {
                    if (IntegerStamp.multiplicationOverflows(minPosA, maxNegB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    maxCandidate = minPosA * maxNegB;
                    if (IntegerStamp.multiplicationOverflows(maxPosA, minNegB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    minCandidate = maxPosA * minNegB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
            }
            if (a.canBeNegative()) {
                if (b.canBePositive()) {
                    if (IntegerStamp.multiplicationOverflows(maxNegA, minPosB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    maxCandidate = maxNegA * minPosB;
                    if (IntegerStamp.multiplicationOverflows(minNegA, maxPosB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    minCandidate = minNegA * maxPosB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
                if (b.canBeNegative()) {
                    if (IntegerStamp.multiplicationOverflows(minNegA, minNegB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    maxCandidate = minNegA * minNegB;
                    if (IntegerStamp.multiplicationOverflows(maxNegA, maxNegB, bits)) {
                        return IntegerStamp.stampForMask(bits, 0L, newMayBeSet);
                    }
                    minCandidate = maxNegA * maxNegB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
            }
            assert (newLowerBound <= newUpperBound) : Assertions.errorMessageContext("newLowerBound", newLowerBound, "newUpperBonud", newUpperBound, "stamp1", stamp1, "stamp2", stamp2);
            return StampFactory.forIntegerWithMask(bits, newLowerBound, newUpperBound, 0L, newMayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 1L;
        }
    }, new ArithmeticOpTable.BinaryOp.MulHigh(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)this.multiplyHigh(a.asLong(), b.asLong(), a.getJavaKind()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            JavaKind javaKind = a.getStackKind();
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            assert (javaKind == b.getStackKind()) : Assertions.errorMessageContext("stamp1", stamp1, "stamp2", stamp2);
            assert (javaKind == JavaKind.Int || javaKind == JavaKind.Long) : javaKind;
            if (a.isEmpty() || b.isEmpty()) {
                return a.empty();
            }
            if (a.isUnrestricted() || b.isUnrestricted()) {
                return a.unrestricted();
            }
            long[] xExtremes = new long[]{a.lowerBound(), a.upperBound()};
            long[] yExtremes = new long[]{b.lowerBound(), b.upperBound()};
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (long x : xExtremes) {
                for (long y : yExtremes) {
                    long result = this.multiplyHigh(x, y, javaKind);
                    min = Math.min(min, result);
                    max = Math.max(max, result);
                }
            }
            return StampFactory.forInteger(javaKind, min, max);
        }

        @Override
        public boolean isNeutral(Constant value) {
            return false;
        }

        private long multiplyHigh(long x, long y, JavaKind javaKind) {
            if (javaKind == JavaKind.Int) {
                return x * y >> 32;
            }
            assert (javaKind == JavaKind.Long) : javaKind;
            long x0 = x & 0xFFFFFFFFL;
            long x1 = x >> 32;
            long y0 = y & 0xFFFFFFFFL;
            long y1 = y >> 32;
            long z0 = x0 * y0;
            long t = x1 * y0 + (z0 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z2 = t >> 32;
            return x1 * y1 + z2 + ((z1 += x0 * y1) >> 32);
        }
    }, new ArithmeticOpTable.BinaryOp.UMulHigh(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)this.multiplyHighUnsigned(a.asLong(), b.asLong(), a.getJavaKind()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            JavaKind javaKind = a.getStackKind();
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            assert (javaKind == b.getStackKind()) : Assertions.errorMessageContext("stamp1", stamp1, "stamp2", stamp2);
            assert (javaKind == JavaKind.Int || javaKind == JavaKind.Long) : javaKind;
            if (a.isEmpty() || b.isEmpty()) {
                return a.empty();
            }
            if (a.isUnrestricted() || b.isUnrestricted()) {
                return a.unrestricted();
            }
            long[] xExtremes = this.getUnsignedExtremes(a);
            long[] yExtremes = this.getUnsignedExtremes(b);
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (long x : xExtremes) {
                for (long y : yExtremes) {
                    long result = this.multiplyHighUnsigned(x, y, javaKind);
                    min = Math.min(min, result);
                    max = Math.max(max, result);
                }
            }
            if (min == max || min >= 0L) {
                return StampFactory.forInteger(javaKind, min, max);
            }
            return StampFactory.forKind(javaKind);
        }

        @Override
        public boolean isNeutral(Constant value) {
            return false;
        }

        private long[] getUnsignedExtremes(IntegerStamp stamp) {
            if (stamp.lowerBound() < 0L && stamp.upperBound() >= 0L) {
                return new long[]{0L, -1L};
            }
            return new long[]{stamp.lowerBound(), stamp.upperBound()};
        }

        private long multiplyHighUnsigned(long x, long y, JavaKind javaKind) {
            if (javaKind == JavaKind.Int) {
                long xl = x & 0xFFFFFFFFL;
                long yl = y & 0xFFFFFFFFL;
                long r = xl * yl;
                return (int)(r >>> 32);
            }
            assert (javaKind == JavaKind.Long) : javaKind;
            long x0 = x & 0xFFFFFFFFL;
            long x1 = x >>> 32;
            long y0 = y & 0xFFFFFFFFL;
            long y1 = y >>> 32;
            long z0 = x0 * y0;
            long t = x1 * y0 + (z0 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z2 = t >>> 32;
            return x1 * y1 + z2 + ((z1 += x0 * y1) >>> 32);
        }
    }, new ArithmeticOpTable.BinaryOp.Div(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            if (b.asLong() == 0L) {
                return null;
            }
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() / b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound && b.lowerBound != 0L) {
                long value = CodeUtil.convert((long)(a.lowerBound() / b.lowerBound()), (int)a.getBits(), (boolean)false);
                return IntegerStamp.createConstant(a.getBits(), value);
            }
            if (b.isStrictlyPositive()) {
                long newLowerBound = a.lowerBound() < 0L ? a.lowerBound() / b.lowerBound() : a.lowerBound() / b.upperBound();
                long newUpperBound = a.upperBound() < 0L ? a.upperBound() / b.upperBound() : a.upperBound() / b.lowerBound();
                return IntegerStamp.create(a.getBits(), newLowerBound, newUpperBound);
            }
            return a.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 1L;
        }
    }, new ArithmeticOpTable.BinaryOp.Rem(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            if (b.asLong() == 0L) {
                return null;
            }
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() % b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            long magnitude;
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound && b.lowerBound != 0L) {
                long value = CodeUtil.convert((long)(a.lowerBound() % b.lowerBound()), (int)a.getBits(), (boolean)false);
                return IntegerStamp.createConstant(a.getBits(), value);
            }
            long newLowerBound = Math.min(a.lowerBound(), 0L);
            long newUpperBound = Math.max(a.upperBound(), 0L);
            if (b.lowerBound() == CodeUtil.minValue((int)b.getBits())) {
                magnitude = CodeUtil.maxValue((int)b.getBits());
            } else {
                try {
                    magnitude = Math.max(NumUtil.safeAbs(b.lowerBound()), NumUtil.safeAbs(b.upperBound())) - 1L;
                }
                catch (ArithmeticException e) {
                    return stamp1.unrestricted();
                }
            }
            newLowerBound = Math.max(newLowerBound, -magnitude);
            newUpperBound = Math.min(newUpperBound, magnitude);
            if (newLowerBound > newUpperBound) {
                return stamp1.unrestricted();
            }
            return IntegerStamp.create(a.getBits(), newLowerBound, newUpperBound);
        }
    }, new ArithmeticOpTable.UnaryOp.Not(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forIntegerKind((JavaKind)value.getJavaKind(), (long)(value.asLong() ^ 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return stamp;
            }
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            int bits = integerStamp.getBits();
            long defaultMask = CodeUtil.mask((int)bits);
            long lowerBoundInput = integerStamp.upperBound() ^ 0xFFFFFFFFFFFFFFFFL;
            long upperBoundInput = integerStamp.lowerBound() ^ 0xFFFFFFFFFFFFFFFFL;
            long mustBeSet1 = (integerStamp.mayBeSet() ^ 0xFFFFFFFFFFFFFFFFL) & defaultMask;
            long mayBeSet1 = (integerStamp.mustBeSet() ^ 0xFFFFFFFFFFFFFFFFL) & defaultMask;
            return IntegerStamp.create(bits, lowerBoundInput, upperBoundInput, mustBeSet1, mayBeSet1);
        }
    }, new ArithmeticOpTable.BinaryOp.And(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() & b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            int bits = a.getBits();
            long mustBeSet = a.mustBeSet & b.mustBeSet;
            long mayBeSet = a.mayBeSet & b.mayBeSet;
            if (IntegerStamp.significantBit(bits, mayBeSet) == 0L) {
                long upperBound = IntegerStamp.maxValueForMasks(bits, mustBeSet, mayBeSet);
                if (a.lowerBound >= 0L) {
                    upperBound = Math.min(upperBound, a.upperBound);
                }
                if (b.lowerBound >= 0L) {
                    upperBound = Math.min(upperBound, b.upperBound);
                }
                return IntegerStamp.create(bits, 0L, upperBound, mustBeSet, mayBeSet);
            }
            if (IntegerStamp.significantBit(bits, mustBeSet) == 1L) {
                long upperBound = Math.min(IntegerStamp.maxValueForMasks(bits, mustBeSet, mayBeSet), Math.min(a.upperBound, b.upperBound));
                return IntegerStamp.create(bits, IntegerStamp.minValueForMasks(bits, mustBeSet, mayBeSet), upperBound, mustBeSet, mayBeSet);
            }
            return IntegerStamp.stampForMask(bits, mustBeSet, mayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            int bits = n.getJavaKind().getBitCount();
            long mask = CodeUtil.mask((int)bits);
            return (n.asLong() & mask) == mask;
        }
    }, new ArithmeticOpTable.BinaryOp.Or(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() | b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            return IntegerStamp.stampForMask(a.getBits(), a.mustBeSet() | b.mustBeSet(), a.mayBeSet() | b.mayBeSet());
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }
    }, new ArithmeticOpTable.BinaryOp.Xor(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Kind must match " + Assertions.errorMessageContext("a", a, "b", b);
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() ^ b.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
            if (b.lowerBound == -1L && b.upperBound == -1L) {
                return OPS.getNot().foldStamp(a);
            }
            if (a.lowerBound == -1L && a.upperBound == -1L) {
                return OPS.getNot().foldStamp(b);
            }
            long variableBits = a.mustBeSet() ^ a.mayBeSet() | b.mustBeSet() ^ b.mayBeSet();
            long newMustBeSet = (a.mustBeSet() ^ b.mustBeSet()) & (variableBits ^ 0xFFFFFFFFFFFFFFFFL);
            long newMayBeSet = a.mustBeSet() ^ b.mustBeSet() | variableBits;
            return IntegerStamp.stampForMask(a.getBits(), newMustBeSet, newMayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }

        @Override
        public Constant getZero(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            return JavaConstant.forPrimitiveInt((int)stamp.getBits(), (long)0L);
        }
    }, new ArithmeticOpTable.ShiftOp.Shl(){

        @Override
        public Constant foldConstant(Constant value, Constant amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            PrimitiveConstant s = (PrimitiveConstant)amount;
            long shift = s.getJavaKind() == JavaKind.Long ? s.asLong() : (long)s.asInt();
            return switch (c.getJavaKind()) {
                case JavaKind.Byte -> JavaConstant.forByte((byte)((byte)(c.asInt() << (int)shift)));
                case JavaKind.Char -> JavaConstant.forChar((char)((char)(c.asInt() << (int)shift)));
                case JavaKind.Short -> JavaConstant.forShort((short)((short)(c.asInt() << (int)shift)));
                case JavaKind.Int -> JavaConstant.forInt((int)(c.asInt() << (int)shift));
                case JavaKind.Long -> JavaConstant.forLong((long)(c.asLong() << (int)shift));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(c.getJavaKind());
            };
        }

        private boolean testNoSignChangeAfterShifting(int bits, long value, int shiftAmount) {
            long removedBits = -1L << bits - shiftAmount - 1;
            if (value < 0L) {
                return (value & removedBits) == removedBits;
            }
            return (value & removedBits) == 0L;
        }

        @Override
        public Stamp foldStampImpl(Stamp stamp, Stamp amount) {
            IntegerStamp value = (IntegerStamp)stamp;
            IntegerStamp shift = (IntegerStamp)amount;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return IntegerStamp.createEmptyStamp(bits);
            }
            if (value.mayBeSet() == 0L) {
                return value;
            }
            int shiftMask = this.getShiftAmountMask(stamp);
            int shiftBits = Integer.bitCount(shiftMask);
            if (shift.lowerBound() == shift.upperBound()) {
                int shiftAmount = (int)(shift.lowerBound() & (long)shiftMask);
                if (shiftAmount == 0) {
                    return value;
                }
                if (shiftAmount >= bits) {
                    IntegerStamp result = IntegerStamp.create(bits, 0L, 0L, 0L, 0L);
                    return result;
                }
                if (this.testNoSignChangeAfterShifting(bits, value.lowerBound(), shiftAmount) && this.testNoSignChangeAfterShifting(bits, value.upperBound(), shiftAmount)) {
                    IntegerStamp result = IntegerStamp.create(bits, value.lowerBound() << shiftAmount, value.upperBound() << shiftAmount, value.mustBeSet() << shiftAmount & CodeUtil.mask((int)bits), value.mayBeSet() << shiftAmount & CodeUtil.mask((int)bits));
                    return result;
                }
            }
            if (shift.lowerBound() >>> shiftBits == shift.upperBound() >>> shiftBits) {
                long defaultMask;
                long mustBeSet = defaultMask = CodeUtil.mask((int)bits);
                long mayBeSet = 0L;
                for (long i = shift.lowerBound(); i <= shift.upperBound(); ++i) {
                    if (!shift.contains(i)) continue;
                    mustBeSet &= value.mustBeSet() << (int)(i & (long)shiftMask);
                    mayBeSet |= value.mayBeSet() << (int)(i & (long)shiftMask);
                }
                return IntegerStamp.stampForMask(bits, mustBeSet, mayBeSet & defaultMask);
            }
            return value.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant c) {
            PrimitiveConstant pc;
            return c instanceof PrimitiveConstant && (pc = (PrimitiveConstant)c).asLong() == 0L;
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            return s.getStackKind().getBitCount() - 1;
        }
    }, new ArithmeticOpTable.ShiftOp.Shr(){

        @Override
        public Constant foldConstant(Constant value, Constant amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            PrimitiveConstant s = (PrimitiveConstant)amount;
            long shift = s.getJavaKind() == JavaKind.Long ? s.asLong() : (long)s.asInt();
            return switch (c.getJavaKind()) {
                case JavaKind.Byte -> JavaConstant.forByte((byte)((byte)(c.asInt() >> (int)shift)));
                case JavaKind.Char -> JavaConstant.forChar((char)((char)(c.asInt() >> (int)shift)));
                case JavaKind.Short -> JavaConstant.forShort((short)((short)(c.asInt() >> (int)shift)));
                case JavaKind.Int -> JavaConstant.forInt((int)(c.asInt() >> (int)shift));
                case JavaKind.Long -> JavaConstant.forLong((long)(c.asLong() >> (int)shift));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(c.getJavaKind());
            };
        }

        @Override
        public Stamp foldStampImpl(Stamp stamp, Stamp amount) {
            IntegerStamp value = (IntegerStamp)stamp;
            IntegerStamp shift = (IntegerStamp)amount;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return IntegerStamp.createEmptyStamp(bits);
            }
            if (shift.lowerBound() == shift.upperBound()) {
                long shiftCount = shift.lowerBound() & (long)this.getShiftAmountMask(stamp);
                if (shiftCount == 0L) {
                    return stamp;
                }
                int extraBits = 64 - bits;
                long defaultMask = CodeUtil.mask((int)bits);
                long mustBeSet = value.mustBeSet() << extraBits >> (int)(shiftCount + (long)extraBits) & defaultMask;
                long mayBeSet = value.mayBeSet() << extraBits >> (int)(shiftCount + (long)extraBits) & defaultMask;
                return IntegerStamp.create(bits, value.lowerBound() >> (int)shiftCount, value.upperBound() >> (int)shiftCount, mustBeSet, mayBeSet);
            }
            long mask = IntegerStamp.mayBeSetFor(bits, value.lowerBound(), value.upperBound());
            return IntegerStamp.stampForMask(bits, 0L, mask);
        }

        @Override
        public boolean isNeutral(Constant c) {
            PrimitiveConstant pc;
            return c instanceof PrimitiveConstant && (pc = (PrimitiveConstant)c).asLong() == 0L;
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            return s.getStackKind().getBitCount() - 1;
        }
    }, new ArithmeticOpTable.ShiftOp.UShr(){

        @Override
        public Constant foldConstant(Constant value, Constant amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            PrimitiveConstant s = (PrimitiveConstant)amount;
            long shift = s.getJavaKind() == JavaKind.Long ? s.asLong() : (long)s.asInt();
            return switch (c.getJavaKind()) {
                case JavaKind.Byte -> JavaConstant.forByte((byte)((byte)(c.asInt() >>> (int)shift)));
                case JavaKind.Char -> JavaConstant.forChar((char)((char)(c.asInt() >>> (int)shift)));
                case JavaKind.Short -> JavaConstant.forShort((short)((short)(c.asInt() >>> (int)shift)));
                case JavaKind.Int -> JavaConstant.forInt((int)(c.asInt() >>> (int)shift));
                case JavaKind.Long -> JavaConstant.forLong((long)(c.asLong() >>> (int)shift));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(c.getJavaKind());
            };
        }

        @Override
        public Stamp foldStampImpl(Stamp stamp, Stamp amount) {
            IntegerStamp value = (IntegerStamp)stamp;
            IntegerStamp shift = (IntegerStamp)amount;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return IntegerStamp.createEmptyStamp(bits);
            }
            if (shift.lowerBound() == shift.upperBound()) {
                long shiftCount = shift.lowerBound() & (long)this.getShiftAmountMask(stamp);
                if (shiftCount == 0L) {
                    return stamp;
                }
                long mustBeSet = value.mustBeSet() >>> (int)shiftCount;
                long mayBeSet = value.mayBeSet() >>> (int)shiftCount;
                if (value.lowerBound() < 0L) {
                    return IntegerStamp.create(bits, mustBeSet, mayBeSet, mustBeSet, mayBeSet);
                }
                return IntegerStamp.create(bits, value.lowerBound() >>> (int)shiftCount, value.upperBound() >>> (int)shiftCount, mustBeSet, mayBeSet);
            }
            long mask = IntegerStamp.mayBeSetFor(bits, value.lowerBound(), value.upperBound());
            return IntegerStamp.stampForMask(bits, 0L, mask);
        }

        @Override
        public boolean isNeutral(Constant c) {
            PrimitiveConstant pc;
            return c instanceof PrimitiveConstant && (pc = (PrimitiveConstant)c).asLong() == 0L;
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            return s.getStackKind().getBitCount() - 1;
        }
    }, new ArithmeticOpTable.UnaryOp.Abs(){

        @Override
        public Constant foldConstant(Constant value) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            return JavaConstant.forIntegerKind((JavaKind)c.getJavaKind(), (long)NumUtil.unsafeAbs(c.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp input) {
            if (input.isEmpty()) {
                return input;
            }
            IntegerStamp stamp = (IntegerStamp)input;
            int bits = stamp.getBits();
            if (stamp.lowerBound == stamp.upperBound) {
                long value = CodeUtil.convert((long)NumUtil.unsafeAbs(stamp.lowerBound()), (int)stamp.getBits(), (boolean)false);
                return IntegerStamp.createConstant(stamp.getBits(), value);
            }
            if (stamp.lowerBound() == CodeUtil.minValue((int)bits)) {
                return input.unrestricted();
            }
            long limit = Math.max(-stamp.lowerBound(), stamp.upperBound());
            return IntegerStamp.create(bits, 0L, limit);
        }
    }, null, new ArithmeticOpTable.IntegerConvertOp.ZeroExtend(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.zeroExtend((long)value.asLong(), (int)inputBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return IntegerStamp.createEmptyStamp(resultBits);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits()) : "Input bits" + inputBits + " stamp bits " + stamp.getBits() + " result bits " + resultBits;
            assert (inputBits <= resultBits) : inputBits + ">=" + resultBits;
            if (inputBits == resultBits) {
                return input;
            }
            if (input.isEmpty()) {
                return IntegerStamp.createEmptyStamp(resultBits);
            }
            long mustBeSet = CodeUtil.zeroExtend((long)stamp.mustBeSet(), (int)inputBits);
            long mayBeSet = CodeUtil.zeroExtend((long)stamp.mayBeSet(), (int)inputBits);
            long lowerBound = stamp.unsignedLowerBound();
            long upperBound = stamp.unsignedUpperBound();
            return IntegerStamp.create(resultBits, lowerBound, upperBound, mustBeSet, mayBeSet);
        }

        @Override
        public Stamp invertStamp(int inputBits, int resultBits, Stamp outStamp) {
            IntegerStamp stamp = (IntegerStamp)outStamp;
            if (stamp.isEmpty()) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long mustBeSetOutputBits = stamp.mustBeSet();
            long mustBeSetExtensionBits = mustBeSetOutputBits >>> inputBits;
            if (mustBeSetExtensionBits != 0L) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long lowerBound = Math.max(stamp.lowerBound(), 0L);
            assert (stamp.upperBound() >= 0L) : "Cannot invert ZeroExtend for stamp with msb=1, which implies a negative value after ZeroExtend!";
            return StampFactory.forUnsignedInteger(inputBits, lowerBound, stamp.upperBound(), stamp.mustBeSet(), stamp.mayBeSet());
        }
    }, new ArithmeticOpTable.IntegerConvertOp.SignExtend(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.signExtend((long)value.asLong(), (int)inputBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return IntegerStamp.createEmptyStamp(resultBits);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits()) : Assertions.errorMessageContext("inputBits", inputBits, "stamp", stamp);
            assert (inputBits <= resultBits) : inputBits + ">=" + resultBits;
            long defaultMask = CodeUtil.mask((int)resultBits);
            long mustBeSet = CodeUtil.signExtend((long)stamp.mustBeSet(), (int)inputBits) & defaultMask;
            long mayBeSet = CodeUtil.signExtend((long)stamp.mayBeSet(), (int)inputBits) & defaultMask;
            return IntegerStamp.create(resultBits, stamp.lowerBound(), stamp.upperBound(), mustBeSet, mayBeSet);
        }

        @Override
        public Stamp invertStamp(int inputBits, int resultBits, Stamp outStamp) {
            boolean inputMSBZero;
            long extensionMask;
            IntegerStamp stamp = (IntegerStamp)outStamp;
            if (stamp.isEmpty()) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long mustBeSetExtensionBits = stamp.mustBeSet() >>> inputBits;
            long mayBeSetExtensionBits = stamp.mayBeSet() >>> inputBits;
            boolean zeroInExtension = mayBeSetExtensionBits != (extensionMask = CodeUtil.mask((int)stamp.getBits()) >>> inputBits);
            boolean oneInExtension = mustBeSetExtensionBits != 0L;
            boolean inputMSBOne = IntegerStamp.significantBit(inputBits, stamp.mustBeSet()) == 1L;
            boolean bl = inputMSBZero = IntegerStamp.significantBit(inputBits, stamp.mayBeSet()) == 0L;
            if (zeroInExtension && oneInExtension || inputMSBOne && zeroInExtension || inputMSBZero && oneInExtension) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long inputMask = CodeUtil.mask((int)inputBits);
            long inputMustBeSet = stamp.mustBeSet() & inputMask;
            long inputMayBeSet = stamp.mayBeSet() & inputMask;
            if (!inputMSBOne && !inputMSBZero) {
                if (zeroInExtension) {
                    long msbZeroMask = ~(1 << inputBits - 1);
                    inputMustBeSet &= msbZeroMask;
                    inputMayBeSet &= msbZeroMask;
                } else if (oneInExtension) {
                    long msbOneMask = 1 << inputBits - 1;
                    inputMustBeSet |= msbOneMask;
                    inputMayBeSet |= msbOneMask;
                }
            }
            long inputUpperBound = IntegerStamp.maxValueForMasks(inputBits, inputMustBeSet, inputMayBeSet);
            long inputLowerBound = IntegerStamp.minValueForMasks(inputBits, inputMustBeSet, inputMayBeSet);
            if (stamp.upperBound() < inputLowerBound || stamp.lowerBound() > inputUpperBound) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            inputUpperBound = Math.min(inputUpperBound, stamp.upperBound());
            inputLowerBound = Math.max(inputLowerBound, stamp.lowerBound());
            return StampFactory.forIntegerWithMask(inputBits, inputLowerBound, inputUpperBound, inputMustBeSet, inputMayBeSet);
        }
    }, new ArithmeticOpTable.IntegerConvertOp.Narrow(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.narrow((long)value.asLong(), (int)resultBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return IntegerStamp.createEmptyStamp(resultBits);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits()) : Assertions.errorMessageContext("inputBits", inputBits, "stamp", stamp);
            assert (resultBits <= inputBits) : resultBits + ">=" + inputBits;
            if (resultBits == inputBits) {
                return stamp;
            }
            long upperBound = stamp.lowerBound() < CodeUtil.minValue((int)resultBits) ? CodeUtil.maxValue((int)resultBits) : IntegerStamp.saturate(stamp.upperBound(), resultBits);
            long lowerBound = stamp.upperBound() > CodeUtil.maxValue((int)resultBits) ? CodeUtil.minValue((int)resultBits) : IntegerStamp.saturate(stamp.lowerBound(), resultBits);
            long defaultMask = CodeUtil.mask((int)resultBits);
            long newMustBeSet = stamp.mustBeSet() & defaultMask;
            long newMayBeSet = stamp.mayBeSet() & defaultMask;
            long newLowerBound = CodeUtil.signExtend((long)((lowerBound | newMustBeSet) & newMayBeSet), (int)resultBits);
            long newUpperBound = CodeUtil.signExtend((long)((upperBound | newMustBeSet) & newMayBeSet), (int)resultBits);
            IntegerStamp result = IntegerStamp.create(resultBits, newLowerBound, newUpperBound, newMustBeSet, newMayBeSet);
            assert (result.hasValues());
            return result;
        }
    }, new ArithmeticOpTable.BinaryOp.Max(true, true){

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant x = (PrimitiveConstant)a;
            PrimitiveConstant y = (PrimitiveConstant)b;
            return JavaConstant.forIntegerKind((JavaKind)x.getJavaKind(), (long)Math.max(x.asLong(), y.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            if (a.isEmpty()) {
                return a;
            }
            if (b.isEmpty()) {
                return b;
            }
            IntegerStamp x = (IntegerStamp)a;
            IntegerStamp y = (IntegerStamp)b;
            long lowerBound = Math.max(x.lowerBound(), y.lowerBound());
            long upperBound = Math.max(x.upperBound(), y.upperBound());
            long mustBeSet = x.mustBeSet() & y.mustBeSet();
            long mayBeSet = x.mayBeSet() | y.mayBeSet();
            return IntegerStamp.create(x.getBits(), lowerBound, upperBound, mustBeSet, mayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            int bits = n.getJavaKind().getBitCount();
            return n.asLong() == NumUtil.minValue(bits);
        }
    }, new ArithmeticOpTable.BinaryOp.Min(true, true){

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant x = (PrimitiveConstant)a;
            PrimitiveConstant y = (PrimitiveConstant)b;
            return JavaConstant.forIntegerKind((JavaKind)x.getJavaKind(), (long)Math.min(x.asLong(), y.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            if (a.isEmpty()) {
                return a;
            }
            if (b.isEmpty()) {
                return b;
            }
            IntegerStamp x = (IntegerStamp)a;
            IntegerStamp y = (IntegerStamp)b;
            long lowerBound = Math.min(x.lowerBound(), y.lowerBound());
            long upperBound = Math.min(x.upperBound(), y.upperBound());
            long mustBeSet = x.mustBeSet() & y.mustBeSet();
            long mayBeSet = x.mayBeSet() | y.mayBeSet();
            return IntegerStamp.create(x.getBits(), lowerBound, upperBound, mustBeSet, mayBeSet);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            int bits = n.getJavaKind().getBitCount();
            return n.asLong() == NumUtil.maxValue(bits);
        }
    }, new ArithmeticOpTable.BinaryOp.UMax(true, true){

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant x = (PrimitiveConstant)a;
            PrimitiveConstant y = (PrimitiveConstant)b;
            return JavaConstant.forIntegerKind((JavaKind)x.getJavaKind(), (long)NumUtil.maxUnsigned(x.asLong(), y.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            if (a.isEmpty()) {
                return a;
            }
            if (b.isEmpty()) {
                return b;
            }
            IntegerStamp x = (IntegerStamp)a;
            IntegerStamp y = (IntegerStamp)b;
            if (x.sameSignBounds() && y.sameSignBounds()) {
                long lowerBound = NumUtil.maxUnsigned(x.unsignedLowerBound(), y.unsignedLowerBound());
                long upperBound = NumUtil.maxUnsigned(x.unsignedUpperBound(), y.unsignedUpperBound());
                long mustBeSet = x.mustBeSet() & y.mustBeSet();
                long mayBeSet = x.mayBeSet() | y.mayBeSet();
                return StampFactory.forUnsignedInteger(x.getBits(), lowerBound, upperBound, mustBeSet, mayBeSet);
            }
            return x.meet(y);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }
    }, new ArithmeticOpTable.BinaryOp.UMin(true, true){

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant x = (PrimitiveConstant)a;
            PrimitiveConstant y = (PrimitiveConstant)b;
            return JavaConstant.forIntegerKind((JavaKind)x.getJavaKind(), (long)NumUtil.minUnsigned(x.asLong(), y.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            if (a.isEmpty()) {
                return a;
            }
            if (b.isEmpty()) {
                return b;
            }
            IntegerStamp x = (IntegerStamp)a;
            IntegerStamp y = (IntegerStamp)b;
            if (x.sameSignBounds() && y.sameSignBounds()) {
                long lowerBound = NumUtil.minUnsigned(x.unsignedLowerBound(), y.unsignedLowerBound());
                long upperBound = NumUtil.minUnsigned(x.unsignedUpperBound(), y.unsignedUpperBound());
                long mustBeSet = x.mustBeSet() & y.mustBeSet();
                long mayBeSet = x.mayBeSet() | y.mayBeSet();
                return StampFactory.forUnsignedInteger(x.getBits(), lowerBound, upperBound, mustBeSet, mayBeSet);
            }
            return x.meet(y);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            int bits = n.getJavaKind().getBitCount();
            return CodeUtil.zeroExtend((long)n.asLong(), (int)bits) == NumUtil.maxValueUnsigned(bits);
        }
    }, null, new ArithmeticOpTable.ReinterpretOp(){

        @Override
        public Constant foldConstant(Stamp resultStamp, Constant constant) {
            return ReinterpretUtils.foldConstant(resultStamp, constant);
        }

        @Override
        public Stamp foldStamp(Stamp resultStamp, Stamp input) {
            if (input.isEmpty()) {
                return resultStamp.empty();
            }
            if (resultStamp instanceof FloatStamp && input instanceof IntegerStamp) {
                return ReinterpretUtils.intToFloat((IntegerStamp)input);
            }
            return resultStamp;
        }
    }, new ArithmeticOpTable.BinaryOp.Compress(false, false){
        private static final long INT_MASK = CodeUtil.mask((int)32);
        private static final long LONG_MASK = CodeUtil.mask((int)64);

        private static int integerCompress(int i, int mask) {
            try {
                Method compress = Integer.class.getDeclaredMethod("compress", Integer.TYPE, Integer.TYPE);
                return (Integer)compress.invoke(null, i, mask);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere(e, "Integer.compress is introduced in Java 19");
            }
        }

        private static long longCompress(long i, long mask) {
            try {
                Method compress = Long.class.getDeclaredMethod("compress", Long.TYPE, Long.TYPE);
                return (Long)compress.invoke(null, i, mask);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere(e, "Long.compress is introduced in Java 19");
            }
        }

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant i = (PrimitiveConstant)a;
            PrimitiveConstant mask = (PrimitiveConstant)b;
            if (i.getJavaKind() == JavaKind.Int) {
                return JavaConstant.forInt((int)25.integerCompress(i.asInt(), mask.asInt()));
            }
            GraalError.guarantee(i.getJavaKind() == JavaKind.Long, "unexpected Java kind %s", (Object)i.getJavaKind());
            return JavaConstant.forLong((long)25.longCompress(i.asLong(), mask.asLong()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp a, Stamp b) {
            IntegerStamp valueStamp = (IntegerStamp)a;
            IntegerStamp maskStamp = (IntegerStamp)b;
            if (valueStamp.getStackKind() == JavaKind.Int) {
                if (maskStamp.mayBeSet() == INT_MASK && valueStamp.canBeNegative()) {
                    return IntegerStamp.create(32, valueStamp.lowerBound(), CodeUtil.maxValue((int)32));
                }
                return IntegerStamp.create(32, (long)25.integerCompress((int)valueStamp.mustBeSet(), (int)maskStamp.mustBeSet()) & INT_MASK, (long)25.integerCompress((int)valueStamp.mayBeSet(), (int)maskStamp.mayBeSet()) & INT_MASK, 0L, (long)25.integerCompress((int)INT_MASK, (int)maskStamp.mayBeSet()) & INT_MASK);
            }
            GraalError.guarantee(valueStamp.getStackKind() == JavaKind.Long, "unexpected Java kind %s", (Object)valueStamp.getStackKind());
            if (maskStamp.mayBeSet() == LONG_MASK && valueStamp.canBeNegative()) {
                return IntegerStamp.create(64, valueStamp.lowerBound(), CodeUtil.maxValue((int)64));
            }
            return IntegerStamp.create(64, 25.longCompress(valueStamp.mustBeSet(), maskStamp.mustBeSet()), 25.longCompress(valueStamp.mayBeSet(), maskStamp.mayBeSet()), 0L, 25.longCompress(LONG_MASK, maskStamp.mayBeSet()));
        }
    }, new ArithmeticOpTable.BinaryOp.Expand(false, false){

        private static int integerExpand(int i, int mask) {
            try {
                Method expand = Integer.class.getDeclaredMethod("expand", Integer.TYPE, Integer.TYPE);
                return (Integer)expand.invoke(null, i, mask);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere(e, "Integer.expand is introduced in Java 19");
            }
        }

        private static long longExpand(long i, long mask) {
            try {
                Method expand = Long.class.getDeclaredMethod("expand", Long.TYPE, Long.TYPE);
                return (Long)expand.invoke(null, i, mask);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere(e, "Long.expand is introduced in Java 19");
            }
        }

        @Override
        public Constant foldConstant(Constant a, Constant b) {
            PrimitiveConstant i = (PrimitiveConstant)a;
            PrimitiveConstant mask = (PrimitiveConstant)b;
            if (i.getJavaKind() == JavaKind.Int) {
                return JavaConstant.forInt((int)26.integerExpand(i.asInt(), mask.asInt()));
            }
            GraalError.guarantee(i.getJavaKind() == JavaKind.Long, "unexpected Java kind %s", (Object)i.getJavaKind());
            return JavaConstant.forLong((long)26.longExpand(i.asLong(), mask.asLong()));
        }

        @Override
        public Stamp foldStampImpl(Stamp a, Stamp b) {
            IntegerStamp maskStamp = (IntegerStamp)b;
            return IntegerStamp.stampForMask(maskStamp.getBits(), 0L, maskStamp.mayBeSet());
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.I2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)value.asInt());
        }

        @Override
        protected Stamp foldStampImpl(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 32) : stamp;
            float lowerBound = stamp.lowerBound();
            float upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Float, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.L2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)value.asLong());
        }

        @Override
        protected Stamp foldStampImpl(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 64) : stamp;
            float lowerBound = stamp.lowerBound();
            float upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Float, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.I2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asInt());
        }

        @Override
        protected Stamp foldStampImpl(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 32) : stamp;
            double lowerBound = stamp.lowerBound();
            double upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.L2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asLong());
        }

        @Override
        protected Stamp foldStampImpl(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 64) : stamp;
            double lowerBound = stamp.lowerBound();
            double upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, true);
        }
    });
    static final IntegerStamp[] emptyStamps = new IntegerStamp[CodeUtil.log2((int)64) + 1];
    static final IntegerStamp[] unrestrictedStamps = new IntegerStamp[CodeUtil.log2((int)64) + 1];

    private IntegerStamp(int bits, boolean empty) {
        super(bits, OPS);
        if (empty) {
            this.lowerBound = CodeUtil.maxValue((int)bits);
            this.upperBound = CodeUtil.minValue((int)bits);
            this.mustBeSet = CodeUtil.mask((int)bits);
            this.mayBeSet = 0L;
            this.canBeZero = false;
        } else {
            this.lowerBound = CodeUtil.minValue((int)bits);
            this.upperBound = CodeUtil.maxValue((int)bits);
            this.mustBeSet = 0L;
            this.mayBeSet = CodeUtil.mask((int)bits);
            this.canBeZero = true;
        }
    }

    private IntegerStamp(int bits, long constant) {
        this(bits, constant, constant, constant & CodeUtil.mask((int)bits), constant & CodeUtil.mask((int)bits), constant == 0L);
    }

    private IntegerStamp(int bits, long lowerBound, long upperBound) {
        super(bits, OPS);
        int sameBitCount = Long.numberOfLeadingZeros(lowerBound ^ upperBound);
        long sameBitMask = -1L >>> sameBitCount;
        long defaultMask = CodeUtil.mask((int)bits);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.mustBeSet = defaultMask & (lowerBound & (sameBitMask ^ 0xFFFFFFFFFFFFFFFFL));
        this.mayBeSet = defaultMask & (lowerBound | sameBitMask);
        this.canBeZero = this.contains(0L, true);
        assert (this.checkInvariants());
    }

    private IntegerStamp(int bits, long lowerBound, long upperBound, long mustBeSet, long mayBeSet, boolean canBeZero) {
        super(bits, OPS);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.mustBeSet = mustBeSet;
        this.mayBeSet = mayBeSet;
        this.canBeZero = this.contains(0L, canBeZero);
        assert (this.checkInvariants());
    }

    private boolean checkInvariants() {
        int allowedBitsMask = 121;
        assert ((this.getBits() & 0x79) == this.getBits() && CodeUtil.isPowerOf2((int)this.getBits())) : "unexpected bit size: " + this.getBits();
        assert (this.lowerBound >= CodeUtil.minValue((int)this.getBits())) : this;
        assert (this.upperBound <= CodeUtil.maxValue((int)this.getBits())) : this;
        assert ((this.mustBeSet & CodeUtil.mask((int)this.getBits())) == this.mustBeSet) : this;
        assert ((this.mayBeSet & CodeUtil.mask((int)this.getBits())) == this.mayBeSet) : this;
        assert ((this.mustBeSet & (this.mayBeSet ^ 0xFFFFFFFFFFFFFFFFL)) == 0L || this.mayBeSet == 0L && this.mustBeSet == CodeUtil.mask((int)this.getBits())) : String.format("must: %016x may: %016x", this.mustBeSet, this.mayBeSet);
        assert (!this.canBeZero || this.contains(0L)) : " Stamp " + String.valueOf(this) + " either has canBeZero set to false or needs to contain 0";
        assert (!this.isEmpty()) : String.format("unexpected empty stamp: %s %s %s %s %s %s", this.lowerBound, this.upperBound, this.mustBeSet, this.mayBeSet, this.canBeZero, this);
        assert (this.contains(this.upperBound)) : String.format("%s must contain its upper bound", this);
        assert (this.contains(this.lowerBound)) : String.format("%s must contain its lower bound", this);
        return true;
    }

    public static IntegerStamp createConstant(int bits, long value) {
        return new IntegerStamp(bits, value);
    }

    public static IntegerStamp create(int bits) {
        return unrestrictedStamps[CodeUtil.log2((int)bits)];
    }

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput) {
        if (lowerBoundInput > upperBoundInput) {
            return IntegerStamp.createEmptyStamp(bits);
        }
        if (lowerBoundInput == upperBoundInput) {
            return IntegerStamp.createConstant(bits, lowerBoundInput);
        }
        return new IntegerStamp(bits, lowerBoundInput, upperBoundInput);
    }

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput, long mustBeSet, long mayBeSet) {
        return IntegerStamp.create(bits, lowerBoundInput, upperBoundInput, mustBeSet, mayBeSet, true);
    }

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput, long mustBeSetInput, long mayBeSetInput, boolean canBeZero) {
        assert (lowerBoundInput >= CodeUtil.minValue((int)bits) && lowerBoundInput <= CodeUtil.maxValue((int)bits)) : Assertions.errorMessageContext("bits", bits, "lowerBound", lowerBoundInput, "upperBound", upperBoundInput, "mustBeSetInput", mustBeSetInput, "mayBeSetInput", mayBeSetInput, "canBeZero", canBeZero);
        assert (upperBoundInput >= CodeUtil.minValue((int)bits) && upperBoundInput <= CodeUtil.maxValue((int)bits)) : Assertions.errorMessageContext("bits", bits, "lowerBound", lowerBoundInput, "upperBound", upperBoundInput, "mustBeSetInput", mustBeSetInput, "mayBeSetInput", mayBeSetInput, "canBeZero", canBeZero);
        if (IntegerStamp.isEmpty(lowerBoundInput, upperBoundInput, mustBeSetInput, mayBeSetInput)) {
            return IntegerStamp.createEmptyStamp(bits);
        }
        long defaultMask = CodeUtil.mask((int)bits);
        if (mustBeSetInput == 0L && mayBeSetInput == defaultMask && canBeZero) {
            return IntegerStamp.create(bits, lowerBoundInput, upperBoundInput);
        }
        long lowerBoundCurrent = lowerBoundInput;
        long upperBoundCurrent = upperBoundInput;
        long mustBeSetCurrent = mustBeSetInput;
        long mayBeSetCurrent = mayBeSetInput;
        int iterations = 0;
        while (iterations++ < 3) {
            long boundedMayBeSet;
            long boundedMustBeSet;
            long maxValue;
            long upperBoundTmp;
            long minValue = IntegerStamp.minValueForMasks(bits, mustBeSetCurrent, mayBeSetCurrent);
            long lowerBoundTmp = Math.max(lowerBoundCurrent, minValue);
            if (lowerBoundTmp == (upperBoundTmp = Math.min(upperBoundCurrent, maxValue = IntegerStamp.maxValueForMasks(bits, mustBeSetCurrent, mayBeSetCurrent)))) {
                boundedMustBeSet = lowerBoundTmp;
                boundedMayBeSet = lowerBoundTmp;
            } else {
                int sameBitCount = Long.numberOfLeadingZeros(lowerBoundTmp ^ upperBoundTmp);
                long sameBitMask = -1L >>> sameBitCount;
                boundedMayBeSet = lowerBoundTmp | sameBitMask;
                boundedMustBeSet = lowerBoundTmp & (sameBitMask ^ 0xFFFFFFFFFFFFFFFFL);
            }
            long mustBeSetTmp = defaultMask & (mustBeSetCurrent | boundedMustBeSet);
            long mayBeSetTmp = defaultMask & mayBeSetCurrent & boundedMayBeSet;
            upperBoundTmp = Math.min(upperBoundTmp, IntegerStamp.maxValueForMasks(bits, mustBeSetTmp, mayBeSetTmp));
            lowerBoundTmp = Math.max(lowerBoundTmp, IntegerStamp.minValueForMasks(bits, mustBeSetTmp, mayBeSetTmp));
            upperBoundTmp = IntegerStamp.computeUpperBound(bits, upperBoundTmp, mustBeSetTmp, mayBeSetTmp, canBeZero);
            lowerBoundTmp = IntegerStamp.computeLowerBound(bits, lowerBoundTmp, mustBeSetTmp, mayBeSetTmp, canBeZero);
            if (lowerBoundTmp > upperBoundTmp || (mustBeSetTmp & (mayBeSetTmp ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || mayBeSetTmp == 0L && (lowerBoundTmp > 0L || upperBoundTmp < 0L)) {
                return IntegerStamp.createEmptyStamp(bits);
            }
            if (lowerBoundCurrent == lowerBoundTmp && upperBoundCurrent == upperBoundTmp && mustBeSetCurrent == mustBeSetTmp && mayBeSetCurrent == mayBeSetTmp) {
                return new IntegerStamp(bits, lowerBoundTmp, upperBoundTmp, mustBeSetTmp, mayBeSetTmp, canBeZero);
            }
            GraalError.guarantee(lowerBoundTmp >= lowerBoundCurrent, "lower bound can't get smaller: %s < %s", (Object)lowerBoundTmp, (Object)lowerBoundCurrent);
            GraalError.guarantee(upperBoundTmp <= upperBoundCurrent, "upper bound can't get larger: %s > %s", (Object)upperBoundTmp, (Object)upperBoundCurrent);
            lowerBoundCurrent = lowerBoundTmp;
            upperBoundCurrent = upperBoundTmp;
            mustBeSetCurrent = mustBeSetTmp;
            mayBeSetCurrent = mayBeSetTmp;
        }
        throw GraalError.shouldNotReachHere("More than 3iterations required to reach a stable stamp");
    }

    private static boolean isEmpty(long lowerBound, long upperBound, long mustBeSet, long mayBeSet) {
        return lowerBound > upperBound || (mustBeSet & (mayBeSet ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || mayBeSet == 0L && (lowerBound > 0L || upperBound < 0L);
    }

    private static long significantBit(long bits, long value) {
        return value >>> (int)(bits - 1L) & 1L;
    }

    private static long minValueForMasks(int bits, long mustBeSet, long mayBeSet) {
        if (IntegerStamp.significantBit(bits, mayBeSet) == 0L) {
            assert (IntegerStamp.significantBit(bits, mustBeSet) == 0L) : String.format("must: %016x may: %016x", mustBeSet, mayBeSet);
            return mustBeSet;
        }
        return mustBeSet | -1L << bits - 1;
    }

    private static long maxValueForMasks(int bits, long mustBeSet, long mayBeSet) {
        if (IntegerStamp.significantBit(bits, mustBeSet) == 1L) {
            assert (IntegerStamp.significantBit(bits, mayBeSet) == 1L) : Assertions.errorMessageContext("bits", bits, "mayBeSet", mayBeSet);
            return CodeUtil.signExtend((long)mayBeSet, (int)bits);
        }
        return mayBeSet & CodeUtil.mask((int)bits) >>> 1;
    }

    private static long computeUpperBound(int bits, long upperBound, long mustBeSet, long mayBeSet, boolean canBeZero) {
        long newUpperBound = CodeUtil.signExtend((long)mustBeSet, (int)bits);
        if (upperBound < 0L || newUpperBound > upperBound) {
            newUpperBound = IntegerStamp.minValueForMasks(bits, mustBeSet, mayBeSet);
        }
        if ((newUpperBound = IntegerStamp.setOptionalBits(bits, upperBound, mustBeSet, mayBeSet, newUpperBound)) == 0L && !canBeZero) {
            if (IntegerStamp.significantBit(bits, mayBeSet) == 0L) {
                return CodeUtil.minValue((int)bits);
            }
            newUpperBound = IntegerStamp.maxValueForMasks(bits, mustBeSet | 1L << bits - 1, mayBeSet);
        }
        if (newUpperBound > upperBound) {
            return CodeUtil.minValue((int)bits);
        }
        return newUpperBound;
    }

    private static long setOptionalBits(int bits, long bound, long mustBeSet, long mayBeSet, long initialValue) {
        long optionalBits = mayBeSet & (mustBeSet ^ 0xFFFFFFFFFFFFFFFFL) & CodeUtil.mask((int)(bits - 1));
        assert ((initialValue & optionalBits) == 0L) : Assertions.errorMessageContext("bits", bits, "bound", bound, "mustBeSet", mustBeSet, "mayBeSet", mayBeSet, "initialValue", initialValue);
        long value = initialValue;
        for (int position = bits - 1; position >= 0; --position) {
            long bit = 1L << position;
            if ((bit & optionalBits) == 0L || (value | bit) > bound) continue;
            value |= bit;
        }
        return value;
    }

    private static long computeLowerBound(int bits, long lowerBound, long mustBeSet, long mayBeSet, boolean canBeZero) {
        long newLowerBound = IntegerStamp.minValueForMasks(bits, mustBeSet, mayBeSet);
        long optionalBits = mayBeSet & (mustBeSet ^ 0xFFFFFFFFFFFFFFFFL) & CodeUtil.mask((int)(bits - 1));
        if (newLowerBound < lowerBound) {
            if (optionalBits == 0L) {
                newLowerBound = 0L;
            } else {
                for (int position = bits - 1; position >= 0; --position) {
                    long bit = 1L << position;
                    if ((bit & optionalBits) == 0L || newLowerBound + bit > lowerBound) continue;
                    newLowerBound += bit;
                }
                GraalError.guarantee(newLowerBound <= lowerBound, "should have been sufficient");
                if (newLowerBound < lowerBound) {
                    boolean incremented = false;
                    for (int position = 0; position < bits - 1; ++position) {
                        long bit = 1L << position;
                        if (incremented) {
                            if ((bit & mustBeSet) != 0L && (newLowerBound & bit) == 0L) {
                                newLowerBound |= bit;
                            }
                            if ((bit & mayBeSet) != 0L || (newLowerBound & bit) == 0L) continue;
                            newLowerBound += bit;
                            continue;
                        }
                        if ((bit & optionalBits) == 0L) continue;
                        newLowerBound += bit;
                        incremented = true;
                    }
                }
            }
        }
        if (newLowerBound == 0L && !canBeZero) {
            if (mustBeSet > 0L) {
                newLowerBound = mustBeSet;
            } else if (mustBeSet == 0L) {
                int lowBit = Long.numberOfTrailingZeros(mayBeSet);
                newLowerBound = 1L << lowBit;
            } else {
                newLowerBound = CodeUtil.maxValue((int)bits);
            }
        }
        if (newLowerBound < lowerBound) {
            return CodeUtil.maxValue((int)bits);
        }
        return newLowerBound;
    }

    public static IntegerStamp stampForMask(int bits, long mustBeSet, long mayBeSet) {
        if ((mustBeSet & (mayBeSet ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return IntegerStamp.createEmptyStamp(bits);
        }
        return new IntegerStamp(bits, IntegerStamp.minValueForMasks(bits, mustBeSet, mayBeSet), IntegerStamp.maxValueForMasks(bits, mustBeSet, mayBeSet), mustBeSet, mayBeSet, true);
    }

    @Override
    public IntegerStamp unrestricted() {
        return IntegerStamp.create(this.getBits());
    }

    @Override
    public IntegerStamp empty() {
        return IntegerStamp.createEmptyStamp(this.getBits());
    }

    static IntegerStamp createEmptyStamp(int bits) {
        assert (CodeUtil.isPowerOf2((int)bits));
        return emptyStamps[CodeUtil.log2((int)bits)];
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (c instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)c;
            long value = primitiveConstant.asLong();
            if (primitiveConstant.getJavaKind() == JavaKind.Boolean && value == 1L) {
                value = -1L;
            }
            IntegerStamp returnedStamp = IntegerStamp.createConstant(this.getBits(), value);
            assert (((Stamp)returnedStamp).hasValues());
            return returnedStamp;
        }
        return this;
    }

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer) {
        switch (this.getBits()) {
            case 1: {
                return JavaConstant.forBoolean((buffer.get() != 0 ? 1 : 0) != 0);
            }
            case 8: {
                return JavaConstant.forByte((byte)buffer.get());
            }
            case 16: {
                return JavaConstant.forShort((short)buffer.getShort());
            }
            case 32: {
                return JavaConstant.forInt((int)buffer.getInt());
            }
            case 64: {
                return JavaConstant.forLong((long)buffer.getLong());
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.getBits());
    }

    @Override
    public boolean hasValues() {
        return this.lowerBound <= this.upperBound;
    }

    @Override
    public JavaKind getStackKind() {
        if (this.getBits() > 32) {
            return JavaKind.Long;
        }
        return JavaKind.Int;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getIntegerKind(this.getBits());
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        switch (this.getBits()) {
            case 1: {
                return metaAccess.lookupJavaType(Boolean.TYPE);
            }
            case 8: {
                return metaAccess.lookupJavaType(Byte.TYPE);
            }
            case 16: {
                return metaAccess.lookupJavaType(Short.TYPE);
            }
            case 32: {
                return metaAccess.lookupJavaType(Integer.TYPE);
            }
            case 64: {
                return metaAccess.lookupJavaType(Long.TYPE);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.getBits());
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement, Stamp accessStamp) {
        PrimitiveStamp primitiveAccess = (PrimitiveStamp)accessStamp;
        int accessBits = primitiveAccess.getBits();
        GraalError.guarantee(this.getBits() >= ((PrimitiveStamp)accessStamp).getBits(), "access size should be less than or equal the result");
        JavaConstant constant = super.readJavaConstant(provider, base, displacement, accessBits);
        if (constant == null) {
            return null;
        }
        if (constant.getJavaKind().getBitCount() != accessBits) {
            constant = this.canBeNegative() ? JavaConstant.forPrimitiveInt((int)this.getBits(), (long)CodeUtil.signExtend((long)constant.asLong(), (int)accessBits)) : JavaConstant.forPrimitiveInt((int)this.getBits(), (long)CodeUtil.zeroExtend((long)constant.asLong(), (int)accessBits));
        }
        return constant;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public long mustBeSet() {
        return this.mustBeSet;
    }

    public long mayBeSet() {
        return this.mayBeSet;
    }

    @Override
    public boolean isUnrestricted() {
        return this.lowerBound == CodeUtil.minValue((int)this.getBits()) && this.upperBound == CodeUtil.maxValue((int)this.getBits()) && this.mustBeSet == 0L && this.mayBeSet == CodeUtil.mask((int)this.getBits()) && this.canBeZero;
    }

    public boolean contains(long value) {
        return this.contains(value, this.canBeZero);
    }

    private boolean contains(long value, boolean isCanBeZero) {
        if (value == 0L && !isCanBeZero) {
            return this.lowerBound == this.upperBound && this.lowerBound == 0L;
        }
        return value >= this.lowerBound && value <= this.upperBound && (value & this.mustBeSet) == this.mustBeSet && (value & this.mayBeSet) == (value & CodeUtil.mask((int)this.getBits()));
    }

    public boolean isPositive() {
        return this.lowerBound() >= 0L;
    }

    public boolean isNegative() {
        return this.upperBound() <= 0L;
    }

    public boolean isStrictlyPositive() {
        return this.lowerBound() > 0L;
    }

    public boolean isStrictlyNegative() {
        return this.upperBound() < 0L;
    }

    public boolean canBePositive() {
        return this.upperBound() > 0L;
    }

    public boolean canBeNegative() {
        return this.lowerBound() < 0L;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('i');
        str.append(this.getBits());
        if (this.hasValues()) {
            if (this.lowerBound == this.upperBound) {
                str.append(" [").append(this.lowerBound).append(']');
            } else if (this.lowerBound != CodeUtil.minValue((int)this.getBits()) || this.upperBound != CodeUtil.maxValue((int)this.getBits())) {
                str.append(" [").append(this.lowerBound);
                str.append(" - ");
                str.append(this.upperBound).append(']');
            }
            if (this.lowerBound != this.upperBound && (this.mustBeSet != 0L || this.mayBeSet != CodeUtil.mask((int)this.getBits()))) {
                str.append(" bits:");
                char firstChar = '\u0000';
                boolean summarized = false;
                for (int i = this.getBits() - 1; i >= 0; --i) {
                    long bit = 1L << i;
                    char c = 'x';
                    if ((this.mayBeSet & bit) == 0L) {
                        c = '0';
                    } else if ((this.mustBeSet & bit) == bit) {
                        c = '1';
                    }
                    if (summarized) {
                        str.append(c);
                        continue;
                    }
                    if (firstChar == '\u0000') {
                        firstChar = c;
                        continue;
                    }
                    if (firstChar == c) continue;
                    int leading = this.getBits() - 1 - i;
                    if (leading > 8) {
                        str.append(firstChar).append("...").append(firstChar);
                    } else {
                        for (int j = 0; j < leading; ++j) {
                            str.append(firstChar);
                        }
                    }
                    str.append(c);
                    summarized = true;
                }
            }
            if (!this.canBeZero && this.contains(0L, true)) {
                str.append(" {!=0}");
            }
        } else {
            str.append("<empty>");
        }
        return str.toString();
    }

    private IntegerStamp createStamp(IntegerStamp other, long newUpperBound, long newLowerBound, long newMustBeSet, long newMayBeSet, boolean newCanBeZero) {
        assert (this.getBits() == other.getBits()) : "Bits must match " + Assertions.errorMessageContext("this", this, "other", other);
        if (IntegerStamp.isEmpty(newLowerBound, newUpperBound, newMustBeSet, newMayBeSet)) {
            return this.empty();
        }
        if (newLowerBound == this.lowerBound && newUpperBound == this.upperBound && newMustBeSet == this.mustBeSet && newMayBeSet == this.mayBeSet && this.canBeZero == newCanBeZero) {
            return this;
        }
        if (newLowerBound == other.lowerBound && newUpperBound == other.upperBound && newMustBeSet == other.mustBeSet && newMayBeSet == other.mayBeSet && newCanBeZero == other.canBeZero) {
            return other;
        }
        return IntegerStamp.create(this.getBits(), newLowerBound, newUpperBound, newMustBeSet, newMayBeSet, newCanBeZero);
    }

    @Override
    public Stamp meet(Stamp otherStamp) {
        if (otherStamp == this) {
            return this;
        }
        if (this.isEmpty()) {
            return otherStamp;
        }
        if (otherStamp.isEmpty()) {
            return this;
        }
        IntegerStamp other = (IntegerStamp)otherStamp;
        return this.createStamp(other, Math.max(this.upperBound, other.upperBound), Math.min(this.lowerBound, other.lowerBound), this.mustBeSet & other.mustBeSet, this.mayBeSet | other.mayBeSet, this.canBeZero || other.canBeZero);
    }

    @Override
    public IntegerStamp join(Stamp otherStamp) {
        if (otherStamp == this) {
            return this;
        }
        IntegerStamp other = (IntegerStamp)otherStamp;
        long newMustBeSet = this.mustBeSet | other.mustBeSet;
        long newLowerBound = Math.max(this.lowerBound, other.lowerBound);
        long newUpperBound = Math.min(this.upperBound, other.upperBound);
        long newMayBeSet = this.mayBeSet & other.mayBeSet;
        boolean newCanBeZero = this.canBeZero && other.canBeZero;
        return this.createStamp(other, newUpperBound, newLowerBound, newMustBeSet, newMayBeSet, newCanBeZero);
    }

    @Override
    public boolean isCompatible(Stamp stamp) {
        if (this == stamp) {
            return true;
        }
        if (stamp instanceof IntegerStamp) {
            IntegerStamp other = (IntegerStamp)stamp;
            return this.getBits() == other.getBits();
        }
        return false;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)constant;
            JavaKind kind = prim.getJavaKind();
            return kind.isNumericInteger() && kind.getBitCount() == this.getBits();
        }
        return false;
    }

    public long unsignedUpperBound() {
        if (this.sameSignBounds()) {
            return CodeUtil.zeroExtend((long)this.upperBound(), (int)this.getBits());
        }
        return NumUtil.maxValueUnsigned(this.getBits());
    }

    public long unsignedLowerBound() {
        if (this.sameSignBounds()) {
            return CodeUtil.zeroExtend((long)this.lowerBound(), (int)this.getBits());
        }
        return 0L;
    }

    private boolean sameSignBounds() {
        return NumUtil.sameSign(this.lowerBound, this.upperBound);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (int)(this.lowerBound ^ this.lowerBound >>> 32);
        result = 31 * result + (int)(this.upperBound ^ this.upperBound >>> 32);
        result = 31 * result + (int)(this.mustBeSet ^ this.mustBeSet >>> 32);
        result = 31 * result + (int)(this.mayBeSet ^ this.mayBeSet >>> 32);
        result = 31 * result + Boolean.hashCode(this.canBeZero);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !super.equals(obj)) {
            return false;
        }
        IntegerStamp other = (IntegerStamp)obj;
        if (this.lowerBound != other.lowerBound || this.upperBound != other.upperBound || this.mustBeSet != other.mustBeSet || this.mayBeSet != other.mayBeSet || this.canBeZero != other.canBeZero) {
            return false;
        }
        return super.equals(other);
    }

    private static long mayBeSetFor(int bits, long lowerBound, long upperBound) {
        long mask = lowerBound | upperBound;
        if (mask == 0L) {
            return 0L;
        }
        return -1L >>> Long.numberOfLeadingZeros(mask) & CodeUtil.mask((int)bits);
    }

    public static boolean sameSign(IntegerStamp s1, IntegerStamp s2) {
        return s1.isPositive() && s2.isPositive() || s1.isStrictlyNegative() && s2.isStrictlyNegative();
    }

    public JavaConstant asConstant() {
        if (this.lowerBound == this.upperBound) {
            switch (this.getBits()) {
                case 1: {
                    return JavaConstant.forBoolean((this.lowerBound != 0L ? 1 : 0) != 0);
                }
                case 8: {
                    return JavaConstant.forByte((byte)((byte)this.lowerBound));
                }
                case 16: {
                    return JavaConstant.forShort((short)((short)this.lowerBound));
                }
                case 32: {
                    return JavaConstant.forInt((int)((int)this.lowerBound));
                }
                case 64: {
                    return JavaConstant.forLong((long)this.lowerBound);
                }
            }
        }
        return null;
    }

    public static boolean addCanOverflow(IntegerStamp a, IntegerStamp b) {
        assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
        return IntegerStamp.addOverflowsPositively(a.upperBound(), b.upperBound(), a.getBits()) || IntegerStamp.addOverflowsNegatively(a.lowerBound(), b.lowerBound(), a.getBits());
    }

    public static boolean addOverflowsPositively(long x, long y, int bits) {
        long result = x + y;
        if (bits == 64) {
            return ((x ^ 0xFFFFFFFFFFFFFFFFL) & (y ^ 0xFFFFFFFFFFFFFFFFL) & result) < 0L;
        }
        return result > CodeUtil.maxValue((int)bits);
    }

    public static boolean addOverflowsNegatively(long x, long y, int bits) {
        long result = x + y;
        if (bits == 64) {
            return (x & y & (result ^ 0xFFFFFFFFFFFFFFFFL)) < 0L;
        }
        return result < CodeUtil.minValue((int)bits);
    }

    public static long carryBits(long x, long y) {
        return x + y ^ x ^ y;
    }

    private static long saturate(long v, int bits) {
        if (bits < 64) {
            long max = CodeUtil.maxValue((int)bits);
            if (v > max) {
                return max;
            }
            long min = CodeUtil.minValue((int)bits);
            if (v < min) {
                return min;
            }
        }
        return v;
    }

    public static boolean multiplicationOverflows(long a, long b, int bits) {
        boolean positive;
        assert (bits <= 64 && bits >= 0) : bits;
        long result = a * b;
        boolean bl = positive = a >= 0L && b >= 0L || a < 0L && b < 0L;
        if (bits == 64) {
            if (a > 0L && b > 0L) {
                return a > Long.MAX_VALUE / b;
            }
            if (a > 0L && b <= 0L) {
                return b < Long.MIN_VALUE / a;
            }
            if (a <= 0L && b > 0L) {
                return a < Long.MIN_VALUE / b;
            }
            return a != 0L && b < Long.MAX_VALUE / a;
        }
        if (positive) {
            return result > CodeUtil.maxValue((int)bits);
        }
        return result < CodeUtil.minValue((int)bits);
    }

    public static boolean multiplicationCanOverflow(IntegerStamp a, IntegerStamp b) {
        assert (a.getBits() == b.getBits()) : "Bits must match " + Assertions.errorMessageContext("a", a, "b", b);
        if (a.mayBeSet() == 0L) {
            return false;
        }
        if (b.mayBeSet() == 0L) {
            return false;
        }
        if (a.isUnrestricted()) {
            return true;
        }
        if (b.isUnrestricted()) {
            return true;
        }
        int bits = a.getBits();
        long minNegA = a.lowerBound();
        long maxNegA = Math.min(0L, a.upperBound());
        long minPosA = Math.max(0L, a.lowerBound());
        long maxPosA = a.upperBound();
        long minNegB = b.lowerBound();
        long maxNegB = Math.min(0L, b.upperBound());
        long minPosB = Math.max(0L, b.lowerBound());
        long maxPosB = b.upperBound();
        boolean mayOverflow = false;
        if (a.canBePositive()) {
            if (b.canBePositive()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxPosA, maxPosB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(minPosA, minPosB, bits);
            }
            if (b.canBeNegative()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(minPosA, maxNegB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxPosA, minNegB, bits);
            }
        }
        if (a.canBeNegative()) {
            if (b.canBePositive()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxNegA, minPosB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(minNegA, maxPosB, bits);
            }
            if (b.canBeNegative()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(minNegA, minNegB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxNegA, maxNegB, bits);
            }
        }
        return mayOverflow;
    }

    public static boolean subtractionCanOverflow(IntegerStamp x, IntegerStamp y) {
        assert (x.getBits() == y.getBits()) : "Bits must match " + Assertions.errorMessageContext("x", x, "y", y);
        return IntegerStamp.subtractionOverflows(x.lowerBound(), y.upperBound(), x.getBits()) || IntegerStamp.subtractionOverflows(x.upperBound(), y.lowerBound(), x.getBits());
    }

    public static boolean subtractionOverflows(long x, long y, int bits) {
        long result = x - y;
        if (bits == 64) {
            return ((x ^ y) & (x ^ result)) < 0L;
        }
        return result < CodeUtil.minValue((int)bits) || result > CodeUtil.maxValue((int)bits);
    }

    public static boolean negateCanOverflow(IntegerStamp stamp) {
        return stamp.lowerBound() == CodeUtil.minValue((int)stamp.getBits());
    }

    static {
        for (int logBits = 0; logBits < emptyStamps.length; ++logBits) {
            IntegerStamp.emptyStamps[logBits] = new IntegerStamp(1 << logBits, true);
            IntegerStamp.unrestrictedStamps[logBits] = new IntegerStamp(1 << logBits, false);
        }
    }
}

