/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import java.nio.ByteBuffer;
import java.util.function.DoubleBinaryOperator;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.calc.ReinterpretUtils;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;

public final class FloatStamp
extends PrimitiveStamp {
    private final double lowerBound;
    private final double upperBound;
    private final boolean nonNaN;
    public static final ArithmeticOpTable OPS = new ArithmeticOpTable(new ArithmeticOpTable.UnaryOp.Neg(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return switch (value.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)(-value.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)(-value.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            return new FloatStamp(stamp.getBits(), -stamp.upperBound(), -stamp.lowerBound(), stamp.isNonNaN());
        }
    }, new ArithmeticOpTable.BinaryOp.Add(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)(a.asFloat() + b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)(a.asDouble() + b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            double upperBound;
            double lowerBound;
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            boolean isNonNaN = true;
            if (stamp1.canBeNaN() || stamp2.canBeNaN()) {
                isNonNaN = false;
            } else if (stamp1.canBeNInf() && stamp2.canBePInf() || stamp1.canBePInf() && stamp2.canBeNInf()) {
                isNonNaN = false;
            }
            if (stamp1.getBits() == 32) {
                lowerBound = stamp1.lowerBound32() + stamp2.lowerBound32();
                upperBound = stamp1.upperBound32() + stamp2.upperBound32();
            } else {
                lowerBound = stamp1.lowerBound() + stamp2.lowerBound();
                upperBound = stamp1.upperBound() + stamp2.upperBound();
            }
            if (stamp1.lowerBound() == Double.POSITIVE_INFINITY && stamp2.upperBound() > Double.NEGATIVE_INFINITY || stamp1.upperBound() > Double.NEGATIVE_INFINITY && stamp2.lowerBound() == Double.POSITIVE_INFINITY) {
                lowerBound = Double.POSITIVE_INFINITY;
            }
            if (stamp1.lowerBound() < Double.POSITIVE_INFINITY && stamp2.upperBound() == Double.NEGATIVE_INFINITY || stamp1.upperBound() == Double.NEGATIVE_INFINITY && stamp2.lowerBound() < Double.POSITIVE_INFINITY) {
                upperBound = Double.NEGATIVE_INFINITY;
            }
            return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return switch (n.getJavaKind()) {
                case JavaKind.Float -> {
                    if (Float.compare(n.asFloat(), -0.0f) == 0) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (Double.compare(n.asDouble(), -0.0) == 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(n.getJavaKind());
            };
        }
    }, new ArithmeticOpTable.BinaryOp.Sub(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)(a.asFloat() - b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)(a.asDouble() - b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            double upperBound;
            double lowerBound;
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            boolean isNonNaN = true;
            if (stamp1.canBeNaN() || stamp2.canBeNaN()) {
                isNonNaN = false;
            } else if (stamp1.canBeNInf() && stamp2.canBeNInf() || stamp1.canBePInf() && stamp2.canBePInf()) {
                isNonNaN = false;
            }
            if (stamp1.getBits() == 32) {
                lowerBound = stamp1.lowerBound32() - stamp2.upperBound32();
                upperBound = stamp1.upperBound32() - stamp2.lowerBound32();
            } else {
                lowerBound = stamp1.lowerBound() - stamp2.upperBound();
                upperBound = stamp1.upperBound() - stamp2.lowerBound();
            }
            if (stamp1.lowerBound() == Double.POSITIVE_INFINITY && stamp2.lowerBound() < Double.POSITIVE_INFINITY || stamp1.upperBound() > Double.NEGATIVE_INFINITY && stamp2.upperBound() == Double.NEGATIVE_INFINITY) {
                lowerBound = Double.POSITIVE_INFINITY;
            }
            if (stamp1.lowerBound() < Double.POSITIVE_INFINITY && stamp2.lowerBound() == Double.POSITIVE_INFINITY || stamp1.upperBound() == Double.NEGATIVE_INFINITY && stamp2.upperBound() > Double.NEGATIVE_INFINITY) {
                upperBound = Double.NEGATIVE_INFINITY;
            }
            return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return switch (n.getJavaKind()) {
                case JavaKind.Float -> {
                    if (Float.compare(n.asFloat(), 0.0f) == 0) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (Double.compare(n.asDouble(), 0.0) == 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(n.getJavaKind());
            };
        }
    }, new ArithmeticOpTable.BinaryOp.Mul(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)(a.asFloat() * b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)(a.asDouble() * b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            double bound;
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            if (stamp1.isNaN()) {
                return stamp1;
            }
            if (stamp2.isNaN()) {
                return stamp2;
            }
            boolean isNonNaN = true;
            if (stamp1.canBeNaN() || stamp2.canBeNaN()) {
                isNonNaN = false;
            } else if (stamp1.contains(0.0) && stamp2.canBeInf()) {
                isNonNaN = false;
            } else if (stamp2.contains(0.0) && stamp1.canBeInf()) {
                isNonNaN = false;
            }
            FloatStamp constant = null;
            FloatStamp other = null;
            if (stamp1.lowerBound() == stamp1.upperBound()) {
                constant = stamp1;
                other = stamp2;
            }
            if (stamp2.lowerBound() == stamp2.upperBound() && (constant == null || constant.lowerBound() == 0.0)) {
                constant = stamp2;
                other = stamp1;
            }
            if (constant != null) {
                double constantVal = constant.lowerBound();
                if (Double.isInfinite(constantVal)) {
                    double upperBound;
                    double lowerBound;
                    if (other.lowerBound() == 0.0 && other.upperBound() == 0.0) {
                        return FloatStamp.createNaN(constant.getBits());
                    }
                    if (other.lowerBound() >= 0.0) {
                        lowerBound = constantVal;
                        upperBound = constantVal;
                    } else if (other.upperBound() <= 0.0) {
                        lowerBound = -constantVal;
                        upperBound = -constantVal;
                    } else {
                        lowerBound = Double.NEGATIVE_INFINITY;
                        upperBound = Double.POSITIVE_INFINITY;
                    }
                    return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
                }
                if (constantVal == 0.0) {
                    return new FloatStamp(stamp1.getBits(), -0.0, 0.0, isNonNaN);
                }
            }
            double lowerBound = Double.POSITIVE_INFINITY;
            double upperBound = Double.NEGATIVE_INFINITY;
            if (stamp1.lowerBound() == Double.NEGATIVE_INFINITY && stamp2.lowerBound() == 0.0) {
                lowerBound = Double.NEGATIVE_INFINITY;
                upperBound = Math.max(upperBound, -stamp2.lowerBound());
            } else if (stamp1.lowerBound() == 0.0 && stamp2.lowerBound() == Double.NEGATIVE_INFINITY) {
                lowerBound = Double.NEGATIVE_INFINITY;
                upperBound = Math.max(upperBound, -stamp1.lowerBound());
            } else {
                bound = stamp1.getBits() == 32 ? (double)(stamp1.lowerBound32() * stamp2.lowerBound32()) : stamp1.lowerBound() * stamp2.lowerBound();
                lowerBound = Math.min(lowerBound, bound);
                upperBound = Math.max(upperBound, bound);
            }
            if (stamp1.upperBound() == Double.POSITIVE_INFINITY && stamp2.upperBound() == 0.0) {
                lowerBound = Double.NEGATIVE_INFINITY;
                upperBound = Math.max(upperBound, stamp2.upperBound());
            } else if (stamp1.upperBound() == 0.0 && stamp2.upperBound() == Double.POSITIVE_INFINITY) {
                lowerBound = Double.NEGATIVE_INFINITY;
                upperBound = Math.max(upperBound, stamp1.upperBound());
            } else {
                bound = stamp1.getBits() == 32 ? (double)(stamp1.upperBound32() * stamp2.upperBound32()) : stamp1.upperBound() * stamp2.upperBound();
                lowerBound = Math.min(lowerBound, bound);
                upperBound = Math.max(upperBound, bound);
            }
            if (stamp1.lowerBound() == Double.NEGATIVE_INFINITY && stamp2.upperBound() == 0.0) {
                lowerBound = Math.min(lowerBound, -stamp2.upperBound());
                upperBound = Double.POSITIVE_INFINITY;
            } else if (stamp1.lowerBound() == 0.0 && stamp2.upperBound() == Double.POSITIVE_INFINITY) {
                lowerBound = Math.min(lowerBound, stamp1.lowerBound());
                upperBound = Double.POSITIVE_INFINITY;
            } else {
                bound = stamp1.getBits() == 32 ? (double)(stamp1.lowerBound32() * stamp2.upperBound32()) : stamp1.lowerBound() * stamp2.upperBound();
                lowerBound = Math.min(lowerBound, bound);
                upperBound = Math.max(upperBound, bound);
            }
            if (stamp1.upperBound() == Double.POSITIVE_INFINITY && stamp2.lowerBound() == 0.0) {
                lowerBound = Math.min(lowerBound, stamp2.lowerBound());
                upperBound = Double.POSITIVE_INFINITY;
            } else if (stamp1.upperBound() == 0.0 && stamp2.lowerBound() == Double.NEGATIVE_INFINITY) {
                lowerBound = Math.min(lowerBound, -stamp1.upperBound());
                upperBound = Double.POSITIVE_INFINITY;
            } else {
                bound = stamp1.getBits() == 32 ? (double)(stamp1.upperBound32() * stamp2.lowerBound32()) : stamp1.upperBound() * stamp2.lowerBound();
                lowerBound = Math.min(lowerBound, bound);
                upperBound = Math.max(upperBound, bound);
            }
            return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return switch (n.getJavaKind()) {
                case JavaKind.Float -> {
                    if (n.asFloat() == 1.0f) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (n.asDouble() == 1.0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(n.getJavaKind());
            };
        }
    }, null, null, new ArithmeticOpTable.BinaryOp.Div(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)(a.asFloat() / b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)(a.asDouble() / b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            if (stamp1.isNaN()) {
                return stamp1;
            }
            if (stamp2.isNaN()) {
                return stamp2;
            }
            boolean isNonNaN = true;
            if (stamp1.canBeNaN() || stamp2.canBeNaN()) {
                isNonNaN = false;
            } else if (stamp1.canBeInf() && stamp2.canBeInf()) {
                isNonNaN = false;
            } else if (stamp1.contains(0.0) && stamp2.contains(0.0)) {
                isNonNaN = false;
            }
            if (stamp2.lowerBound() == Double.POSITIVE_INFINITY || stamp2.upperBound() == Double.NEGATIVE_INFINITY) {
                if (stamp1.lowerBound() == Double.POSITIVE_INFINITY || stamp1.upperBound() == Double.NEGATIVE_INFINITY) {
                    return FloatStamp.createNaN(stamp1.getBits());
                }
                return new FloatStamp(stamp1.getBits(), -0.0, 0.0, isNonNaN);
            }
            if (stamp1.lowerBound() == Double.POSITIVE_INFINITY || stamp1.upperBound() == Double.NEGATIVE_INFINITY) {
                if (stamp2.lowerBound() > 0.0) {
                    double bound = stamp1.lowerBound() / stamp2.lowerBound();
                    return new FloatStamp(stamp1.getBits(), bound, bound, isNonNaN);
                }
                if (stamp2.upperBound() < 0.0) {
                    double bound = stamp1.lowerBound() / stamp2.upperBound();
                    return new FloatStamp(stamp1.getBits(), bound, bound, isNonNaN);
                }
                return new FloatStamp(stamp1.getBits(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, isNonNaN);
            }
            if (stamp2.lowerBound() > 0.0) {
                double boundDivisor = stamp1.lowerBound() < 0.0 ? stamp2.lowerBound() : stamp2.upperBound();
                double lowerBound = stamp1.getBits() == 32 ? (double)(stamp1.lowerBound32() / (float)boundDivisor) : stamp1.lowerBound() / boundDivisor;
                boundDivisor = stamp1.upperBound() < 0.0 ? stamp2.upperBound() : stamp2.lowerBound();
                double upperBound = stamp1.getBits() == 32 ? (double)(stamp1.upperBound32() / (float)boundDivisor) : stamp1.upperBound() / boundDivisor;
                return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
            }
            if (stamp2.upperBound() < 0.0) {
                double boundDivisor = stamp1.upperBound() < 0.0 ? stamp2.lowerBound() : stamp2.upperBound();
                double lowerBound = stamp1.getBits() == 32 ? (double)(stamp1.upperBound32() / (float)boundDivisor) : stamp1.upperBound() / boundDivisor;
                boundDivisor = stamp1.lowerBound() < 0.0 ? stamp2.upperBound() : stamp2.lowerBound();
                double upperBound = stamp1.getBits() == 32 ? (double)(stamp1.lowerBound32() / (float)boundDivisor) : stamp1.lowerBound() / boundDivisor;
                return new FloatStamp(stamp1.getBits(), lowerBound, upperBound, isNonNaN);
            }
            return new FloatStamp(stamp1.getBits(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, isNonNaN);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return switch (n.getJavaKind()) {
                case JavaKind.Float -> {
                    if (n.asFloat() == 1.0f) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (n.asDouble() == 1.0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(n.getJavaKind());
            };
        }
    }, new ArithmeticOpTable.BinaryOp.Rem(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(a.asFloat() % b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(a.asDouble() % b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }
    }, new ArithmeticOpTable.UnaryOp.Not(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            switch (value.getJavaKind()) {
                case Float: {
                    int f = Float.floatToRawIntBits(value.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(~f));
                }
                case Double: {
                    long d = Double.doubleToRawLongBits(value.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(d ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
        }

        @Override
        protected Stamp foldStampImpl(Stamp s) {
            FloatStamp result;
            Constant folded;
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            JavaConstant constant = stamp.asConstant();
            if (constant != null && (folded = this.foldConstant((Constant)constant)) != null && (result = FloatStamp.stampForConstant(folded)) != null && result.isConstant()) {
                return result;
            }
            return s.unrestricted();
        }
    }, new ArithmeticOpTable.BinaryOp.And(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(fa & fb));
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da & db));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == -1;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == -1L;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
        }
    }, new ArithmeticOpTable.BinaryOp.Or(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    float floatOr = Float.intBitsToFloat(fa | fb);
                    assert ((fa | fb) == Float.floatToRawIntBits(floatOr)) : Assertions.errorMessageContext("a", a, "b", b);
                    return JavaConstant.forFloat((float)floatOr);
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da | db));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == 0;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == 0L;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
        }
    }, new ArithmeticOpTable.BinaryOp.Xor(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(fa ^ fb));
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da ^ db));
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == 0;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == 0L;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
        }
    }, null, null, null, new ArithmeticOpTable.UnaryOp.Abs(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return switch (value.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)Math.abs(value.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)Math.abs(value.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s) {
            double upperBound;
            double lowerBound;
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            if (stamp.isNaN()) {
                return s;
            }
            if (stamp.lowerBound() > 0.0) {
                lowerBound = stamp.lowerBound();
                upperBound = stamp.upperBound();
            } else if (stamp.upperBound() < 0.0) {
                lowerBound = -stamp.upperBound();
                upperBound = -stamp.lowerBound();
            } else {
                lowerBound = 0.0;
                upperBound = Math.max(Math.abs(stamp.lowerBound()), Math.abs(stamp.upperBound()));
            }
            return new FloatStamp(stamp.getBits(), lowerBound, upperBound, stamp.isNonNaN());
        }
    }, new ArithmeticOpTable.UnaryOp.Sqrt(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return switch (value.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)((float)Math.sqrt(value.asFloat())));
                case JavaKind.Double -> JavaConstant.forDouble((double)Math.sqrt(value.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            if (stamp.isNaN()) {
                return s;
            }
            if (stamp.upperBound() < 0.0) {
                return FloatStamp.createNaN(stamp.getBits());
            }
            double lowerBound = Math.sqrt(Math.max(-0.0, stamp.lowerBound()));
            double upperBound = Math.sqrt(stamp.upperBound());
            if (stamp.getBits() == 32) {
                lowerBound = (float)lowerBound;
                upperBound = (float)upperBound;
            }
            return new FloatStamp(stamp.getBits(), lowerBound, upperBound, stamp.isNonNaN() && stamp.lowerBound() >= 0.0);
        }
    }, null, null, null, new ArithmeticOpTable.BinaryOp.Max(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)Math.max(a.asFloat(), b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)Math.max(a.asDouble(), b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            return new FloatStamp(stamp1.getBits(), Math.max(stamp1.lowerBound(), stamp2.lowerBound()), Math.max(stamp1.upperBound(), stamp2.upperBound()), stamp1.isNonNaN() && stamp2.isNonNaN());
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            return switch (value.getJavaKind()) {
                case JavaKind.Float -> {
                    if (value.asFloat() == Float.NEGATIVE_INFINITY) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (value.asDouble() == Double.NEGATIVE_INFINITY) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
            };
        }
    }, new ArithmeticOpTable.BinaryOp.Min(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind()) : "Must have same kind " + Assertions.errorMessageContext("a", a, "b", b);
            return switch (a.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)Math.min(a.asFloat(), b.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)Math.min(a.asDouble(), b.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(a.getJavaKind());
            };
        }

        @Override
        protected Stamp foldStampImpl(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            return new FloatStamp(stamp1.getBits(), Math.min(stamp1.lowerBound(), stamp2.lowerBound()), Math.min(stamp1.upperBound(), stamp2.upperBound()), stamp1.isNonNaN() && stamp2.isNonNaN());
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            return switch (value.getJavaKind()) {
                case JavaKind.Float -> {
                    if (value.asFloat() == Float.POSITIVE_INFINITY) {
                        yield true;
                    }
                    yield false;
                }
                case JavaKind.Double -> {
                    if (value.asDouble() == Double.POSITIVE_INFINITY) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
            };
        }
    }, null, null, new ArithmeticOpTable.TernaryOp.FMA(){

        public JavaConstant foldConstant(Constant a, Constant b, Constant c) {
            PrimitiveConstant pa = (PrimitiveConstant)a;
            PrimitiveConstant pb = (PrimitiveConstant)b;
            PrimitiveConstant pc = (PrimitiveConstant)c;
            GraalError.guarantee(pa.getJavaKind() == pb.getJavaKind() && pa.getJavaKind() == pc.getJavaKind(), "Must have same kind: a %s, b %s, c %s", (Object)pa, (Object)pb, (Object)pc);
            return switch (pa.getJavaKind()) {
                case JavaKind.Float -> JavaConstant.forFloat((float)GraalServices.fma(pa.asFloat(), pb.asFloat(), pc.asFloat()));
                case JavaKind.Double -> JavaConstant.forDouble((double)GraalServices.fma(pa.asDouble(), pb.asDouble(), pc.asDouble()));
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(pa.getJavaKind());
            };
        }

        @Override
        public Stamp foldStamp(Stamp a, Stamp b, Stamp c) {
            if (a.isEmpty()) {
                return a;
            }
            if (b.isEmpty()) {
                return b;
            }
            if (c.isEmpty()) {
                return c;
            }
            JavaConstant constantA = ((FloatStamp)a).asConstant();
            JavaConstant constantB = ((FloatStamp)b).asConstant();
            JavaConstant constantC = ((FloatStamp)c).asConstant();
            if (constantA != null && constantB != null && constantC != null) {
                return StampFactory.forConstant(this.foldConstant((Constant)constantA, (Constant)constantB, (Constant)constantC));
            }
            return a.unrestricted();
        }
    }, new ArithmeticOpTable.ReinterpretOp(){

        @Override
        public Constant foldConstant(Stamp resultStamp, Constant constant) {
            return ReinterpretUtils.foldConstant(resultStamp, constant);
        }

        @Override
        public Stamp foldStamp(Stamp resultStamp, Stamp input) {
            if (input.isEmpty()) {
                return resultStamp.empty();
            }
            if (resultStamp instanceof IntegerStamp && input instanceof FloatStamp) {
                return ReinterpretUtils.floatToInt((FloatStamp)input);
            }
            return resultStamp;
        }
    }, null, null, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2I){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forInt((int)((int)value.asFloat()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Int);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32) : floatStamp;
            boolean mustHaveZero = !floatStamp.isNonNaN();
            int lowerBound = (int)floatStamp.lowerBound();
            int upperBound = (int)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0) {
                    lowerBound = 0;
                } else if (upperBound < 0) {
                    upperBound = 0;
                }
            }
            return StampFactory.forInteger(JavaKind.Int, lowerBound, upperBound);
        }

        @Override
        public boolean canOverflowInteger(Stamp inputStamp) {
            FloatStamp floatStamp;
            return inputStamp instanceof FloatStamp && FloatStamp.floatingToIntegerCanOverflow(floatStamp = (FloatStamp)inputStamp, 32);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2L){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forLong((long)((long)value.asFloat()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Long);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32) : floatStamp;
            boolean mustHaveZero = !floatStamp.isNonNaN();
            long lowerBound = (long)floatStamp.lowerBound();
            long upperBound = (long)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0L) {
                    lowerBound = 0L;
                } else if (upperBound < 0L) {
                    upperBound = 0L;
                }
            }
            return StampFactory.forInteger(JavaKind.Long, lowerBound, upperBound);
        }

        @Override
        public boolean canOverflowInteger(Stamp inputStamp) {
            FloatStamp floatStamp;
            return inputStamp instanceof FloatStamp && FloatStamp.floatingToIntegerCanOverflow(floatStamp = (FloatStamp)inputStamp, 64);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2I){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forInt((int)((int)value.asDouble()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Int);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64) : floatStamp;
            boolean mustHaveZero = !floatStamp.isNonNaN();
            int lowerBound = (int)floatStamp.lowerBound();
            int upperBound = (int)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0) {
                    lowerBound = 0;
                } else if (upperBound < 0) {
                    upperBound = 0;
                }
            }
            return StampFactory.forInteger(JavaKind.Int, lowerBound, upperBound);
        }

        @Override
        public boolean canOverflowInteger(Stamp inputStamp) {
            FloatStamp floatStamp;
            return inputStamp instanceof FloatStamp && FloatStamp.floatingToIntegerCanOverflow(floatStamp = (FloatStamp)inputStamp, 32);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2L){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forLong((long)((long)value.asDouble()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Long);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64) : floatStamp;
            boolean mustHaveZero = !floatStamp.isNonNaN();
            long lowerBound = (long)floatStamp.lowerBound();
            long upperBound = (long)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0L) {
                    lowerBound = 0L;
                } else if (upperBound < 0L) {
                    upperBound = 0L;
                }
            }
            return StampFactory.forInteger(JavaKind.Long, lowerBound, upperBound);
        }

        @Override
        public boolean canOverflowInteger(Stamp inputStamp) {
            FloatStamp floatStamp;
            return inputStamp instanceof FloatStamp && FloatStamp.floatingToIntegerCanOverflow(floatStamp = (FloatStamp)inputStamp, 64);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asFloat());
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32) : floatStamp;
            return StampFactory.forFloat(JavaKind.Double, floatStamp.lowerBound(), floatStamp.upperBound(), floatStamp.isNonNaN());
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)((float)value.asDouble()));
        }

        @Override
        protected Stamp foldStampImpl(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64) : Assertions.errorMessage(floatStamp);
            return StampFactory.forFloat(JavaKind.Float, (float)floatStamp.lowerBound(), (float)floatStamp.upperBound(), floatStamp.isNonNaN());
        }
    });

    private FloatStamp(int bits, double lowerBound, double upperBound, boolean nonNaN) {
        super(bits, OPS);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.nonNaN = nonNaN;
    }

    public static FloatStamp create(int bits, double lowerBound, double upperBound, boolean nonNaN) {
        assert (bits == 64 || bits == 32) : Assertions.errorMessage(bits);
        if (bits == 32) {
            assert (Double.compare((float)lowerBound, lowerBound) == 0) : Assertions.errorMessage(lowerBound);
            assert (Double.compare((float)upperBound, upperBound) == 0) : Assertions.errorMessage(upperBound);
        }
        assert (Double.isNaN(lowerBound) == Double.isNaN(upperBound)) : Assertions.errorMessage(lowerBound, upperBound);
        assert (!Double.isNaN(lowerBound) || !nonNaN) : Assertions.errorMessage(lowerBound, nonNaN);
        assert (!(lowerBound > upperBound)) : Assertions.errorMessage(lowerBound, upperBound);
        return new FloatStamp(bits, lowerBound, upperBound, nonNaN);
    }

    public static FloatStamp createUnrestricted(int bits) {
        assert (bits == 64 || bits == 32) : Assertions.errorMessage(bits);
        return bits == 64 ? ConstantCache.DOUBLE_BOTTOM : ConstantCache.FLOAT_BOTTOM;
    }

    public static FloatStamp createEmpty(int bits) {
        assert (bits == 64 || bits == 32) : Assertions.errorMessage(bits);
        return bits == 64 ? ConstantCache.DOUBLE_TOP : ConstantCache.FLOAT_TOP;
    }

    public static FloatStamp createNaN(int bits) {
        assert (bits == 64 || bits == 32) : Assertions.errorMessage(bits);
        return bits == 64 ? ConstantCache.DOUBLE_NAN : ConstantCache.FLOAT_NAN;
    }

    @Override
    public FloatStamp unrestricted() {
        return FloatStamp.createUnrestricted(this.getBits());
    }

    @Override
    public FloatStamp empty() {
        return FloatStamp.createEmpty(this.getBits());
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        JavaConstant jc = (JavaConstant)c;
        assert (jc.getJavaKind().isNumericFloat() && jc.getJavaKind().getBitCount() == this.getBits()) : Assertions.errorMessage(jc, this.getBits());
        return StampFactory.forConstant(jc);
    }

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer) {
        switch (this.getBits()) {
            case 32: {
                return JavaConstant.forFloat((float)buffer.getFloat());
            }
            case 64: {
                return JavaConstant.forDouble((double)buffer.getDouble());
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.getBits());
    }

    @Override
    public boolean hasValues() {
        return !(this.lowerBound > this.upperBound);
    }

    @Override
    public JavaKind getStackKind() {
        if (this.getBits() > 32) {
            return JavaKind.Double;
        }
        return JavaKind.Float;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getFloatingKind(this.getBits());
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        switch (this.getBits()) {
            case 32: {
                return metaAccess.lookupJavaType(Float.TYPE);
            }
            case 64: {
                return metaAccess.lookupJavaType(Double.TYPE);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.getBits());
    }

    public double lowerBound() {
        assert (this.hasValues()) : "Empty stamp";
        return this.lowerBound;
    }

    public double upperBound() {
        assert (this.hasValues()) : "Empty stamp";
        return this.upperBound;
    }

    private float lowerBound32() {
        assert (this.getBits() == 32) : "Must be float";
        return (float)this.lowerBound();
    }

    private float upperBound32() {
        assert (this.getBits() == 32) : "Must be float";
        return (float)this.upperBound();
    }

    public boolean isNonNaN() {
        return this.nonNaN;
    }

    public boolean canBeNaN() {
        return !this.nonNaN;
    }

    public boolean isNaN() {
        return Double.isNaN(this.lowerBound);
    }

    @Override
    public boolean isUnrestricted() {
        return this.lowerBound == Double.NEGATIVE_INFINITY && this.upperBound == Double.POSITIVE_INFINITY && !this.nonNaN;
    }

    private boolean canBeNInf() {
        return this.lowerBound == Double.NEGATIVE_INFINITY;
    }

    private boolean canBePInf() {
        return this.upperBound == Double.POSITIVE_INFINITY;
    }

    private boolean canBeInf() {
        return this.canBeNInf() || this.canBePInf();
    }

    public boolean contains(double value) {
        if (Double.isNaN(value)) {
            return !this.nonNaN;
        }
        return value >= this.lowerBound && value <= this.upperBound;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('f');
        str.append(this.getBits());
        if (this.hasValues()) {
            str.append(this.nonNaN ? "!" : "");
            if (this.lowerBound == this.upperBound) {
                str.append(" [").append(this.lowerBound).append(']');
            } else if (this.lowerBound != Double.NEGATIVE_INFINITY || this.upperBound != Double.POSITIVE_INFINITY) {
                str.append(" [").append(this.lowerBound).append(" - ").append(this.upperBound).append(']');
            }
        } else {
            str.append("<empty>");
        }
        return str.toString();
    }

    private static double meetBounds(double a, double b, DoubleBinaryOperator op) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return op.applyAsDouble(a, b);
    }

    @Override
    public Stamp meet(Stamp otherStamp) {
        boolean meetNonNaN;
        if (otherStamp == this) {
            return this;
        }
        if (this.isEmpty()) {
            return otherStamp;
        }
        if (otherStamp.isEmpty()) {
            return this;
        }
        FloatStamp other = (FloatStamp)otherStamp;
        assert (this.getBits() == other.getBits()) : "Bits must match " + Assertions.errorMessageContext("thisBits", this.getBits(), "otherBits", other.getBits(), "other", other);
        double meetUpperBound = FloatStamp.meetBounds(this.upperBound, other.upperBound, Math::max);
        double meetLowerBound = FloatStamp.meetBounds(this.lowerBound, other.lowerBound, Math::min);
        boolean bl = meetNonNaN = this.nonNaN && other.nonNaN;
        if (Double.compare(meetLowerBound, this.lowerBound) == 0 && Double.compare(meetUpperBound, this.upperBound) == 0 && meetNonNaN == this.nonNaN) {
            return this;
        }
        if (Double.compare(meetLowerBound, other.lowerBound) == 0 && Double.compare(meetUpperBound, other.upperBound) == 0 && meetNonNaN == other.nonNaN) {
            return other;
        }
        return new FloatStamp(this.getBits(), meetLowerBound, meetUpperBound, meetNonNaN);
    }

    @Override
    public Stamp join(Stamp otherStamp) {
        boolean joinNonNaN;
        if (otherStamp == this) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (otherStamp.isEmpty()) {
            return otherStamp;
        }
        FloatStamp other = (FloatStamp)otherStamp;
        assert (this.getBits() == other.getBits()) : "Bits must match " + Assertions.errorMessageContext("thisBits", this.getBits(), "otherBits", other.getBits(), "other", other);
        double joinUpperBound = Math.min(this.upperBound, other.upperBound);
        double joinLowerBound = Math.max(this.lowerBound, other.lowerBound);
        boolean bl = joinNonNaN = this.nonNaN || other.nonNaN;
        if (joinLowerBound > joinUpperBound) {
            joinLowerBound = Double.NaN;
            joinUpperBound = Double.NaN;
        }
        if (Double.isNaN(joinLowerBound) && joinNonNaN) {
            return this.empty();
        }
        if (Double.compare(joinLowerBound, this.lowerBound) == 0 && Double.compare(joinUpperBound, this.upperBound) == 0 && joinNonNaN == this.nonNaN) {
            return this;
        }
        if (Double.compare(joinLowerBound, other.lowerBound) == 0 && Double.compare(joinUpperBound, other.upperBound) == 0 && joinNonNaN == other.nonNaN) {
            return other;
        }
        return new FloatStamp(this.getBits(), joinLowerBound, joinUpperBound, joinNonNaN);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        long temp = Double.doubleToLongBits(this.lowerBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.nonNaN ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.upperBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean isCompatible(Stamp stamp) {
        if (this == stamp) {
            return true;
        }
        if (stamp instanceof FloatStamp) {
            FloatStamp other = (FloatStamp)stamp;
            return this.getBits() == other.getBits();
        }
        return false;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)constant;
            JavaKind kind = prim.getJavaKind();
            return kind.isNumericFloat() && kind.getBitCount() == this.getBits();
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !super.equals(obj)) {
            return false;
        }
        FloatStamp other = (FloatStamp)obj;
        if (Double.doubleToLongBits(this.lowerBound) != Double.doubleToLongBits(other.lowerBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.upperBound) != Double.doubleToLongBits(other.upperBound)) {
            return false;
        }
        if (this.nonNaN != other.nonNaN) {
            return false;
        }
        return super.equals(other);
    }

    public JavaConstant asConstant() {
        if (this.isConstant()) {
            switch (this.getBits()) {
                case 32: {
                    return JavaConstant.forFloat((float)((float)this.lowerBound));
                }
                case 64: {
                    return JavaConstant.forDouble((double)this.lowerBound);
                }
            }
        }
        return null;
    }

    private boolean isConstant() {
        return this.lowerBound == this.upperBound && this.nonNaN && this.lowerBound != 0.0;
    }

    private static FloatStamp stampForConstant(Constant constant) {
        PrimitiveConstant value = (PrimitiveConstant)constant;
        FloatStamp result = switch (value.getJavaKind()) {
            case JavaKind.Float -> {
                if (Float.isNaN(value.asFloat())) {
                    yield new FloatStamp(32, Double.NaN, Double.NaN, false);
                }
                yield new FloatStamp(32, value.asFloat(), value.asFloat(), true);
            }
            case JavaKind.Double -> {
                if (Double.isNaN(value.asDouble())) {
                    yield new FloatStamp(64, Double.NaN, Double.NaN, false);
                }
                yield new FloatStamp(64, value.asDouble(), value.asDouble(), true);
            }
            default -> throw GraalError.shouldNotReachHereUnexpectedValue(value.getJavaKind());
        };
        if (result.isConstant()) {
            return result;
        }
        return null;
    }

    private static Stamp maybeFoldConstant(ArithmeticOpTable.BinaryOp<?> op, FloatStamp stamp1, FloatStamp stamp2) {
        FloatStamp stamp;
        JavaConstant constant2;
        JavaConstant constant1;
        Constant folded;
        if (stamp1.isConstant() && stamp2.isConstant() && (folded = op.foldConstant((Constant)(constant1 = stamp1.asConstant()), (Constant)(constant2 = stamp2.asConstant()))) != null && (stamp = FloatStamp.stampForConstant(folded)) != null && stamp.isConstant()) {
            assert (stamp.asConstant().equals((Object)folded));
            return stamp;
        }
        return null;
    }

    public static boolean floatingToIntegerCanOverflow(FloatStamp floatStamp, int integerBits) {
        boolean canBeInfinity;
        boolean bl = canBeInfinity = Double.isInfinite(floatStamp.lowerBound()) || Double.isInfinite(floatStamp.upperBound());
        if (canBeInfinity) {
            return true;
        }
        boolean conversionCanOverflow = FloatStamp.integralPartLargerMaxValue(floatStamp, integerBits) || FloatStamp.integralPartSmallerMinValue(floatStamp, integerBits);
        return conversionCanOverflow;
    }

    private static boolean integralPartLargerMaxValue(FloatStamp floatStamp, int integerBits) {
        double upperBound = floatStamp.upperBound();
        if (Double.isInfinite(upperBound) || Double.isNaN(upperBound)) {
            return true;
        }
        assert (integerBits == 32 || integerBits == 64) : "Must be int or long " + Assertions.errorMessage(integerBits, upperBound);
        long maxValue = NumUtil.maxValue(integerBits);
        return upperBound >= (double)maxValue;
    }

    private static boolean integralPartSmallerMinValue(FloatStamp floatStamp, int integerBits) {
        double lowerBound = floatStamp.lowerBound();
        if (Double.isInfinite(lowerBound) || Double.isNaN(lowerBound)) {
            return true;
        }
        assert (integerBits == 32 || integerBits == 64) : "Must be int or long " + Assertions.errorMessage(integerBits, lowerBound);
        long minValue = NumUtil.minValue(integerBits);
        return lowerBound <= (double)minValue;
    }

    private static class ConstantCache {
        private static final FloatStamp FLOAT_BOTTOM = new FloatStamp(32, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false);
        private static final FloatStamp DOUBLE_BOTTOM = new FloatStamp(64, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false);
        private static final FloatStamp FLOAT_TOP = new FloatStamp(32, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, true);
        private static final FloatStamp DOUBLE_TOP = new FloatStamp(64, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, true);
        private static final FloatStamp FLOAT_NAN = new FloatStamp(32, Double.NaN, Double.NaN, false);
        private static final FloatStamp DOUBLE_NAN = new FloatStamp(64, Double.NaN, Double.NaN, false);

        private ConstantCache() {
        }
    }
}

