/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.spi;

import java.util.Arrays;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.GraalError;

public final class ForeignCallSignature {
    public static final Pattern NAME_PATTERN = Pattern.compile("[\\S]+");
    private final String name;
    private final Class<?> resultType;
    private final Class<?>[] argumentTypes;

    public ForeignCallSignature(String name, Class<?> resultType, Class<?> ... argumentTypes) {
        GraalError.guarantee(NAME_PATTERN.matcher(name).matches(), "invalid foreign call name: %s", (Object)name);
        this.name = name;
        this.resultType = resultType;
        this.argumentTypes = argumentTypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public Class<?>[] getArgumentTypes() {
        return (Class[])this.argumentTypes.clone();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignCallSignature) {
            ForeignCallSignature other = (ForeignCallSignature)obj;
            return other.name.equals(this.name) && other.resultType.equals(this.resultType) && Arrays.equals(other.argumentTypes, this.argumentTypes);
        }
        return false;
    }

    public String toString(boolean withName) {
        StringBuilder sb = withName ? new StringBuilder(this.name) : new StringBuilder();
        sb.append('(');
        String sep = "";
        for (Class<?> arg : this.argumentTypes) {
            sb.append(sep).append(arg.getSimpleName());
            sep = ",";
        }
        return sb.append(')').append(this.resultType.getSimpleName()).toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

