/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BasicBlock;

public abstract class CFGLoop<T extends BasicBlock<T>> {
    private final CFGLoop<T> parent;
    private final ArrayList<CFGLoop<T>> children;
    private final int depth;
    private final int index;
    private final T header;
    private final ArrayList<T> blocks;
    private final ArrayList<T> exits;
    private final ArrayList<T> naturalExits;
    private boolean inverted = false;

    protected CFGLoop(CFGLoop<T> parent, int index, T header) {
        this.parent = parent;
        this.depth = parent != null ? parent.getDepth() + 1 : 1;
        this.index = index;
        this.header = header;
        this.blocks = new ArrayList();
        this.children = new ArrayList();
        this.exits = new ArrayList();
        this.naturalExits = new ArrayList();
    }

    public abstract int numBackedges();

    public String toString() {
        return "loop " + this.index + " depth " + this.getDepth() + (String)(this.parent != null ? " outer " + this.parent.index : "");
    }

    public CFGLoop<T> getParent() {
        return this.parent;
    }

    public CFGLoop<T> getOutmostLoop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getOutmostLoop();
    }

    public List<CFGLoop<T>> getChildren() {
        return this.children;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIndex() {
        return this.index;
    }

    public T getHeader() {
        return this.header;
    }

    public List<T> getBlocks() {
        return this.blocks;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isAncestorOrSelf(CFGLoop<?> potentialAncestor) {
        for (CFGLoop<T> p = this; p != null; p = p.getParent()) {
            if (p != potentialAncestor) continue;
            return true;
        }
        return false;
    }

    public List<T> getLoopExits() {
        return this.exits;
    }

    public boolean isLoopExit(T block) {
        assert (CFGLoop.isSorted(this.exits));
        return Collections.binarySearch(this.exits, block, BasicBlock.BLOCK_ID_COMPARATOR) >= 0;
    }

    public ArrayList<T> getNaturalExits() {
        return this.naturalExits;
    }

    public boolean isNaturalExit(T block) {
        assert (CFGLoop.isSorted(this.naturalExits));
        return Collections.binarySearch(this.naturalExits, block, BasicBlock.BLOCK_ID_COMPARATOR) >= 0;
    }

    private static <T extends BasicBlock<T>> boolean isSorted(List<T> list) {
        int lastId = Integer.MIN_VALUE;
        for (BasicBlock block : list) {
            if (block.getId() < lastId) {
                return false;
            }
            lastId = block.getId();
        }
        return true;
    }

    public int hashCode() {
        return this.index + this.depth * 31;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

