/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.calc;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.calc.UnsignedMath;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;

public enum Condition {
    EQ("=="),
    NE("!="),
    LT("<"),
    LE("<="),
    GT(">"),
    GE(">="),
    AE("|>=|"),
    BE("|<=|"),
    AT("|>|"),
    BT("|<|");

    public final String operator;

    private Condition(String operator) {
        this.operator = operator;
    }

    public boolean check(int left, int right) {
        switch (this.ordinal()) {
            case 0: {
                return left == right;
            }
            case 1: {
                return left != right;
            }
            case 2: {
                return left < right;
            }
            case 3: {
                return left <= right;
            }
            case 4: {
                return left > right;
            }
            case 5: {
                return left >= right;
            }
            case 6: {
                return UnsignedMath.aboveOrEqual(left, right);
            }
            case 7: {
                return UnsignedMath.belowOrEqual(left, right);
            }
            case 8: {
                return UnsignedMath.aboveThan(left, right);
            }
            case 9: {
                return UnsignedMath.belowThan(left, right);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public CanonicalizedCondition canonicalize() {
        return new CanonicalizedCondition(switch (this.ordinal()) {
            case 0, 1 -> CanonicalCondition.EQ;
            case 2, 3, 4, 5 -> CanonicalCondition.LT;
            case 6, 7, 8, 9 -> CanonicalCondition.BT;
            default -> throw new IllegalArgumentException(this.toString());
        }, this.canonicalMirror(), this.canonicalNegate());
    }

    public boolean isCanonical() {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 9: {
                return true;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 6: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean canonicalMirror() {
        switch (this.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
            case 9: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 6: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean canonicalNegate() {
        switch (this.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 9: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
            case 6: {
                return true;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public final Condition negate() {
        switch (this.ordinal()) {
            case 0: {
                return NE;
            }
            case 1: {
                return EQ;
            }
            case 2: {
                return GE;
            }
            case 3: {
                return GT;
            }
            case 4: {
                return LE;
            }
            case 5: {
                return LT;
            }
            case 9: {
                return AE;
            }
            case 7: {
                return AT;
            }
            case 8: {
                return BE;
            }
            case 6: {
                return BT;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public boolean implies(Condition other) {
        if (other == this) {
            return true;
        }
        switch (this.ordinal()) {
            case 0: {
                return other == LE || other == GE || other == BE || other == AE;
            }
            case 1: {
                return false;
            }
            case 2: {
                return other == LE || other == NE;
            }
            case 3: {
                return false;
            }
            case 4: {
                return other == GE || other == NE;
            }
            case 5: {
                return false;
            }
            case 9: {
                return other == BE || other == NE;
            }
            case 7: {
                return false;
            }
            case 8: {
                return other == AE || other == NE;
            }
            case 6: {
                return false;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public final Condition mirror() {
        switch (this.ordinal()) {
            case 0: {
                return EQ;
            }
            case 1: {
                return NE;
            }
            case 2: {
                return GT;
            }
            case 3: {
                return GE;
            }
            case 4: {
                return LT;
            }
            case 5: {
                return LE;
            }
            case 9: {
                return AT;
            }
            case 7: {
                return AE;
            }
            case 8: {
                return BT;
            }
            case 6: {
                return BE;
            }
        }
        throw new IllegalArgumentException();
    }

    public final boolean isUnsigned() {
        return this == BT || this == BE || this == AT || this == AE;
    }

    public TriState foldCondition(Stamp compareStamp, Constant lt, Constant rt, ConstantReflectionProvider constantReflection, boolean unorderedIsTrue) {
        return compareStamp.tryConstantFold(this, lt, rt, unorderedIsTrue, constantReflection);
    }

    public boolean foldCondition(PrimitiveConstant lp, PrimitiveConstant rp, boolean unorderedIsTrue) {
        switch (lp.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: {
                int x = lp.asInt();
                int y = rp.asInt();
                switch (this.ordinal()) {
                    case 0: {
                        return x == y;
                    }
                    case 1: {
                        return x != y;
                    }
                    case 2: {
                        return x < y;
                    }
                    case 3: {
                        return x <= y;
                    }
                    case 4: {
                        return x > y;
                    }
                    case 5: {
                        return x >= y;
                    }
                    case 6: {
                        return UnsignedMath.aboveOrEqual(x, y);
                    }
                    case 7: {
                        return UnsignedMath.belowOrEqual(x, y);
                    }
                    case 8: {
                        return UnsignedMath.aboveThan(x, y);
                    }
                    case 9: {
                        return UnsignedMath.belowThan(x, y);
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Long: {
                long x = lp.asLong();
                long y = rp.asLong();
                switch (this.ordinal()) {
                    case 0: {
                        return x == y;
                    }
                    case 1: {
                        return x != y;
                    }
                    case 2: {
                        return x < y;
                    }
                    case 3: {
                        return x <= y;
                    }
                    case 4: {
                        return x > y;
                    }
                    case 5: {
                        return x >= y;
                    }
                    case 6: {
                        return UnsignedMath.aboveOrEqual(x, y);
                    }
                    case 7: {
                        return UnsignedMath.belowOrEqual(x, y);
                    }
                    case 8: {
                        return UnsignedMath.aboveThan(x, y);
                    }
                    case 9: {
                        return UnsignedMath.belowThan(x, y);
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Float: {
                float x = lp.asFloat();
                float y = rp.asFloat();
                if (Float.isNaN(x) || Float.isNaN(y)) {
                    return unorderedIsTrue;
                }
                switch (this.ordinal()) {
                    case 0: {
                        return x == y;
                    }
                    case 1: {
                        return x != y;
                    }
                    case 2: {
                        return x < y;
                    }
                    case 3: {
                        return x <= y;
                    }
                    case 4: {
                        return x > y;
                    }
                    case 5: {
                        return x >= y;
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
            case Double: {
                double x = lp.asDouble();
                double y = rp.asDouble();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    return unorderedIsTrue;
                }
                switch (this.ordinal()) {
                    case 0: {
                        return x == y;
                    }
                    case 1: {
                        return x != y;
                    }
                    case 2: {
                        return x < y;
                    }
                    case 3: {
                        return x <= y;
                    }
                    case 4: {
                        return x > y;
                    }
                    case 5: {
                        return x >= y;
                    }
                }
                throw new GraalError("expected condition: %s", new Object[]{this});
            }
        }
        throw new GraalError("expected value kind %s while folding condition: %s", new Object[]{lp.getJavaKind(), this});
    }

    private static boolean in(Condition needle, Condition ... haystack) {
        for (Condition c : haystack) {
            if (c != needle) continue;
            return true;
        }
        return false;
    }

    public boolean trueIsDisjoint(Condition other) {
        if (other == this) {
            return false;
        }
        switch (this.ordinal()) {
            case 0: {
                return Condition.in(other, NE, LT, GT, AT, BT);
            }
            case 1: {
                return other == EQ;
            }
            case 2: {
                return Condition.in(other, EQ, GT, GE);
            }
            case 3: {
                return other == GT;
            }
            case 4: {
                return Condition.in(other, EQ, LT, LE);
            }
            case 5: {
                return other == LT;
            }
            case 6: {
                return other == BT;
            }
            case 7: {
                return other == AT;
            }
            case 8: {
                return Condition.in(other, EQ, BE, BT);
            }
            case 9: {
                return Condition.in(other, EQ, AE, AT);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public Condition join(Condition other) {
        if (other == this) {
            return this;
        }
        switch (this.ordinal()) {
            case 0: {
                if (other == LE || other == GE || other == BE || other == AE) {
                    return EQ;
                }
                return null;
            }
            case 1: {
                if (other == LT || other == GT || other == BT || other == AT) {
                    return other;
                }
                if (other == LE) {
                    return LT;
                }
                if (other == GE) {
                    return GT;
                }
                if (other == BE) {
                    return BT;
                }
                if (other == AE) {
                    return AT;
                }
                return null;
            }
            case 3: {
                if (other == GE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == LT) {
                    return LT;
                }
                return null;
            }
            case 2: {
                if (other == NE || other == LE) {
                    return LT;
                }
                return null;
            }
            case 5: {
                if (other == LE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == GT) {
                    return GT;
                }
                return null;
            }
            case 4: {
                if (other == NE || other == GE) {
                    return GT;
                }
                return null;
            }
            case 7: {
                if (other == AE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == BT) {
                    return BT;
                }
                return null;
            }
            case 9: {
                if (other == NE || other == BE) {
                    return BT;
                }
                return null;
            }
            case 6: {
                if (other == BE || other == EQ) {
                    return EQ;
                }
                if (other == NE || other == AT) {
                    return AT;
                }
                return null;
            }
            case 8: {
                if (other == NE || other == AE) {
                    return AT;
                }
                return null;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public Condition meet(Condition other) {
        if (other == this) {
            return this;
        }
        switch (this.ordinal()) {
            case 0: {
                if (other == LE || other == GE || other == BE || other == AE) {
                    return other;
                }
                if (other == LT) {
                    return LE;
                }
                if (other == GT) {
                    return GE;
                }
                if (other == BT) {
                    return BE;
                }
                if (other == AT) {
                    return AE;
                }
                return null;
            }
            case 1: {
                if (other == LT || other == GT || other == BT || other == AT) {
                    return NE;
                }
                return null;
            }
            case 3: {
                if (other == EQ || other == LT) {
                    return LE;
                }
                return null;
            }
            case 2: {
                if (other == EQ || other == LE) {
                    return LE;
                }
                if (other == NE || other == GT) {
                    return NE;
                }
                return null;
            }
            case 5: {
                if (other == EQ || other == GT) {
                    return GE;
                }
                return null;
            }
            case 4: {
                if (other == EQ || other == GE) {
                    return GE;
                }
                if (other == NE || other == LT) {
                    return NE;
                }
                return null;
            }
            case 7: {
                if (other == EQ || other == BT) {
                    return BE;
                }
                return null;
            }
            case 9: {
                if (other == EQ || other == BE) {
                    return BE;
                }
                if (other == NE || other == AT) {
                    return NE;
                }
                return null;
            }
            case 6: {
                if (other == EQ || other == AT) {
                    return AE;
                }
                return null;
            }
            case 8: {
                if (other == EQ || other == AE) {
                    return AE;
                }
                if (other == NE || other == BT) {
                    return NE;
                }
                return null;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public static final class CanonicalizedCondition {
        private final CanonicalCondition canonicalCondition;
        private final boolean mirror;
        private final boolean negate;

        private CanonicalizedCondition(CanonicalCondition canonicalCondition, boolean mirror, boolean negate) {
            this.canonicalCondition = canonicalCondition;
            this.mirror = mirror;
            this.negate = negate;
        }

        public CanonicalCondition getCanonicalCondition() {
            return this.canonicalCondition;
        }

        public boolean mustMirror() {
            return this.mirror;
        }

        public boolean mustNegate() {
            return this.negate;
        }
    }
}

