/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common;

import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaKind;

public enum Stride {
    S1(1, 0),
    S2(2, 1),
    S4(4, 2),
    S8(8, 3);

    public final int value;
    public final int log2;

    private Stride(int value, int log2) {
        this.value = value;
        this.log2 = log2;
    }

    public int getBitCount() {
        return this.value << 3;
    }

    public static Stride fromInt(int scale) {
        switch (scale) {
            case 1: {
                return S1;
            }
            case 2: {
                return S2;
            }
            case 4: {
                return S4;
            }
            case 8: {
                return S8;
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported stride: " + scale);
    }

    public static Stride fromLog2(int shift) {
        switch (shift) {
            case 0: {
                return S1;
            }
            case 1: {
                return S2;
            }
            case 2: {
                return S4;
            }
            case 3: {
                return S8;
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported stride: " + (1 << shift));
    }

    public static Stride fromJavaKind(JavaKind kind) {
        return Stride.fromInt(kind.getByteCount());
    }

    public static Stride min(Stride a, Stride b) {
        return a.value < b.value ? a : b;
    }

    public static Stride max(Stride a, Stride b) {
        return a.value > b.value ? a : b;
    }
}

