/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common;

import jdk.graal.compiler.options.EnumOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public enum SpectrePHTMitigations {
    None,
    AllTargets,
    GuardTargets,
    NonDeoptGuardTargets;


    public static class Options {
        public static final OptionKey<Boolean> SpeculativeExecutionBarriers = new OptionKey<Boolean>(Boolean.valueOf(false)){

            @Override
            public Boolean getValue(OptionValues values) {
                if (values.getMap().get(SpectrePHTBarriers) == AllTargets) {
                    return true;
                }
                return (Boolean)super.getValue(values);
            }

            @Override
            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (values.containsKey(SpectrePHTBarriers)) {
                    Object otherValue = values.get(SpectrePHTBarriers);
                    if (newValue.booleanValue() && otherValue != AllTargets || !newValue.booleanValue() && otherValue == AllTargets) {
                        throw new IllegalArgumentException("SpectrePHTBarriers can be set to 'AllTargets' if and only if SpeculativeExecutionBarriers is enabled or unspecified.");
                    }
                }
            }
        };
        public static final EnumOptionKey<SpectrePHTMitigations> SpectrePHTBarriers = new EnumOptionKey<SpectrePHTMitigations>(None){

            private boolean isSpeculativeExecutionBarriersEnabled(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                Object value = values.get(SpeculativeExecutionBarriers);
                return value != null && (Boolean)value != false;
            }

            @Override
            public SpectrePHTMitigations getValue(OptionValues values) {
                if (this.isSpeculativeExecutionBarriersEnabled(values.getMap())) {
                    return AllTargets;
                }
                return (SpectrePHTMitigations)((Object)super.getValue(values));
            }

            @Override
            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, SpectrePHTMitigations oldValue, SpectrePHTMitigations newValue) {
                boolean otherIsEnabled;
                if (values.containsKey(SpeculativeExecutionBarriers) && ((otherIsEnabled = this.isSpeculativeExecutionBarriersEnabled((UnmodifiableEconomicMap<OptionKey<?>, Object>)values)) && newValue != AllTargets || !otherIsEnabled && newValue == AllTargets)) {
                    throw new IllegalArgumentException("SpectrePHTBarriers can be set to 'AllTargets' if and only if SpeculativeExecutionBarriers is enabled or unspecified.");
                }
            }
        };
        public static final OptionKey<Boolean> SpectrePHTIndexMasking = new OptionKey<Boolean>(false);
    }
}

