/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.code.CodeUtil;

public class NumUtil {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    public static final int ASSERTION_TRUNCATE_ARR_LENGTH = 1024;

    public static boolean isShiftCount(int x) {
        return 0 <= x && x < 32;
    }

    public static boolean isUByte(int x) {
        return (x & 0xFF) == x;
    }

    public static boolean isByte(int x) {
        return (byte)x == x;
    }

    public static boolean isUByte(long x) {
        return (x & 0xFFL) == x;
    }

    public static boolean isByte(long l) {
        return (long)((byte)l) == l;
    }

    public static boolean isUInt(long x) {
        return (x & 0xFFFFFFFFL) == x;
    }

    public static boolean isInt(long l) {
        return (long)((int)l) == l;
    }

    public static boolean isShort(int x) {
        return (short)x == x;
    }

    public static boolean isShort(long x) {
        return (long)((short)x) == x;
    }

    public static boolean isUShort(int s) {
        return s == (s & 0xFFFF);
    }

    public static boolean is32bit(long x) {
        return Integer.MIN_VALUE <= x && x < 0x80000000L;
    }

    public static byte safeToUByte(int v) {
        assert (NumUtil.isUByte(v));
        return (byte)v;
    }

    public static byte safeToByte(long v) {
        assert (NumUtil.isByte(v));
        return (byte)v;
    }

    public static byte safeToByteAE(long v) {
        if (!NumUtil.isByte(v)) {
            throw new ArithmeticException(String.format("%s is not a byte", v));
        }
        return (byte)v;
    }

    public static short safeToUShort(int v) {
        assert (NumUtil.isUShort(v));
        return (short)v;
    }

    public static short safeToShort(long v) {
        assert (NumUtil.isShort(v));
        return (short)v;
    }

    public static short safeToShortAE(long v) {
        if (!NumUtil.isShort(v)) {
            throw new ArithmeticException(String.format("%s is not a short", v));
        }
        return (short)v;
    }

    public static int safeToUInt(long v) {
        assert (NumUtil.isUInt(v));
        return (int)v;
    }

    public static int safeToInt(long v) {
        assert (NumUtil.isInt(v));
        return (int)v;
    }

    public static int safeToIntAE(long v) {
        if (!NumUtil.isInt(v)) {
            throw new ArithmeticException(String.format("%s is not an int", v));
        }
        return (int)v;
    }

    public static int roundUp(int number, int mod) {
        return (number + mod - 1) / mod * mod;
    }

    public static long roundUp(long number, long mod) {
        return (number + mod - 1L) / mod * mod;
    }

    public static int divideAndRoundUp(int number, int divisor) {
        return (number + divisor - 1) / divisor;
    }

    public static boolean isUnsignedNbit(int n, int value) {
        assert (n > 0 && n < 32) : n;
        return 32 - Integer.numberOfLeadingZeros(value) <= n;
    }

    public static boolean isUnsignedNbit(int n, long value) {
        assert (n > 0 && n < 64) : n;
        return 64 - Long.numberOfLeadingZeros(value) <= n;
    }

    public static boolean isSignedNbit(int n, int value) {
        assert (n > 0 && n < 32) : n;
        int min = -(1 << n - 1);
        int max = (1 << n - 1) - 1;
        return value >= min && value <= max;
    }

    public static boolean isSignedNbit(int n, long value) {
        assert (n > 0 && n < 64) : n;
        long min = -(1L << n - 1);
        long max = (1L << n - 1) - 1L;
        return value >= min && value <= max;
    }

    public static int getNbitNumberInt(int n) {
        assert (n >= 0 && n <= 32) : "0 <= n <= 32; instead: " + n;
        if (n < 32) {
            return (1 << n) - 1;
        }
        return -1;
    }

    public static long getNbitNumberLong(int n) {
        assert (n >= 0 && n <= 64) : n;
        if (n < 64) {
            return (1L << n) - 1L;
        }
        return -1L;
    }

    public static long minValue(int bits) {
        return CodeUtil.minValue((int)bits);
    }

    public static long maxValue(int bits) {
        return CodeUtil.maxValue((int)bits);
    }

    public static long maxValueUnsigned(int bits) {
        return NumUtil.getNbitNumberLong(bits);
    }

    public static long maxUnsigned(long a, long b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return b;
        }
        return a;
    }

    public static long minUnsigned(long a, long b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return a;
        }
        return b;
    }

    public static boolean sameSign(long a, long b) {
        return a < 0L == b < 0L;
    }

    public static boolean isUnsignedPowerOf2(long n) {
        return n != 0L && (n & n - 1L) == 0L;
    }

    public static int unsignedLog2(long val) {
        assert (val != 0L);
        return 63 - Long.numberOfLeadingZeros(val);
    }

    public static byte[] hexStringToBytes(String hex) {
        int len = hex.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int val = Integer.parseInt(hex.substring(i << 1, (i << 1) + 2), 16);
            if (val < 0 || val > 255) {
                throw new NumberFormatException("Value out of range: " + val);
            }
            bytes[i] = (byte)val;
        }
        return bytes;
    }

    public static String bytesToHexString(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static boolean assertPositiveDouble(double d) {
        assert (Double.isFinite(d) && d >= 0.0) : "expected finite positive double, got " + d;
        return true;
    }

    public static boolean assertFiniteDouble(double d) {
        assert (Double.isFinite(d)) : "expected finite  double, got " + d;
        return true;
    }

    public static boolean assertNonNegativeInt(int i) {
        assert (i >= 0) : "expected positive int, got " + i;
        return true;
    }

    public static boolean assertPositiveInt(int i) {
        assert (i > 0) : "expected positive int, got " + i;
        return true;
    }

    public static boolean assertNonNegativeLong(long l) {
        assert (l >= 0L) : "expected positive long, got " + l;
        return true;
    }

    public static boolean assertNonNegativeDouble(double d) {
        assert (d >= 0.0) : "expected  positive double, got " + d;
        return true;
    }

    public static boolean assertArrayLength(Object[] o, int length) {
        assert (o.length == length) : "Length of array " + NumUtil.arrayToString(o, 1024) + " !=" + length;
        return true;
    }

    public static boolean assertArrayLength(Object[] o, int minLength, int maxLength) {
        assert (o.length >= minLength && o.length <= maxLength) : "Length of array " + NumUtil.arrayToString(o, 1024) + " is not in [" + minLength + ":" + maxLength + "]";
        return true;
    }

    public static String arrayToString(Object[] a, int truncateAfter) {
        if (a.length <= truncateAfter) {
            return Arrays.toString(a);
        }
        String s = Arrays.toString(Arrays.copyOf(a, truncateAfter));
        return s.substring(0, s.length() - 1) + ", ...]";
    }

    public static boolean absOverflows(long l, ValueNode v) {
        return NumUtil.absOverflows(l, IntegerStamp.getBits(v.stamp(NodeView.DEFAULT)));
    }

    public static boolean absOverflows(long l, int bits) {
        if (bits == 32) {
            int i = (int)l;
            return i == Integer.MIN_VALUE;
        }
        if (bits == 64) {
            return l == Long.MIN_VALUE;
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes but is " + bits);
    }

    public static long safeAbs(long l, ValueNode v) throws ArithmeticException {
        return NumUtil.safeAbs(l, IntegerStamp.getBits(v.stamp(NodeView.DEFAULT)));
    }

    public static long safeAbs(long l) throws ArithmeticException {
        return NumUtil.safeAbs(l, 64);
    }

    public static int safeAbs(int i) throws ArithmeticException {
        return NumUtil.safeToInt(NumUtil.safeAbs((long)i, 32));
    }

    public static long safeAbs(long l, int bits) throws ArithmeticException {
        if (bits == 32) {
            int i = (int)l;
            return Math.absExact(i);
        }
        if (bits == 64) {
            return Math.absExact(l);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes but is " + bits);
    }

    public static int unsafeAbs(int i) {
        return Math.abs(i);
    }

    public static long unsafeAbs(long l) {
        return Math.abs(l);
    }

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }
}

