/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import jdk.internal.misc.Unsafe;

public class FieldsScanner {
    private final CalcOffset calc;
    public final ArrayList<FieldInfo> data = new ArrayList();

    public FieldsScanner(CalcOffset calc) {
        this.calc = calc;
    }

    public void scan(Class<?> clazz, Class<?> endClazz, boolean includeTransient) {
        for (Class<?> currentClazz = clazz; currentClazz != endClazz; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !includeTransient && Modifier.isTransient(field.getModifiers())) continue;
                long offset = this.calc.getOffset(field);
                this.scanField(field, offset);
            }
        }
    }

    protected void scanField(Field field, long offset) {
        this.data.add(new FieldInfo(offset, field.getName(), field.getType(), field.getDeclaringClass()));
    }

    public static interface CalcOffset {
        public long getOffset(Field var1);
    }

    public static class FieldInfo
    implements Comparable<FieldInfo> {
        public static final Comparator<FieldInfo> STABLE_COMPARATOR = (o1, o2) -> {
            int res = o1.name.compareTo(o2.name);
            if (res == 0 && (res = o1.declaringClass.getName().compareTo(o2.declaringClass.getName())) == 0) {
                res = o1.type.getName().compareTo(o2.type.getName());
            }
            return res;
        };
        public final long offset;
        public final String name;
        public final Class<?> type;
        public final Class<?> declaringClass;

        public FieldInfo(long offset, String name, Class<?> type, Class<?> declaringClass) {
            this.offset = offset;
            this.name = name;
            this.type = type;
            this.declaringClass = declaringClass;
        }

        @Override
        public int compareTo(FieldInfo o) {
            return this.offset < o.offset ? -1 : (this.offset > o.offset ? 1 : 0);
        }

        public String toString() {
            return "[" + this.offset + "]" + this.name + ":" + this.type.getSimpleName();
        }
    }

    public static class DefaultCalcOffset
    implements CalcOffset {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();

        @Override
        public long getOffset(Field field) {
            return UNSAFE.objectFieldOffset(field);
        }
    }
}

