/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.DynamicDeoptimizeNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.MultiGuardNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.UseTrappingOperationPhase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.EconomicMap;

public class UseTrappingDivPhase
extends BasePhase<LowTierContext> {
    private static boolean conditionIsZeroCheck(LogicNode condition, ValueNode divisor) {
        if (condition instanceof IntegerEqualsNode) {
            IntegerEqualsNode eq = (IntegerEqualsNode)condition;
            return eq.getX() == divisor && eq.getY().isConstant() && eq.getY().asJavaConstant().asLong() == 0L;
        }
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        graph.clearLastSchedule();
        if (!GraalOptions.FloatingDivNodes.getValue(graph.getOptions()).booleanValue()) {
            return;
        }
        EconomicMap trappingReplaceTargets = null;
        StructuredGraph.ScheduleResult sched = null;
        for (IntegerDivRemNode divRem : graph.getNodes(IntegerDivRemNode.TYPE)) {
            IfNode ifNode;
            BeginNode divGuard;
            if (!(divRem instanceof SignedDivNode) && !(divRem instanceof SignedRemNode)) continue;
            ValueNode divisor = divRem.getY();
            ValueNode dividend = divRem.getX();
            if (divRem.getZeroGuard() instanceof MultiGuardNode || !(divRem.getZeroGuard() instanceof BeginNode) || !((divGuard = (BeginNode)divRem.getZeroGuard()).predecessor() instanceof IfNode) || (ifNode = (IfNode)divGuard.predecessor()).falseSuccessor() != divGuard || !UseTrappingDivPhase.conditionIsZeroCheck(ifNode.condition(), divisor) || !ifNode.condition().hasExactlyOneUsage()) continue;
            if (trappingReplaceTargets == null) {
                trappingReplaceTargets = EconomicMap.create();
                SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST);
                sched = graph.getLastSchedule();
            }
            HIRBlock ifBlock = sched.getNodeToBlockMap().get(ifNode);
            HIRBlock dividendBlock = sched.getNodeToBlockMap().get(dividend);
            if (dividendBlock == null) {
                assert (dividend instanceof PhiNode) : Assertions.errorMessage(dividend);
                dividendBlock = sched.getNodeToBlockMap().get(((PhiNode)dividend).merge());
            }
            if (!dividendBlock.dominates(ifBlock)) continue;
            trappingReplaceTargets.put((Object)((IntegerEqualsNode)ifNode.condition()), (Object)divRem);
        }
        if (trappingReplaceTargets != null) {
            new Instance(trappingReplaceTargets).run(graph, context);
        }
    }

    static class Instance
    extends UseTrappingOperationPhase {
        final EconomicMap<IntegerEqualsNode, IntegerDivRemNode> trappingReplaceTargets;

        Instance(EconomicMap<IntegerEqualsNode, IntegerDivRemNode> trappingReplaceTargets) {
            this.trappingReplaceTargets = trappingReplaceTargets;
        }

        @Override
        public boolean isSupportedReason(DeoptimizationReason reason) {
            return reason == DeoptimizationReason.ArithmeticException;
        }

        @Override
        public boolean canReplaceCondition(LogicNode condition, IfNode ifNode) {
            if (condition instanceof IntegerEqualsNode) {
                return this.trappingReplaceTargets.containsKey((Object)((IntegerEqualsNode)condition));
            }
            return false;
        }

        @Override
        public boolean useAddressOptimization(AddressNode adr, LowTierContext context) {
            return false;
        }

        @Override
        public DeoptimizingFixedWithNextNode tryReplaceExisting(StructuredGraph graph, AbstractBeginNode nonTrappingContinuation, AbstractBeginNode trappingContinuation, LogicNode condition, IfNode ifNode, AbstractDeoptimizeNode deopt, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
            return null;
        }

        @Override
        public DeoptimizingFixedWithNextNode createImplicitNode(StructuredGraph graph, LogicNode condition, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
            assert (condition instanceof IntegerEqualsNode) : condition;
            IntegerEqualsNode ieq = (IntegerEqualsNode)condition;
            IntegerDivRemNode divRem = (IntegerDivRemNode)this.trappingReplaceTargets.get((Object)ieq);
            ValueNode dividend = divRem.getX();
            ValueNode divisor = divRem.getY();
            IntegerDivRemNode divRemFixed = null;
            if (divRem instanceof SignedDivNode) {
                divRemFixed = graph.add(new SignedDivNode(dividend, divisor, null));
            } else if (divRem instanceof SignedRemNode) {
                divRemFixed = graph.add(new SignedRemNode(dividend, divisor, null));
            } else {
                throw GraalError.shouldNotReachHere("divRem is null or has unexpected type: " + String.valueOf(divRem));
            }
            divRemFixed.setImplicitDeoptimization(deoptReasonAndAction, deoptSpeculation);
            GraalError.guarantee(divRemFixed.canDeoptimize(), "Fixed representation must deopt since we replaced a 0 check");
            return divRemFixed;
        }

        @Override
        public boolean trueSuccessorIsDeopt() {
            return true;
        }

        @Override
        public void finalAction(DeoptimizingFixedWithNextNode trappingVersionNode, LogicNode condition) {
            assert (trappingVersionNode instanceof IntegerDivRemNode) : trappingVersionNode;
            IntegerDivRemNode fixedNonTrappingVersion = (IntegerDivRemNode)this.trappingReplaceTargets.get((Object)((IntegerEqualsNode)condition));
            fixedNonTrappingVersion.replaceAtUsages(trappingVersionNode);
            GraphUtil.unlinkFixedNode(fixedNonTrappingVersion);
            fixedNonTrappingVersion.safeDelete();
        }

        @Override
        public void actionBeforeGuardRewrite(DeoptimizingFixedWithNextNode trappingVersionNode) {
        }

        @Override
        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return ALWAYS_APPLICABLE;
        }

        @Override
        protected void run(StructuredGraph graph, LowTierContext context) {
            MetaAccessProvider metaAccessProvider = context.getMetaAccess();
            for (DeoptimizeNode deoptimizeNode : graph.getNodes(DeoptimizeNode.TYPE)) {
                this.tryUseTrappingVersion(deoptimizeNode, deoptimizeNode.predecessor(), deoptimizeNode.getSpeculation(), deoptimizeNode.getActionAndReason(metaAccessProvider).asJavaConstant(), deoptimizeNode.getSpeculation(metaAccessProvider).asJavaConstant(), context);
            }
            for (DynamicDeoptimizeNode dynamicDeoptimizeNode : graph.getNodes(DynamicDeoptimizeNode.TYPE)) {
                this.tryUseTrappingVersion(metaAccessProvider, dynamicDeoptimizeNode, context);
            }
        }
    }
}

