/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64LIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64NodeMatchRules;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.core.gen.NodeLIRBuilder;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public abstract class AMD64NodeLIRBuilder
extends NodeLIRBuilder {
    public AMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        Value targetAddressSrc = this.operand(callTarget.computedAddress());
        RegisterValue targetAddress = AMD64.rax.asValue(targetAddressSrc.getValueKind());
        this.gen.emitMove((AllocatableValue)targetAddress, targetAddressSrc);
        this.append(new AMD64Call.IndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)targetAddress, callState));
    }

    @Override
    protected boolean peephole(ValueNode valueNode) {
        if (valueNode instanceof IntegerDivRemNode) {
            AMD64ArithmeticLIRGenerator arithmeticGen = (AMD64ArithmeticLIRGenerator)this.gen.getArithmetic();
            IntegerDivRemNode divRem = (IntegerDivRemNode)valueNode;
            FixedNode node = divRem.next();
            while (true) {
                CompilationAlarm.checkProgress(valueNode.graph());
                if (node instanceof IfNode) {
                    IfNode ifNode = (IfNode)node;
                    double probability = ifNode.getTrueSuccessorProbability();
                    if (probability == 1.0) {
                        node = ifNode.trueSuccessor();
                    } else {
                        if (probability != 0.0) break;
                        node = ifNode.falseSuccessor();
                    }
                } else if (!(node instanceof FixedWithNextNode)) break;
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)node;
                if (fixedWithNextNode instanceof IntegerDivRemNode) {
                    IntegerDivRemNode otherDivRem = (IntegerDivRemNode)fixedWithNextNode;
                    if (divRem.getOp() != otherDivRem.getOp() && divRem.getType() == otherDivRem.getType() && otherDivRem.getX() == divRem.getX() && otherDivRem.getY() == divRem.getY() && !this.hasOperand(otherDivRem)) {
                        Value[] results = switch (divRem.getType()) {
                            case IntegerDivRemNode.Type.SIGNED -> arithmeticGen.emitSignedDivRem(this.operand(divRem.getX()), this.operand(divRem.getY()), this.state((DeoptimizingNode)((Object)valueNode)));
                            case IntegerDivRemNode.Type.UNSIGNED -> arithmeticGen.emitUnsignedDivRem(this.operand(divRem.getX()), this.operand(divRem.getY()), this.state((DeoptimizingNode)((Object)valueNode)));
                            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)divRem.getType());
                        };
                        switch (divRem.getOp()) {
                            case DIV: {
                                assert (otherDivRem.getOp() == IntegerDivRemNode.Op.REM) : Assertions.errorMessage(valueNode, otherDivRem);
                                this.setResult(divRem, results[0]);
                                this.setResult(otherDivRem, results[1]);
                                break;
                            }
                            case REM: {
                                assert (otherDivRem.getOp() == IntegerDivRemNode.Op.DIV) : Assertions.errorMessage(valueNode, otherDivRem);
                                this.setResult(divRem, results[1]);
                                this.setResult(otherDivRem, results[0]);
                                break;
                            }
                            default: {
                                throw GraalError.shouldNotReachHereUnexpectedValue((Object)divRem.getOp());
                            }
                        }
                        return true;
                    }
                }
                node = fixedWithNextNode.next();
            }
        }
        return false;
    }

    @Override
    public AMD64LIRGenerator getLIRGeneratorTool() {
        return (AMD64LIRGenerator)this.gen;
    }
}

