/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.PlatformKind;

public abstract class AMD64LIRKindTool
implements LIRKindTool {
    @Override
    public LIRKind getIntegerKind(int bits) {
        if (bits <= 8) {
            return LIRKind.value((PlatformKind)AMD64Kind.BYTE);
        }
        if (bits <= 16) {
            return LIRKind.value((PlatformKind)AMD64Kind.WORD);
        }
        if (bits <= 32) {
            return LIRKind.value((PlatformKind)AMD64Kind.DWORD);
        }
        assert (bits <= 64) : bits;
        return LIRKind.value((PlatformKind)AMD64Kind.QWORD);
    }

    @Override
    public LIRKind getFloatingKind(int bits) {
        switch (bits) {
            case 32: {
                return LIRKind.value((PlatformKind)AMD64Kind.SINGLE);
            }
            case 64: {
                return LIRKind.value((PlatformKind)AMD64Kind.DOUBLE);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(bits);
    }

    @Override
    public LIRKind getObjectKind() {
        return LIRKind.reference((PlatformKind)AMD64Kind.QWORD);
    }

    @Override
    public LIRKind getWordKind() {
        return LIRKind.value((PlatformKind)AMD64Kind.QWORD);
    }

    @Override
    public abstract LIRKind getNarrowOopKind();

    @Override
    public abstract LIRKind getNarrowPointerKind();
}

