/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import java.util.EnumSet;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64ReadBarrierSetLIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64ReadDataFromUserPageKeyRegister;
import jdk.graal.compiler.core.amd64.AMD64WriteDataToUserPageKeyRegister;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.AMD64AESDecryptOp;
import jdk.graal.compiler.lir.amd64.AMD64AESEncryptOp;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.lir.amd64.AMD64ArrayCompareToOp;
import jdk.graal.compiler.lir.amd64.AMD64ArrayCopyWithConversionsOp;
import jdk.graal.compiler.lir.amd64.AMD64ArrayEqualsOp;
import jdk.graal.compiler.lir.amd64.AMD64ArrayIndexOfOp;
import jdk.graal.compiler.lir.amd64.AMD64ArrayRegionCompareToOp;
import jdk.graal.compiler.lir.amd64.AMD64BigIntegerMulAddOp;
import jdk.graal.compiler.lir.amd64.AMD64BigIntegerMultiplyToLenOp;
import jdk.graal.compiler.lir.amd64.AMD64BigIntegerSquareToLenOp;
import jdk.graal.compiler.lir.amd64.AMD64BinaryConsumer;
import jdk.graal.compiler.lir.amd64.AMD64ByteSwapOp;
import jdk.graal.compiler.lir.amd64.AMD64CacheWritebackOp;
import jdk.graal.compiler.lir.amd64.AMD64CacheWritebackPostSyncOp;
import jdk.graal.compiler.lir.amd64.AMD64CalcStringAttributesOp;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64CipherBlockChainingAESDecryptOp;
import jdk.graal.compiler.lir.amd64.AMD64CipherBlockChainingAESEncryptOp;
import jdk.graal.compiler.lir.amd64.AMD64ControlFlow;
import jdk.graal.compiler.lir.amd64.AMD64CountPositivesOp;
import jdk.graal.compiler.lir.amd64.AMD64CounterModeAESCryptOp;
import jdk.graal.compiler.lir.amd64.AMD64EncodeArrayOp;
import jdk.graal.compiler.lir.amd64.AMD64GHASHProcessBlocksOp;
import jdk.graal.compiler.lir.amd64.AMD64HaltOp;
import jdk.graal.compiler.lir.amd64.AMD64LFenceOp;
import jdk.graal.compiler.lir.amd64.AMD64MD5Op;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.amd64.AMD64PauseOp;
import jdk.graal.compiler.lir.amd64.AMD64SHA1Op;
import jdk.graal.compiler.lir.amd64.AMD64SHA256AVX2Op;
import jdk.graal.compiler.lir.amd64.AMD64SHA256Op;
import jdk.graal.compiler.lir.amd64.AMD64SHA3Op;
import jdk.graal.compiler.lir.amd64.AMD64SHA512Op;
import jdk.graal.compiler.lir.amd64.AMD64StringLatin1InflateOp;
import jdk.graal.compiler.lir.amd64.AMD64StringUTF16CompressOp;
import jdk.graal.compiler.lir.amd64.AMD64VectorizedHashCodeOp;
import jdk.graal.compiler.lir.amd64.AMD64VectorizedMismatchOp;
import jdk.graal.compiler.lir.amd64.AMD64ZapRegistersOp;
import jdk.graal.compiler.lir.amd64.AMD64ZapStackOp;
import jdk.graal.compiler.lir.amd64.AMD64ZeroMemoryOp;
import jdk.graal.compiler.lir.amd64.vector.AMD64OpMaskCompareOp;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorCompareOp;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public abstract class AMD64LIRGenerator
extends LIRGenerator {
    public AMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, BarrierSetLIRGeneratorTool barrierSetLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, barrierSetLIRGen, moveFactory, providers, lirGenRes);
    }

    @Override
    protected JavaConstant zapValueForKind(PlatformKind kind) {
        long dead = -2401018187971961171L;
        switch ((AMD64Kind)kind) {
            case BYTE: {
                return JavaConstant.forByte((byte)((byte)dead));
            }
            case WORD: {
                return JavaConstant.forShort((short)((short)dead));
            }
            case DWORD: {
                return JavaConstant.forInt((int)((int)dead));
            }
            case QWORD: {
                return JavaConstant.forLong((long)dead);
            }
            case SINGLE: {
                return JavaConstant.forFloat((float)Float.intBitsToFloat((int)dead));
            }
            case MASK16: 
            case MASK64: {
                return JavaConstant.forLong((long)dead);
            }
        }
        assert (((AMD64Kind)kind).isXMM()) : "kind " + String.valueOf(kind) + " not supported in zapping";
        return JavaConstant.forDouble((double)Double.longBitsToDouble(dead));
    }

    public AMD64AddressValue asAddressValue(Value address) {
        long displacement;
        if (address instanceof AMD64AddressValue) {
            return (AMD64AddressValue)address;
        }
        if (address instanceof JavaConstant && NumUtil.isInt(displacement = ((JavaConstant)address).asLong())) {
            return new AMD64AddressValue(address.getValueKind(), Value.ILLEGAL, (int)displacement);
        }
        return new AMD64AddressValue(address.getValueKind(), this.asAllocatable(address), 0);
    }

    @Override
    public Variable emitAddress(AllocatableValue stackslot) {
        Variable result = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new AMD64Move.StackLeaOp(result, stackslot));
        return result;
    }

    @Override
    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        switch ((AMD64Kind)kind.getPlatformKind()) {
            case BYTE: 
            case WORD: {
                return (K)kind.changeType((PlatformKind)AMD64Kind.DWORD);
            }
        }
        return kind;
    }

    protected Value loadNonInlinableConstant(Value value) {
        if (LIRValueUtil.isConstantValue(value) && !this.getMoveFactory().canInlineConstant(LIRValueUtil.asConstant(value))) {
            return this.emitMove(value);
        }
        return value;
    }

    private AllocatableValue asAllocatable(Value value, ValueKind<?> kind) {
        if (value.getValueKind().equals(kind)) {
            return this.asAllocatable(value);
        }
        if (ValueUtil.isRegister((Value)value)) {
            return ValueUtil.asRegister((Value)value).asValue(kind);
        }
        if (LIRValueUtil.isConstantValue(value)) {
            return this.emitLoadConstant(kind, LIRValueUtil.asConstant(value));
        }
        Variable variable = this.newVariable(kind);
        this.emitMove(variable, value);
        return variable;
    }

    private Value emitCompareAndSwapHelper(boolean isLogic, LIRKind accessKind, Value address, Value expectedValue, Value newValue, BarrierType barrierType) {
        ValueKind kind = newValue.getValueKind();
        GraalError.guarantee(kind.equals(expectedValue.getValueKind()), "%s != %s", (Object)kind, (Object)expectedValue.getValueKind());
        AMD64AddressValue addressValue = this.asAddressValue(address);
        LIRKind integerAccessKind = accessKind;
        Value reinterpretedExpectedValue = expectedValue;
        Value reinterpretedNewValue = newValue;
        boolean isXmm = ((AMD64Kind)accessKind.getPlatformKind()).isXMM();
        if (isXmm) {
            integerAccessKind = accessKind.getPlatformKind().equals((Object)AMD64Kind.SINGLE) ? LIRKind.fromJavaKind(this.target().arch, JavaKind.Int) : LIRKind.fromJavaKind(this.target().arch, JavaKind.Long);
            reinterpretedExpectedValue = this.arithmeticLIRGen.emitReinterpret(integerAccessKind, expectedValue);
            reinterpretedNewValue = this.arithmeticLIRGen.emitReinterpret(integerAccessKind, newValue);
        }
        AMD64Kind memKind = (AMD64Kind)integerAccessKind.getPlatformKind();
        RegisterValue aRes = AMD64.rax.asValue((ValueKind)integerAccessKind);
        AllocatableValue allocatableNewValue = this.asAllocatable(reinterpretedNewValue, integerAccessKind);
        this.emitMove((AllocatableValue)aRes, reinterpretedExpectedValue);
        this.emitCompareAndSwapOp(isLogic, integerAccessKind, memKind, aRes, addressValue, allocatableNewValue, barrierType);
        return aRes;
    }

    private Value emitCompareAndSwap(boolean isLogic, LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue, BarrierType barrierType) {
        Value aRes = this.emitCompareAndSwapHelper(isLogic, accessKind, address, expectedValue, newValue, barrierType);
        if (isLogic) {
            assert (trueValue.getValueKind().equals(falseValue.getValueKind()));
            return this.emitCondMoveOp(Condition.EQ, trueValue, falseValue, false, false);
        }
        if (((AMD64Kind)accessKind.getPlatformKind()).isXMM()) {
            return this.arithmeticLIRGen.emitReinterpret(accessKind, aRes);
        }
        Variable result = this.newVariable(newValue.getValueKind());
        this.emitMove(result, aRes);
        return result;
    }

    @Override
    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        return LIRValueUtil.asVariable(this.emitCompareAndSwap(true, accessKind, address, expectedValue, newValue, trueValue, falseValue, barrierType));
    }

    @Override
    public Value emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        return this.emitCompareAndSwap(false, accessKind, address, expectedValue, newValue, null, null, barrierType);
    }

    public void emitCompareAndSwapBranch(boolean isLogic, LIRKind kind, AMD64AddressValue address, Value expectedValue, Value newValue, Condition condition, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability, BarrierType barrierType) {
        GraalError.guarantee(kind.getPlatformKind().getSizeInBytes() <= expectedValue.getValueKind().getPlatformKind().getSizeInBytes(), "kind=%s, expectedValue=%s", (Object)kind, (Object)expectedValue);
        GraalError.guarantee(kind.getPlatformKind().getSizeInBytes() <= newValue.getValueKind().getPlatformKind().getSizeInBytes(), "kind=%s, newValue=%s", (Object)kind, (Object)newValue);
        GraalError.guarantee(condition == Condition.EQ || condition == Condition.NE, Assertions.errorMessage(new Object[]{condition, address, expectedValue, newValue}));
        this.emitCompareAndSwapHelper(isLogic, kind, address, expectedValue, newValue, barrierType);
        this.append(new AMD64ControlFlow.BranchOp(condition, trueLabel, falseLabel, trueLabelProbability));
    }

    protected void emitCompareAndSwapOp(boolean isLogic, LIRKind accessKind, AMD64Kind memKind, RegisterValue raxValue, AMD64AddressValue address, AllocatableValue newValue, BarrierType barrierType) {
        BarrierSetLIRGeneratorTool barrierSetLIRGeneratorTool;
        if (barrierType != BarrierType.NONE && (barrierSetLIRGeneratorTool = this.getBarrierSet()) instanceof AMD64ReadBarrierSetLIRGenerator) {
            AMD64ReadBarrierSetLIRGenerator readBarrierSet = (AMD64ReadBarrierSetLIRGenerator)barrierSetLIRGeneratorTool;
            readBarrierSet.emitCompareAndSwapOp(this, isLogic, accessKind, memKind, raxValue, address, newValue, barrierType);
        } else {
            this.append(new AMD64Move.CompareAndSwapOp(memKind, (AllocatableValue)raxValue, address, (AllocatableValue)raxValue, newValue));
        }
    }

    @Override
    public Value emitAtomicReadAndAdd(LIRKind accessKind, Value address, Value delta) {
        Variable result = this.newVariable(this.toRegisterKind(accessKind));
        AMD64AddressValue addressValue = this.asAddressValue(address);
        this.append(new AMD64Move.AtomicReadAndAddOp((AMD64Kind)accessKind.getPlatformKind(), result, addressValue, this.asAllocatable(delta)));
        return result;
    }

    @Override
    public Value emitAtomicReadAndWrite(LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        BarrierSetLIRGeneratorTool barrierSetLIRGeneratorTool;
        if (barrierType != BarrierType.NONE && (barrierSetLIRGeneratorTool = this.getBarrierSet()) instanceof AMD64ReadBarrierSetLIRGenerator) {
            AMD64ReadBarrierSetLIRGenerator readBarrierSet = (AMD64ReadBarrierSetLIRGenerator)barrierSetLIRGeneratorTool;
            return readBarrierSet.emitAtomicReadAndWrite(this, accessKind, address, newValue, barrierType);
        }
        Variable result = this.newVariable(this.toRegisterKind(accessKind));
        AMD64AddressValue addressValue = this.asAddressValue(address);
        this.append(new AMD64Move.AtomicReadAndWriteOp((AMD64Kind)accessKind.getPlatformKind(), result, addressValue, this.asAllocatable(newValue)));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        this.append(new AMD64Move.NullCheckOp(this.asAddressValue(address), state));
    }

    @Override
    public void emitJump(LabelRef label) {
        assert (label != null);
        this.append(new StandardOp.JumpOp(label));
    }

    @Override
    public void emitCompareBranch(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (cmpKind == AMD64Kind.SINGLE || cmpKind == AMD64Kind.DOUBLE) {
            boolean isSelfEqualsCheck = cond == Condition.EQ && !unorderedIsTrue && left.equals((Object)right);
            Condition finalCond = this.emitFloatCompare(null, cmpKind, left, right, cond, unorderedIsTrue);
            this.append(new AMD64ControlFlow.FloatBranchOp(finalCond, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability, isSelfEqualsCheck));
            return;
        }
        if (LIRValueUtil.isVariable(right)) {
            this.emitRawCompareBranch(AMD64BaseAssembler.OperandSize.get(cmpKind), this.asAllocatable(right), this.loadNonInlinableConstant(left), cond.mirror(), trueLabel, falseLabel, trueLabelProbability);
        } else {
            this.emitRawCompareBranch(AMD64BaseAssembler.OperandSize.get(cmpKind), this.asAllocatable(left), this.loadNonInlinableConstant(right), cond, trueLabel, falseLabel, trueLabelProbability);
        }
    }

    private void emitRawCompareBranch(AMD64BaseAssembler.OperandSize size, AllocatableValue left, Value right, Condition cond, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (LIRValueUtil.isConstantValue(right)) {
            Constant c = LIRValueUtil.asConstant(right);
            if (JavaConstant.isNull((Constant)c)) {
                AMD64ArithmeticLIRGenerator arithmeticLIRGenerator = (AMD64ArithmeticLIRGenerator)this.arithmeticLIRGen;
                if (arithmeticLIRGenerator.mustReplaceNullWithNullRegister(c)) {
                    this.append(new AMD64ControlFlow.CmpBranchOp(size, left, (Value)arithmeticLIRGenerator.getNullRegisterValue(), null, cond, trueLabel, falseLabel, trueLabelProbability));
                } else {
                    this.append(new AMD64ControlFlow.TestBranchOp(size, left, (Value)left, null, cond, trueLabel, falseLabel, trueLabelProbability));
                }
                return;
            }
            if (c instanceof VMConstant) {
                VMConstant vc = (VMConstant)c;
                if (size == AMD64BaseAssembler.OperandSize.DWORD && this.target().inlineObjects) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(AMD64BaseAssembler.OperandSize.DWORD, (Value)left, vc, null, cond, trueLabel, falseLabel, trueLabelProbability));
                } else {
                    this.append(new AMD64ControlFlow.CmpDataBranchOp(size, left, (Constant)vc, cond, trueLabel, falseLabel, trueLabelProbability));
                }
                return;
            }
            if (c instanceof JavaConstant) {
                JavaConstant jc = (JavaConstant)c;
                if (jc.isDefaultForKind()) {
                    if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                        this.append(new AMD64ControlFlow.TestByteBranchOp(left, left, cond, trueLabel, falseLabel, trueLabelProbability));
                    } else {
                        this.append(new AMD64ControlFlow.TestBranchOp(size, left, (Value)left, null, cond, trueLabel, falseLabel, trueLabelProbability));
                    }
                    return;
                }
                if (NumUtil.is32bit(jc.asLong())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)left, (int)jc.asLong(), null, cond, trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
            }
        }
        this.append(new AMD64ControlFlow.CmpBranchOp(size, left, (Value)this.asAllocatable(right), null, cond, trueLabel, falseLabel, trueLabelProbability));
    }

    public void emitCompareBranchMemory(AMD64Kind cmpKind, Value left, AMD64AddressValue right, LIRFrameState state, Condition cond, boolean unorderedIsTrue, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (cmpKind.isXMM()) {
            GraalError.guarantee(cmpKind == AMD64Kind.SINGLE || cmpKind == AMD64Kind.DOUBLE, "Must be float");
            Condition finalCond = this.emitFloatCompare(state, (PlatformKind)cmpKind, left, right, cond, unorderedIsTrue);
            this.append(new AMD64ControlFlow.FloatBranchOp(finalCond, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability));
        } else {
            AMD64BaseAssembler.OperandSize size = AMD64BaseAssembler.OperandSize.get((PlatformKind)cmpKind);
            if (LIRValueUtil.isConstantValue(left)) {
                long value;
                ConstantValue a = LIRValueUtil.asConstantValue(left);
                if (JavaConstant.isNull((Constant)a.getConstant())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, 0, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
                if (a.getConstant() instanceof VMConstant && size == AMD64BaseAssembler.OperandSize.DWORD && this.target().inlineObjects) {
                    VMConstant vc = (VMConstant)a.getConstant();
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, vc, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
                if (a.getConstant() instanceof JavaConstant && a.getJavaConstant().getJavaKind() != JavaKind.Object && NumUtil.is32bit(value = a.getJavaConstant().asLong())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, (int)value, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
            }
            this.append(new AMD64ControlFlow.CmpBranchOp(size, this.asAllocatable(left), right, state, cond, trueLabel, falseLabel, trueLabelProbability));
        }
    }

    @Override
    public void emitOverflowCheckBranch(LabelRef overflow, LabelRef noOverflow, LIRKind cmpLIRKind, double overflowProbability) {
        this.append(new AMD64ControlFlow.BranchOp(AMD64Assembler.ConditionFlag.Overflow, overflow, noOverflow, overflowProbability));
    }

    @Override
    public void emitIntegerTestBranch(Value left, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        if (left.getPlatformKind().getVectorLength() > 1) {
            this.append(new AMD64OpMaskCompareOp(AMD64Assembler.VexRMOp.VPTEST, AMD64LIRGenerator.getRegisterSize(left), this.asAllocatable(left), this.asAllocatable(right)));
            this.append(new AMD64ControlFlow.BranchOp(Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
        } else {
            AMD64BaseAssembler.OperandSize size;
            assert (((AMD64Kind)left.getPlatformKind()).isInteger());
            AMD64BaseAssembler.OperandSize operandSize = size = left.getPlatformKind() == AMD64Kind.QWORD ? AMD64BaseAssembler.OperandSize.QWORD : AMD64BaseAssembler.OperandSize.DWORD;
            if (LIRValueUtil.isJavaConstant(right) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(right).asLong())) {
                this.append(new AMD64ControlFlow.TestConstBranchOp(size, (Value)this.asAllocatable(left), (int)LIRValueUtil.asJavaConstant(right).asLong(), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else if (LIRValueUtil.isJavaConstant(left) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(left).asLong())) {
                this.append(new AMD64ControlFlow.TestConstBranchOp(size, (Value)this.asAllocatable(right), (int)LIRValueUtil.asJavaConstant(left).asLong(), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else if (ValueUtil.isAllocatableValue((Value)right)) {
                this.append(new AMD64ControlFlow.TestBranchOp(size, this.asAllocatable(right), (Value)this.asAllocatable(left), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else {
                this.append(new AMD64ControlFlow.TestBranchOp(size, this.asAllocatable(left), (Value)this.asAllocatable(right), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            }
        }
    }

    @Override
    public void emitOpMaskTestBranch(Value left, boolean negateLeft, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        this.emitOpMaskTest(left, right);
        this.append(new AMD64ControlFlow.BranchOp(negateLeft ? Condition.BT : Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
    }

    @Override
    public void emitOpMaskOrTestBranch(Value left, Value right, boolean allZeros, LabelRef trueDestination, LabelRef falseDestination, double trueSuccessorProbability) {
        this.emitOpMaskOrTest(left, right);
        this.append(new AMD64ControlFlow.BranchOp(allZeros ? Condition.EQ : Condition.BT, trueDestination, falseDestination, trueSuccessorProbability));
    }

    @Override
    public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        boolean isSelfEqualsCheck;
        if (cmpKind != AMD64Kind.SINGLE && cmpKind != AMD64Kind.DOUBLE) {
            Condition finalCondition = this.emitIntegerCompare(cmpKind, left, right, cond);
            return this.emitCondMoveOp(finalCondition, trueValue, falseValue, false, false, false);
        }
        Condition finalCond = this.emitFloatCompare(null, cmpKind, left, right, cond, unorderedIsTrue);
        boolean finalUnordered = unorderedIsTrue;
        Value finalTrueValue = trueValue;
        Value finalFalseValue = falseValue;
        boolean bl = isSelfEqualsCheck = finalCond == Condition.EQ && left.equals((Object)right);
        if (!isSelfEqualsCheck && !finalUnordered && finalCond == Condition.EQ) {
            finalCond = Condition.NE;
            finalUnordered = true;
            finalTrueValue = falseValue;
            finalFalseValue = trueValue;
        }
        return this.emitCondMoveOp(finalCond, finalTrueValue, finalFalseValue, true, finalUnordered, isSelfEqualsCheck);
    }

    private Variable emitCondMoveOp(Condition condition, Value trueValue, Value falseValue, boolean isFloatComparison, boolean unorderedIsTrue) {
        return this.emitCondMoveOp(condition, trueValue, falseValue, isFloatComparison, unorderedIsTrue, false);
    }

    private Variable emitCondMoveOp(Condition condition, Value trueValue, Value falseValue, boolean isFloatComparison, boolean unorderedIsTrue, boolean isSelfEqualsCheck) {
        boolean isParityCheckNecessary = isFloatComparison && unorderedIsTrue != AMD64ControlFlow.trueOnUnordered(condition);
        Variable result = this.newVariable(LIRKind.mergeReferenceInformation(trueValue, falseValue));
        if (!isParityCheckNecessary && LIRValueUtil.isIntConstant(trueValue, 1L) && LIRValueUtil.isIntConstant(falseValue, 0L)) {
            if (isFloatComparison) {
                this.append(new AMD64ControlFlow.FloatCondSetOp(result, condition));
            } else {
                this.append(new AMD64ControlFlow.CondSetOp(result, condition));
            }
        } else if (!isParityCheckNecessary && LIRValueUtil.isIntConstant(trueValue, 0L) && LIRValueUtil.isIntConstant(falseValue, 1L)) {
            if (isFloatComparison) {
                this.append(new AMD64ControlFlow.FloatCondSetOp(result, condition.negate()));
            } else {
                this.append(new AMD64ControlFlow.CondSetOp(result, condition.negate()));
            }
        } else if (isFloatComparison) {
            this.append(new AMD64ControlFlow.FloatCondMoveOp(result, condition, unorderedIsTrue, this.asAllocatable(trueValue), this.asAllocatable(falseValue), isSelfEqualsCheck));
        } else {
            this.append(new AMD64ControlFlow.CondMoveOp(result, condition, this.asAllocatable(trueValue), this.loadNonInlinableConstant(falseValue)));
        }
        return result;
    }

    @Override
    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        this.emitIntegerTest(left, right);
        return this.emitCondMoveOp(Condition.EQ, (Value)this.asAllocatable(trueValue), this.loadNonInlinableConstant(falseValue), false, false);
    }

    protected static AVXKind.AVXSize getRegisterSize(Value a) {
        AMD64Kind kind = (AMD64Kind)a.getPlatformKind();
        if (kind.isXMM()) {
            return AVXKind.getRegisterSize(kind);
        }
        return AVXKind.AVXSize.XMM;
    }

    private void emitIntegerTest(Value a, Value b) {
        if (a.getPlatformKind().getVectorLength() > 1) {
            this.append(new AMD64VectorCompareOp(AMD64Assembler.VexRMOp.VPTEST, AMD64LIRGenerator.getRegisterSize(a), this.asAllocatable(a), this.asAllocatable(b)));
        } else {
            AMD64BaseAssembler.OperandSize size;
            assert (((AMD64Kind)a.getPlatformKind()).isInteger());
            AMD64BaseAssembler.OperandSize operandSize = size = a.getPlatformKind() == AMD64Kind.QWORD ? AMD64BaseAssembler.OperandSize.QWORD : AMD64BaseAssembler.OperandSize.DWORD;
            if (LIRValueUtil.isJavaConstant(b) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(b).asLong())) {
                this.append(new AMD64BinaryConsumer.ConstOp(AMD64Assembler.AMD64MIOp.TEST, size, this.asAllocatable(a), (int)LIRValueUtil.asJavaConstant(b).asLong()));
            } else if (LIRValueUtil.isJavaConstant(a) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(a).asLong())) {
                this.append(new AMD64BinaryConsumer.ConstOp(AMD64Assembler.AMD64MIOp.TEST, size, this.asAllocatable(b), (int)LIRValueUtil.asJavaConstant(a).asLong()));
            } else if (ValueUtil.isAllocatableValue((Value)b)) {
                this.append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.TEST, size, this.asAllocatable(b), this.asAllocatable(a)));
            } else {
                this.append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.TEST, size, this.asAllocatable(a), this.asAllocatable(b)));
            }
        }
    }

    @Override
    public Variable emitOpMaskTestMove(Value left, boolean negateLeft, Value right, Value trueValue, Value falseValue) {
        this.emitOpMaskTest(left, right);
        return this.emitCondMoveOp(negateLeft ? Condition.BT : Condition.EQ, (Value)this.asAllocatable(trueValue), (Value)this.asAllocatable(falseValue), false, false);
    }

    @Override
    public Variable emitOpMaskOrTestMove(Value left, Value right, boolean allZeros, Value trueValue, Value falseValue) {
        this.emitOpMaskOrTest(left, right);
        return this.emitCondMoveOp(allZeros ? Condition.EQ : Condition.BT, (Value)this.asAllocatable(trueValue), (Value)this.asAllocatable(falseValue), false, false);
    }

    private void emitOpMaskTest(Value a, Value b) {
        GraalError.guarantee(AMD64Assembler.supportsFullAVX512(((AMD64)this.target().arch).getFeatures()), "AVX512 needed for opmask operations");
        AMD64Kind aKind = (AMD64Kind)a.getPlatformKind();
        AMD64Kind bKind = (AMD64Kind)b.getPlatformKind();
        GraalError.guarantee(aKind.isMask() && bKind.isMask(), "opmask test needs inputs to be opmasks");
        GraalError.guarantee(aKind == bKind, "input masks need to be of the same size");
        AMD64Assembler.VexRROp op = switch ((AMD64Kind)a.getPlatformKind()) {
            case AMD64Kind.MASK8 -> AMD64Assembler.VexRROp.KTESTB;
            case AMD64Kind.MASK16 -> AMD64Assembler.VexRROp.KTESTW;
            case AMD64Kind.MASK32 -> AMD64Assembler.VexRROp.KTESTD;
            case AMD64Kind.MASK64 -> AMD64Assembler.VexRROp.KTESTQ;
            default -> throw GraalError.shouldNotReachHere("emitting opmask test for unknown mask kind " + a.getPlatformKind().name());
        };
        this.append(new AMD64OpMaskCompareOp(op, AMD64LIRGenerator.getRegisterSize(a), this.asAllocatable(a), this.asAllocatable(b)));
    }

    private void emitOpMaskOrTest(Value a, Value b) {
        GraalError.guarantee(AMD64Assembler.supportsFullAVX512(((AMD64)this.target().arch).getFeatures()), "AVX512 needed for opmask operations");
        AMD64Kind aKind = (AMD64Kind)a.getPlatformKind();
        AMD64Kind bKind = (AMD64Kind)b.getPlatformKind();
        GraalError.guarantee(aKind.isMask() && bKind.isMask(), "opmask ortest needs inputs to be opmasks");
        GraalError.guarantee(aKind == bKind, "input masks need to be of the same size");
        AMD64Assembler.VexRROp op = switch ((AMD64Kind)a.getPlatformKind()) {
            case AMD64Kind.MASK8 -> AMD64Assembler.VexRROp.KORTESTB;
            case AMD64Kind.MASK16 -> AMD64Assembler.VexRROp.KORTESTW;
            case AMD64Kind.MASK32 -> AMD64Assembler.VexRROp.KORTESTD;
            case AMD64Kind.MASK64 -> AMD64Assembler.VexRROp.KORTESTQ;
            default -> throw GraalError.shouldNotReachHere("emitting opmask test for unknown mask kind " + a.getPlatformKind().name());
        };
        this.append(new AMD64OpMaskCompareOp(op, AMD64LIRGenerator.getRegisterSize(a), this.asAllocatable(a), this.asAllocatable(b)));
    }

    private Condition emitIntegerCompare(PlatformKind cmpKind, Value a, Value b, Condition cond) {
        GraalError.guarantee(cmpKind != AMD64Kind.SINGLE && cmpKind != AMD64Kind.DOUBLE, "Must not be float");
        if (LIRValueUtil.isVariable(b)) {
            this.emitRawCompare(cmpKind, b, a);
            return cond.mirror();
        }
        this.emitRawCompare(cmpKind, a, b);
        return cond;
    }

    private void emitRawCompare(PlatformKind cmpKind, Value left, Value right) {
        ((AMD64ArithmeticLIRGeneratorTool)((Object)this.arithmeticLIRGen)).emitCompareOp((AMD64Kind)cmpKind, this.asAllocatable(left), this.loadNonInlinableConstant(right));
    }

    private Condition emitFloatCompare(LIRFrameState state, PlatformKind kind, Value left, Value right, Condition cond, boolean unordered) {
        AMD64BaseAssembler.OperandSize opSize;
        GraalError.guarantee(kind == AMD64Kind.SINGLE || kind == AMD64Kind.DOUBLE, "Must be float");
        boolean commute = cond == Condition.EQ || cond == Condition.NE ? LIRValueUtil.isVariable(right) : unordered != AMD64ControlFlow.trueOnUnordered(cond);
        Object x = left;
        Value y = right;
        Condition c = cond;
        if (commute) {
            x = right;
            y = left;
            c = c.mirror();
        }
        AMD64BaseAssembler.OperandSize operandSize = opSize = kind == AMD64Kind.SINGLE ? AMD64BaseAssembler.OperandSize.PS : AMD64BaseAssembler.OperandSize.PD;
        if (y instanceof AMD64AddressValue) {
            AMD64AddressValue addr = (AMD64AddressValue)y;
            this.append(new AMD64BinaryConsumer.MemoryRMOp(AMD64Assembler.SSEOp.UCOMIS, opSize, this.asAllocatable((Value)x), addr, state));
        } else {
            if (x instanceof AMD64AddressValue) {
                x = this.arithmeticLIRGen.emitLoad(LIRKind.value(kind), (Value)x, state, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
            }
            this.append(new AMD64BinaryConsumer.Op(AMD64Assembler.SSEOp.UCOMIS, opSize, this.asAllocatable((Value)x), this.asAllocatable(y)));
        }
        return c;
    }

    @Override
    public void emitMembar(int barriers) {
        int necessaryBarriers = this.target().arch.requiredBarriers(barriers);
        if (this.target().isMP && necessaryBarriers != 0) {
            this.append(new AMD64Move.MembarOp(necessaryBarriers));
        }
    }

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        long maxOffset = linkage.getMaxCallTargetOffset();
        if (maxOffset != (long)((int)maxOffset)) {
            this.append(new AMD64Call.DirectFarForeignCallOp(linkage, result, arguments, temps, info));
        } else {
            this.append(new AMD64Call.DirectNearForeignCallOp(linkage, result, arguments, temps, info));
        }
    }

    @Override
    public Variable emitReverseBytes(Value input) {
        Variable result = this.newVariable(LIRKind.combine(input));
        this.append(new AMD64ByteSwapOp((Value)result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitArrayCompareTo(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value lengthA, Value arrayB, Value lengthB) {
        LIRKind resultKind = LIRKind.value((PlatformKind)AMD64Kind.DWORD);
        RegisterValue raxRes = AMD64.rax.asValue((ValueKind)resultKind);
        RegisterValue cntA = AMD64.rcx.asValue(lengthA.getValueKind());
        RegisterValue cntB = AMD64.rdx.asValue(lengthB.getValueKind());
        this.emitMove((AllocatableValue)cntA, lengthA);
        this.emitMove((AllocatableValue)cntB, lengthB);
        this.append(new AMD64ArrayCompareToOp(this, this.getAVX3Threshold(), strideA, strideB, runtimeCheckedCPUFeatures, (Value)raxRes, arrayA, (Value)cntA, arrayB, (Value)cntB));
        Variable result = this.newVariable(resultKind);
        this.emitMove(result, (Value)raxRes);
        return result;
    }

    @Override
    public Variable emitArrayRegionCompareTo(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length, Value dynamicStrides) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayRegionCompareToOp.movParamsAndCreate(this, null, null, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitArrayRegionCompareTo(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayRegionCompareToOp.movParamsAndCreate(this, strideA, strideB, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, length, null, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitVectorizedMismatch(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value arrayB, Value length, Value stride) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64VectorizedMismatchOp.movParamsAndCreate(this, runtimeCheckedCPUFeatures, (Value)result, arrayA, arrayB, length, stride));
        return result;
    }

    @Override
    public Variable emitVectorizedHashCode(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayStart, Value length, Value initialValue, JavaKind arrayKind) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64VectorizedHashCodeOp(this, runtimeCheckedCPUFeatures, result, this.asAllocatable(arrayStart), this.asAllocatable(length), this.asAllocatable(initialValue), arrayKind));
        return result;
    }

    @Override
    public Variable emitArrayEquals(JavaKind commonElementKind, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        Stride stride = Stride.fromJavaKind(commonElementKind);
        this.append(AMD64ArrayEqualsOp.movParamsAndCreate(this, commonElementKind, stride, stride, stride, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, null, length, null, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitArrayEquals(Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayEqualsOp.movParamsAndCreate(this, strideA, strideB, strideB, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, null, length, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitArrayEqualsDynamicStrides(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value length, Value dynamicStrides) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayEqualsOp.movParamsAndCreate(this, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, null, length, dynamicStrides, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitArrayEqualsWithMask(Stride strideA, Stride strideB, Stride strideMask, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value mask, Value length) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayEqualsOp.movParamsAndCreate(this, strideA, strideB, strideMask, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, mask, length, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public Variable emitArrayEqualsWithMaskDynamicStrides(EnumSet<?> runtimeCheckedCPUFeatures, Value arrayA, Value offsetA, Value arrayB, Value offsetB, Value mask, Value length, Value dynamicStrides) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayEqualsOp.movParamsAndCreate(this, runtimeCheckedCPUFeatures, (Value)result, arrayA, offsetA, arrayB, offsetB, mask, length, dynamicStrides, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
        return result;
    }

    @Override
    public void emitArrayCopyWithConversion(Stride strideSrc, Stride strideDst, EnumSet<?> runtimeCheckedCPUFeatures, Value arraySrc, Value offsetSrc, Value arrayDst, Value offsetDst, Value length) {
        this.append(AMD64ArrayCopyWithConversionsOp.movParamsAndCreate(this, strideSrc, strideDst, runtimeCheckedCPUFeatures, arraySrc, offsetSrc, arrayDst, offsetDst, length, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
    }

    @Override
    public void emitArrayCopyWithConversion(EnumSet<?> runtimeCheckedCPUFeatures, Value arraySrc, Value offsetSrc, Value arrayDst, Value offsetDst, Value length, Value dynamicStrides) {
        this.append(AMD64ArrayCopyWithConversionsOp.movParamsAndCreate(this, runtimeCheckedCPUFeatures, arraySrc, offsetSrc, arrayDst, offsetDst, length, dynamicStrides, AMD64MacroAssembler.ExtendMode.ZERO_EXTEND));
    }

    @Override
    public Variable emitCalcStringAttributes(LIRGeneratorTool.CalcStringAttributesEncoding encoding, EnumSet<?> runtimeCheckedCPUFeatures, Value array, Value offset, Value length, boolean assumeValid) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)(encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8 || encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16 ? AMD64Kind.QWORD : AMD64Kind.DWORD)));
        this.append(AMD64CalcStringAttributesOp.movParamsAndCreate(this, encoding, runtimeCheckedCPUFeatures, array, offset, length, (Value)result, assumeValid));
        return result;
    }

    @Override
    public Variable emitEncodeArray(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value length, LIRGeneratorTool.CharsetName charset) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64EncodeArrayOp(this, runtimeCheckedCPUFeatures, (Value)result, (Value)this.asAllocatable(src), (Value)this.asAllocatable(dst), (Value)this.asAllocatable(length), charset));
        return result;
    }

    @Override
    public Variable emitCountPositives(EnumSet<?> runtimeCheckedCPUFeatures, Value array, Value length) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64CountPositivesOp(this, runtimeCheckedCPUFeatures, this.getAVX3Threshold(), result, this.asAllocatable(array), (Value)this.asAllocatable(length)));
        return result;
    }

    @Override
    public void emitAESEncrypt(Value from, Value to, Value key) {
        this.append(new AMD64AESEncryptOp(this, this.asAllocatable(from), this.asAllocatable(to), this.asAllocatable(key), this.getArrayLengthOffset() - this.getArrayBaseOffset(JavaKind.Int)));
    }

    @Override
    public void emitAESDecrypt(Value from, Value to, Value key) {
        this.append(new AMD64AESDecryptOp(this, (Value)this.asAllocatable(from), (Value)this.asAllocatable(to), (Value)this.asAllocatable(key), this.getArrayLengthOffset() - this.getArrayBaseOffset(JavaKind.Int)));
    }

    @Override
    public Variable emitCTRAESCrypt(Value inAddr, Value outAddr, Value kAddr, Value counterAddr, Value len, Value encryptedCounterAddr, Value usedPtr) {
        Variable result = this.newVariable(len.getValueKind());
        this.append(new AMD64CounterModeAESCryptOp(this.asAllocatable(inAddr), this.asAllocatable(outAddr), this.asAllocatable(kAddr), this.asAllocatable(counterAddr), this.asAllocatable(len), this.asAllocatable(encryptedCounterAddr), this.asAllocatable(usedPtr), result, this.getArrayLengthOffset() - this.getArrayBaseOffset(JavaKind.Int)));
        return result;
    }

    @Override
    public Variable emitCBCAESEncrypt(Value inAddr, Value outAddr, Value kAddr, Value rAddr, Value len) {
        Variable result = this.newVariable(len.getValueKind());
        this.append(new AMD64CipherBlockChainingAESEncryptOp(this.asAllocatable(inAddr), this.asAllocatable(outAddr), this.asAllocatable(kAddr), this.asAllocatable(rAddr), this.asAllocatable(len), result, this.getArrayLengthOffset() - this.getArrayBaseOffset(JavaKind.Int)));
        return result;
    }

    @Override
    public Variable emitCBCAESDecrypt(Value inAddr, Value outAddr, Value kAddr, Value rAddr, Value len) {
        Variable result = this.newVariable(len.getValueKind());
        this.append(new AMD64CipherBlockChainingAESDecryptOp(this.asAllocatable(inAddr), this.asAllocatable(outAddr), this.asAllocatable(kAddr), this.asAllocatable(rAddr), this.asAllocatable(len), result, this.getArrayLengthOffset() - this.getArrayBaseOffset(JavaKind.Int)));
        return result;
    }

    @Override
    public void emitGHASHProcessBlocks(Value state, Value hashSubkey, Value data, Value blocks) {
        this.append(new AMD64GHASHProcessBlocksOp(this, this.asAllocatable(state), this.asAllocatable(hashSubkey), this.asAllocatable(data), this.asAllocatable(blocks)));
    }

    @Override
    public void emitBigIntegerMultiplyToLen(Value x, Value xlen, Value y, Value ylen, Value z, Value zlen) {
        RegisterValue rX = AMD64.rdi.asValue(x.getValueKind());
        RegisterValue rXlen = AMD64.rax.asValue(xlen.getValueKind());
        RegisterValue rY = AMD64.rsi.asValue(y.getValueKind());
        RegisterValue rYlen = AMD64.rcx.asValue(ylen.getValueKind());
        RegisterValue rZ = AMD64.r8.asValue(z.getValueKind());
        RegisterValue rZlen = AMD64.r9.asValue(zlen.getValueKind());
        this.emitMove((AllocatableValue)rX, x);
        this.emitMove((AllocatableValue)rXlen, xlen);
        this.emitMove((AllocatableValue)rY, y);
        this.emitMove((AllocatableValue)rYlen, ylen);
        this.emitMove((AllocatableValue)rZ, z);
        this.emitMove((AllocatableValue)rZlen, zlen);
        this.append(new AMD64BigIntegerMultiplyToLenOp((Value)rX, (Value)rXlen, (Value)rY, (Value)rYlen, (Value)rZ, (Value)rZlen, this.getHeapBaseRegister()));
    }

    @Override
    public Variable emitBigIntegerMulAdd(Value out, Value in, Value offset, Value len, Value k) {
        RegisterValue rOut = AMD64.rdi.asValue(out.getValueKind());
        RegisterValue rIn = AMD64.rsi.asValue(in.getValueKind());
        RegisterValue rOffset = AMD64.r11.asValue(offset.getValueKind());
        RegisterValue rLen = AMD64.rcx.asValue(len.getValueKind());
        RegisterValue rK = AMD64.r8.asValue(k.getValueKind());
        this.emitMove((AllocatableValue)rOut, out);
        this.emitMove((AllocatableValue)rIn, in);
        this.emitMove((AllocatableValue)rOffset, offset);
        this.emitMove((AllocatableValue)rLen, len);
        this.emitMove((AllocatableValue)rK, k);
        this.append(new AMD64BigIntegerMulAddOp((Value)rOut, (Value)rIn, (Value)rOffset, (Value)rLen, (Value)rK, this.getHeapBaseRegister()));
        Variable result = this.newVariable(len.getValueKind());
        this.emitMove(result, (Value)AMD64.rax.asValue(len.getValueKind()));
        return result;
    }

    @Override
    public void emitBigIntegerSquareToLen(Value x, Value len, Value z, Value zlen) {
        RegisterValue rX = AMD64.rdi.asValue(x.getValueKind());
        RegisterValue rLen = AMD64.rsi.asValue(len.getValueKind());
        RegisterValue rZ = AMD64.r11.asValue(z.getValueKind());
        RegisterValue rZlen = AMD64.rcx.asValue(zlen.getValueKind());
        this.emitMove((AllocatableValue)rX, x);
        this.emitMove((AllocatableValue)rLen, len);
        this.emitMove((AllocatableValue)rZ, z);
        this.emitMove((AllocatableValue)rZlen, zlen);
        this.append(new AMD64BigIntegerSquareToLenOp((Value)rX, (Value)rLen, (Value)rZ, (Value)rZlen, this.getHeapBaseRegister()));
    }

    @Override
    public void emitSha1ImplCompress(Value buf, Value state) {
        this.append(new AMD64SHA1Op(this, this.asAllocatable(buf), this.asAllocatable(state)));
    }

    @Override
    public void emitSha256ImplCompress(Value buf, Value state) {
        if (this.supportsCPUFeature(AMD64.CPUFeature.SHA)) {
            this.append(new AMD64SHA256Op(this, this.asAllocatable(buf), this.asAllocatable(state)));
        } else {
            RegisterValue rBuf = AMD64.rdi.asValue(buf.getValueKind());
            RegisterValue rState = AMD64.rsi.asValue(state.getValueKind());
            this.emitMove((AllocatableValue)rBuf, buf);
            this.emitMove((AllocatableValue)rState, state);
            this.append(new AMD64SHA256AVX2Op((AllocatableValue)rBuf, (AllocatableValue)rState));
        }
    }

    @Override
    public void emitSha3ImplCompress(Value buf, Value state, Value blockSize) {
        this.append(new AMD64SHA3Op(this.asAllocatable(buf), this.asAllocatable(state), this.asAllocatable(blockSize)));
    }

    @Override
    public void emitSha512ImplCompress(Value buf, Value state) {
        RegisterValue rBuf = AMD64.rdi.asValue(buf.getValueKind());
        RegisterValue rState = AMD64.rsi.asValue(state.getValueKind());
        this.emitMove((AllocatableValue)rBuf, buf);
        this.emitMove((AllocatableValue)rState, state);
        this.append(new AMD64SHA512Op((AllocatableValue)rBuf, (AllocatableValue)rState));
    }

    @Override
    public void emitMD5ImplCompress(Value buf, Value state) {
        this.append(new AMD64MD5Op(this, this.asAllocatable(buf), this.asAllocatable(state)));
    }

    protected boolean supports(EnumSet<?> runtimeCheckedCPUFeatures, AMD64.CPUFeature feature) {
        assert (runtimeCheckedCPUFeatures == null || runtimeCheckedCPUFeatures.isEmpty() || runtimeCheckedCPUFeatures.iterator().next() instanceof AMD64.CPUFeature) : Assertions.errorMessage(runtimeCheckedCPUFeatures);
        EnumSet<?> typedFeatures = runtimeCheckedCPUFeatures;
        return typedFeatures != null && typedFeatures.contains(feature) || ((AMD64)this.target().arch).getFeatures().contains(feature);
    }

    @Override
    public AVXKind.AVXSize getMaxVectorSize(EnumSet<?> runtimeCheckedCPUFeatures) {
        if (this.supports(runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX512VL)) {
            return AVXKind.AVXSize.ZMM;
        }
        if (this.supports(runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX2)) {
            return AVXKind.AVXSize.YMM;
        }
        return AVXKind.AVXSize.XMM;
    }

    protected int getAVX3Threshold() {
        return 4096;
    }

    @Override
    public Variable emitArrayIndexOf(Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, EnumSet<?> runtimeCheckedCPUFeatures, Value arrayPointer, Value arrayOffset, Value arrayLength, Value fromIndex, Value ... searchValues) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(AMD64ArrayIndexOfOp.movParamsAndCreate(stride, variant, this, runtimeCheckedCPUFeatures, (Value)result, arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues));
        return result;
    }

    @Override
    public void emitStringLatin1Inflate(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value len) {
        RegisterValue rsrc = AMD64.rsi.asValue(src.getValueKind());
        RegisterValue rdst = AMD64.rdi.asValue(dst.getValueKind());
        RegisterValue rlen = AMD64.rdx.asValue(len.getValueKind());
        this.emitMove((AllocatableValue)rsrc, src);
        this.emitMove((AllocatableValue)rdst, dst);
        this.emitMove((AllocatableValue)rlen, len);
        this.append(new AMD64StringLatin1InflateOp(this, runtimeCheckedCPUFeatures, this.getAVX3Threshold(), (Value)rsrc, (Value)rdst, (Value)rlen));
    }

    @Override
    public Variable emitStringUTF16Compress(EnumSet<?> runtimeCheckedCPUFeatures, Value src, Value dst, Value len) {
        RegisterValue rsrc = AMD64.rsi.asValue(src.getValueKind());
        RegisterValue rdst = AMD64.rdi.asValue(dst.getValueKind());
        RegisterValue rlen = AMD64.rdx.asValue(len.getValueKind());
        this.emitMove((AllocatableValue)rsrc, src);
        this.emitMove((AllocatableValue)rdst, dst);
        this.emitMove((AllocatableValue)rlen, len);
        LIRKind reskind = LIRKind.value((PlatformKind)AMD64Kind.DWORD);
        RegisterValue rres = AMD64.rax.asValue((ValueKind)reskind);
        this.append(new AMD64StringUTF16CompressOp(this, runtimeCheckedCPUFeatures, this.getAVX3Threshold(), (Value)rres, (Value)rsrc, (Value)rdst, (Value)rlen));
        Variable res = this.newVariable(reskind);
        this.emitMove(res, (Value)rres);
        return res;
    }

    protected AMD64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, AllocatableValue temp) {
        return new AMD64ControlFlow.StrategySwitchOp(strategy, keyTargets, defaultTarget, key, temp);
    }

    @Override
    public void emitStrategySwitch(SwitchStrategy strategy, AllocatableValue key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        boolean needsTemp = !LIRKind.isValue((Value)key);
        this.append(this.createStrategySwitchOp(strategy, keyTargets, defaultTarget, key, needsTemp ? this.newVariable(key.getValueKind()) : Value.ILLEGAL));
    }

    @Override
    protected void emitRangeTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue key) {
        Variable scratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        Variable idxScratch = this.newVariable(key.getValueKind());
        this.append(new AMD64ControlFlow.RangeTableSwitchOp(lowKey, defaultTarget, targets, (Value)key, scratch, idxScratch));
    }

    @Override
    protected void emitHashTableSwitch(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value, Value hash) {
        Variable scratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        Variable entryScratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new AMD64ControlFlow.HashTableSwitchOp(keys, defaultTarget, targets, value, this.asAllocatable(hash), scratch, entryScratch));
    }

    @Override
    public void emitPause() {
        this.append(new AMD64PauseOp());
    }

    @Override
    public void emitSpinWait() {
        this.append(new AMD64PauseOp());
    }

    @Override
    public void emitHalt() {
        this.append(new AMD64HaltOp());
    }

    @Override
    public void emitCacheWriteback(Value address) {
        this.append(new AMD64CacheWritebackOp(this.asAddressValue(address)));
    }

    @Override
    public void emitCacheWritebackSync(boolean isPreSync) {
        if (!isPreSync) {
            this.append(new AMD64CacheWritebackPostSyncOp());
        }
    }

    @Override
    public LIRInstruction createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        return new AMD64ZapRegistersOp(zappedRegisters, zapValues);
    }

    @Override
    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        return new AMD64ZapStackOp(zappedStack, zapValues);
    }

    @Override
    public void emitSpeculationFence() {
        this.append(new AMD64LFenceOp());
    }

    @Override
    public void emitProtectionKeyRegisterWrite(Value value) {
        RegisterValue rax = AMD64.rax.asValue(value.getValueKind());
        this.emitMove((AllocatableValue)rax, value);
        this.append(new AMD64WriteDataToUserPageKeyRegister(rax));
    }

    @Override
    public Value emitProtectionKeyRegisterRead() {
        AMD64ReadDataFromUserPageKeyRegister rdpkru = new AMD64ReadDataFromUserPageKeyRegister();
        this.append(rdpkru);
        return this.emitReadRegister(AMD64.rax, rdpkru.retVal.getValueKind());
    }

    @Override
    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        RegisterValue lengthReg = AMD64.rcx.asValue(length.getValueKind());
        this.emitMove((AllocatableValue)lengthReg, length);
        this.append(new AMD64ZeroMemoryOp(this.asAddressValue(address), lengthReg));
    }

    public boolean supportsCPUFeature(AMD64.CPUFeature feature) {
        return ((AMD64)this.target().arch).getFeatures().contains(feature);
    }

    public boolean supportsCPUFeature(String feature) {
        try {
            return ((AMD64)this.target().arch).getFeatures().contains(AMD64.CPUFeature.valueOf((String)feature));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

