/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.core.amd64.AMD64AddressLowering;
import jdk.graal.compiler.core.amd64.AMD64AddressNode;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public abstract class AMD64CompressAddressLowering
extends AMD64AddressLowering {
    private static final CounterKey counterFoldedUncompressDuringAddressLowering = DebugContext.counter("FoldedUncompressDuringAddressLowering");

    @Override
    protected final boolean improve(StructuredGraph graph, DebugContext debug, AMD64AddressNode addr, boolean isBaseNegated, boolean isIndexNegated) {
        if (super.improve(graph, debug, addr, isBaseNegated, isIndexNegated)) {
            return true;
        }
        if (!isBaseNegated && !isIndexNegated && addr.getScale() == Stride.S1) {
            ValueNode base = addr.getBase();
            ValueNode index = addr.getIndex();
            if (this.tryToImproveUncompression(addr, index, base) || this.tryToImproveUncompression(addr, base, index)) {
                counterFoldedUncompressDuringAddressLowering.increment(debug);
                return true;
            }
        }
        return false;
    }

    private boolean tryToImproveUncompression(AMD64AddressNode addr, ValueNode value, ValueNode other) {
        CompressionNode compression;
        return value instanceof CompressionNode && (compression = (CompressionNode)value).getOp() == CompressionNode.CompressionOp.Uncompress && this.improveUncompression(addr, compression, other);
    }

    protected abstract boolean improveUncompression(AMD64AddressNode var1, CompressionNode var2, ValueNode var3);

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static class HeapBaseNode
    extends FloatingNode
    implements LIRLowerable {
        public static final NodeClass<HeapBaseNode> TYPE = NodeClass.create(HeapBaseNode.class);
        private final Register heapBaseRegister;

        public HeapBaseNode(Register heapBaseRegister) {
            super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.pointer());
            this.heapBaseRegister = heapBaseRegister;
        }

        @Override
        public void generate(NodeLIRBuilderTool generator) {
            LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
            generator.setResult(this, (Value)this.heapBaseRegister.asValue((ValueKind)kind));
        }
    }
}

