/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@NodeInfo
public class AMD64AddressNode
extends AddressNode
implements Simplifiable,
LIRLowerable {
    public static final NodeClass<AMD64AddressNode> TYPE = NodeClass.create(AMD64AddressNode.class);
    @Node.OptionalInput
    private ValueNode base;
    @Node.OptionalInput
    private ValueNode index;
    private Stride stride;
    private int displacement;

    public AMD64AddressNode(ValueNode base) {
        this(base, null);
    }

    public AMD64AddressNode(ValueNode base, ValueNode index) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.index = index;
        this.stride = Stride.S1;
    }

    public void canonicalizeIndex(SimplifierTool tool) {
        ValueNode valY;
        LoopBeginNode loopNode;
        PhiNode phi;
        AddNode add;
        ValueNode valX;
        if (this.index instanceof AddNode && ((IntegerStamp)this.index.stamp(NodeView.DEFAULT)).getBits() == 64 && (valX = (add = (AddNode)this.index).getX()) instanceof PhiNode && (phi = (PhiNode)valX).merge() instanceof LoopBeginNode && !(loopNode = (LoopBeginNode)phi.merge()).isSimpleLoop() && (valY = add.getY()) instanceof ConstantNode) {
            int addBy = valY.asJavaConstant().asInt();
            this.displacement += this.stride.value * addBy;
            this.replaceFirstInput(this.index, phi);
            tool.addToWorkList(this.index);
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        AllocatableValue baseValue = this.base == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.base));
        AllocatableValue indexValue = this.index == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.index));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        Object indexReference = this.index == null ? null : (this.stride.equals((Object)Stride.S1) ? LIRKind.derivedBaseFromValue(indexValue) : (LIRKind.isValue((Value)indexValue) ? null : Value.ILLEGAL));
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, indexReference);
        gen.setResult(this, new AMD64AddressValue(kind, baseValue, indexValue, this.stride, this.displacement));
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        if (this.isAlive()) {
            this.updateUsages(this.base, base);
        }
        this.base = base;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    public void setIndex(ValueNode index) {
        if (this.isAlive()) {
            this.updateUsages(this.index, index);
        }
        this.index = index;
    }

    public Stride getScale() {
        return this.stride;
    }

    public void setScale(Stride stride) {
        this.stride = stride;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return this.displacement;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        this.canonicalizeIndex(tool);
    }
}

