/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.aarch64.AArch64ArithmeticOp;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@NodeInfo(nameTemplate="AArch64PointerAdd", cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class AArch64PointerAddNode
extends FloatingNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<AArch64PointerAddNode> TYPE = NodeClass.create(AArch64PointerAddNode.class);
    @Node.Input
    ValueNode base;
    @Node.Input
    ValueNode offset;

    public AArch64PointerAddNode(ValueNode base, ValueNode offset) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.pointer());
        this.base = base;
        this.offset = offset;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64)) : base;
        assert (offset != null && offset.getStackKind().isNumericInteger()) : offset;
    }

    public ValueNode getBase() {
        return this.base;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        LIRGeneratorTool tool = builder.getLIRGeneratorTool();
        Value x = builder.operand(this.base);
        Value y = builder.operand(this.offset);
        AllocatableValue baseValue = tool.asAllocatable(x);
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, null);
        builder.setResult(this, (Value)((AArch64ArithmeticLIRGenerator)gen).emitBinary(kind, AArch64ArithmeticOp.ADD, true, x, y));
    }
}

