/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@NodeInfo
public class AArch64AddressNode
extends AddressNode
implements LIRLowerable {
    public static final NodeClass<AArch64AddressNode> TYPE = NodeClass.create(AArch64AddressNode.class);
    @Node.OptionalInput
    private ValueNode base;
    @Node.OptionalInput
    private ValueNode index;
    private AArch64Address.AddressingMode addressingMode;
    private final int bitMemoryTransferSize;
    private int displacement;
    private int scaleFactor;

    public AArch64AddressNode(int bitMemoryTransferSize, ValueNode base, ValueNode index) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.bitMemoryTransferSize = bitMemoryTransferSize;
        this.base = base;
        this.index = index;
        this.addressingMode = AArch64Address.AddressingMode.REGISTER_OFFSET;
        this.displacement = 0;
        this.scaleFactor = 1;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.verify());
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        AllocatableValue baseValue = this.base == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.base));
        AllocatableValue indexValue = this.index == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.index));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        AllocatableValue indexReference = this.index == null || LIRKind.isValue(indexValue.getValueKind()) ? null : Value.ILLEGAL;
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, indexReference);
        gen.setResult(this, new AArch64AddressValue(kind, this.bitMemoryTransferSize, baseValue, indexValue, this.displacement, this.scaleFactor, this.addressingMode));
    }

    @Override
    public boolean verifyNode() {
        this.assertTrue(this.bitMemoryTransferSize == -1 || this.bitMemoryTransferSize == 8 || this.bitMemoryTransferSize == 16 || this.bitMemoryTransferSize == 32 || this.bitMemoryTransferSize == 64 || this.bitMemoryTransferSize == 128, "Invalid memory transfer size.", new Object[0]);
        switch (this.addressingMode) {
            case IMMEDIATE_SIGNED_UNSCALED: {
                this.assertTrue(this.scaleFactor == 1, "Should not have scale factor.", new Object[0]);
                this.assertTrue(this.index == null, "Immediate address cannot use index register.", new Object[0]);
                break;
            }
            case IMMEDIATE_UNSIGNED_SCALED: {
                this.assertTrue(this.bitMemoryTransferSize / 8 == this.scaleFactor, "Invalid scale factor.", new Object[0]);
                this.assertTrue(this.index == null, "Immediate address cannot use index register.", new Object[0]);
                break;
            }
            case BASE_REGISTER_ONLY: {
                this.assertTrue(this.scaleFactor == 1, "Should not have scale factor.", new Object[0]);
                this.assertTrue(this.displacement == 0 && this.index == null, "Base register only mode cannot have either a displacement or index register.", new Object[0]);
                break;
            }
            case REGISTER_OFFSET: 
            case EXTENDED_REGISTER_OFFSET: {
                this.assertTrue(this.scaleFactor == 1 || this.bitMemoryTransferSize / 8 == this.scaleFactor, "Invalid scale factor.", new Object[0]);
                this.assertTrue(this.displacement == 0 && this.index != null, "Register based mode cannot have a displacement.", new Object[0]);
                break;
            }
            default: {
                this.fail("Pairwise and post/pre index addressing modes should not be present.", new Object[0]);
            }
        }
        return super.verifyNode();
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        if (this.isAlive()) {
            this.updateUsages(this.base, base);
        }
        this.base = base;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    public void setIndex(ValueNode index) {
        if (this.isAlive()) {
            this.updateUsages(this.index, index);
        }
        this.index = index;
    }

    public long getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(long displacement, int scaleFactor, AArch64Address.AddressingMode addressingMode) {
        assert (scaleFactor == 1 || this.bitMemoryTransferSize / 8 == scaleFactor) : Assertions.errorMessageContext("scaleFactor", scaleFactor, "bitMemoryTransfeSize", this.bitMemoryTransferSize);
        this.displacement = NumUtil.safeToInt(displacement);
        this.scaleFactor = scaleFactor;
        this.addressingMode = addressingMode;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return this.displacement;
    }

    public AArch64Address.AddressingMode getAddressingMode() {
        return this.addressingMode;
    }
}

