/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.GraalCompilerOptions;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.MemUseTrackerKey;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.tiers.TargetProvider;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class GraalCompiler {
    private static final TimerKey CompilerTimer = DebugContext.timer("GraalCompiler").doc("Time spent in compilation (excludes code installation).");
    private static final MemUseTrackerKey CompilerMemory = DebugContext.memUseTracker("GraalCompiler");
    private static final TimerKey FrontEnd = DebugContext.timer("FrontEnd").doc("Time spent processing HIR.");

    public static <T extends CompilationResult> T compile(Request<T> r) {
        DebugContext debug = r.graph.getDebug();
        try (CompilationAlarm alarm = CompilationAlarm.trackCompilationPeriod(r.graph.getOptions());){
            assert (!r.graph.isFrozen());
            try (DebugContext.Scope s0 = debug.scope("GraalCompiler", r.graph, r.providers.getCodeCache());
                 DebugCloseable a = CompilerTimer.start(debug);
                 DebugCloseable b = CompilerMemory.start(debug);){
                GraalCompiler.emitFrontEnd(r.providers, r.backend, r.graph, r.graphBuilderSuite, r.optimisticOpts, r.profilingInfo, r.suites);
                r.backend.emitBackEnd(r.graph, null, r.installedCodeOwner, (CompilationResult)r.compilationResult, r.factory, r.entryPointDecorator, null, r.lirSuites);
                if (r.verifySourcePositions) assert (r.graph.verifySourcePositions(true));
                GraalCompiler.checkForRequestedCrash(r.graph, r.requestedCrashHandler());
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            GraalCompiler.checkForRequestedDelay(r.graph);
            Object t = r.compilationResult;
            return t;
        }
    }

    private static void checkForRequestedCrash(StructuredGraph graph, RequestedCrashHandler requestedCrashHandler) {
        String value = GraalCompilerOptions.CrashAt.getValue(graph.getOptions());
        if (value != null) {
            boolean bailout = false;
            boolean permanentBailout = false;
            String methodPattern = value;
            if (value.endsWith(":Bailout")) {
                methodPattern = value.substring(0, value.length() - ":Bailout".length());
                bailout = true;
            } else if (value.endsWith(":PermanentBailout")) {
                methodPattern = value.substring(0, value.length() - ":PermanentBailout".length());
                permanentBailout = true;
            }
            String matchedLabel = GraalCompiler.match(graph, methodPattern);
            if (matchedLabel != null) {
                String crashMessage = "Forced crash after compiling " + matchedLabel;
                if (requestedCrashHandler == null || requestedCrashHandler.notifyCrash(graph.getOptions(), crashMessage)) {
                    if (permanentBailout) {
                        throw new PermanentBailoutException(crashMessage);
                    }
                    if (bailout) {
                        throw new RetryableBailoutException(crashMessage);
                    }
                    throw new RuntimeException(crashMessage);
                }
            }
        }
    }

    private static void checkForRequestedDelay(StructuredGraph graph) {
        String methodPattern;
        String matchedLabel;
        long delayNS = Math.max(0L, TimeUnit.SECONDS.toNanos(GraalCompilerOptions.InjectedCompilationDelay.getValue(graph.getOptions()).intValue()));
        if (delayNS != 0L && (matchedLabel = GraalCompiler.match(graph, methodPattern = DebugOptions.MethodFilter.getValue(graph.getOptions()))) != null) {
            long startNS = System.nanoTime();
            TTY.printf("[%s] delaying compilation of %s for %d ms%n", Thread.currentThread().getName(), matchedLabel, TimeUnit.NANOSECONDS.toMillis(delayNS));
            while (System.nanoTime() - startNS < delayNS) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static String match(StructuredGraph graph, String methodPattern) {
        if (methodPattern == null) {
            return graph.name != null ? graph.name : graph.method().format("%H.%n(%p)");
        }
        String label = null;
        if (graph.name != null && graph.name.contains(methodPattern)) {
            label = graph.name;
        }
        if (label == null) {
            ResolvedJavaMethod method = graph.method();
            MethodFilter filter = MethodFilter.parse(methodPattern);
            if (filter.matches((JavaMethod)method)) {
                label = method.format("%H.%n(%p)");
            }
        }
        return label;
    }

    public static void emitFrontEnd(Providers providers, TargetProvider target, StructuredGraph graph, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites) {
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("FrontEnd");
             DebugCloseable a = FrontEnd.start(debug);){
            HighTierContext highTierContext = new HighTierContext(providers, graphBuilderSuite, optimisticOpts);
            if (graph.start().next() == null) {
                try (DebugContext.CompilerPhaseScope cps = debug.enterCompilerPhase("Parsing");){
                    graphBuilderSuite.apply(graph, highTierContext);
                    new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
                    assert (graph.verifySourcePositions(true));
                    debug.dump(1, graph, "After parsing");
                }
            } else {
                debug.dump(2, graph, "initial state");
            }
            suites.getHighTier().apply(graph, highTierContext);
            graph.maybeCompress();
            debug.dump(1, graph, "After high tier");
            MidTierContext midTierContext = new MidTierContext(providers, target, optimisticOpts, profilingInfo);
            suites.getMidTier().apply(graph, midTierContext);
            graph.maybeCompress();
            debug.dump(1, graph, "After mid tier");
            LowTierContext lowTierContext = new LowTierContext(providers, target);
            suites.getLowTier().apply(graph, lowTierContext);
            debug.dump(1, graph, "After low tier");
            debug.dump(1, graph.getLastSchedule(), "Final HIR schedule");
            graph.logInliningTree();
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        finally {
            graph.checkCancellation();
        }
    }

    public record Request<T extends CompilationResult>(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Providers providers, Backend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites, LIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator, RequestedCrashHandler requestedCrashHandler, boolean verifySourcePositions) {
        public Request(StructuredGraph graph, ResolvedJavaMethod installedCodeOwner, Providers providers, Backend backend, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ProfilingInfo profilingInfo, Suites suites, LIRSuites lirSuites, T compilationResult, CompilationResultBuilderFactory factory, boolean verifySourcePositions) {
            this(graph, installedCodeOwner, providers, backend, graphBuilderSuite, optimisticOpts, profilingInfo, suites, lirSuites, compilationResult, factory, null, null, verifySourcePositions);
        }

        public T execute() {
            return GraalCompiler.compile(this);
        }
    }

    public static interface RequestedCrashHandler {
        public boolean notifyCrash(OptionValues var1, String var2);
    }
}

