/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.GraalCompilerOptions;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.JavaMethod;

public final class CompilationPrinter {
    private final CompilationIdentifier id;
    private final Object source;
    private final int entryBCI;
    private final long start;
    private final long allocatedBytesBefore;
    private static final CompilationPrinter DISABLED = new CompilationPrinter();

    public static CompilationPrinter begin(OptionValues options, CompilationIdentifier id, Object source, int entryBCI) {
        GraalError.guarantee(source instanceof JavaMethod || source instanceof ForeignCallSignature, "%s", source.getClass());
        if (GraalCompilerOptions.PrintCompilation.getValue(options).booleanValue() && !TTY.isSuppressed()) {
            return new CompilationPrinter(id, source, entryBCI);
        }
        return DISABLED;
    }

    private CompilationPrinter() {
        this.source = null;
        this.id = null;
        this.entryBCI = -1;
        this.start = -1L;
        this.allocatedBytesBefore = -1L;
    }

    private CompilationPrinter(CompilationIdentifier id, Object source, int entryBCI) {
        this.source = source;
        this.id = id;
        this.entryBCI = entryBCI;
        this.start = System.nanoTime();
        this.allocatedBytesBefore = GraalServices.isThreadAllocatedMemorySupported() ? GraalServices.getCurrentThreadAllocatedBytes() : -1L;
    }

    private String getMethodDescription() {
        if (this.source instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)this.source;
            return String.format("%-30s %-70s %-45s %-50s %s", this.id.toString(CompilationIdentifier.Verbosity.ID), method.getDeclaringClass().getName(), method.getName(), method.getSignature().toMethodDescriptor(), this.entryBCI == -1 ? "" : "(OSR@" + this.entryBCI + ") ");
        }
        ForeignCallSignature sig = (ForeignCallSignature)this.source;
        return String.format("%-30s %-70s %-45s %-50s %s", this.id.toString(CompilationIdentifier.Verbosity.ID), "<stub>", sig.getName(), sig.toString(false), "");
    }

    public void finish(CompilationResult result, InstalledCode installedCode) {
        if (this.id != null) {
            long stop = System.nanoTime();
            long duration = (stop - this.start) / 1000L;
            int targetCodeSize = result != null ? result.getTargetCodeSize() : -1;
            int bytecodeSize = result != null ? result.getBytecodeSize() : 0;
            String allocated = "";
            String installed = "";
            if (this.allocatedBytesBefore != -1L) {
                long allocatedBytesAfter = GraalServices.getCurrentThreadAllocatedBytes();
                long allocatedKBytes = (allocatedBytesAfter - this.allocatedBytesBefore) / 1024L;
                allocated = String.format(" %5dkB allocated", allocatedKBytes);
            }
            if (installedCode != null) {
                installed = String.format(" start=0x%016x", installedCode.getStart());
            }
            TTY.println(this.getMethodDescription() + String.format(" | %4dus %5dB bytecodes %5dB codesize%s%s", duration, bytecodeSize, targetCodeSize, allocated, installed));
        }
    }
}

