/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.bytecode;

import java.lang.reflect.Field;

public class Bytecodes {
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int LDC_W = 19;
    public static final int LDC2_W = 20;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int INVOKEDYNAMIC = 186;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int WIDE = 196;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int GOTO_W = 200;
    public static final int JSR_W = 201;
    public static final int BREAKPOINT = 202;
    public static final int ILLEGAL = 255;
    public static final int END = 256;
    public static final int LAST_JVM_OPCODE = 201;
    private static final String[] nameArray;
    private static final int[] flagsArray;
    private static final int[] lengthArray;
    private static final int[] stackEffectArray;

    public static int lengthOf(int opcode) {
        return lengthArray[opcode & 0xFF];
    }

    public static int stackEffectOf(int opcode) {
        return stackEffectArray[opcode & 0xFF];
    }

    public static String nameOf(int opcode) throws IllegalArgumentException {
        String name = nameArray[opcode & 0xFF];
        if (name == null) {
            return "<illegal opcode: " + opcode + ">";
        }
        return name;
    }

    public static int valueOf(String name) {
        for (int opcode = 0; opcode < nameArray.length; ++opcode) {
            if (!name.equalsIgnoreCase(nameArray[opcode])) continue;
            return opcode;
        }
        throw new IllegalArgumentException("No opcode for " + name);
    }

    public static boolean isBranch(int opcode) {
        return (flagsArray[opcode & 0xFF] & 4) != 0;
    }

    public static boolean isConditionalBranch(int opcode) {
        return (flagsArray[opcode & 0xFF] & 2) != 0;
    }

    public static boolean isInvoke(int opcode) {
        return (flagsArray[opcode & 0xFF] & 0x1000) != 0;
    }

    public static String operator(int op) {
        switch (op) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return "+";
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return "-";
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return "*";
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return "/";
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return "%";
            }
            case 120: 
            case 121: {
                return "<<";
            }
            case 122: 
            case 123: {
                return ">>";
            }
            case 124: 
            case 125: {
                return ">>>";
            }
            case 126: 
            case 127: {
                return "&";
            }
            case 128: 
            case 129: {
                return "|";
            }
            case 130: 
            case 131: {
                return "^";
            }
        }
        return Bytecodes.nameOf(op);
    }

    private static void def(int opcode, String name, String format, int stackEffect) {
        Bytecodes.def(opcode, name, format, stackEffect, 0);
    }

    private static void def(int opcode, String name, String format, int stackEffect, int flags) {
        int instructionLength;
        assert (nameArray[opcode] == null) : "opcode " + opcode + " is already bound to name " + nameArray[opcode];
        Bytecodes.nameArray[opcode] = name;
        Bytecodes.lengthArray[opcode] = instructionLength = format.length();
        Bytecodes.stackEffectArray[opcode] = stackEffect;
        Bytecodes.flagsArray[opcode] = flags;
        assert (!Bytecodes.isConditionalBranch(opcode) || Bytecodes.isBranch(opcode)) : "a conditional branch must also be a branch";
    }

    static {
        int allFlags = 0;
        try {
            for (Field field : Flags.class.getDeclaredFields()) {
                int flagsFilter = 24;
                if ((field.getModifiers() & flagsFilter) != flagsFilter || field.isSynthetic()) continue;
                assert (field.getType() == Integer.TYPE) : "Field is not int : " + String.valueOf(field);
                int flag = field.getInt(null);
                assert (flag != 0) : flag;
                assert ((flag & allFlags) == 0) : field.getName() + " has a value conflicting with another flag";
                allFlags |= flag;
            }
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        nameArray = new String[256];
        flagsArray = new int[256];
        lengthArray = new int[256];
        stackEffectArray = new int[256];
        Bytecodes.def(0, "nop", "b", 0);
        Bytecodes.def(1, "aconst_null", "b", 1);
        Bytecodes.def(2, "iconst_m1", "b", 1);
        Bytecodes.def(3, "iconst_0", "b", 1);
        Bytecodes.def(4, "iconst_1", "b", 1);
        Bytecodes.def(5, "iconst_2", "b", 1);
        Bytecodes.def(6, "iconst_3", "b", 1);
        Bytecodes.def(7, "iconst_4", "b", 1);
        Bytecodes.def(8, "iconst_5", "b", 1);
        Bytecodes.def(9, "lconst_0", "b", 2);
        Bytecodes.def(10, "lconst_1", "b", 2);
        Bytecodes.def(11, "fconst_0", "b", 1);
        Bytecodes.def(12, "fconst_1", "b", 1);
        Bytecodes.def(13, "fconst_2", "b", 1);
        Bytecodes.def(14, "dconst_0", "b", 2);
        Bytecodes.def(15, "dconst_1", "b", 2);
        Bytecodes.def(16, "bipush", "bc", 1);
        Bytecodes.def(17, "sipush", "bcc", 1);
        Bytecodes.def(18, "ldc", "bi", 1, 128);
        Bytecodes.def(19, "ldc_w", "bii", 1, 128);
        Bytecodes.def(20, "ldc2_w", "bii", 2, 128);
        Bytecodes.def(21, "iload", "bi", 1, 1024);
        Bytecodes.def(22, "lload", "bi", 2, 1024);
        Bytecodes.def(23, "fload", "bi", 1, 1024);
        Bytecodes.def(24, "dload", "bi", 2, 1024);
        Bytecodes.def(25, "aload", "bi", 1, 1024);
        Bytecodes.def(26, "iload_0", "b", 1, 1024);
        Bytecodes.def(27, "iload_1", "b", 1, 1024);
        Bytecodes.def(28, "iload_2", "b", 1, 1024);
        Bytecodes.def(29, "iload_3", "b", 1, 1024);
        Bytecodes.def(30, "lload_0", "b", 2, 1024);
        Bytecodes.def(31, "lload_1", "b", 2, 1024);
        Bytecodes.def(32, "lload_2", "b", 2, 1024);
        Bytecodes.def(33, "lload_3", "b", 2, 1024);
        Bytecodes.def(34, "fload_0", "b", 1, 1024);
        Bytecodes.def(35, "fload_1", "b", 1, 1024);
        Bytecodes.def(36, "fload_2", "b", 1, 1024);
        Bytecodes.def(37, "fload_3", "b", 1, 1024);
        Bytecodes.def(38, "dload_0", "b", 2, 1024);
        Bytecodes.def(39, "dload_1", "b", 2, 1024);
        Bytecodes.def(40, "dload_2", "b", 2, 1024);
        Bytecodes.def(41, "dload_3", "b", 2, 1024);
        Bytecodes.def(42, "aload_0", "b", 1, 1024);
        Bytecodes.def(43, "aload_1", "b", 1, 1024);
        Bytecodes.def(44, "aload_2", "b", 1, 1024);
        Bytecodes.def(45, "aload_3", "b", 1, 1024);
        Bytecodes.def(46, "iaload", "b", -1, 128);
        Bytecodes.def(47, "laload", "b", 0, 128);
        Bytecodes.def(48, "faload", "b", -1, 128);
        Bytecodes.def(49, "daload", "b", 0, 128);
        Bytecodes.def(50, "aaload", "b", -1, 128);
        Bytecodes.def(51, "baload", "b", -1, 128);
        Bytecodes.def(52, "caload", "b", -1, 128);
        Bytecodes.def(53, "saload", "b", -1, 128);
        Bytecodes.def(54, "istore", "bi", -1, 2048);
        Bytecodes.def(55, "lstore", "bi", -2, 2048);
        Bytecodes.def(56, "fstore", "bi", -1, 2048);
        Bytecodes.def(57, "dstore", "bi", -2, 2048);
        Bytecodes.def(58, "astore", "bi", -1, 2048);
        Bytecodes.def(59, "istore_0", "b", -1, 2048);
        Bytecodes.def(60, "istore_1", "b", -1, 2048);
        Bytecodes.def(61, "istore_2", "b", -1, 2048);
        Bytecodes.def(62, "istore_3", "b", -1, 2048);
        Bytecodes.def(63, "lstore_0", "b", -2, 2048);
        Bytecodes.def(64, "lstore_1", "b", -2, 2048);
        Bytecodes.def(65, "lstore_2", "b", -2, 2048);
        Bytecodes.def(66, "lstore_3", "b", -2, 2048);
        Bytecodes.def(67, "fstore_0", "b", -1, 2048);
        Bytecodes.def(68, "fstore_1", "b", -1, 2048);
        Bytecodes.def(69, "fstore_2", "b", -1, 2048);
        Bytecodes.def(70, "fstore_3", "b", -1, 2048);
        Bytecodes.def(71, "dstore_0", "b", -2, 2048);
        Bytecodes.def(72, "dstore_1", "b", -2, 2048);
        Bytecodes.def(73, "dstore_2", "b", -2, 2048);
        Bytecodes.def(74, "dstore_3", "b", -2, 2048);
        Bytecodes.def(75, "astore_0", "b", -1, 2048);
        Bytecodes.def(76, "astore_1", "b", -1, 2048);
        Bytecodes.def(77, "astore_2", "b", -1, 2048);
        Bytecodes.def(78, "astore_3", "b", -1, 2048);
        Bytecodes.def(79, "iastore", "b", -3, 128);
        Bytecodes.def(80, "lastore", "b", -4, 128);
        Bytecodes.def(81, "fastore", "b", -3, 128);
        Bytecodes.def(82, "dastore", "b", -4, 128);
        Bytecodes.def(83, "aastore", "b", -3, 128);
        Bytecodes.def(84, "bastore", "b", -3, 128);
        Bytecodes.def(85, "castore", "b", -3, 128);
        Bytecodes.def(86, "sastore", "b", -3, 128);
        Bytecodes.def(87, "pop", "b", -1);
        Bytecodes.def(88, "pop2", "b", -2);
        Bytecodes.def(89, "dup", "b", 1);
        Bytecodes.def(90, "dup_x1", "b", 1);
        Bytecodes.def(91, "dup_x2", "b", 1);
        Bytecodes.def(92, "dup2", "b", 2);
        Bytecodes.def(93, "dup2_x1", "b", 2);
        Bytecodes.def(94, "dup2_x2", "b", 2);
        Bytecodes.def(95, "swap", "b", 0);
        Bytecodes.def(96, "iadd", "b", -1, 768);
        Bytecodes.def(97, "ladd", "b", -2, 768);
        Bytecodes.def(98, "fadd", "b", -1, 768);
        Bytecodes.def(99, "dadd", "b", -2, 768);
        Bytecodes.def(100, "isub", "b", -1);
        Bytecodes.def(101, "lsub", "b", -2);
        Bytecodes.def(102, "fsub", "b", -1);
        Bytecodes.def(103, "dsub", "b", -2);
        Bytecodes.def(104, "imul", "b", -1, 768);
        Bytecodes.def(105, "lmul", "b", -2, 768);
        Bytecodes.def(106, "fmul", "b", -1, 768);
        Bytecodes.def(107, "dmul", "b", -2, 768);
        Bytecodes.def(108, "idiv", "b", -1, 128);
        Bytecodes.def(109, "ldiv", "b", -2, 128);
        Bytecodes.def(110, "fdiv", "b", -1);
        Bytecodes.def(111, "ddiv", "b", -2);
        Bytecodes.def(112, "irem", "b", -1, 128);
        Bytecodes.def(113, "lrem", "b", -2, 128);
        Bytecodes.def(114, "frem", "b", -1);
        Bytecodes.def(115, "drem", "b", -2);
        Bytecodes.def(116, "ineg", "b", 0);
        Bytecodes.def(117, "lneg", "b", 0);
        Bytecodes.def(118, "fneg", "b", 0);
        Bytecodes.def(119, "dneg", "b", 0);
        Bytecodes.def(120, "ishl", "b", -1);
        Bytecodes.def(121, "lshl", "b", -1);
        Bytecodes.def(122, "ishr", "b", -1);
        Bytecodes.def(123, "lshr", "b", -1);
        Bytecodes.def(124, "iushr", "b", -1);
        Bytecodes.def(125, "lushr", "b", -1);
        Bytecodes.def(126, "iand", "b", -1, 768);
        Bytecodes.def(127, "land", "b", -2, 768);
        Bytecodes.def(128, "ior", "b", -1, 768);
        Bytecodes.def(129, "lor", "b", -2, 768);
        Bytecodes.def(130, "ixor", "b", -1, 768);
        Bytecodes.def(131, "lxor", "b", -2, 768);
        Bytecodes.def(132, "iinc", "bic", 0, 3072);
        Bytecodes.def(133, "i2l", "b", 1);
        Bytecodes.def(134, "i2f", "b", 0);
        Bytecodes.def(135, "i2d", "b", 1);
        Bytecodes.def(136, "l2i", "b", -1);
        Bytecodes.def(137, "l2f", "b", -1);
        Bytecodes.def(138, "l2d", "b", 0);
        Bytecodes.def(139, "f2i", "b", 0);
        Bytecodes.def(140, "f2l", "b", 1);
        Bytecodes.def(141, "f2d", "b", 1);
        Bytecodes.def(142, "d2i", "b", -1);
        Bytecodes.def(143, "d2l", "b", 0);
        Bytecodes.def(144, "d2f", "b", -1);
        Bytecodes.def(145, "i2b", "b", 0);
        Bytecodes.def(146, "i2c", "b", 0);
        Bytecodes.def(147, "i2s", "b", 0);
        Bytecodes.def(148, "lcmp", "b", -3);
        Bytecodes.def(149, "fcmpl", "b", -1);
        Bytecodes.def(150, "fcmpg", "b", -1);
        Bytecodes.def(151, "dcmpl", "b", -3);
        Bytecodes.def(152, "dcmpg", "b", -3);
        Bytecodes.def(153, "ifeq", "boo", -1, 6);
        Bytecodes.def(154, "ifne", "boo", -1, 6);
        Bytecodes.def(155, "iflt", "boo", -1, 6);
        Bytecodes.def(156, "ifge", "boo", -1, 6);
        Bytecodes.def(157, "ifgt", "boo", -1, 6);
        Bytecodes.def(158, "ifle", "boo", -1, 6);
        Bytecodes.def(159, "if_icmpeq", "boo", -2, 262);
        Bytecodes.def(160, "if_icmpne", "boo", -2, 262);
        Bytecodes.def(161, "if_icmplt", "boo", -2, 6);
        Bytecodes.def(162, "if_icmpge", "boo", -2, 6);
        Bytecodes.def(163, "if_icmpgt", "boo", -2, 6);
        Bytecodes.def(164, "if_icmple", "boo", -2, 6);
        Bytecodes.def(165, "if_acmpeq", "boo", -2, 262);
        Bytecodes.def(166, "if_acmpne", "boo", -2, 262);
        Bytecodes.def(167, "goto", "boo", 0, 5);
        Bytecodes.def(168, "jsr", "boo", 0, 5);
        Bytecodes.def(169, "ret", "bi", 0, 1);
        Bytecodes.def(170, "tableswitch", "", -1, 1);
        Bytecodes.def(171, "lookupswitch", "", -1, 1);
        Bytecodes.def(172, "ireturn", "b", -1, 129);
        Bytecodes.def(173, "lreturn", "b", -2, 129);
        Bytecodes.def(174, "freturn", "b", -1, 129);
        Bytecodes.def(175, "dreturn", "b", -2, 129);
        Bytecodes.def(176, "areturn", "b", -1, 129);
        Bytecodes.def(177, "return", "b", 0, 129);
        Bytecodes.def(178, "getstatic", "bjj", 1, 136);
        Bytecodes.def(179, "putstatic", "bjj", -1, 144);
        Bytecodes.def(180, "getfield", "bjj", 0, 136);
        Bytecodes.def(181, "putfield", "bjj", -2, 144);
        Bytecodes.def(182, "invokevirtual", "bjj", -1, 4224);
        Bytecodes.def(183, "invokespecial", "bjj", -1, 4224);
        Bytecodes.def(184, "invokestatic", "bjj", 0, 4224);
        Bytecodes.def(185, "invokeinterface", "bjja_", -1, 4224);
        Bytecodes.def(186, "invokedynamic", "bjjjj", 0, 4224);
        Bytecodes.def(187, "new", "bii", 1, 128);
        Bytecodes.def(188, "newarray", "bc", 0, 128);
        Bytecodes.def(189, "anewarray", "bii", 0, 128);
        Bytecodes.def(190, "arraylength", "b", 0, 128);
        Bytecodes.def(191, "athrow", "b", -1, 129);
        Bytecodes.def(192, "checkcast", "bii", 0, 128);
        Bytecodes.def(193, "instanceof", "bii", 0, 128);
        Bytecodes.def(194, "monitorenter", "b", -1, 128);
        Bytecodes.def(195, "monitorexit", "b", -1, 128);
        Bytecodes.def(196, "wide", "", 0);
        Bytecodes.def(197, "multianewarray", "biic", 1, 128);
        Bytecodes.def(198, "ifnull", "boo", -1, 6);
        Bytecodes.def(199, "ifnonnull", "boo", -1, 6);
        Bytecodes.def(200, "goto_w", "boooo", 0, 5);
        Bytecodes.def(201, "jsr_w", "boooo", 0, 5);
        Bytecodes.def(202, "breakpoint", "b", 0, 128);
    }

    static class Flags {
        static final int STOP = 1;
        static final int FALL_THROUGH = 2;
        static final int BRANCH = 4;
        static final int FIELD_READ = 8;
        static final int FIELD_WRITE = 16;
        static final int TRAP = 128;
        static final int COMMUTATIVE = 256;
        static final int ASSOCIATIVE = 512;
        static final int LOAD = 1024;
        static final int STORE = 2048;
        static final int INVOKE = 4096;

        Flags() {
        }
    }
}

