/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.bytecode;

import jdk.graal.compiler.bytecode.BytecodeLookupSwitch;
import jdk.graal.compiler.bytecode.BytecodeTableSwitch;
import jdk.graal.compiler.bytecode.Bytecodes;
import jdk.graal.compiler.bytecode.Bytes;

public final class BytecodeStream {
    private final byte[] code;
    private int opcode;
    private int curBCI;
    private int nextBCI;

    public BytecodeStream(byte[] code) {
        assert (code != null);
        this.code = code;
        this.setBCI(0);
    }

    public void next() {
        this.setBCI(this.nextBCI);
    }

    public int nextBCI() {
        return this.nextBCI;
    }

    public int currentBCI() {
        return this.curBCI;
    }

    public int endBCI() {
        return this.code.length;
    }

    public int currentBC() {
        if (this.opcode == 196) {
            return Bytes.beU1(this.code, this.curBCI + 1);
        }
        return this.opcode;
    }

    public int readLocalIndex() {
        if (this.opcode == 196) {
            return Bytes.beU2(this.code, this.curBCI + 2);
        }
        return Bytes.beU1(this.code, this.curBCI + 1);
    }

    public int readIncrement() {
        if (this.opcode == 196) {
            return Bytes.beS2(this.code, this.curBCI + 4);
        }
        return Bytes.beS1(this.code, this.curBCI + 2);
    }

    public int readBranchDest() {
        if (this.opcode == 200 || this.opcode == 201) {
            return this.curBCI + Bytes.beS4(this.code, this.curBCI + 1);
        }
        return this.curBCI + Bytes.beS2(this.code, this.curBCI + 1);
    }

    public int readInt(int bci) {
        return Bytes.beS4(this.code, bci);
    }

    public int readUByte(int bci) {
        return Bytes.beU1(this.code, bci);
    }

    public char readCPI() {
        if (this.opcode == 18) {
            return (char)Bytes.beU1(this.code, this.curBCI + 1);
        }
        return (char)Bytes.beU2(this.code, this.curBCI + 1);
    }

    public int readCPI4() {
        assert (this.opcode == 186) : this.opcode;
        return Bytes.beS4(this.code, this.curBCI + 1);
    }

    public byte readByte() {
        return this.code[this.curBCI + 1];
    }

    public short readShort() {
        return (short)Bytes.beS2(this.code, this.curBCI + 1);
    }

    public void setBCI(int bci) {
        this.curBCI = bci;
        if (this.curBCI < this.code.length) {
            this.opcode = Bytes.beU1(this.code, bci);
            assert (this.opcode < 202) : "illegal bytecode";
            this.nextBCI = bci + this.lengthOf();
        } else {
            this.opcode = 256;
            this.nextBCI = this.curBCI;
        }
    }

    private int lengthOf() {
        int length = Bytecodes.lengthOf(this.opcode);
        if (length == 0) {
            switch (this.opcode) {
                case 170: {
                    return new BytecodeTableSwitch(this, this.curBCI).size();
                }
                case 171: {
                    return new BytecodeLookupSwitch(this, this.curBCI).size();
                }
                case 196: {
                    int opc = Bytes.beU1(this.code, this.curBCI + 1);
                    if (opc == 169) {
                        return 4;
                    }
                    if (opc == 132) {
                        return 6;
                    }
                    return 4;
                }
            }
            throw new Error("unknown variable-length bytecode: " + this.opcode);
        }
        return length;
    }
}

