/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.bytecode;

import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.bytecode.BytecodeSwitch;

public class BytecodeLookupSwitch
extends BytecodeSwitch {
    private static final int OFFSET_TO_NUMBER_PAIRS = 4;
    private static final int OFFSET_TO_FIRST_PAIR_MATCH = 8;
    private static final int OFFSET_TO_FIRST_PAIR_OFFSET = 12;
    private static final int PAIR_SIZE = 8;

    public BytecodeLookupSwitch(BytecodeStream stream, int bci) {
        super(stream, bci);
    }

    @Override
    public int offsetAt(int i) {
        return this.stream.readInt(this.alignedBci + 12 + 8 * i);
    }

    @Override
    public int keyAt(int i) {
        return this.stream.readInt(this.alignedBci + 8 + 8 * i);
    }

    @Override
    public int numberOfCases() {
        return this.stream.readInt(this.alignedBci + 4);
    }

    @Override
    public int size() {
        return this.alignedBci + 8 + 8 * this.numberOfCases() - this.bci;
    }
}

