/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm.amd64;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.asm.BranchTargetOutOfBoundsException;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.collections.EconomicSet;

public class AMD64Assembler
extends AMD64BaseAssembler {
    private final boolean useBranchesWithin32ByteBoundary;
    private boolean optimizeLongJumps;
    protected static final int P_0F = 15;
    protected static final int P_0F38 = 14351;
    protected static final int P_0F3A = 14863;
    private static final UnionRegisterCategory CPU_OR_MASK = new UnionRegisterCategory("CPU_OR_MASK", AMD64.CPU, AMD64.MASK);
    private static final UnionRegisterCategory CPU_OR_XMM = new UnionRegisterCategory("CPU_OR_XMM", AMD64.CPU, AMD64.XMM);
    public static final int JCC_ERRATUM_MITIGATION_BOUNDARY = 32;
    public static final int OPCODE_IN_BYTES = 1;
    public static final int MODRM_IN_BYTES = 1;
    private int nextJumpIdx = 0;
    private List<JumpInfo> jumpInfo = new ArrayList<JumpInfo>();
    private EconomicSet<Integer> longToShortJumps = EconomicSet.create();
    private static final int MAX_OPTIMIZE_LONG_JUMPS_BAILOUTS = 20;
    private static AtomicInteger optimizeLongJumpsBailouts = new AtomicInteger(0);

    public AMD64Assembler(TargetDescription target) {
        super(target);
        this.useBranchesWithin32ByteBoundary = false;
        this.optimizeLongJumps = GraalOptions.OptimizeLongJumps.getDefaultValue();
    }

    public AMD64Assembler(TargetDescription target, OptionValues optionValues, boolean hasIntelJccErratum) {
        super(target);
        this.useBranchesWithin32ByteBoundary = Options.UseBranchesWithin32ByteBoundary.hasBeenSet(optionValues) ? Options.UseBranchesWithin32ByteBoundary.getValue(optionValues) : GraalOptions.ReduceCodeSize.getValue(optionValues) == false && hasIntelJccErratum;
        this.optimizeLongJumps = GraalOptions.OptimizeLongJumps.getValue(optionValues);
    }

    private static boolean categoryContains(Register.RegisterCategory category, Register register) {
        return register.getRegisterCategory().equals((Object)category) || category instanceof UnionRegisterCategory && ((UnionRegisterCategory)category).contains(register);
    }

    public final void emit(VexRMOp op, Register dst, Register src, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src);
    }

    public final void emit(VexRMOp op, Register dst, AMD64Address src, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src);
    }

    public final void emit(VexRMIOp op, Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src, imm8);
    }

    public final void emit(VexMRIOp op, Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src, imm8);
    }

    public final void emit(VexRVMOp op, Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src1, src2);
    }

    public final void emit(VexGeneralPurposeRMVOp op, Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        op.emit(this, size, dst, src1, src2);
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte) {
        boolean needsRex = AMD64Assembler.needsRex(dst, dstIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, Register src, boolean srcIsByte) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src, srcIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected boolean mayCrossBoundary(int opStart, int opEnd) {
        return opStart / 32 != (opEnd - 1) / 32 || opEnd % 32 == 0;
    }

    private static int bytesUntilBoundary(int pos) {
        return 32 - pos % 32;
    }

    protected boolean ensureWithinBoundary(int opStart) {
        int nextOpStart;
        int opEnd;
        if (this.useBranchesWithin32ByteBoundary && this.mayCrossBoundary(opStart, opEnd = (nextOpStart = this.position()) - 1)) {
            throw new GraalError("instruction at %d of size %d bytes crosses a JCC erratum boundary", opStart, nextOpStart - opStart);
        }
        return true;
    }

    protected final int mitigateJCCErratum(int bytesToEmit) {
        return this.mitigateJCCErratum(this.position(), bytesToEmit);
    }

    protected final int mitigateJCCErratum(int position, int bytesToEmit) {
        int bytesUntilBoundary;
        if (this.useBranchesWithin32ByteBoundary && (bytesUntilBoundary = AMD64Assembler.bytesUntilBoundary(position)) < bytesToEmit) {
            this.nop(bytesUntilBoundary);
            return bytesUntilBoundary;
        }
        return 0;
    }

    public void jcc(ConditionFlag cc, int jumpTarget, boolean forceDisp32) {
        int shortSize = JumpType.JCCB.instrSize;
        int longSize = JumpType.JCC.instrSize;
        long disp = jumpTarget - this.position();
        if (!forceDisp32 && NumUtil.isByte(disp - (long)shortSize)) {
            this.mitigateJCCErratum(shortSize);
            disp = jumpTarget - this.position();
            if (NumUtil.isByte(disp - (long)shortSize)) {
                int pos = this.position();
                this.emitByte(0x70 | cc.getValue());
                this.emitByte((int)(disp - (long)shortSize & 0xFFL));
                this.trackJump(JumpType.JCCB, pos);
                return;
            }
        }
        assert (forceDisp32 || NumUtil.isInt(disp - (long)longSize)) : "must be 32bit offset (call4)";
        this.mitigateJCCErratum(longSize);
        int pos = this.position();
        disp = jumpTarget - this.position();
        this.emitByte(15);
        this.emitByte(0x80 | cc.getValue());
        this.emitInt((int)(disp - (long)longSize));
        this.trackJump(JumpType.JCC, pos);
    }

    public final void jcc(ConditionFlag cc) {
        this.annotatePatchingImmediate(2, 4);
        int pos = this.position();
        this.emitByte(15);
        this.emitByte(0x80 | cc.getValue());
        this.emitInt(0);
        this.trackJump(JumpType.JCC, pos);
    }

    public final void jcc(ConditionFlag cc, Label l) {
        assert (0 <= cc.getValue() && cc.getValue() < 16) : "illegal cc";
        if (l.isBound()) {
            this.jcc(cc, l.position(), false);
        } else if (this.canUseShortJump(this.nextJumpIdx)) {
            this.jccb(cc, l);
        } else {
            this.mitigateJCCErratum(6);
            l.addPatchAt(this.position(), this);
            int pos = this.position();
            this.emitByte(15);
            this.emitByte(0x80 | cc.getValue());
            this.emitInt(0);
            this.trackJump(JumpType.JCC, pos);
        }
    }

    public final void jccb(ConditionFlag cc, Label l) {
        if (this.force4ByteNonZeroDisplacements) {
            this.jcc(cc, l);
            return;
        }
        int shortSize = JumpType.JCCB.instrSize;
        this.mitigateJCCErratum(shortSize);
        int pos = this.position();
        if (l.isBound()) {
            int entry = l.position();
            assert (NumUtil.isByte(entry - (this.position() + shortSize))) : "Displacement too large for a short jmp: " + (entry - (this.position() + shortSize));
            long disp = entry - this.position();
            this.emitByte(0x70 | cc.getValue());
            this.emitByte((int)(disp - (long)shortSize & 0xFFL));
            this.trackJump(JumpType.JCCB, pos);
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(0x70 | cc.getValue());
            this.emitByte(0);
            this.trackJump(JumpType.JCCB, pos);
        }
    }

    public final void jcc(ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        if (branchTarget == null) {
            this.jcc(cc, 0, true);
        } else if (isShortJmp) {
            this.jccb(cc, branchTarget);
        } else {
            this.jcc(cc, branchTarget);
        }
    }

    public final int jmp(int jumpTarget, boolean forceDisp32) {
        long disp;
        int pos;
        int shortSize = JumpType.JMPB.instrSize;
        int longSize = JumpType.JMP.instrSize;
        if (!forceDisp32) {
            this.mitigateJCCErratum(shortSize);
            pos = this.position();
            disp = jumpTarget - pos;
            if (NumUtil.isByte(disp - (long)shortSize)) {
                this.emitByte(235);
                this.emitByte((int)(disp - (long)shortSize & 0xFFL));
                this.trackJump(JumpType.JMPB, pos);
                return pos;
            }
        }
        this.mitigateJCCErratum(longSize);
        pos = this.position();
        disp = jumpTarget - pos;
        this.emitByte(233);
        this.emitInt((int)(disp - (long)longSize));
        this.trackJump(JumpType.JMP, pos);
        return pos;
    }

    @Override
    public final void jmp(Label l) {
        if (l.isBound()) {
            this.jmp(l.position(), false);
        } else if (this.canUseShortJump(this.nextJumpIdx)) {
            this.jmpb(l);
        } else {
            this.mitigateJCCErratum(5);
            int pos = this.position();
            l.addPatchAt(pos, this);
            this.emitByte(233);
            this.emitInt(0);
            this.trackJump(JumpType.JMP, pos);
        }
    }

    public final void jmp(Label l, boolean isShortJmp) {
        if (isShortJmp) {
            this.jmpb(l);
        } else {
            this.jmp(l);
        }
    }

    protected final void jmpWithoutAlignment(Register entry) {
        this.prefix(entry);
        this.emitByte(255);
        this.emitModRM(4, entry);
    }

    public void jmp(Register entry) {
        int bytesToEmit = AMD64Assembler.needsRex(entry) ? 3 : 2;
        this.mitigateJCCErratum(bytesToEmit);
        int beforeJmp = this.position();
        this.jmpWithoutAlignment(entry);
        assert (beforeJmp + bytesToEmit == this.position()) : beforeJmp + " " + bytesToEmit + " " + this.position();
    }

    public void jmp(AMD64Address adr) {
        int bytesToEmit = AMD64Assembler.getPrefixInBytes(AMD64BaseAssembler.OperandSize.DWORD, adr) + 1 + this.addressInBytes(adr);
        this.mitigateJCCErratum(bytesToEmit);
        int beforeJmp = this.position();
        this.prefix(adr);
        this.emitByte(255);
        this.emitOperandHelper(AMD64.rsp, adr, 0);
        assert (beforeJmp + bytesToEmit == this.position()) : beforeJmp + " " + bytesToEmit + " " + this.position();
    }

    protected int addressInBytes(AMD64Address addr) {
        Register base = addr.getBase();
        Register index = addr.getIndex();
        int disp = addr.getDisplacement();
        if (base.equals((Object)AMD64.rip)) {
            return 5;
        }
        if (base.isValid()) {
            boolean isByteDisplacement;
            boolean isZeroDisplacement = addr.getDisplacementAnnotation() == null && disp == 0 && !base.equals((Object)AMD64.rbp) && !base.equals((Object)AMD64.r13);
            boolean bl = isByteDisplacement = addr.getDisplacementAnnotation() == null && NumUtil.isByte(disp) && (!this.force4ByteNonZeroDisplacements || disp == 0);
            if (index.isValid()) {
                if (isZeroDisplacement) {
                    return 2;
                }
                if (isByteDisplacement) {
                    return 3;
                }
                return 6;
            }
            if (base.equals((Object)AMD64.rsp) || base.equals((Object)AMD64.r12)) {
                if (disp == 0) {
                    return 2;
                }
                if (isByteDisplacement) {
                    return 3;
                }
                return 6;
            }
            if (isZeroDisplacement) {
                return 1;
            }
            if (isByteDisplacement) {
                return 2;
            }
            return 5;
        }
        return 6;
    }

    public final void jmpb(Label l) {
        if (this.force4ByteNonZeroDisplacements) {
            this.jmp(l);
            return;
        }
        int shortSize = JumpType.JMPB.instrSize;
        this.mitigateJCCErratum(shortSize);
        if (l.isBound()) {
            int pos = this.position();
            int displacement = l.position() - pos - shortSize;
            GraalError.guarantee(NumUtil.isByte(displacement), "Displacement too large to be encoded as a byte: %d", (Object)displacement);
            this.emitByte(235);
            this.emitByte(displacement & 0xFF);
            this.trackJump(JumpType.JMPB, pos);
        } else {
            int pos = this.position();
            l.addPatchAt(pos, this);
            this.emitByte(235);
            this.emitByte(0);
            this.trackJump(JumpType.JMPB, pos);
        }
    }

    @Override
    protected final void patchJumpTarget(int branch, int branchTarget) {
        int op = this.getByte(branch);
        assert (op == 232 || op == 0 || op == 233 || op == 235 || (op & 0xF0) == 112 || op == 15 && (this.getByte(branch + 1) & 0xF0) == 128) : "Invalid opcode at patch point branch=" + branch + ", branchTarget=" + branchTarget + ", op=" + op;
        if (op == 0) {
            int offsetToJumpTableBase = this.getShort(branch + 1);
            int jumpTableBase = branch - offsetToJumpTableBase;
            int imm32 = branchTarget - jumpTableBase;
            this.emitInt(imm32, branch);
        } else if (op == 235 || (op & 0xF0) == 112) {
            int imm8 = branchTarget - (branch + 2);
            if (!NumUtil.isByte(imm8)) {
                throw new BranchTargetOutOfBoundsException(true, "Displacement too large to be encoded as a byte: %d", imm8);
            }
            this.emitByte(imm8, branch + 1);
        } else {
            int off = 1;
            if (op == 15) {
                off = 2;
            }
            int imm32 = branchTarget - (branch + 4 + off);
            this.emitInt(imm32, branch + off);
        }
    }

    public void ret(int imm16) {
        if (imm16 == 0) {
            this.mitigateJCCErratum(1);
            this.emitByte(195);
        } else {
            this.mitigateJCCErratum(3);
            this.emitByte(194);
            this.emitShort(imm16);
        }
    }

    private boolean canUseShortJump(int jumpIdx) {
        return !this.force4ByteNonZeroDisplacements && this.optimizeLongJumps && this.longToShortJumps != null && this.longToShortJumps.contains((Object)jumpIdx);
    }

    private void trackJump(JumpType type, int pos) {
        this.jumpInfo.add(new JumpInfo(this.nextJumpIdx++, type, pos, this));
    }

    public void disableOptimizeLongJumpsAfterException() {
        assert (optimizeLongJumpsBailouts.incrementAndGet() < 20) : "Replacing 4byte-displacement jumps with 1byte-displacement jumps has resulted in too many BranchTargetOutOfBoundsExceptions. Please check the algorithm or disable the optimization by setting OptimizeLongJumps=false!";
        this.optimizeLongJumps = false;
    }

    @Override
    public void reset() {
        if (this.optimizeLongJumps) {
            this.longToShortJumps.clear();
            for (JumpInfo j : this.jumpInfo) {
                if (!j.canBeOptimized()) continue;
                this.longToShortJumps.add((Object)j.jumpIdx);
            }
        }
        super.reset();
        this.nextJumpIdx = 0;
        this.jumpInfo = new ArrayList<JumpInfo>();
    }

    @Override
    public AMD64Address makeAddress(int transferSize, Register base, int displacement) {
        return this.makeAddress(base, displacement);
    }

    public AMD64Address makeAddress(Register base, int displacement) {
        return new AMD64Address(base, displacement);
    }

    @Override
    public AMD64Address getPlaceholder(int instructionStartPosition) {
        return new AMD64Address(AMD64.rip, Register.None, Stride.S1, 0, null, instructionStartPosition);
    }

    @Override
    public void align(int modulus) {
        this.align(modulus, this.position());
    }

    @Override
    public final void ensureUniquePC() {
        this.nop();
    }

    @Override
    public void halt() {
        this.hlt();
    }

    private void intelNops(int count) {
        int i;
        for (i = count; i >= 15; i -= 15) {
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.addrNop8();
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(144);
        }
        switch (i) {
            case 14: {
                this.emitByte(102);
            }
            case 13: {
                this.emitByte(102);
            }
            case 12: {
                this.addrNop8();
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(144);
                break;
            }
            case 11: {
                this.emitByte(102);
            }
            case 10: {
                this.emitByte(102);
            }
            case 9: {
                this.emitByte(102);
            }
            case 8: {
                this.addrNop8();
                break;
            }
            case 7: {
                this.addrNop7();
                break;
            }
            case 6: {
                this.emitByte(102);
            }
            case 5: {
                this.addrNop5();
                break;
            }
            case 4: {
                this.addrNop4();
                break;
            }
            case 3: {
                this.emitByte(102);
            }
            case 2: {
                this.emitByte(102);
            }
            case 1: {
                this.emitByte(144);
                break;
            }
            default: {
                assert (i == 0) : i;
                break;
            }
        }
    }

    private void addrNop8() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(132);
        this.emitByte(0);
        this.emitInt(0);
    }

    private void addrNop7() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(128);
        this.emitInt(0);
    }

    private void addrNop5() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(68);
        this.emitByte(0);
        this.emitByte(0);
    }

    private void addrNop4() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(64);
        this.emitByte(0);
    }

    public void align(int modulus, int target) {
        if (target % modulus != 0) {
            this.nop(modulus - target % modulus);
        }
    }

    protected final void call() {
        this.annotatePatchingImmediate(1, 4);
        this.emitByte(232);
        this.emitInt(0);
    }

    public final void bswapl(Register reg) {
        this.prefix(reg);
        this.emitByte(15);
        this.emitModRM(1, reg);
    }

    public final void bswapq(Register reg) {
        this.prefixq(reg);
        this.emitByte(15);
        this.emitByte(200 + AMD64Assembler.encode(reg));
    }

    public final void call(Label l) {
        if (l.isBound()) {
            this.emitByte(232);
            this.emitInt(l.position());
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(232);
            this.emitInt(0);
        }
    }

    public final void call(Register src) {
        this.prefix(src);
        this.emitByte(255);
        this.emitModRM(2, src);
    }

    public final void cdql() {
        this.emitByte(153);
    }

    public final void cdqq() {
        this.rexw();
        this.emitByte(153);
    }

    public final void clflush(AMD64Address adr) {
        this.prefix(adr);
        this.emitByte(15);
        this.emitByte(174);
        this.emitOperandHelper(7, adr, 0);
    }

    public final void cmovl(ConditionFlag cc, Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void cmovl(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void cmovq(ConditionFlag cc, Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void cmovq(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void endbranch() {
        this.emitByte(243);
        this.emitByte(15);
        this.emitByte(30);
        this.emitByte(250);
    }

    public final void fcos() {
        this.emitByte(217);
        this.emitByte(255);
    }

    public final void ffree(int i) {
        this.emitFPUArith(221, 192, i);
    }

    public final void fincstp() {
        this.emitByte(217);
        this.emitByte(247);
    }

    public final void fldd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(0, src, 0);
    }

    public final void fldlg2() {
        this.emitByte(217);
        this.emitByte(236);
    }

    public final void fldln2() {
        this.emitByte(217);
        this.emitByte(237);
    }

    public final void flds(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(0, src, 0);
    }

    public final void fnstswAX() {
        this.emitByte(223);
        this.emitByte(224);
    }

    public final void fprem() {
        this.emitByte(217);
        this.emitByte(248);
    }

    public final void fptan() {
        this.emitByte(217);
        this.emitByte(242);
    }

    public final void fsin() {
        this.emitByte(217);
        this.emitByte(254);
    }

    public final void fstp(int i) {
        assert (0 <= i && i < 8) : "illegal stack offset";
        this.emitByte(221);
        this.emitByte(216 + i);
    }

    public final void fstpd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(3, src, 0);
    }

    public final void fstps(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(3, src, 0);
    }

    public final void fwait() {
        this.emitByte(155);
    }

    public final void fxch(int i) {
        this.emitFPUArith(217, 200, i);
    }

    private void emitFPUArith(int b1, int b2, int i) {
        assert (0 <= i && i < 8) : "illegal FPU register: " + i;
        this.emitByte(b1);
        this.emitByte(b2 + i);
    }

    public final void fyl2x() {
        this.emitByte(217);
        this.emitByte(241);
    }

    public final void hlt() {
        this.emitByte(244);
    }

    public final void illegal() {
        this.emitByte(15);
        this.emitByte(11);
    }

    public final void int3() {
        this.emitByte(204);
    }

    public final void lead(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leaq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leave() {
        this.emitByte(201);
    }

    public final void lfence() {
        this.emitByte(15);
        this.emitByte(174);
        this.emitByte(232);
    }

    public final void lock() {
        this.emitByte(240);
    }

    public final void membar(int barriers) {
        if (this.isTargetMP() && (barriers & 4) != 0) {
            this.lock();
            this.addl(new AMD64Address(AMD64.rsp, this.membarOffset()), 0);
        }
    }

    protected int membarOffset() {
        return 0;
    }

    public final void movl(Register dst, int imm32) {
        this.movl(dst, imm32, false);
    }

    public final void movl(Register dst, int imm32, boolean annotateImm) {
        int insnPos = this.position();
        this.prefix(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitInt(imm32);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movlhps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(22);
        this.emitModRM(dst, src);
    }

    public final void movlpd(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(18);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movq(Register dst, AMD64Address src) {
        this.movq(dst, src, false);
    }

    public final void movq(Register dst, AMD64Address src, boolean force4BytesDisplacement) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst)) {
            this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
            this.emitByte(126);
            this.emitOperandHelper(dst, src, force4BytesDisplacement, 0);
        } else {
            AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src, force4BytesDisplacement);
        }
    }

    public final void movq(Register dst, long imm64) {
        this.movq(dst, imm64, false);
    }

    public final void movq(Register dst, long imm64, boolean annotateImm) {
        int insnPos = this.position();
        this.prefixq(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitLong(imm64);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movq(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) {
            this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
            this.emitByte(126);
            this.emitModRM(dst, src);
        } else {
            AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        }
    }

    public final void movq(AMD64Address dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, src)) {
            this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
            this.emitByte(214);
            this.emitOperandHelper(src, dst, 0);
        } else {
            AMD64MROp.MOV.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        }
    }

    public final void nop() {
        this.nop(1);
    }

    public final void nop(int count) {
        this.intelNops(count);
    }

    public final void pause() {
        this.emitByte(243);
        this.emitByte(144);
    }

    public final void pextrw(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(197);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pmovmskb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src)) : String.valueOf(dst) + " " + String.valueOf(src);
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(215);
        this.emitModRM(dst, src);
    }

    public final void pop(Register dst) {
        this.prefix(dst);
        this.emitByte(88 + AMD64Assembler.encode(dst));
    }

    public final void prefetchnta(AMD64Address src) {
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(0, src, 0);
    }

    private void prefetchPrefix(AMD64Address src) {
        this.prefix(src);
        this.emitByte(15);
    }

    public final void prefetcht0(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(1, src, 0);
    }

    public final void prefetcht1(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(2, src, 0);
    }

    public final void prefetcht2(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(24);
        this.emitOperandHelper(3, src, 0);
    }

    public final void prefetchw(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AMD_3DNOW_PREFETCH));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(13);
        this.emitOperandHelper(1, src, 0);
    }

    public final void push(int imm32) {
        this.emitByte(104);
        this.emitInt(imm32);
    }

    public final void push(Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, src));
        this.prefix(src);
        this.emitByte(80 + AMD64Assembler.encode(src));
    }

    public final void pushfq() {
        this.emitByte(156);
    }

    public final void rdpid(Register dst) {
        assert (this.supports(AMD64.CPUFeature.RDPID));
        this.emitByte(243);
        this.prefix(dst);
        this.emitByte(15);
        this.emitByte(199);
        this.emitModRM(7, dst);
    }

    public final void rdpkru() {
        this.emitByte(15);
        this.emitByte(1);
        this.emitByte(238);
    }

    public final void rdtsc() {
        this.emitByte(15);
        this.emitByte(49);
    }

    public final void rdtscp() {
        this.emitByte(15);
        this.emitByte(1);
        this.emitByte(249);
    }

    public final void repStosb() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(170);
    }

    public final void repStosq() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(171);
    }

    public final void setb(ConditionFlag cc, Register dst) {
        this.prefix(dst, true);
        this.emitByte(15);
        this.emitByte(0x90 | cc.getValue());
        this.emitModRM(0, dst);
    }

    public final void sfence() {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        this.emitByte(15);
        this.emitByte(174);
        this.emitByte(248);
    }

    public final void testl(Register dst, int imm32) {
        if (dst.encoding == 0) {
            this.emitByte(169);
            this.emitInt(imm32);
        } else {
            AMD64MIOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
        }
    }

    public final void vzeroupper() {
        this.emitVEX(0, 0, 1, 0, 0, 0);
        this.emitByte(119);
    }

    public final void wrpkru() {
        this.emitByte(15);
        this.emitByte(1);
        this.emitByte(239);
    }

    public final void nullCheck(AMD64Address address) {
        this.testl(AMD64.rax, address);
    }

    public final void adcl(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADC.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void adcq(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADC.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void adcxq(Register dst, Register src) {
        AMD64RMOp.ADCX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void addl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void addpd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addpd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addq(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addq(AMD64Address dst, Register src) {
        AMD64BinaryArithmetic.ADD.mrOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addsd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void addsd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void adoxq(Register dst, Register src) {
        AMD64RMOp.ADOX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void aesdec(Register dst, Register src) {
        SSEOp.AESDEC.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void aesdeclast(Register dst, Register src) {
        SSEOp.AESDECLAST.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void aesenc(Register dst, Register src) {
        SSEOp.AESENC.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void aesenclast(Register dst, Register src) {
        SSEOp.AESENCLAST.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andl(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void andl(Register dst, Register src) {
        AMD64BinaryArithmetic.AND.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void andnpd(Register dst, Register src) {
        SSEOp.ANDN.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andpd(Register dst, Register src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andpd(Register dst, AMD64Address src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andq(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void andq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void andq(Register dst, Register src) {
        AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void bsfq(Register dst, Register src) {
        AMD64RMOp.BSF.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void bsrl(Register dst, Register src) {
        AMD64RMOp.BSR.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void bsrq(Register dst, Register src) {
        AMD64RMOp.BSR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void btq(Register src, int imm8) {
        AMD64MIOp.BT.emit(this, AMD64BaseAssembler.OperandSize.QWORD, src, imm8);
    }

    public final void btrq(Register src, int imm8) {
        AMD64MIOp.BTR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, src, imm8);
    }

    public final void cmpb(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.byteRmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void cmpb(AMD64Address dst, int imm) {
        AMD64BinaryArithmetic.CMP.byteImmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, imm);
    }

    public final void cmpl(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpl(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpq(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void cmpq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void cmpq(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpw(AMD64Address dst, int imm16) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.WORD, NumUtil.isByte(imm16)).emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, imm16);
    }

    public final void cmpw(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void cmpwImm16(AMD64Address dst, int imm16) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.WORD, false).emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, imm16);
    }

    public final void cmpxchgb(Register reg, AMD64Address adr) {
        AMD64MROp.CMPXCHGB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, adr, reg);
    }

    public final void cmpxchgl(Register reg, AMD64Address adr) {
        AMD64MROp.CMPXCHG.emit(this, AMD64BaseAssembler.OperandSize.DWORD, adr, reg);
    }

    public final void cmpxchgq(Register reg, AMD64Address adr) {
        AMD64RMOp.CMPXCHG.emit(this, AMD64BaseAssembler.OperandSize.QWORD, reg, adr);
    }

    public final void cmpxchgw(Register reg, AMD64Address adr) {
        AMD64MROp.CMPXCHG.emit(this, AMD64BaseAssembler.OperandSize.WORD, adr, reg);
    }

    public final void cvtdq2pd(Register dst, Register src) {
        SSEOp.CVTDQ2PD.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void cvtsd2siq(Register dst, Register src) {
        SSEOp.CVTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvtsi2sdl(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cvtsi2sdq(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttpd2dq(Register dst, Register src) {
        SSEOp.CVTTPD2DQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void cvttsd2sil(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cvttsd2siq(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttss2sil(Register dst, Register src) {
        SSEOp.CVTTSS2SI.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void decl(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void decl(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void decq(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void decq(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void divsd(Register dst, Register src) {
        SSEOp.DIV.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void gf2p8affineqb(Register dst, Register src, int imm8) {
        if (this.supports(AMD64.CPUFeature.AVX)) {
            VexRVMIOp.VGF2P8AFFINEQB.emit(this, AVXKind.AVXSize.XMM, dst, dst, src, imm8);
        } else {
            SSERMIOp.GF2P8AFFINEQB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
        }
    }

    public final void imull(Register dst, Register src, int value) {
        if (NumUtil.isByte(value)) {
            AMD64RMIOp.IMUL_SX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        } else {
            AMD64RMIOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        }
    }

    public final void imull(Register dst, Register src) {
        AMD64RMOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void imulq(Register dst, Register src) {
        AMD64RMOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void incl(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void incl(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void incq(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void incq(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void movapd(Register dst, Register src) {
        SSEOp.MOVAPD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void movaps(Register dst, Register src) {
        SSEOp.MOVAPS.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void movb(Register dst, AMD64Address src) {
        AMD64RMOp.MOVB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void movb(AMD64Address dst, int imm8) {
        AMD64MIOp.MOVB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, imm8);
    }

    public final void movb(AMD64Address dst, Register src) {
        AMD64MROp.MOVB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void movddup(Register dst, Register src) {
        SSEOp.MOVDDUP.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movdl(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            SSEOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            SSEMROp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdl(Register dst, AMD64Address src) {
        SSEOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movdq(Register dst, AMD64Address src) {
        SSEOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(AMD64Address dst, Register src) {
        SSEMROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            SSEOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            SSEMROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdqa(Register dst, Register src) {
        SSEOp.MOVDQA.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void movdqu(Register dst, AMD64Address src) {
        SSEOp.MOVDQU.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movdqu(Register dst, Register src) {
        SSEOp.MOVDQU.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movdqu(AMD64Address dst, Register src) {
        SSEMROp.MOVDQU.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movl(Register dst, Register src) {
        AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movl(Register dst, AMD64Address src) {
        AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movl(Register dst, AMD64Address src, boolean wide) {
        AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, wide);
    }

    public final void movl(AMD64Address dst, int imm32) {
        AMD64MIOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void movl(AMD64Address dst, Register src) {
        AMD64MROp.MOV.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movsbl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movsbl(Register dst, Register src) {
        AMD64RMOp.MOVSXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movsbq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movsbq(Register dst, Register src) {
        AMD64RMOp.MOVSXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movsd(Register dst, Register src) {
        SSEOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(Register dst, AMD64Address src) {
        SSEOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(AMD64Address dst, Register src) {
        SSEMROp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movslq(Register dst, int imm32) {
        AMD64MIOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void movslq(AMD64Address dst, int imm32) {
        AMD64MIOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void movslq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSXD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movslq(Register dst, Register src) {
        AMD64RMOp.MOVSXD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movss(Register dst, Register src) {
        SSEOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(Register dst, AMD64Address src) {
        SSEOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(AMD64Address dst, Register src) {
        SSEMROp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movswl(Register dst, Register src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movswl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movswq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movw(AMD64Address dst, int imm16) {
        AMD64MIOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, imm16);
    }

    public final void movw(AMD64Address dst, Register src) {
        AMD64MROp.MOV.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void movw(Register dst, AMD64Address src) {
        AMD64RMOp.MOV.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void movzbl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzbl(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzbq(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzbq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzwl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzwq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void mull(Register src) {
        AMD64MOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, src);
    }

    public final void mulpd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulpd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulq(Register src) {
        AMD64MOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, src);
    }

    public final void mulsd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulsd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulss(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void mulxq(Register dst1, Register dst2, Register src) {
        VexGeneralPurposeRVMOp.MULX.emit(this, AVXKind.AVXSize.QWORD, dst1, dst2, src);
    }

    public final void negl(Register dst) {
        AMD64MOp.NEG.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void negq(Register dst) {
        AMD64MOp.NEG.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void notl(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void notq(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void orl(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(AMD64Address dst, Register src) {
        AMD64BinaryArithmetic.OR.mrOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void orq(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void orq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void orq(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void orqImm32(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, false).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void packusdw(Register dst, Register src) {
        SSEOp.PACKUSDW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void packuswb(Register dst, Register src) {
        SSEOp.PACKUSWB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void paddd(Register dst, Register src) {
        SSEOp.PADDD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void paddd(Register dst, AMD64Address src) {
        SSEOp.PADDD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void paddq(Register dst, Register src) {
        SSEOp.PADDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void palignr(Register dst, Register src, int imm8) {
        SSERMIOp.PALIGNR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pand(Register dst, Register src) {
        SSEOp.PAND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pand(Register dst, AMD64Address src) {
        SSEOp.PAND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pandn(Register dst, Register src) {
        SSEOp.PANDN.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pblendw(Register dst, Register src, int imm8) {
        SSERMIOp.PBLENDW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pclmulqdq(Register dst, Register src, int imm8) {
        SSERMIOp.PCLMULQDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pcmpeqb(Register dst, Register src) {
        SSEOp.PCMPEQB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpeqb(Register dst, AMD64Address src) {
        SSEOp.PCMPEQB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpeqd(Register dst, Register src) {
        SSEOp.PCMPEQD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpeqd(Register dst, AMD64Address src) {
        SSEOp.PCMPEQD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpeqw(Register dst, Register src) {
        SSEOp.PCMPEQW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpeqw(Register dst, AMD64Address src) {
        SSEOp.PCMPEQW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpestri(Register dst, AMD64Address src, int imm8) {
        SSERMIOp.PCMPESTRI.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pcmpestri(Register dst, Register src, int imm8) {
        SSERMIOp.PCMPESTRI.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pcmpgtb(Register dst, Register src) {
        SSEOp.PCMPGTB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pcmpgtd(Register dst, Register src) {
        SSEOp.PCMPGTD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pextrb(AMD64Address dst, Register src, int imm8) {
        SSEMRIOp.PEXTRB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pextrd(AMD64Address dst, Register src, int imm8) {
        SSEMRIOp.PEXTRD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pextrq(Register dst, Register src, int imm8) {
        SSEMRIOp.PEXTRQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pextrq(AMD64Address dst, Register src, int imm8) {
        SSEMRIOp.PEXTRQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pextrw(AMD64Address dst, Register src, int imm8) {
        SSEMRIOp.PEXTRW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrb(Register dst, AMD64Address src, int imm8) {
        SSERMIOp.PINSRB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrd(Register dst, AMD64Address src, int imm8) {
        SSERMIOp.PINSRD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrq(Register dst, Register src, int imm8) {
        SSERMIOp.PINSRQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrq(Register dst, AMD64Address src, int imm8) {
        SSERMIOp.PINSRQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrw(Register dst, Register src, int imm8) {
        SSERMIOp.PINSRW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pinsrw(Register dst, AMD64Address src, int imm8) {
        SSERMIOp.PINSRW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pminub(Register dst, Register src) {
        SSEOp.PMINUB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pminud(Register dst, Register src) {
        SSEOp.PMINUD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pminuw(Register dst, Register src) {
        SSEOp.PMINUW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbd(Register dst, AMD64Address src) {
        SSEOp.PMOVSXBD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbd(Register dst, Register src) {
        SSEOp.PMOVSXBD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbq(Register dst, AMD64Address src) {
        SSEOp.PMOVSXBQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbq(Register dst, Register src) {
        SSEOp.PMOVSXBQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbw(Register dst, AMD64Address src) {
        SSEOp.PMOVSXBW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxbw(Register dst, Register src) {
        SSEOp.PMOVSXBW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxdq(Register dst, AMD64Address src) {
        SSEOp.PMOVSXDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxdq(Register dst, Register src) {
        SSEOp.PMOVSXDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxwd(Register dst, AMD64Address src) {
        SSEOp.PMOVSXWD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxwd(Register dst, Register src) {
        SSEOp.PMOVSXWD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxwq(Register dst, AMD64Address src) {
        SSEOp.PMOVSXWQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovsxwq(Register dst, Register src) {
        SSEOp.PMOVSXWQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbd(Register dst, AMD64Address src) {
        SSEOp.PMOVZXBD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbd(Register dst, Register src) {
        SSEOp.PMOVZXBD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbq(Register dst, AMD64Address src) {
        SSEOp.PMOVZXBQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbq(Register dst, Register src) {
        SSEOp.PMOVZXBQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbw(Register dst, AMD64Address src) {
        SSEOp.PMOVZXBW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxbw(Register dst, Register src) {
        SSEOp.PMOVZXBW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxdq(Register dst, AMD64Address src) {
        SSEOp.PMOVZXDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxdq(Register dst, Register src) {
        SSEOp.PMOVZXDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxwd(Register dst, AMD64Address src) {
        SSEOp.PMOVZXWD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxwd(Register dst, Register src) {
        SSEOp.PMOVZXWD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxwq(Register dst, AMD64Address src) {
        SSEOp.PMOVZXWQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pmovzxwq(Register dst, Register src) {
        SSEOp.PMOVZXWQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void popcntl(Register dst, Register src) {
        AMD64RMOp.POPCNT.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void por(Register dst, Register src) {
        SSEOp.POR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pshufb(Register dst, Register src) {
        SSEOp.PSHUFB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pshufb(Register dst, AMD64Address src) {
        SSEOp.PSHUFB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pshufd(Register dst, Register src, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERMIOp.PSHUFD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src, imm8);
    }

    public final void pshuflw(Register dst, Register src, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERMIOp.PSHUFLW.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src, imm8);
    }

    public final void pslld(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSLLD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void pslldq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSLLDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psllq(Register dst, Register shift) {
        SSEOp.PSLLQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, shift);
    }

    public final void psllq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSLLQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psllw(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSLLW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psrad(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSRAD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psrld(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSRLD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psrldq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSRLDQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psrlq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSRLQ.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psrlw(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isUByte(imm8), "invalid value");
        SSERIOp.PSRLW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, imm8);
    }

    public final void psubd(Register dst, Register src) {
        SSEOp.PSUBD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusb(Register dst, Register src) {
        SSEOp.PSUBUSB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusb(Register dst, AMD64Address src) {
        SSEOp.PSUBUSB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusw(Register dst, Register src) {
        SSEOp.PSUBUSW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void psubusw(Register dst, AMD64Address src) {
        SSEOp.PSUBUSW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void ptest(Register dst, Register src) {
        SSEOp.PTEST.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void ptest(Register dst, AMD64Address src) {
        SSEOp.PTEST.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void punpcklbw(Register dst, Register src) {
        SSEOp.PUNPCKLBW.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void pxor(Register dst, Register src) {
        SSEOp.PXOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void rclq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.RCL.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void rcpps(Register dst, Register src) {
        SSEOp.RCPPS.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void rcrq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.RCR.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void roll(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.ROL.miOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, (int)((byte)imm8));
    }

    public final void rorq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isByte(imm8), "only byte immediate is supported");
        AMD64Shift.ROR.miOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, (int)((byte)imm8));
    }

    public final void rorxl(Register dst, Register src, int imm8) {
        VexRMIOp.RORXL.emit(this, AVXKind.AVXSize.XMM, dst, src, (int)((byte)imm8));
    }

    public final void rorxq(Register dst, Register src, int imm8) {
        VexRMIOp.RORXQ.emit(this, AVXKind.AVXSize.XMM, dst, src, (int)((byte)imm8));
    }

    public final void sarl(Register dst) {
        AMD64MOp.SAR.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void sarl(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        if (imm8 == 1) {
            AMD64MOp.SAR1.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
        } else {
            AMD64MIOp.SAR.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm8);
        }
    }

    public final void sarq(Register dst) {
        AMD64MOp.SAR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void sarq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        if (imm8 == 1) {
            AMD64MOp.SAR1.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
        } else {
            AMD64MIOp.SAR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm8);
        }
    }

    public final void sbbq(Register dst, Register src) {
        AMD64BinaryArithmetic.SBB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void sha1msg1(Register dst, Register src) {
        AMD64RMOp.SHA1MSG1.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1msg2(Register dst, Register src) {
        AMD64RMOp.SHA1MSG2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1nexte(Register dst, Register src) {
        AMD64RMOp.SHA1NEXTE.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha1rnds4(Register dst, Register src, int imm8) {
        AMD64RMIOp.SHA1RNDS4.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src, imm8);
    }

    public final void sha256msg1(Register dst, Register src) {
        AMD64RMOp.SHA256MSG1.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha256msg2(Register dst, Register src) {
        AMD64RMOp.SHA256MSG2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void sha256rnds2(Register dst, Register src) {
        AMD64RMOp.SHA256RNDS2.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void shll(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        if (imm8 == 1) {
            AMD64MOp.SHL1.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
        } else {
            AMD64MIOp.SHL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm8);
        }
    }

    public final void shll(Register dst) {
        AMD64MOp.SHL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void shlq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        if (imm8 == 1) {
            AMD64MOp.SHL1.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
        } else {
            AMD64MIOp.SHL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm8);
        }
    }

    public final void shlq(Register dst) {
        AMD64MOp.SHL.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void shlxl(Register dst, Register src1, Register src2) {
        VexGeneralPurposeRMVOp.SHLX.emit(this, AVXKind.AVXSize.DWORD, dst, src1, src2);
    }

    public final void shrl(Register dst) {
        AMD64MOp.SHR.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void shrl(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        AMD64MIOp.SHR.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm8);
    }

    public final void shrq(Register dst, int imm8) {
        GraalError.guarantee(NumUtil.isShiftCount(imm8 >> 1), "illegal shift count");
        if (imm8 == 1) {
            AMD64MOp.SHR1.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
        } else {
            AMD64MIOp.SHR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm8);
        }
    }

    public final void shrq(Register dst) {
        AMD64MOp.SHR.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void sqrtsd(Register dst, Register src) {
        SSEOp.SQRT.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void subl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void subpd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void subq(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void subqWide(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, false).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subsd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void subsd(Register dst, AMD64Address src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void testl(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void testl(Register dst, AMD64Address src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void testl(AMD64Address dst, int imm32) {
        AMD64MIOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void testq(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void testq(Register dst, AMD64Address src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void ucomisd(Register dst, Register src) {
        SSEOp.UCOMIS.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void ucomiss(Register dst, Register src) {
        SSEOp.UCOMIS.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void unpckhpd(Register dst, Register src) {
        SSEOp.UNPCKHPD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void unpcklpd(Register dst, Register src) {
        SSEOp.UNPCKLPD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void vcvtph2ps(Register dst, Register src) {
        VexRMOp.VCVTPH2PS.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void vcvtps2ph(Register dst, Register src, int imm8) {
        VexMRIOp.VCVTPS2PH.emit(this, AVXKind.AVXSize.XMM, dst, src, imm8);
    }

    public final void vmovdqu(Register dst, AMD64Address src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(Register dst, Register src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(AMD64Address dst, Register src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu64(Register dst, AMD64Address src) {
        VexMoveOp.VMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void vmovdqu64(AMD64Address dst, Register src) {
        VexMoveOp.VMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void vpaddd(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDD.emit(this, size, dst, nds, src);
    }

    public final void vpaddd(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDD.emit(this, size, dst, nds, src);
    }

    public final void vpaddq(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDQ.emit(this, size, dst, nds, src);
    }

    public final void vpaddq(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPADDQ.emit(this, size, dst, nds, src);
    }

    public final void vpalignr(Register dst, Register nds, Register src, int imm8, AVXKind.AVXSize size) {
        VexRVMIOp.VPALIGNR.emit(this, size, dst, nds, src, imm8);
    }

    public final void vpand(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPAND.emit(this, size, dst, nds, src);
    }

    public final void vpandn(Register dst, Register nds, Register src) {
        VexRVMOp.VPANDN.emit(this, AVXKind.AVXSize.YMM, dst, nds, src);
    }

    public final void vpblendd(Register dst, Register nds, Register src, int imm8, AVXKind.AVXSize size) {
        VexRVMIOp.VPBLENDD.emit(this, size, dst, nds, src, imm8);
    }

    public final void vpclmulhqhqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 17);
    }

    public final void vpclmulhqlqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 1);
    }

    public final void vpclmullqhqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 16);
    }

    public final void vpclmullqlqdq(Register dst, Register nds, Register src) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, 0);
    }

    public final void vpclmulqdq(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPCLMULQDQ.emit(this, AVXKind.AVXSize.XMM, dst, nds, src, imm8);
    }

    public final void vpcmpeqb(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQB.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vpcmpeqd(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQD.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vpcmpeqw(Register dst, Register src1, Register src2) {
        VexRVMOp.VPCMPEQW.emit(this, AVXKind.AVXSize.YMM, dst, src1, src2);
    }

    public final void vperm2f128(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPERM2F128.emit(this, AVXKind.AVXSize.YMM, dst, nds, src, imm8);
    }

    public final void vperm2i128(Register dst, Register nds, Register src, int imm8) {
        VexRVMIOp.VPERM2I128.emit(this, AVXKind.AVXSize.YMM, dst, nds, src, imm8);
    }

    public final void vpmovmskb(Register dst, Register src) {
        VexRMOp.VPMOVMSKB.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vpmovzxbw(Register dst, AMD64Address src) {
        VexRMOp.VPMOVZXBW.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vpor(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPOR.emit(this, size, dst, nds, src);
    }

    public final void vpshufb(Register dst, Register src1, Register src2, AVXKind.AVXSize size) {
        VexRVMOp.VPSHUFB.emit(this, size, dst, src1, src2);
    }

    public final void vpshufd(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexRMIOp.VPSHUFD.emit(this, size, dst, src, imm8);
    }

    public final void vpslld(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSLLD.emit(this, size, dst, src, imm8);
    }

    public final void vpslldq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftImmOp.VPSLLDQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsllq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSLLQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsllw(Register dst, Register src, int imm8) {
        VexShiftOp.VPSLLW.emit(this, AVXKind.AVXSize.YMM, dst, src, imm8);
    }

    public final void vpsrld(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSRLD.emit(this, size, dst, src, imm8);
    }

    public final void vpsrldq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftImmOp.VPSRLDQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsrlq(Register dst, Register src, int imm8, AVXKind.AVXSize size) {
        VexShiftOp.VPSRLQ.emit(this, size, dst, src, imm8);
    }

    public final void vpsrlw(Register dst, Register src, int imm8) {
        VexShiftOp.VPSRLW.emit(this, AVXKind.AVXSize.YMM, dst, src, imm8);
    }

    public final void vptest(Register dst, Register src, AVXKind.AVXSize size) {
        VexRMOp.VPTEST.emit(this, size, dst, src);
    }

    public final void vpxor(Register dst, Register nds, Register src, AVXKind.AVXSize size) {
        VexRVMOp.VPXOR.emit(this, size, dst, nds, src);
    }

    public final void vpxor(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size) {
        VexRVMOp.VPXOR.emit(this, size, dst, nds, src);
    }

    public final void xaddb(AMD64Address dst, Register src) {
        AMD64MROp.XADDB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void xaddl(AMD64Address dst, Register src) {
        AMD64MROp.XADD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void xaddq(AMD64Address dst, Register src) {
        AMD64MROp.XADD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void xaddw(AMD64Address dst, Register src) {
        AMD64MROp.XADD.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void xchgb(Register dst, AMD64Address src) {
        AMD64RMOp.XCHGB.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void xchgl(Register dst, AMD64Address src) {
        AMD64RMOp.XCHG.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void xchgq(Register dst, AMD64Address src) {
        AMD64RMOp.XCHG.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void xchgw(Register dst, AMD64Address src) {
        AMD64RMOp.XCHG.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void xorb(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.XOR.byteRmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void xorl(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void xorl(Register dst, int imm32) {
        AMD64BinaryArithmetic.XOR.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void xorpd(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void xorpd(Register dst, AMD64Address src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void xorps(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void xorps(Register dst, AMD64Address src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void xorq(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void kmovb(Register dst, Register src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovb(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovb(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVB.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(Register dst, Register src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovd(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVD.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(Register dst, Register src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovq(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVQ.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(Register dst, Register src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(AMD64Address dst, Register src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kmovw(Register dst, AMD64Address src) {
        VexMoveMaskOp.KMOVW.emit(this, AVXKind.AVXSize.XMM, dst, src);
    }

    public final void kortestd(Register src1, Register src2) {
        VexRROp.KORTESTD.emit(this, AVXKind.AVXSize.XMM, src1, src2);
    }

    public final void kortestq(Register src1, Register src2) {
        VexRROp.KORTESTQ.emit(this, AVXKind.AVXSize.XMM, src1, src2);
    }

    public final void kshiftrw(Register dst, Register src, int imm8) {
        VexMaskRRIOp.KSHIFTRW.emit(this, AVXKind.AVXSize.XMM, dst, src, imm8);
    }

    public final void ktestd(Register src1, Register src2) {
        VexRROp.KTESTD.emit(this, AVXKind.AVXSize.XMM, src1, src2);
    }

    public final void ktestq(Register src1, Register src2) {
        VexRROp.KTESTQ.emit(this, AVXKind.AVXSize.XMM, src1, src2);
    }

    public final void evmovdqu16(Register dst, AMD64Address src) {
        VexMoveOp.EVMOVDQU16.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evmovdqu16(Register dst, Register src) {
        VexMoveOp.EVMOVDQU16.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evmovdqu16(Register dst, Register mask, AMD64Address src) {
        VexMoveOp.EVMOVDQU16.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask, 1, 0);
    }

    public final void evmovdqu16(AMD64Address dst, Register src) {
        VexMoveOp.EVMOVDQU16.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evmovdqu16(AMD64Address dst, Register mask, Register src) {
        VexMoveOp.EVMOVDQU16.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask);
    }

    public final void evmovdqu64(Register dst, AMD64Address src) {
        VexMoveOp.EVMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evmovdqu64(Register dst, Register mask, AMD64Address src) {
        VexMoveOp.EVMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask, 1, 0);
    }

    public final void evmovdqu64(AMD64Address dst, Register src) {
        VexMoveOp.EVMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evmovdqu64(AMD64Address dst, Register mask, Register src) {
        VexMoveOp.EVMOVDQU64.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask);
    }

    public final void evpbroadcastw(Register dst, Register src) {
        VexRROp.EVPBROADCASTW_GPR.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evpcmpeqb(Register kdst, Register nds, AMD64Address src) {
        VexRVMOp.EVPCMPEQB.emit(this, AVXKind.AVXSize.ZMM, kdst, nds, src);
    }

    public final void evpcmpgtb(Register kdst, Register nds, AMD64Address src) {
        VexRVMOp.EVPCMPGTB.emit(this, AVXKind.AVXSize.ZMM, kdst, nds, src);
    }

    public final void evpcmpgtb(Register kdst, Register mask, Register nds, AMD64Address src) {
        VexRVMOp.EVPCMPGTB.emit(this, AVXKind.AVXSize.ZMM, kdst, nds, src, mask);
    }

    public final void evpcmpuw(Register kdst, Register nds, Register src, int vcc) {
        VexRVMIOp.EVPCMPUW.emit(this, AVXKind.AVXSize.ZMM, kdst, nds, src, vcc);
    }

    public final void evpcmpuw(Register kdst, Register mask, Register nds, Register src, int vcc) {
        VexRVMIOp.EVPCMPUW.emit(this, AVXKind.AVXSize.ZMM, kdst, nds, src, mask, vcc);
    }

    public final void evpermt2q(Register dst, Register src1, Register src2) {
        VexRVMOp.EVPERMT2Q.emit(this, AVXKind.AVXSize.ZMM, dst, src1, src2);
    }

    public final void evpmovwb(AMD64Address dst, Register src) {
        VexMROp.EVPMOVWB.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evpmovwb(AMD64Address dst, Register mask, Register src) {
        VexMROp.EVPMOVWB.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask, 0, 0);
    }

    public final void evpmovzxbw(Register dst, AMD64Address src) {
        VexMoveOp.EVPMOVZXBW.emit(this, AVXKind.AVXSize.ZMM, dst, src);
    }

    public final void evpmovzxbw(Register dst, Register mask, AMD64Address src) {
        VexMoveOp.EVPMOVZXBW.emit(this, AVXKind.AVXSize.ZMM, dst, src, mask, 0, 0);
    }

    public final void evprolq(Register dst, Register src, int imm8) {
        EvexRMIExtendOp.EVPROLQ.emit(this, AVXKind.AVXSize.ZMM, dst, src, imm8);
    }

    public final void evprolvq(Register dst, Register src1, Register src2) {
        VexRVMOp.EVPROLVQ.emit(this, AVXKind.AVXSize.ZMM, dst, src1, src2);
    }

    public final void evpternlogq(Register dst, int imm8, Register src1, Register src2) {
        VexRVMIOp.EVPTERNLOGQ.emit(this, AVXKind.AVXSize.ZMM, dst, src1, src2, imm8);
    }

    public final void evpxorq(Register dst, Register mask, Register nds, AMD64Address src) {
        VexRVMOp.EVPXOR.emit(this, AVXKind.AVXSize.ZMM, dst, nds, src, mask);
    }

    public static class Options {
        public static final OptionKey<Boolean> UseBranchesWithin32ByteBoundary = new OptionKey<Boolean>(false);
    }

    private static class UnionRegisterCategory
    extends Register.RegisterCategory {
        private final Register.RegisterCategory[] categories;

        UnionRegisterCategory(String name, Register.RegisterCategory ... categories) {
            super(name);
            this.categories = categories;
        }

        public boolean contains(Register r) {
            for (Register.RegisterCategory category : this.categories) {
                if (!r.getRegisterCategory().equals((Object)category)) continue;
                return true;
            }
            return false;
        }
    }

    public static class VexRMOp
    extends VexRROp {
        public static final VexRMOp VAESIMC = new VexRMOp("VAESIMC", 1, 2, 0, 219, VEXOpAssertion.AES_AVX1_128ONLY);
        public static final VexRMOp VCVTTSS2SI = new VexRMOp("VCVTTSS2SI", 2, 1, 0, 44, VEXOpAssertion.CPU_XMM_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_32BIT, 0);
        public static final VexRMOp VCVTTSS2SQ = new VexRMOp("VCVTTSS2SQ", 2, 1, 1, 44, VEXOpAssertion.CPU_XMM_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_32BIT, 1);
        public static final VexRMOp VCVTTSD2SI = new VexRMOp("VCVTTSD2SI", 3, 1, 0, 44, VEXOpAssertion.CPU_XMM_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_64BIT, 0);
        public static final VexRMOp VCVTTSD2SQ = new VexRMOp("VCVTTSD2SQ", 3, 1, 1, 44, VEXOpAssertion.CPU_XMM_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_64BIT, 1);
        public static final VexRMOp VCVTPS2PD = new VexRMOp("VCVTPS2PD", 0, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VCVTPD2PS = new VexRMOp("VCVTPD2PS", 1, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTDQ2PS = new VexRMOp("VCVTDQ2PS", 0, 1, 0, 91, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VCVTTPS2DQ = new VexRMOp("VCVTTPS2DQ", 2, 1, 0, 91, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VCVTTPD2DQ = new VexRMOp("VCVTTPD2DQ", 1, 1, 0, 230, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VCVTDQ2PD = new VexRMOp("VCVTDQ2PD", 2, 1, 0, 230, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VMOVDDUP = new VexRMOp("VMOVDDUP", 3, 1, 0, 18, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.DUP, 1);
        public static final VexRMOp VBROADCASTSS = new VexRMOp("VBROADCASTSS", 1, 2, 0, 24, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRMOp VBROADCASTSD = new VexRMOp("VBROADCASTSD", 1, 2, 0, 25, VEXOpAssertion.AVX1_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRMOp VBROADCASTF128 = new VexRMOp("VBROADCASTF128", 1, 2, 0, 26, VEXOpAssertion.AVX1_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRMOp VPBROADCASTI128 = new VexRMOp("VPBROADCASTI128", 1, 2, 0, 90, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRMOp VPBROADCASTB = new VexRMOp("VPBROADCASTB", 1, 2, 0, 120, VEXOpAssertion.AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.T1S_8BIT, 0);
        public static final VexRMOp VPBROADCASTW = new VexRMOp("VPBROADCASTW", 1, 2, 0, 121, VEXOpAssertion.AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.T1S_16BIT, 0);
        public static final VexRMOp VPBROADCASTD = new VexRMOp("VPBROADCASTD", 1, 2, 0, 88, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRMOp VPBROADCASTQ = new VexRMOp("VPBROADCASTQ", 1, 2, 0, 89, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRMOp VPMOVMSKB = new VexRMOp("VPMOVMSKB", 1, 1, 0, 215, VEXOpAssertion.AVX1_2_CPU_XMM);
        public static final VexRMOp VMOVMSKPD = new VexRMOp("VMOVMSKPD", 1, 1, 0, 80, VEXOpAssertion.AVX1_CPU_XMM);
        public static final VexRMOp VMOVMSKPS = new VexRMOp("VMOVMSKPS", 0, 1, 0, 80, VEXOpAssertion.AVX1_CPU_XMM);
        public static final VexRMOp VPMOVSXBW = new VexRMOp("VPMOVSXBW", 1, 2, 0, 32, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVSXBD = new VexRMOp("VPMOVSXBD", 1, 2, 0, 33, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVSXBQ = new VexRMOp("VPMOVSXBQ", 1, 2, 0, 34, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.OVM, 0);
        public static final VexRMOp VPMOVSXWD = new VexRMOp("VPMOVSXWD", 1, 2, 0, 35, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVSXWQ = new VexRMOp("VPMOVSXWQ", 1, 2, 0, 36, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVSXDQ = new VexRMOp("VPMOVSXDQ", 1, 2, 0, 37, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXBW = new VexRMOp("VPMOVZXBW", 1, 2, 0, 48, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXBD = new VexRMOp("VPMOVZXBD", 1, 2, 0, 49, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVZXBQ = new VexRMOp("VPMOVZXBQ", 1, 2, 0, 50, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.OVM, 0);
        public static final VexRMOp VPMOVZXWD = new VexRMOp("VPMOVZXWD", 1, 2, 0, 51, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPMOVZXWQ = new VexRMOp("VPMOVZXWQ", 1, 2, 0, 52, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0);
        public static final VexRMOp VPMOVZXDQ = new VexRMOp("VPMOVZXDQ", 1, 2, 0, 53, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp VPTEST = new VexRMOp("VPTEST", 1, 2, 0, 23, VEXOpAssertion.AVX1);
        public static final VexRMOp VSQRTPD = new VexRMOp("VSQRTPD", 1, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMOp VSQRTPS = new VexRMOp("VSQRTPS", 0, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VUCOMISS = new VexRMOp("VUCOMISS", 0, 1, 0, 46, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRMOp VUCOMISD = new VexRMOp("VUCOMISD", 1, 1, 0, 46, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRMOp VPABSB = new VexRMOp("VPABSB", 1, 2, 0, 28, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPABSW = new VexRMOp("VPABSW", 1, 2, 0, 29, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VPABSD = new VexRMOp("VPABSD", 1, 2, 0, 30, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMOp VCVTPH2PS = new VexRMOp("VCVTPH2PS", 1, 2, 0, 19, VEXOpAssertion.F16C_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexRMOp EVCVTTSS2SI = new VexRMOp("EVCVTTSS2SI", VCVTTSS2SI);
        public static final VexRMOp EVCVTTSS2SQ = new VexRMOp("EVCVTTSS2SQ", VCVTTSS2SQ);
        public static final VexRMOp EVCVTTSD2SI = new VexRMOp("EVCVTTSD2SI", VCVTTSD2SI);
        public static final VexRMOp EVCVTTSD2SQ = new VexRMOp("EVCVTTSD2SQ", VCVTTSD2SQ);
        public static final VexRMOp EVCVTPS2PD = new VexRMOp("EVCVTPS2PD", VCVTPS2PD);
        public static final VexRMOp EVCVTPD2PS = new VexRMOp("EVCVTPD2PS", VCVTPD2PS);
        public static final VexRMOp EVCVTDQ2PS = new VexRMOp("EVCVTDQ2PS", VCVTDQ2PS);
        public static final VexRMOp EVCVTQQ2PS = new VexRMOp("EVCVTQQ2PS", 0, 1, 1, 91, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVCVTQQ2PD = new VexRMOp("EVCVTQQ2PD", 2, 1, 1, 230, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVCVTTPS2DQ = new VexRMOp("EVCVTTPS2DQ", VCVTTPS2DQ);
        public static final VexRMOp EVCVTTPS2QQ = new VexRMOp("EVCVTTPS2QQ", 1, 1, 0, 122, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0, true);
        public static final VexRMOp EVCVTTPD2DQ = new VexRMOp("EVCVTTPD2DQ", VCVTTPD2DQ);
        public static final VexRMOp EVCVTTPD2QQ = new VexRMOp("EVCVTTPD2QQ", 1, 1, 1, 122, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVCVTDQ2PD = new VexRMOp("EVCVTDQ2PD", VCVTDQ2PD);
        public static final VexRMOp EVMOVDDUP = new VexRMOp("EVMOVDDUP", VMOVDDUP);
        public static final VexRMOp EVBROADCASTSS = new VexRMOp("EVBROADCASTSS", VBROADCASTSS);
        public static final VexRMOp EVBROADCASTSD = new VexRMOp("EVBROADCASTSD", VBROADCASTSD);
        public static final VexRMOp EVPBROADCASTB = new VexRMOp("EVPBROADCASTB", VPBROADCASTB);
        public static final VexRMOp EVPBROADCASTW = new VexRMOp("EVPBROADCASTW", VPBROADCASTW);
        public static final VexRMOp EVPBROADCASTD = new VexRMOp("EVPBROADCASTD", VPBROADCASTD);
        public static final VexRMOp EVPBROADCASTQ = new VexRMOp("EVPBROADCASTQ", VPBROADCASTQ);
        public static final VexRMOp EVPMOVB2M = new VexRMOp("EVPMOVB2M", 2, 2, 0, 41, VEXOpAssertion.MASK_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRMOp EVPMOVW2M = new VexRMOp("EVPMOVW2M", 2, 2, 1, 41, VEXOpAssertion.MASK_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVPMOVD2M = new VexRMOp("EVPMOVD2M", 2, 2, 0, 57, VEXOpAssertion.MASK_XMM_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRMOp EVPMOVQ2M = new VexRMOp("EVPMOVQ2M", 2, 2, 1, 57, VEXOpAssertion.MASK_XMM_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVPMOVSXBW = new VexRMOp("EVPMOVSXBW", VPMOVSXBW);
        public static final VexRMOp EVPMOVSXBD = new VexRMOp("EVPMOVSXBD", VPMOVSXBD);
        public static final VexRMOp EVPMOVSXBQ = new VexRMOp("EVPMOVSXBQ", VPMOVSXBQ);
        public static final VexRMOp EVPMOVSXWD = new VexRMOp("EVPMOVSXWD", VPMOVSXWD);
        public static final VexRMOp EVPMOVSXWQ = new VexRMOp("EVPMOVSXWQ", VPMOVSXWQ);
        public static final VexRMOp EVPMOVSXDQ = new VexRMOp("EVPMOVSXDQ", VPMOVSXDQ);
        public static final VexRMOp EVPMOVZXBW = new VexRMOp("EVPMOVZXBW", VPMOVZXBW);
        public static final VexRMOp EVPMOVZXBD = new VexRMOp("EVPMOVZXBD", VPMOVZXBD);
        public static final VexRMOp EVPMOVZXBQ = new VexRMOp("EVPMOVZXBQ", VPMOVZXBQ);
        public static final VexRMOp EVPMOVZXWD = new VexRMOp("EVPMOVZXWD", VPMOVZXWD);
        public static final VexRMOp EVPMOVZXWQ = new VexRMOp("EVPMOVZXWQ", VPMOVZXWQ);
        public static final VexRMOp EVPMOVZXDQ = new VexRMOp("EVPMOVZXDQ", VPMOVZXDQ);
        public static final VexRMOp EVSQRTPD = new VexRMOp("EVSQRTPD", VSQRTPD);
        public static final VexRMOp EVSQRTPS = new VexRMOp("EVSQRTPS", VSQRTPS);
        public static final VexRMOp EVUCOMISS = new VexRMOp("EVUCOMISS", VUCOMISS);
        public static final VexRMOp EVUCOMISD = new VexRMOp("EVUCOMISD", VUCOMISD);
        public static final VexRMOp EVPABSB = new VexRMOp("EVPABSB", VPABSB);
        public static final VexRMOp EVPABSW = new VexRMOp("EVPABSW", VPABSW);
        public static final VexRMOp EVPABSD = new VexRMOp("EVPABSD", VPABSD);
        public static final VexRMOp EVPABSQ = new VexRMOp("EVPABSQ", 1, 2, 0, 31, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRMOp EVCVTPH2PS = new VexRMOp("EVCVTPH2PS", VCVTPH2PS);

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        protected VexRMOp(String opcode, VexRMOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        protected VexRMOp(String opcode, VexRMOp vexOp, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, evexTuple, wEvex);
        }

        @Override
        public VexRMOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRMOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0, this.getDisp8Scale(this.isEvex, size));
        }
    }

    public static class VexRMIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexRMIOp VAESKEYGENASSIST = new VexRMIOp("VAESKEYGENASSIST", 1, 3, 0, 223, VEXOpAssertion.AES_AVX1_128ONLY);
        public static final VexRMIOp VPERMQ = new VexRMIOp("VPERMQ", 1, 3, 1, 0, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMIOp VPSHUFLW = new VexRMIOp("VPSHUFLW", 3, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPSHUFHW = new VexRMIOp("VPSHUFHW", 2, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPSHUFD = new VexRMIOp("VPSHUFD", 1, 1, 0, 112, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPERMILPD = new VexRMIOp("VPERMILPD", 1, 3, 0, 5, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMIOp VPERMILPS = new VexRMIOp("VPERMILPS", 1, 3, 0, 4, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRMIOp VPERMPD = new VexRMIOp("VPERMPD", 1, 3, 1, 1, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRMIOp RORXL = new VexRMIOp("RORXL", 3, 3, 0, 240, VEXOpAssertion.BMI2);
        public static final VexRMIOp RORXQ = new VexRMIOp("RORXQ", 3, 3, 1, 240, VEXOpAssertion.BMI2);
        public static final VexRMIOp EVPERMILPD = new VexRMIOp("EVPERMILPD", VPERMILPD);
        public static final VexRMIOp EVPERMILPS = new VexRMIOp("EVPERMILPS", VPERMILPS);
        public static final VexRMIOp EVPERMPD = new VexRMIOp("EVPERMPD", VPERMPD);
        public static final VexRMIOp EVPERMQ = new VexRMIOp("EVPERMQ", VPERMQ);
        public static final VexRMIOp EVPSHUFLW = new VexRMIOp("EVPSHUFLW", VPSHUFLW);
        public static final VexRMIOp EVPSHUFHW = new VexRMIOp("EVPSHUFHW", VPSHUFHW);
        public static final VexRMIOp EVPSHUFD = new VexRMIOp("EVPSHUFD", VPSHUFD);

        protected VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        protected VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        protected VexRMIOp(String opcode, VexRMIOp vexOp) {
            this(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexRMIOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRMIOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 1, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexMRIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexMRIOp VPEXTRB = new VexMRIOp("VPEXTRB", 1, 3, 0, 20, VEXOpAssertion.XMM_CPU_AVX1_AVX512BW_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_8BIT, 0);
        public static final VexMRIOp VPEXTRW = new VexMRIOp("VPEXTRW", 1, 3, 0, 21, VEXOpAssertion.XMM_CPU_AVX1_AVX512BW_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_16BIT, 0);
        public static final VexMRIOp VPEXTRD = new VexMRIOp("VPEXTRD", 1, 3, 0, 22, VEXOpAssertion.XMM_CPU_AVX1_AVX512DQ_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMRIOp VPEXTRQ = new VexMRIOp("VPEXTRQ", 1, 3, 1, 22, VEXOpAssertion.XMM_CPU_AVX1_AVX512DQ_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexMRIOp VEXTRACTF128 = new VexMRIOp("VEXTRACTF128", 1, 3, 0, 25, VEXOpAssertion.AVX1_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexMRIOp VEXTRACTI128 = new VexMRIOp("VEXTRACTI128", 1, 3, 0, 57, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexMRIOp EVPEXTRB = new VexMRIOp("EVPEXTRB", VPEXTRB);
        public static final VexMRIOp EVPEXTRW = new VexMRIOp("EVPEXTRW", VPEXTRW);
        public static final VexMRIOp EVPEXTRD = new VexMRIOp("EVPEXTRD", VPEXTRD);
        public static final VexMRIOp EVPEXTRQ = new VexMRIOp("EVPEXTRQ", VPEXTRQ);
        public static final VexMRIOp EVEXTRACTF32X4 = new VexMRIOp("EVEXTRACTF32X4", VEXTRACTF128);
        public static final VexMRIOp EVEXTRACTI32X4 = new VexMRIOp("EVEXTRACTI32X4", VEXTRACTI128);
        public static final VexMRIOp EVEXTRACTF64X2 = new VexMRIOp("EVEXTRACTF64X2", 1, 3, 1, 25, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1, true);
        public static final VexMRIOp EVEXTRACTI64X2 = new VexMRIOp("EVEXTRACTI64X2", 1, 3, 1, 57, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1, true);
        public static final VexMRIOp EVEXTRACTF32X8 = new VexMRIOp("EVEXTRACTF32X8", 1, 3, 0, 27, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0, true);
        public static final VexMRIOp EVEXTRACTI32X8 = new VexMRIOp("EVEXTRACTI32X8", 1, 3, 0, 59, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0, true);
        public static final VexMRIOp EVEXTRACTF64X4 = new VexMRIOp("EVEXTRACTF64X2", 1, 3, 1, 27, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1, true);
        public static final VexMRIOp EVEXTRACTI64X4 = new VexMRIOp("EVEXTRACTI64X2", 1, 3, 1, 59, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1, true);
        public static final VexMRIOp VCVTPS2PH = new VexMRIOp("VCVTPS2PH", 1, 3, 0, 29, VEXOpAssertion.F16C_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0);
        public static final VexMRIOp EVCVTPS2PH = new VexMRIOp("EVCVTPS2PH", VCVTPS2PH);

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexMRIOp(String opcode, VexMRIOp vexOp) {
            this(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            this(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, false);
        }

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        @Override
        public VexMRIOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexMRIOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static class VexRVMOp
    extends VexOp {
        public static final VexRVMOp VANDPS = new VexRVMOp("VANDPS", 0, 1, 0, 84, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VANDPD = new VexRVMOp("VANDPD", 1, 1, 0, 84, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VANDNPS = new VexRVMOp("VANDNPS", 0, 1, 0, 85, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VANDNPD = new VexRVMOp("VANDNPD", 1, 1, 0, 85, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VORPS = new VexRVMOp("VORPS", 0, 1, 0, 86, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VORPD = new VexRVMOp("VORPD", 1, 1, 0, 86, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VXORPS = new VexRVMOp("VXORPS", 0, 1, 0, 87, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VXORPD = new VexRVMOp("VXORPD", 1, 1, 0, 87, VEXOpAssertion.AVX1_AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VADDPS = new VexRVMOp("VADDPS", 0, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VADDPD = new VexRVMOp("VADDPD", 1, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VADDSS = new VexRVMOp("VADDSS", 2, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VADDSD = new VexRVMOp("VADDSD", 3, 1, 0, 88, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMULPS = new VexRVMOp("VMULPS", 0, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMULPD = new VexRVMOp("VMULPD", 1, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMULSS = new VexRVMOp("VMULSS", 2, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMULSD = new VexRVMOp("VMULSD", 3, 1, 0, 89, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VSUBPS = new VexRVMOp("VSUBPS", 0, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VSUBPD = new VexRVMOp("VSUBPD", 1, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VSUBSS = new VexRVMOp("VSUBSS", 2, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VSUBSD = new VexRVMOp("VSUBSD", 3, 1, 0, 92, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMINPS = new VexRVMOp("VMINPS", 0, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMINPD = new VexRVMOp("VMINPD", 1, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMINSS = new VexRVMOp("VMINSS", 2, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMINSD = new VexRVMOp("VMINSD", 3, 1, 0, 93, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VDIVPS = new VexRVMOp("VDIVPS", 0, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VDIVPD = new VexRVMOp("VDIVPD", 1, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VDIVSS = new VexRVMOp("VDIVSS", 2, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VDIVSD = new VexRVMOp("VDIVSD", 3, 1, 0, 94, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMAXPS = new VexRVMOp("VMAXPS", 0, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMAXPD = new VexRVMOp("VMAXPD", 1, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VMAXSS = new VexRVMOp("VMAXSS", 2, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMAXSD = new VexRVMOp("VMAXSD", 3, 1, 0, 95, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VPACKUSDW = new VexRVMOp("VPACKUSDW", 1, 2, 0, 43, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPACKUSWB = new VexRVMOp("VPACKUSWB", 1, 1, 0, 103, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPACKSSWB = new VexRVMOp("VPACKSSWB", 1, 1, 0, 99, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VADDSUBPS = new VexRVMOp("VADDSUBPS", 3, 1, 0, 208, VEXOpAssertion.AVX1);
        public static final VexRVMOp VADDSUBPD = new VexRVMOp("VADDSUBPD", 1, 1, 0, 208, VEXOpAssertion.AVX1);
        public static final VexRVMOp VPAND = new VexRVMOp("VPAND", 1, 1, 0, 219, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPANDN = new VexRVMOp("VPANDN", 1, 1, 0, 223, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPOR = new VexRVMOp("VPOR", 1, 1, 0, 235, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPXOR = new VexRVMOp("VPXOR", 1, 1, 0, 239, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPADDB = new VexRVMOp("VPADDB", 1, 1, 0, 252, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDW = new VexRVMOp("VPADDW", 1, 1, 0, 253, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDD = new VexRVMOp("VPADDD", 1, 1, 0, 254, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPADDQ = new VexRVMOp("VPADDQ", 1, 1, 0, 212, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPMAXSB = new VexRVMOp("VPMAXSB", 1, 2, 0, 60, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXSW = new VexRVMOp("VPMAXSW", 1, 1, 0, 238, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXSD = new VexRVMOp("VPMAXSD", 1, 2, 0, 61, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUB = new VexRVMOp("VPMAXUB", 1, 1, 0, 222, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUW = new VexRVMOp("VPMAXUW", 1, 2, 0, 62, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMAXUD = new VexRVMOp("VPMAXUD", 1, 2, 0, 63, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSB = new VexRVMOp("VPMINSB", 1, 2, 0, 56, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSW = new VexRVMOp("VPMINSW", 1, 1, 0, 234, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINSD = new VexRVMOp("VPMINSD", 1, 2, 0, 57, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUB = new VexRVMOp("VPMINUB", 1, 1, 0, 218, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUW = new VexRVMOp("VPMINUW", 1, 2, 0, 58, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMINUD = new VexRVMOp("VPMINUD", 1, 2, 0, 59, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULHUW = new VexRVMOp("VPMULHUW", 1, 1, 0, 228, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULHW = new VexRVMOp("VPMULHW", 1, 1, 0, 229, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULLW = new VexRVMOp("VPMULLW", 1, 1, 0, 213, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPMULLD = new VexRVMOp("VPMULLD", 1, 2, 0, 64, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBUSB = new VexRVMOp("VPSUBUSB", 1, 1, 0, 216, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBUSW = new VexRVMOp("VPSUBUSW", 1, 1, 0, 217, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBB = new VexRVMOp("VPSUBB", 1, 1, 0, 248, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBW = new VexRVMOp("VPSUBW", 1, 1, 0, 249, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBD = new VexRVMOp("VPSUBD", 1, 1, 0, 250, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSUBQ = new VexRVMOp("VPSUBQ", 1, 1, 0, 251, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPSLLVD = new VexRVMOp("VPSLLVD", 1, 2, 0, 71, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSLLVQ = new VexRVMOp("VPSLLVQ", 1, 2, 1, 71, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPSRLVD = new VexRVMOp("VPSRLVD", 1, 2, 0, 69, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSRLVQ = new VexRVMOp("VPSRLVQ", 1, 2, 1, 69, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VPSRAVD = new VexRVMOp("VPSRAVD", 1, 2, 0, 70, VEXOpAssertion.AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPSHUFB = new VexRVMOp("VPSHUFB", 1, 2, 0, 0, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPCMPEQB = new VexRVMOp("VPCMPEQB", 1, 1, 0, 116, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQW = new VexRVMOp("VPCMPEQW", 1, 1, 0, 117, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQD = new VexRVMOp("VPCMPEQD", 1, 1, 0, 118, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQQ = new VexRVMOp("VPCMPEQQ", 1, 2, 0, 41, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTB = new VexRVMOp("VPCMPGTB", 1, 1, 0, 100, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTW = new VexRVMOp("VPCMPGTW", 1, 1, 0, 101, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTD = new VexRVMOp("VPCMPGTD", 1, 1, 0, 102, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTQ = new VexRVMOp("VPCMPGTQ", 1, 2, 0, 55, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VFMADD231SS = new VexRVMOp("VFMADD231SS", 1, 2, 0, 185, VEXOpAssertion.FMA_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VFMADD231SD = new VexRVMOp("VFMADD231SD", 1, 2, 1, 185, VEXOpAssertion.FMA_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VFMADD231PS = new VexRVMOp("VFMADD231PS", 1, 2, 0, 184, VEXOpAssertion.FMA, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VFMADD231PD = new VexRVMOp("VFMADD231PD", 1, 2, 1, 184, VEXOpAssertion.FMA, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMOp VSQRTSD = new VexRVMOp("VSQRTSD", 3, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VSQRTSS = new VexRVMOp("VSQRTSS", 2, 1, 0, 81, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VPERMD = new VexRVMOp("VPERMD", 1, 2, 0, 54, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VMOVSS = new VexRVMOp("VMOVSS", 2, 1, 0, 16, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMOp VMOVSD = new VexRVMOp("VMOVSD", 3, 1, 0, 16, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMOVHPD = new VexRVMOp("VMOVHPD", 1, 1, 0, 22, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMOVLPD = new VexRVMOp("VMOVLPD", 1, 1, 0, 18, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMOp VMOVLHPS = new VexRVMOp("VMOVLHPS", 0, 1, 0, 22, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMOp VPHADDW = new VexRVMOp("VPHADDW", 1, 2, 0, 1, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPHADDD = new VexRVMOp("VPHADDD", 1, 2, 0, 2, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp EVANDPS = new VexRVMOp("EVANDPS", VANDPS);
        public static final VexRVMOp EVANDPD = new VexRVMOp("EVANDPD", VANDPD);
        public static final VexRVMOp EVANDNPS = new VexRVMOp("EVANDNPS", VANDNPS);
        public static final VexRVMOp EVANDNPD = new VexRVMOp("EVANDNPD", VANDNPD);
        public static final VexRVMOp EVORPS = new VexRVMOp("EVORPS", VORPS);
        public static final VexRVMOp EVORPD = new VexRVMOp("EVORPD", VORPD);
        public static final VexRVMOp EVXORPS = new VexRVMOp("EVXORPS", VXORPS);
        public static final VexRVMOp EVXORPD = new VexRVMOp("EVXORPD", VXORPD);
        public static final VexRVMOp EVADDPS = new VexRVMOp("EVADDPS", VADDPS);
        public static final VexRVMOp EVADDPD = new VexRVMOp("EVADDPD", VADDPD);
        public static final VexRVMOp EVADDSS = new VexRVMOp("EVADDSS", VADDSS);
        public static final VexRVMOp EVADDSD = new VexRVMOp("EVADDSD", VADDSD);
        public static final VexRVMOp EVMULPS = new VexRVMOp("EVMULPS", VMULPS);
        public static final VexRVMOp EVMULPD = new VexRVMOp("EVMULPD", VMULPD);
        public static final VexRVMOp EVMULSS = new VexRVMOp("EVMULSS", VMULSS);
        public static final VexRVMOp EVMULSD = new VexRVMOp("EVMULSD", VMULSD);
        public static final VexRVMOp EVSUBPS = new VexRVMOp("EVSUBPS", VSUBPS);
        public static final VexRVMOp EVSUBPD = new VexRVMOp("EVSUBPD", VSUBPD);
        public static final VexRVMOp EVSUBSS = new VexRVMOp("EVSUBSS", VSUBSS);
        public static final VexRVMOp EVSUBSD = new VexRVMOp("EVSUBSD", VSUBSD);
        public static final VexRVMOp EVMINPS = new VexRVMOp("EVMINPS", VMINPS);
        public static final VexRVMOp EVMINPD = new VexRVMOp("EVMINPD", VMINPD);
        public static final VexRVMOp EVMINSS = new VexRVMOp("EVMINSS", VMINSS);
        public static final VexRVMOp EVMINSD = new VexRVMOp("EVMINSD", VMINSD);
        public static final VexRVMOp EVDIVPS = new VexRVMOp("EVDIVPS", VDIVPS);
        public static final VexRVMOp EVDIVPD = new VexRVMOp("EVDIVPD", VDIVPD);
        public static final VexRVMOp EVDIVSS = new VexRVMOp("EVDIVSS", VDIVSS);
        public static final VexRVMOp EVDIVSD = new VexRVMOp("EVDIVSD", VDIVSD);
        public static final VexRVMOp EVMAXPS = new VexRVMOp("EVMAXPS", VMAXPS);
        public static final VexRVMOp EVMAXPD = new VexRVMOp("EVMAXPD", VMAXPD);
        public static final VexRVMOp EVMAXSS = new VexRVMOp("EVMAXSS", VMAXSS);
        public static final VexRVMOp EVMAXSD = new VexRVMOp("EVMAXSD", VMAXSD);
        public static final VexRVMOp EVPACKUSDW = new VexRVMOp("EVPACKUSDW", VPACKUSDW);
        public static final VexRVMOp EVPACKUSWB = new VexRVMOp("EVPACKUSWB", VPACKUSWB);
        public static final VexRVMOp EVPAND = new VexRVMOp("EVPAND", VPAND);
        public static final VexRVMOp EVPANDN = new VexRVMOp("EVPANDN", VPANDN);
        public static final VexRVMOp EVPOR = new VexRVMOp("EVPOR", VPOR);
        public static final VexRVMOp EVPXOR = new VexRVMOp("EVPXOR", VPXOR);
        public static final VexRVMOp EVPADDB = new VexRVMOp("EVPADDB", VPADDB);
        public static final VexRVMOp EVPADDW = new VexRVMOp("EVPADDW", VPADDW);
        public static final VexRVMOp EVPADDD = new VexRVMOp("EVPADDD", VPADDD);
        public static final VexRVMOp EVPADDQ = new VexRVMOp("EVPADDQ", VPADDQ);
        public static final VexRVMOp EVPMAXSB = new VexRVMOp("EVPMAXSB", VPMAXSB);
        public static final VexRVMOp EVPMAXSW = new VexRVMOp("EVPMAXSW", VPMAXSW);
        public static final VexRVMOp EVPMAXSD = new VexRVMOp("EVPMAXSD", VPMAXSD);
        public static final VexRVMOp EVPMAXSQ = new VexRVMOp("EVPMAXSQ", 1, 2, 1, 61, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPMAXUB = new VexRVMOp("EVPMAXUB", VPMAXUB);
        public static final VexRVMOp EVPMAXUW = new VexRVMOp("EVPMAXUW", VPMAXUW);
        public static final VexRVMOp EVPMAXUD = new VexRVMOp("EVPMAXUD", VPMAXUD);
        public static final VexRVMOp EVPMAXUQ = new VexRVMOp("EVPMAXUQ", 1, 2, 1, 63, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPMINSB = new VexRVMOp("EVPMINSB", VPMINSB);
        public static final VexRVMOp EVPMINSW = new VexRVMOp("EVPMINSW", VPMINSW);
        public static final VexRVMOp EVPMINSD = new VexRVMOp("EVPMINSD", VPMINSD);
        public static final VexRVMOp EVPMINSQ = new VexRVMOp("EVPMINSQ", 1, 2, 1, 57, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPMINUB = new VexRVMOp("EVPMINUB", VPMINUB);
        public static final VexRVMOp EVPMINUW = new VexRVMOp("EVPMINUW", VPMINUW);
        public static final VexRVMOp EVPMINUD = new VexRVMOp("EVPMINUD", VPMINUD);
        public static final VexRVMOp EVPMINUQ = new VexRVMOp("EVPMINUQ", 1, 2, 1, 59, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPMULHUW = new VexRVMOp("EVPMULHUW", VPMULHUW);
        public static final VexRVMOp EVPMULHW = new VexRVMOp("EVPMULHW", VPMULHW);
        public static final VexRVMOp EVPMULLW = new VexRVMOp("EVPMULLW", VPMULLW);
        public static final VexRVMOp EVPMULLD = new VexRVMOp("EVPMULLD", VPMULLD);
        public static final VexRVMOp EVPMULLQ = new VexRVMOp("EVPMULLQ", 1, 2, 1, 64, VEXOpAssertion.AVX512DQ_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPSUBUSB = new VexRVMOp("EVPSUBUSB", VPSUBUSB);
        public static final VexRVMOp EVPSUBUSW = new VexRVMOp("EVPSUBUSW", VPSUBUSW);
        public static final VexRVMOp EVPSUBB = new VexRVMOp("EVPSUBB", VPSUBB);
        public static final VexRVMOp EVPSUBW = new VexRVMOp("EVPSUBW", VPSUBW);
        public static final VexRVMOp EVPSUBD = new VexRVMOp("EVPSUBD", VPSUBD);
        public static final VexRVMOp EVPSUBQ = new VexRVMOp("EVPSUBQ", VPSUBQ);
        public static final VexRVMOp EVPSLLVW = new VexRVMOp("EVPSLLVW", 1, 2, 1, 18, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPSLLVD = new VexRVMOp("EVPSLLVD", VPSLLVD);
        public static final VexRVMOp EVPSLLVQ = new VexRVMOp("EVPSLLVQ", VPSLLVQ);
        public static final VexRVMOp EVPSRLVW = new VexRVMOp("EVPSRLVW", 1, 2, 1, 16, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPSRLVD = new VexRVMOp("EVPSRLVD", VPSRLVD);
        public static final VexRVMOp EVPSRLVQ = new VexRVMOp("EVPSRLVQ", VPSRLVQ);
        public static final VexRVMOp EVPSRAVW = new VexRVMOp("EVPSRAVW", 1, 2, 1, 17, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPSRAVD = new VexRVMOp("EVPSRAVD", VPSRAVD);
        public static final VexRVMOp EVPSRAVQ = new VexRVMOp("EVPSRAVQ", 1, 2, 1, 70, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPSHUFB = new VexRVMOp("EVPSHUFB", VPSHUFB);
        public static final VexRVMOp EVPCMPEQB = new VexRVMOp("EVPCMPEQB", 1, 1, 0, 116, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPEQW = new VexRVMOp("EVPCMPEQW", 1, 1, 0, 117, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPEQD = new VexRVMOp("EVPCMPEQD", 1, 1, 0, 118, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPEQQ = new VexRVMOp("EVPCMPEQQ", 1, 2, 0, 41, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPCMPGTB = new VexRVMOp("EVPCMPGTB", 1, 1, 0, 100, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPGTW = new VexRVMOp("EVPCMPGTW", 1, 1, 0, 101, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPGTD = new VexRVMOp("EVPCMPGTD", 1, 1, 0, 102, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPCMPGTQ = new VexRVMOp("EVPCMPGTQ", 1, 2, 0, 55, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVFMADD231SS = new VexRVMOp("EVFMADD231SS", VFMADD231SS);
        public static final VexRVMOp EVFMADD231SD = new VexRVMOp("EVFMADD231SD", VFMADD231SD);
        public static final VexRVMOp EVFMADD231PS = new VexRVMOp("EVFMADD231PS", VFMADD231PS);
        public static final VexRVMOp EVFMADD231PD = new VexRVMOp("EVFMADD231PD", VFMADD231PD);
        public static final VexRVMOp EVSQRTSD = new VexRVMOp("EVSQRTSD", VSQRTSD);
        public static final VexRVMOp EVSQRTSS = new VexRVMOp("EVSQRTSS", VSQRTSS);
        public static final VexRVMOp EVPERMW = new VexRVMOp("EVPERMW", 1, 2, 1, 141, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPERMD = new VexRVMOp("EVPERMD", VPERMD);
        public static final VexRVMOp EVPBLENDMB = new VexRVMOp("EVPBLENDMB", 1, 2, 0, 102, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPBLENDMW = new VexRVMOp("EVPBLENDMW", 1, 2, 1, 102, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPBLENDMD = new VexRVMOp("EVPBLENDMD", 1, 2, 0, 100, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPBLENDMQ = new VexRVMOp("EVPBLENDMQ", 1, 2, 1, 100, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVBLENDMPS = new VexRVMOp("EVBLENDMPS", 1, 2, 0, 101, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVBLENDMPD = new VexRVMOp("EVBLENDMPD", 1, 2, 1, 101, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPERMT2B = new VexRVMOp("EVPERMT2B", 1, 2, 0, 125, VEXOpAssertion.AVX512_VBMI_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMOp EVPERMT2Q = new VexRVMOp("EVPERMT2Q", 1, 2, 1, 126, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVPROLVQ = new VexRVMOp("EVPROLVQ", 1, 2, 1, 21, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMOp EVMOVSS = new VexRVMOp("EVMOVSS", VMOVSS);
        public static final VexRVMOp EVMOVSD = new VexRVMOp("EVMOVSD", VMOVSD);
        public static final VexRVMOp EVMOVHPD = new VexRVMOp("EVMOVHPD", VMOVHPD);
        public static final VexRVMOp EVMOVLPD = new VexRVMOp("EVMOVLPD", VMOVLPD);
        public static final VexRVMOp EVMOVLHPS = new VexRVMOp("EVMOVLHPS", VMOVLHPS);

        protected VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        private VexRVMOp(String opcode, VexRVMOp vexOp) {
            this(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        private VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        @Override
        public VexRVMOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRVMOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            this.emit(asm, size, dst, src1, src2, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            this.emit(asm, size, dst, src1, src2, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask) {
            this.emit(asm, size, dst, src1, src2, mask, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask) {
            this.emit(asm, size, dst, src1, src2, mask, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(this.isEvex, size));
        }

        public boolean isPacked() {
            return this.pp == 0 || this.pp == 1;
        }
    }

    public static final class VexGeneralPurposeRMVOp
    extends VexOp {
        public static final VexGeneralPurposeRMVOp BEXTR = new VexGeneralPurposeRMVOp("BEXTR", 0, 2, 0, 247, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMVOp BZHI = new VexGeneralPurposeRMVOp("BZHI", 0, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SARX = new VexGeneralPurposeRMVOp("SARX", 2, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHRX = new VexGeneralPurposeRMVOp("SHRX", 3, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHLX = new VexGeneralPurposeRMVOp("SHLX", 1, 2, 0, 247, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRMVOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public VexGeneralPurposeRMVOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexGeneralPurposeRMVOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            this.emitVexOrEvex(asm, dst, src2, src1, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src1);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src1, Register src2) {
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            this.emitVexOrEvex(asm, dst, src2, src1, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src1, 0);
        }
    }

    public static final class JumpType
    extends Enum<JumpType> {
        public static final /* enum */ JumpType JMP = new JumpType(5, 1, 4);
        public static final /* enum */ JumpType JMPB = new JumpType(2, 1, 1);
        public static final /* enum */ JumpType JCC = new JumpType(6, 2, 4);
        public static final /* enum */ JumpType JCCB = new JumpType(2, 1, 1);
        public final int instrSize;
        public final int dispSize;
        public final int dispPos;
        private static final /* synthetic */ JumpType[] $VALUES;

        public static JumpType[] values() {
            return (JumpType[])$VALUES.clone();
        }

        public static JumpType valueOf(String name) {
            return Enum.valueOf(JumpType.class, name);
        }

        private JumpType(int instrSize, int dispPos, int dispSize) {
            assert (instrSize == dispPos + dispSize) : "Invalid JumpInfo: instrSize=" + instrSize + ", dispPos=" + dispPos + ", dispSize=" + dispSize;
            this.instrSize = instrSize;
            this.dispPos = dispPos;
            this.dispSize = dispSize;
        }

        private static /* synthetic */ JumpType[] $values() {
            return new JumpType[]{JMP, JMPB, JCC, JCCB};
        }

        static {
            $VALUES = JumpType.$values();
        }
    }

    public static enum ConditionFlag {
        Zero(4, "|zero|"),
        NotZero(5, "|nzero|"),
        Equal(4, "="),
        NotEqual(5, "!="),
        Less(12, "<"),
        LessEqual(14, "<="),
        Greater(15, ">"),
        GreaterEqual(13, ">="),
        Below(2, "|<|"),
        BelowEqual(6, "|<=|"),
        Above(7, "|>|"),
        AboveEqual(3, "|>=|"),
        Overflow(0, "|of|"),
        NoOverflow(1, "|nof|"),
        CarrySet(2, "|carry|"),
        CarryClear(3, "|ncarry|"),
        Negative(8, "|neg|"),
        Positive(9, "|pos|"),
        Parity(10, "|par|"),
        NoParity(11, "|npar|");

        private final int value;
        private final String operator;

        private ConditionFlag(int value, String operator) {
            this.value = value;
            this.operator = operator;
        }

        public ConditionFlag negate() {
            switch (this.ordinal()) {
                case 0: {
                    return NotZero;
                }
                case 1: {
                    return Zero;
                }
                case 2: {
                    return NotEqual;
                }
                case 3: {
                    return Equal;
                }
                case 4: {
                    return GreaterEqual;
                }
                case 5: {
                    return Greater;
                }
                case 6: {
                    return LessEqual;
                }
                case 7: {
                    return Less;
                }
                case 8: {
                    return AboveEqual;
                }
                case 9: {
                    return Above;
                }
                case 10: {
                    return BelowEqual;
                }
                case 11: {
                    return Below;
                }
                case 12: {
                    return NoOverflow;
                }
                case 13: {
                    return Overflow;
                }
                case 14: {
                    return CarryClear;
                }
                case 15: {
                    return CarrySet;
                }
                case 16: {
                    return Positive;
                }
                case 17: {
                    return Negative;
                }
                case 18: {
                    return NoParity;
                }
                case 19: {
                    return Parity;
                }
            }
            throw new IllegalArgumentException();
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.operator;
        }
    }

    public static class JumpInfo {
        private static final int ALIGNMENT_COMPENSATION_HEURISTIC = 32;
        public final int jumpIdx;
        public final int instrPos;
        public final JumpType type;
        public int displacementPosition;
        private final AMD64Assembler asm;

        JumpInfo(int jumpIdx, JumpType type, int pos, AMD64Assembler asm) {
            this.jumpIdx = jumpIdx;
            this.type = type;
            this.instrPos = pos;
            this.displacementPosition = pos + type.dispPos;
            this.asm = asm;
        }

        public int getDisplacement() {
            switch (this.type.dispSize) {
                case 1: {
                    return this.asm.getByte(this.instrPos + this.type.dispPos);
                }
                case 4: {
                    return this.asm.getInt(this.instrPos + this.type.dispPos);
                }
            }
            throw new RuntimeException("Unhandled jump displacement size: " + this.type.dispSize);
        }

        public boolean canBeOptimized() {
            if (this.type != JumpType.JCC && this.type != JumpType.JMP) {
                return false;
            }
            int displacement = this.getDisplacement();
            if (displacement < 0) {
                return false;
            }
            return NumUtil.isByte(this.getDisplacement() + 32);
        }

        public boolean isLongJmp() {
            return this.asm.getByte(this.instrPos) == 233;
        }

        public boolean isLongJcc() {
            return this.asm.getByte(this.instrPos) == 15 && (this.asm.getByte(this.instrPos + 1) & 0xF0) == 128;
        }
    }

    public static class AMD64RMOp
    extends AMD64RROp {
        public static final AMD64RMOp IMUL = new AMD64RMOp("IMUL", 15, 175, OpAssertion.ByteOrLargerAssertion);
        public static final AMD64RMOp BSF = new AMD64RMOp("BSF", 15, 188, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp BSR = new AMD64RMOp("BSR", 15, 189, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp POPCNT = new AMD64RMOp("POPCNT", 243, 15, 184, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.POPCNT);
        public static final AMD64RMOp TZCNT = new AMD64RMOp("TZCNT", 243, 15, 188, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.BMI1);
        public static final AMD64RMOp LZCNT = new AMD64RMOp("LZCNT", 243, 15, 189, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.LZCNT);
        public static final AMD64RMOp MOVZXB = new AMD64RMOp("MOVZXB", 15, 182, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVZX = new AMD64RMOp("MOVZX", 15, 183, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXB = new AMD64RMOp("MOVSXB", 15, 190, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVSX = new AMD64RMOp("MOVSX", 15, 191, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXD = new AMD64RMOp("MOVSXD", 99, OpAssertion.QwordAssertion);
        public static final AMD64RMOp MOVB = new AMD64RMOp("MOVB", 138, OpAssertion.ByteAssertion);
        public static final AMD64RMOp MOV = new AMD64RMOp("MOV", 139, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp CMP = new AMD64RMOp("CMP", 59, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp XCHGB = new AMD64RMOp("XCHGB", 134, OpAssertion.ByteAssertion);
        public static final AMD64RMOp XCHG = new AMD64RMOp("XCHG", 135, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp TESTB = new AMD64RMOp("TEST", 132, OpAssertion.ByteAssertion);
        public static final AMD64RMOp TEST = new AMD64RMOp("TEST", 133, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp CMPXCHG = new AMD64RMOp("CMPXCHG", 15, 177, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp ADCX = new AMD64RMOp("ADCX", 102, 14351, 246, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.ADX);
        public static final AMD64RMOp ADOX = new AMD64RMOp("ADOX", 243, 14351, 246, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.ADX);
        public static final AMD64RMOp SHA1MSG1 = new AMD64RMOp("SHA1MSG1", 14351, 201, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA1MSG2 = new AMD64RMOp("SHA1MSG2", 14351, 202, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA1NEXTE = new AMD64RMOp("SHA1NEXTE", 14351, 200, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256MSG1 = new AMD64RMOp("SHA256MSG1", 14351, 204, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256MSG2 = new AMD64RMOp("SHA256MSG2", 14351, 205, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);
        public static final AMD64RMOp SHA256RNDS2 = new AMD64RMOp("SHA256RNDS2", 14351, 203, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);

        protected AMD64RMOp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, 0, op, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, 0, prefix, op, assertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion) {
            super(opcode, 0, prefix, op, dstIsByte, srcIsByte, assertion, null);
        }

        @Override
        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, dst, src));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src) {
            assert (this.verify(asm, size, dst, null));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            asm.emitOperandHelper(dst, src, 0);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src, boolean force4Byte) {
            assert (this.verify(asm, size, dst, null));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            asm.emitOperandHelper(dst, src, force4Byte, 0);
        }
    }

    public static class AMD64MROp
    extends AMD64RROp {
        public static final AMD64MROp MOVB = new AMD64MROp("MOVB", 136, OpAssertion.ByteAssertion);
        public static final AMD64MROp MOV = new AMD64MROp("MOV", 137, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MROp TEST = new AMD64MROp("TEST", 133, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MROp CMPXCHGB = new AMD64MROp("CMPXCHGB", 15, 176, OpAssertion.ByteAssertion);
        public static final AMD64MROp CMPXCHG = new AMD64MROp("CMPXCHG", 15, 177, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MROp XADDB = new AMD64MROp("XADDB", 15, 192, OpAssertion.ByteAssertion);
        public static final AMD64MROp XADD = new AMD64MROp("XADD", 15, 193, OpAssertion.WordOrLargerAssertion);

        protected AMD64MROp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, 0, op, assertion, null);
        }

        protected AMD64MROp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion, null);
        }

        protected AMD64MROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        @Override
        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, src, dst));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, dst.encoding);
            asm.emitModRM(src, dst);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src) {
            assert (this.verify(asm, size, src, null));
            assert (!this.isSSEInstruction());
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, 0);
            asm.emitOperandHelper(src, dst, 0);
        }
    }

    public static class AMD64MIOp
    extends AMD64ImmOp {
        public static final AMD64MIOp BT = new AMD64MIOp("BT", true, 15, 186, 4, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp BTR = new AMD64MIOp("BTR", true, 15, 186, 6, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp MOVB = new AMD64MIOp("MOVB", true, 198, 0, OpAssertion.ByteAssertion);
        public static final AMD64MIOp MOV = new AMD64MIOp("MOV", false, 199, 0, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp SAR = new AMD64MIOp("SAR", true, 193, 7, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp SHL = new AMD64MIOp("SHL", true, 193, 4, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp SHR = new AMD64MIOp("SHR", true, 193, 5, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MIOp TEST = new AMD64MIOp("TEST", false, 247, 0);
        private final int ext;

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext) {
            this(opcode, immIsByte, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext, OpAssertion assertion) {
            this(opcode, immIsByte, 0, op, ext, assertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, immIsByte, prefix, op, assertion);
            this.ext = ext;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, dst, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, null, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, this.immediateSize(size));
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }
    }

    public static final class AMD64BinaryArithmetic {
        public static final AMD64BinaryArithmetic ADD = new AMD64BinaryArithmetic("ADD", 0);
        public static final AMD64BinaryArithmetic OR = new AMD64BinaryArithmetic("OR", 1);
        public static final AMD64BinaryArithmetic ADC = new AMD64BinaryArithmetic("ADC", 2);
        public static final AMD64BinaryArithmetic SBB = new AMD64BinaryArithmetic("SBB", 3);
        public static final AMD64BinaryArithmetic AND = new AMD64BinaryArithmetic("AND", 4);
        public static final AMD64BinaryArithmetic SUB = new AMD64BinaryArithmetic("SUB", 5);
        public static final AMD64BinaryArithmetic XOR = new AMD64BinaryArithmetic("XOR", 6);
        public static final AMD64BinaryArithmetic CMP = new AMD64BinaryArithmetic("CMP", 7);
        private final AMD64MIOp byteImmOp;
        private final AMD64MROp byteMrOp;
        private final AMD64RMOp byteRmOp;
        private final AMD64MIOp immOp;
        private final AMD64MIOp immSxOp;
        private final AMD64MROp mrOp;
        private final AMD64RMOp rmOp;

        private AMD64BinaryArithmetic(String opcode, int code) {
            int baseOp = code << 3;
            this.byteImmOp = new AMD64MIOp(opcode, true, 0, 128, code, OpAssertion.ByteAssertion);
            this.byteMrOp = new AMD64MROp(opcode, 0, baseOp, OpAssertion.ByteAssertion);
            this.byteRmOp = new AMD64RMOp(opcode, 0, baseOp | 2, OpAssertion.ByteAssertion);
            this.immOp = new AMD64MIOp(opcode, false, 0, 129, code, OpAssertion.WordOrLargerAssertion);
            this.immSxOp = new AMD64MIOp(opcode, true, 0, 131, code, OpAssertion.WordOrLargerAssertion);
            this.mrOp = new AMD64MROp(opcode, 0, baseOp | 1, OpAssertion.WordOrLargerAssertion);
            this.rmOp = new AMD64RMOp(opcode, 0, baseOp | 3, OpAssertion.WordOrLargerAssertion);
        }

        public AMD64MIOp getMIOpcode(AMD64BaseAssembler.OperandSize size, boolean sx) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteImmOp;
            }
            if (sx) {
                return this.immSxOp;
            }
            return this.immOp;
        }

        public AMD64MROp getMROpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteMrOp;
            }
            return this.mrOp;
        }

        public AMD64RMOp getRMOpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteRmOp;
            }
            return this.rmOp;
        }
    }

    public static class SSEOp
    extends AMD64RMOp {
        public static final SSEOp CVTDQ2PD = new SSEOp("CVTDQ2PD", 15, 230, PreferredNDS.NONE, OpAssertion.SingleAssertion);
        public static final SSEOp CVTSI2SS = new SSEOp("CVTSI2SS", 243, 15, 42, PreferredNDS.DST, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTSI2SD = new SSEOp("CVTSI2SD", 242, 15, 42, PreferredNDS.DST, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTTSS2SI = new SSEOp("CVTTSS2SI", 243, 15, 44, PreferredNDS.NONE, OpAssertion.FloatToIntAssertion);
        public static final SSEOp CVTTSD2SI = new SSEOp("CVTTSD2SI", 242, 15, 44, PreferredNDS.NONE, OpAssertion.FloatToIntAssertion);
        public static final SSEOp CVTTPD2DQ = new SSEOp("CVTTPD2DQ", 15, 230, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp UCOMIS = new SSEOp("UCOMIS", 15, 46, PreferredNDS.NONE, OpAssertion.PackedFloatAssertion);
        public static final SSEOp SQRT = new SSEOp("SQRT", 15, 81, PreferredNDS.SRC, OpAssertion.ScalarFloatAssertion);
        public static final SSEOp AND = new SSEOp("AND", 15, 84, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ANDN = new SSEOp("ANDN", 15, 85, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp OR = new SSEOp("OR", 15, 86, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp XOR = new SSEOp("XOR", 15, 87, PreferredNDS.DST, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ADD = new SSEOp("ADD", 15, 88, PreferredNDS.DST);
        public static final SSEOp MUL = new SSEOp("MUL", 15, 89, PreferredNDS.DST);
        public static final SSEOp CVTSS2SD = new SSEOp("CVTSS2SD", 15, 90, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEOp CVTSD2SS = new SSEOp("CVTSD2SS", 15, 90, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        public static final SSEOp CVTSD2SI = new SSEOp("CVTSD2SI", 242, 15, 45, PreferredNDS.NONE, OpAssertion.FloatToIntAssertion);
        public static final SSEOp SUB = new SSEOp("SUB", 15, 92, PreferredNDS.DST);
        public static final SSEOp MIN = new SSEOp("MIN", 15, 93, PreferredNDS.DST);
        public static final SSEOp DIV = new SSEOp("DIV", 15, 94, PreferredNDS.DST);
        public static final SSEOp MAX = new SSEOp("MAX", 15, 95, PreferredNDS.DST);
        public static final SSEOp PADDD = new SSEOp("PADDD", 15, 254, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PADDQ = new SSEOp("PADDQ", 15, 212, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSLLQ = new SSEOp("PSLLQ", 15, 243, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBB = new SSEOp("PSUBB", 15, 248, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBW = new SSEOp("PSUBW", 15, 249, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBD = new SSEOp("PSUBD", 15, 250, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBUSB = new SSEOp("PSUBUSB", 15, 216, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PSUBUSW = new SSEOp("PSUBUSW", 15, 217, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PMINUB = new SSEOp("PMINUB", 15, 218, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PMINUW = new SSEOp("PMINUW", 14351, 58, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMINUD = new SSEOp("PMINUD", 14351, 59, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PACKUSWB = new SSEOp("PACKUSWB", 15, 103, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PACKUSDW = new SSEOp("PACKUSDW", 14351, 43, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PCMPEQB = new SSEOp("PCMPEQB", 15, 116, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PCMPEQW = new SSEOp("PCMPEQW", 15, 117, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PCMPEQD = new SSEOp("PCMPEQD", 15, 118, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PCMPGTB = new SSEOp("PCMPGTB", 15, 100, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PCMPGTW = new SSEOp("PCMPGTW", 15, 101, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PCMPGTD = new SSEOp("PCMPGTD", 15, 102, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp PMOVSXBW = new SSEOp("PMOVSXBW", 14351, 32, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVSXBD = new SSEOp("PMOVSXBD", 14351, 33, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVSXBQ = new SSEOp("PMOVSXBQ", 14351, 34, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVSXWD = new SSEOp("PMOVSXWD", 14351, 35, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVSXWQ = new SSEOp("PMOVSXWQ", 14351, 36, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVSXDQ = new SSEOp("PMOVSXDQ", 14351, 37, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXBW = new SSEOp("PMOVZXBW", 14351, 48, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXBD = new SSEOp("PMOVZXBD", 14351, 49, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXBQ = new SSEOp("PMOVZXBQ", 14351, 50, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXWD = new SSEOp("PMOVZXWD", 14351, 51, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXWQ = new SSEOp("PMOVZXWQ", 14351, 52, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PMOVZXDQ = new SSEOp("PMOVZXDQ", 14351, 53, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PAND = new SSEOp("PAND", 15, 219, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSEOp PANDN = new SSEOp("PANDN", 15, 223, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSEOp POR = new SSEOp("POR", 15, 235, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSEOp PXOR = new SSEOp("PXOR", 15, 239, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSEOp RCPPS = new SSEOp("RCPPS", 15, 83, PreferredNDS.NONE, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SSE);
        public static final SSEOp PTEST = new SSEOp("PTEST", 14351, 23, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEOp PSHUFB = new SSEOp("PSHUFB", 14351, 0, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSSE3);
        public static final SSEOp PUNPCKLBW = new SSEOp("PUNPCKLBW", 15, 96, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp AESDEC = new SSEOp("AESDEC", 14351, 222, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.AES);
        public static final SSEOp AESDECLAST = new SSEOp("AESDECLAST", 14351, 223, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.AES);
        public static final SSEOp AESENC = new SSEOp("AESENC", 14351, 220, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.AES);
        public static final SSEOp AESENCLAST = new SSEOp("AESENCLAST", 14351, 221, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.AES);
        public static final SSEOp MOVD = new SSEOp("MOVD", 102, 15, 110, PreferredNDS.NONE, OpAssertion.DwordToFloatAssertion);
        public static final SSEOp MOVQ = new SSEOp("MOVQ", 102, 15, 110, PreferredNDS.NONE, OpAssertion.QwordToFloatAssertion);
        public static final SSEOp MOVSS = new SSEOp("MOVSS", 15, 16, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEOp MOVSD = new SSEOp("MOVSD", 15, 16, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        public static final SSEOp MOVAPD = new SSEOp("MOVAPD", 15, 40, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp MOVAPS = new SSEOp("MOVAPS", 15, 40, PreferredNDS.NONE, OpAssertion.PackedFloatAssertion);
        public static final SSEOp MOVDDUP = new SSEOp("MOVDDUP", 15, 18, PreferredNDS.NONE, OpAssertion.DoubleAssertion, AMD64.CPUFeature.SSE3);
        public static final SSEOp MOVDQA = new SSEOp("MOVDQA", 15, 111, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp MOVDQU = new SSEOp("MOVDQU", 15, 111, PreferredNDS.NONE, OpAssertion.SingleAssertion);
        public static final SSEOp UNPCKHPD = new SSEOp("UNPCKHPD", 15, 21, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        public static final SSEOp UNPCKLPD = new SSEOp("UNPCKLPD", 15, 20, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion);
        private final PreferredNDS preferredNDS;

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS) {
            this(opcode, 0, prefix, op, preferredNDS, OpAssertion.FloatAssertion);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, preferredNDS, OpAssertion.FloatAssertion, feature);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, 0, prefix, op, preferredNDS, assertion);
        }

        protected SSEOp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, preferredNDS, assertion, feature);
        }

        protected SSEOp(String opcode, int mandatoryPrefix, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, mandatoryPrefix, prefix, op, preferredNDS, assertion, AMD64.CPUFeature.SSE2);
        }

        protected SSEOp(String opcode, int mandatoryPrefix, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, mandatoryPrefix, prefix, op, assertion, feature);
            this.preferredNDS = preferredNDS;
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, dst, src));
            assert (this.isSSEInstruction());
            Register nds = this.preferredNDS.getNds(dst, src);
            asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src) {
            assert (this.verify(asm, size, dst, null));
            assert (this.isSSEInstruction());
            Register nds = this == MOVSS || this == MOVSD ? Register.None : this.preferredNDS.getNds(dst, src);
            asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0);
        }
    }

    public static final class AMD64MOp
    extends AMD64Op {
        public static final AMD64MOp DEC = new AMD64MOp("DEC", 255, 1);
        public static final AMD64MOp DECB = new AMD64MOp("DEC", 254, 1, OpAssertion.ByteAssertion);
        public static final AMD64MOp DIV = new AMD64MOp("DIV", 247, 6);
        public static final AMD64MOp IDIV = new AMD64MOp("IDIV", 247, 7);
        public static final AMD64MOp IMUL = new AMD64MOp("IMUL", 247, 5);
        public static final AMD64MOp INC = new AMD64MOp("INC", 255, 0);
        public static final AMD64MOp INCB = new AMD64MOp("INC", 254, 0, OpAssertion.ByteAssertion);
        public static final AMD64MOp MUL = new AMD64MOp("MUL", 247, 4);
        public static final AMD64MOp NEG = new AMD64MOp("NEG", 247, 3);
        public static final AMD64MOp NEGB = new AMD64MOp("NEG", 246, 3, OpAssertion.ByteAssertion);
        public static final AMD64MOp NOT = new AMD64MOp("NOT", 247, 2);
        public static final AMD64MOp NOTB = new AMD64MOp("NOT", 246, 2, OpAssertion.ByteAssertion);
        public static final AMD64MOp POP = new AMD64MOp("POP", 143, 0, OpAssertion.WordOrQwordAssertion);
        public static final AMD64MOp PUSH = new AMD64MOp("PUSH", 255, 6, OpAssertion.WordOrQwordAssertion);
        public static final AMD64MOp SAR = new AMD64MOp("SAR", 211, 7, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MOp SAR1 = new AMD64MOp("SAR1", 209, 7, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MOp SHL = new AMD64MOp("SHL", 211, 4, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MOp SHL1 = new AMD64MOp("SHL1", 209, 4, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MOp SHR = new AMD64MOp("SHR", 211, 5, OpAssertion.WordOrLargerAssertion);
        public static final AMD64MOp SHR1 = new AMD64MOp("SHR1", 209, 5, OpAssertion.WordOrLargerAssertion);
        private final int ext;

        protected AMD64MOp(String opcode, int op, int ext) {
            this(opcode, 0, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MOp(String opcode, int op, int ext, OpAssertion assertion) {
            this(opcode, 0, op, ext, assertion);
        }

        protected AMD64MOp(String opcode, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, 0, prefix, op, assertion, null);
            this.ext = ext;
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst) {
            assert (this.verify(asm, size, dst, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst) {
            assert (this.verify(asm, size, null, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, 0);
        }
    }

    public static final class VexRVMIOp
    extends VexOp {
        public static final VexRVMIOp VPINSRB = new VexRVMIOp("VPINSRB", 1, 3, 0, 32, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512BW_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_8BIT, 0);
        public static final VexRVMIOp VPINSRW = new VexRVMIOp("VPINSRW", 1, 1, 0, 196, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512BW_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_16BIT, 0);
        public static final VexRVMIOp VPINSRD = new VexRVMIOp("VPINSRD", 1, 3, 0, 34, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512DQ_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMIOp VPINSRQ = new VexRVMIOp("VPINSRQ", 1, 3, 1, 34, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512DQ_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMIOp VINSERTPS = new VexRVMIOp("VINSERTPS", 1, 3, 0, 33, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMIOp VSHUFPS = new VexRVMIOp("VSHUFPS", 0, 1, 0, 198, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VSHUFPD = new VexRVMIOp("VSHUFPD", 1, 1, 0, 198, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp VINSERTF128 = new VexRVMIOp("VINSERTF128", 1, 3, 0, 24, VEXOpAssertion.AVX1_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRVMIOp VINSERTI128 = new VexRVMIOp("VINSERTI128", 1, 3, 0, 56, VEXOpAssertion.AVX2_AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.T4_32BIT, 0);
        public static final VexRVMIOp VPERM2I128 = new VexRVMIOp("VPERM2I128", 1, 3, 0, 70, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRVMIOp VPERM2F128 = new VexRVMIOp("VPERM2F128", 1, 3, 0, 6, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRVMIOp VPCLMULQDQ = new VexRVMIOp("VPCLMULQDQ", 1, 3, 0, 68, VEXOpAssertion.CLMUL_AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPALIGNR = new VexRVMIOp("VPALIGNR", 1, 3, 0, 15, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexRVMIOp VPBLENDD = new VexRVMIOp("VPBLENDD", 1, 3, 0, 2, VEXOpAssertion.AVX2);
        public static final VexRVMIOp VGF2P8AFFINEQB = new VexRVMIOp("VGF2P8AFFINEQB", 1, 3, 1, 206, VEXOpAssertion.GFNI_AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexRVMIOp EVPINSRB = new VexRVMIOp("EVPINSRB", VPINSRB);
        public static final VexRVMIOp EVPINSRW = new VexRVMIOp("EVPINSRW", VPINSRW);
        public static final VexRVMIOp EVPINSRD = new VexRVMIOp("EVPINSRD", VPINSRD);
        public static final VexRVMIOp EVPINSRQ = new VexRVMIOp("EVPINSRQ", VPINSRQ);
        public static final VexRVMIOp EVINSERTPS = new VexRVMIOp("EVINSERTPS", VINSERTPS);
        public static final VexRVMIOp EVSHUFPS = new VexRVMIOp("EVSHUFPS", VSHUFPS);
        public static final VexRVMIOp EVSHUFPD = new VexRVMIOp("EVSHUFPD", VSHUFPD);
        public static final VexRVMIOp EVPTERNLOGD = new VexRVMIOp("EVPTERNLOGD", 1, 3, 0, 37, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMIOp EVPTERNLOGQ = new VexRVMIOp("EVPTERNLOGQ", 1, 3, 1, 37, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMIOp EVPALIGNR = new VexRVMIOp("EVPALIGNR", VPALIGNR);
        public static final VexRVMIOp EVINSERTF32X4 = new VexRVMIOp("EVINSERTF32X4", VINSERTF128);
        public static final VexRVMIOp EVINSERTI32X4 = new VexRVMIOp("EVINSERTI32X4", VINSERTI128);
        public static final VexRVMIOp EVINSERTF64X2 = new VexRVMIOp("EVINSERTF64X2", 1, 3, 1, 24, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1, true);
        public static final VexRVMIOp EVINSERTI64X2 = new VexRVMIOp("EVINSERTI64X2", 1, 3, 1, 56, VEXOpAssertion.AVX512DQ_VL_256_512, AMD64BaseAssembler.EVEXTuple.T2_64BIT, 1, true);
        public static final VexRVMIOp EVINSERTF32X8 = new VexRVMIOp("EVINSERTF32X8", 1, 3, 0, 26, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0, true);
        public static final VexRVMIOp EVINSERTI32X8 = new VexRVMIOp("EVINSERTI32X8", 1, 3, 0, 58, VEXOpAssertion.AVX512DQ_512ONLY, AMD64BaseAssembler.EVEXTuple.T8_32BIT, 0, true);
        public static final VexRVMIOp EVINSERTF64X4 = new VexRVMIOp("EVINSERTF64X4", 1, 3, 1, 26, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1, true);
        public static final VexRVMIOp EVINSERTI64X4 = new VexRVMIOp("EVINSERTI64X4", 1, 3, 1, 58, VEXOpAssertion.AVX512F_512ONLY, AMD64BaseAssembler.EVEXTuple.T4_64BIT, 1, true);
        public static final VexRVMIOp EVALIGND = new VexRVMIOp("EVALIGND", 1, 3, 0, 3, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMIOp EVALIGNQ = new VexRVMIOp("EVALIGNQ", 1, 3, 1, 3, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMIOp EVPCMPUB = new VexRVMIOp("EVPCMPUB", 1, 3, 0, 62, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMIOp EVPCMPUW = new VexRVMIOp("EVPCMPUW", 1, 3, 1, 62, VEXOpAssertion.MASK_XMM_XMM_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMIOp EVPCMPUD = new VexRVMIOp("EVPCMPUD", 1, 3, 0, 30, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexRVMIOp EVPCMPUQ = new VexRVMIOp("EVPCMPUQ", 1, 3, 1, 30, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMIOp EVSHUFI64X2 = new VexRVMIOp("EVSHUFI64X2", 1, 3, 1, 67, VEXOpAssertion.AVX512F_VL_256_512, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexRVMIOp EVGF2P8AFFINEQB = new VexRVMIOp("EVGF2P8AFFINEQB", VGF2P8AFFINEQB);

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        private VexRVMIOp(String opcode, VexRVMIOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexRVMIOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRVMIOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, int imm8) {
            assert ((imm8 & 0xFF) == imm8) : imm8;
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, int imm8) {
            assert ((imm8 & 0xFF) == imm8) : imm8;
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int imm8) {
            this.emit(asm, size, dst, src1, src2, mask, imm8, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int imm8, int z, int b) {
            assert ((imm8 & 0xFF) == imm8) : imm8;
            this.emitVexOrEvex(asm, dst, src1, src2, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(imm8);
        }
    }

    public static class SSERMIOp
    extends AMD64RMIOp {
        public static final SSERMIOp ROUNDSS = new SSERMIOp("ROUNDSS", true, 14863, 10, PreferredNDS.SRC, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp ROUNDSD = new SSERMIOp("ROUNDSD", true, 14863, 11, PreferredNDS.SRC, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp PCMPESTRI = new SSERMIOp("PCMPESTRI", true, 14863, 97, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_2);
        public static final SSERMIOp PCLMULQDQ = new SSERMIOp("PCLMULQDQ", true, 14863, 68, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.CLMUL);
        public static final SSERMIOp GF2P8AFFINEQB = new SSERMIOp("GF2P8AFFINEQB", true, 14863, true, 206, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.GFNI);
        public static final SSERMIOp PINSRB = new SSERMIOp("PINSRB", true, 14863, 32, PreferredNDS.DST, OpAssertion.PackedDoubleIntToFloatAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp PINSRW = new SSERMIOp("PINSRW", true, 15, 196, PreferredNDS.DST, OpAssertion.PackedDoubleIntToFloatAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERMIOp PINSRD = new SSERMIOp("PINSRD", true, 14863, 34, PreferredNDS.DST, OpAssertion.PackedDoubleIntToFloatAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp PINSRQ = new SSERMIOp("PINSRQ", true, 14863, true, 34, PreferredNDS.DST, OpAssertion.PackedDoubleIntToFloatAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp PALIGNR = new SSERMIOp("PALIGNR", true, 14863, 15, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSSE3);
        public static final SSERMIOp PBLENDW = new SSERMIOp("PBLENDW", true, 14863, 14, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSERMIOp PSHUFD = new SSERMIOp("PSHUFD", true, 15, 112, PreferredNDS.NONE, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERMIOp PSHUFLW = new SSERMIOp("PSHUFLW", true, 15, 112, PreferredNDS.NONE, OpAssertion.DoubleAssertion, AMD64.CPUFeature.SSE2);
        private final PreferredNDS preferredNDS;
        private final boolean w;

        protected SSERMIOp(String opcode, boolean immIsByte, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, immIsByte, prefix, false, op, preferredNDS, assertion, feature);
        }

        protected SSERMIOp(String opcode, boolean immIsByte, int prefix, boolean w, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
            this.preferredNDS = preferredNDS;
            this.w = w;
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src, int imm) {
            assert (this.verify(asm, size, dst, src));
            assert (this.isSSEInstruction());
            asm.simdPrefix(dst, this.preferredNDS.getNds(dst, src), src, size, this.prefix1, this.prefix2, this.w);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            this.emitImmediate(asm, size, imm);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src, int imm) {
            assert (this.verify(asm, size, dst, null));
            assert (this.isSSEInstruction());
            asm.simdPrefix(dst, this.preferredNDS.getNds(dst, src), src, size, this.prefix1, this.prefix2, this.w);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, this.immediateSize(size));
            this.emitImmediate(asm, size, imm);
        }
    }

    public static class AMD64RMIOp
    extends AMD64ImmOp {
        public static final AMD64RMIOp IMUL = new AMD64RMIOp("IMUL", false, 105);
        public static final AMD64RMIOp IMUL_SX = new AMD64RMIOp("IMUL", true, 107);
        public static final AMD64RMIOp SHA1RNDS4 = new AMD64RMIOp("SHA1RNDS4", true, 14863, 204, OpAssertion.PackedSingleAssertion, AMD64.CPUFeature.SHA);

        protected AMD64RMIOp(String opcode, boolean immIsByte, int op) {
            super(opcode, immIsByte, 0, op, OpAssertion.WordOrLargerAssertion, null);
        }

        protected AMD64RMIOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src, int imm) {
            assert (this.verify(asm, size, dst, src));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
            asm.emitModRM(dst, src);
            this.emitImmediate(asm, size, imm);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src, int imm) {
            assert (this.verify(asm, size, dst, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            asm.emitOperandHelper(dst, src, this.immediateSize(size));
            this.emitImmediate(asm, size, imm);
        }
    }

    public static class SSEMROp
    extends AMD64MROp {
        public static final SSEMROp MOVD = new SSEMROp("MOVD", 102, 15, 126, PreferredNDS.NONE, OpAssertion.DwordToFloatAssertion);
        public static final SSEMROp MOVQ = new SSEMROp("MOVQ", 102, 15, 126, PreferredNDS.NONE, OpAssertion.QwordToFloatAssertion);
        public static final SSEMROp MOVSS = new SSEMROp("MOVSS", 15, 17, PreferredNDS.SRC, OpAssertion.SingleAssertion);
        public static final SSEMROp MOVSD = new SSEMROp("MOVSD", 15, 17, PreferredNDS.SRC, OpAssertion.DoubleAssertion);
        public static final SSEMROp MOVDQU = new SSEMROp("MOVDQU", 15, 127, PreferredNDS.NONE, OpAssertion.SingleAssertion);
        private final PreferredNDS preferredNDS;

        protected SSEMROp(String opcode, int prefix, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            this(opcode, 0, prefix, op, preferredNDS, assertion);
        }

        protected SSEMROp(String opcode, int prefix1, int prefix2, int op, PreferredNDS preferredNDS, OpAssertion assertion) {
            super(opcode, prefix1, prefix2, op, assertion, AMD64.CPUFeature.SSE2);
            this.preferredNDS = preferredNDS;
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, src, dst));
            assert (this.isSSEInstruction());
            asm.simdPrefix(src, this.preferredNDS.getNds(dst, src), dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src) {
            assert (this.verify(asm, size, src, null));
            assert (this.isSSEInstruction());
            Register nds = this == MOVSS || this == MOVSD ? Register.None : this.preferredNDS.getNds(src, dst);
            asm.simdPrefix(src, nds, dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 0);
        }
    }

    public static final class VexGeneralPurposeRVMOp
    extends VexRVMOp {
        public static final VexGeneralPurposeRVMOp ANDN = new VexGeneralPurposeRVMOp("ANDN", 0, 2, 0, 242, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRVMOp MULX = new VexGeneralPurposeRVMOp("MULX", 3, 2, 0, 246, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PDEP = new VexGeneralPurposeRVMOp("PDEP", 3, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PEXT = new VexGeneralPurposeRVMOp("PEXT", 2, 2, 0, 245, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public VexGeneralPurposeRVMOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexGeneralPurposeRVMOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            this.emit(asm, size, dst, src1, src2, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Register mask, int z, int b) {
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            this.emitVexOrEvex(asm, dst, src1, src2, mask, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            this.emit(asm, size, dst, src1, src2, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Register mask, int z, int b) {
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD) : size;
            this.emitVexOrEvex(asm, dst, src1, src2, mask, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0);
        }
    }

    public static class SSEMRIOp
    extends AMD64ImmOp {
        public static final SSEMRIOp PEXTRB = new SSEMRIOp("PEXTRB", true, 14863, false, 20, PreferredNDS.NONE, OpAssertion.PackedDoubleFloatToIntAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEMRIOp PEXTRW = new SSEMRIOp("PEXTRW", true, 14863, false, 21, PreferredNDS.NONE, OpAssertion.PackedDoubleFloatToIntAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEMRIOp PEXTRD = new SSEMRIOp("PEXTRD", true, 14863, false, 22, PreferredNDS.NONE, OpAssertion.PackedDoubleFloatToIntAssertion, AMD64.CPUFeature.SSE4_1);
        public static final SSEMRIOp PEXTRQ = new SSEMRIOp("PEXTRQ", true, 14863, true, 22, PreferredNDS.NONE, OpAssertion.PackedDoubleFloatToIntAssertion, AMD64.CPUFeature.SSE4_1);
        private final PreferredNDS preferredNDS;
        private final boolean w;

        protected SSEMRIOp(String opcode, boolean immIsByte, int prefix, boolean w, int op, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
            this.w = w;
            this.preferredNDS = preferredNDS;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src, int imm) {
            assert (this.verify(asm, size, dst, src));
            assert (this.isSSEInstruction());
            asm.simdPrefix(src, this.preferredNDS.getNds(src, dst), dst, size, this.prefix1, this.prefix2, this.w);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
            this.emitImmediate(asm, size, imm);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src, int imm) {
            assert (this.verify(asm, size, null, src));
            assert (this.isSSEInstruction());
            asm.simdPrefix(src, this.preferredNDS.getNds(src, dst), dst, size, this.prefix1, this.prefix2, this.w);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, this.immediateSize(size));
            this.emitImmediate(asm, size, imm);
        }
    }

    public static class SSERIOp
    extends AMD64ImmOp {
        public static final SSERIOp PSLLW = new SSERIOp("PSLLW", true, 15, 113, 6, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSLLD = new SSERIOp("PSLLD", true, 15, 114, 6, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSLLDQ = new SSERIOp("PSLLDQ", true, 15, 115, 7, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSLLQ = new SSERIOp("PSLLQ", true, 15, 115, 6, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRAW = new SSERIOp("PSRAW", true, 15, 113, 4, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRAD = new SSERIOp("PSRAD", true, 15, 114, 4, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRLW = new SSERIOp("PSRLW", true, 15, 113, 2, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRLD = new SSERIOp("PSRLD", true, 15, 114, 2, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRLDQ = new SSERIOp("PSRLDQ", true, 15, 115, 3, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        public static final SSERIOp PSRLQ = new SSERIOp("PSRLQ", true, 15, 115, 2, PreferredNDS.DST, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE2);
        private final int ext;
        private final PreferredNDS preferredNDS;

        protected SSERIOp(String opcode, boolean immIsByte, int prefix, int op, int ext, PreferredNDS preferredNDS, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
            this.ext = ext;
            this.preferredNDS = preferredNDS;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm) {
            assert (this.verify(asm, size, dst, null));
            assert (this.isSSEInstruction());
            asm.simdPrefix(AMD64.xmm0, this.preferredNDS.getNds(dst, Register.None), dst, size, this.prefix1, this.prefix2, false);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, dst);
            this.emitImmediate(asm, size, imm);
        }
    }

    public static final class AMD64Shift {
        public static final AMD64Shift ROL = new AMD64Shift("ROL", 0);
        public static final AMD64Shift ROR = new AMD64Shift("ROR", 1);
        public static final AMD64Shift RCL = new AMD64Shift("RCL", 2);
        public static final AMD64Shift RCR = new AMD64Shift("RCR", 3);
        public static final AMD64Shift SHL = new AMD64Shift("SHL", 4);
        public static final AMD64Shift SHR = new AMD64Shift("SHR", 5);
        public static final AMD64Shift SAR = new AMD64Shift("SAR", 7);
        public final AMD64MOp m1Op;
        public final AMD64MOp mcOp;
        public final AMD64MIOp miOp;

        private AMD64Shift(String opcode, int code) {
            this.m1Op = new AMD64MOp(opcode, 0, 209, code, OpAssertion.WordOrLargerAssertion);
            this.mcOp = new AMD64MOp(opcode, 0, 211, code, OpAssertion.WordOrLargerAssertion);
            this.miOp = new AMD64MIOp(opcode, true, 0, 193, code, OpAssertion.WordOrLargerAssertion);
        }
    }

    public static final class VexMoveOp
    extends VexGeneralMoveOp {
        public static final VexMoveOp VMOVDQA32 = new VexMoveOp("VMOVDQA32", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQA64 = new VexMoveOp("VMOVDQA64", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVDQU32 = new VexMoveOp("VMOVDQU32", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQU64 = new VexMoveOp("VMOVDQU64", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVAPS = new VexMoveOp("VMOVAPS", 0, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVAPD = new VexMoveOp("VMOVAPD", 1, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVUPS = new VexMoveOp("VMOVUPS", 0, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVUPD = new VexMoveOp("VMOVUPD", 1, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVSS = new VexMoveOp("VMOVSS", 2, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMoveOp VMOVSD = new VexMoveOp("VMOVSD", 3, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexMoveOp VMOVD = new VexMoveOp("VMOVD", 1, 1, 0, 110, 126, VEXOpAssertion.AVX1_AVX512F_CPU_OR_XMM, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMoveOp VMOVQ = new VexMoveOp("VMOVQ", 1, 1, 1, 110, 126, VEXOpAssertion.AVX1_AVX512F_CPU_OR_XMM, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexMoveOp EVMOVDQA32 = new VexMoveOp("EVMOVDQA32", VMOVDQA32);
        public static final VexMoveOp EVMOVDQA64 = new VexMoveOp("EVMOVDQA64", VMOVDQA64);
        public static final VexMoveOp EVMOVDQU8 = new VexMoveOp("EVMOVDQU8", 3, 1, 0, 111, 127, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, true);
        public static final VexMoveOp EVMOVDQU16 = new VexMoveOp("EVMOVDQU16", 3, 1, 1, 111, 127, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, true);
        public static final VexMoveOp EVMOVDQU32 = new VexMoveOp("EVMOVDQU32", VMOVDQU32);
        public static final VexMoveOp EVMOVDQU64 = new VexMoveOp("EVMOVDQU64", VMOVDQU64);
        public static final VexMoveOp EVMOVAPS = new VexMoveOp("EVMOVAPS", VMOVAPS);
        public static final VexMoveOp EVMOVAPD = new VexMoveOp("EVMOVAPD", VMOVAPD);
        public static final VexMoveOp EVMOVUPS = new VexMoveOp("EVMOVUPS", VMOVUPS);
        public static final VexMoveOp EVMOVUPD = new VexMoveOp("EVMOVUPD", VMOVUPD);
        public static final VexMoveOp EVMOVSS = new VexMoveOp("EVMOVSS", VMOVSS);
        public static final VexMoveOp EVMOVSD = new VexMoveOp("EVMOVSD", VMOVSD);
        public static final VexMoveOp EVMOVD = new VexMoveOp("EVMOVD", VMOVD);
        public static final VexMoveOp EVMOVQ = new VexMoveOp("EVMOVQ", VMOVQ);
        private final int opReverse;

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.opReverse = opReverse;
        }

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
            this.opReverse = opReverse;
        }

        private VexMoveOp(String opcode, VexMoveOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.opReverse = vexOp.opReverse;
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexMoveOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexMoveOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            this.emitVexOrEvex(asm, src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(this.isEvex, size));
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, Register mask) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, 0, 0);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(this.isEvex, size));
        }

        public void emitReverse(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            Register nds = this == VMOVSS || this == VMOVSD || this == EVMOVSS || this == EVMOVSD ? src : Register.None;
            this.emitVexOrEvex(asm, src, nds, dst, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.opReverse);
            asm.emitModRM(src, dst);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            Register nds = this == VMOVSS || this == VMOVSD || this == EVMOVSS || this == EVMOVSD ? src : Register.None;
            this.emitVexOrEvex(asm, dst, nds, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(this.isEvex, size));
        }
    }

    public static final class VexShiftOp
    extends VexRVMOp
    implements VexRRIOp {
        public static final VexShiftOp VPSRLW = new VexShiftOp("VPSRLW", 1, 1, 0, 209, 113, 2, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSRLD = new VexShiftOp("VPSRLD", 1, 1, 0, 210, 114, 2, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSRLQ = new VexShiftOp("VPSRLQ", 1, 1, 0, 211, 115, 2, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 1);
        public static final VexShiftOp VPSRAW = new VexShiftOp("VPSRAW", 1, 1, 0, 225, 113, 4, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSRAD = new VexShiftOp("VPSRAD", 1, 1, 0, 226, 114, 4, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSLLW = new VexShiftOp("VPSLLW", 1, 1, 0, 241, 113, 6, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSLLD = new VexShiftOp("VPSLLD", 1, 1, 0, 242, 114, 6, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 0);
        public static final VexShiftOp VPSLLQ = new VexShiftOp("VPSLLQ", 1, 1, 0, 243, 115, 6, VEXOpAssertion.AVX1_AVX2_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 1);
        public static final VexShiftOp EVPSRLW = new VexShiftOp("EVPSRLW", VPSRLW);
        public static final VexShiftOp EVPSRLD = new VexShiftOp("EVPSRLD", VPSRLD);
        public static final VexShiftOp EVPSRLQ = new VexShiftOp("EVPSRLQ", VPSRLQ);
        public static final VexShiftOp EVPSRAW = new VexShiftOp("EVPSRAW", VPSRAW);
        public static final VexShiftOp EVPSRAD = new VexShiftOp("EVPSRAD", VPSRAD);
        public static final VexShiftOp EVPSRAQ = new VexShiftOp("EVPSRAQ", 1, 1, 1, 226, 114, 4, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.M128, 1, true);
        public static final VexShiftOp EVPSLLW = new VexShiftOp("EVPSLLW", VPSLLW);
        public static final VexShiftOp EVPSLLD = new VexShiftOp("EVPSLLD", VPSLLD);
        public static final VexShiftOp EVPSLLQ = new VexShiftOp("EVPSLLQ", VPSLLQ);
        private final int immOp;
        private final int r;

        private VexShiftOp(String opcode, int pp, int mmmmm, int w, int op, int immOp, int r, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.immOp = immOp;
            this.r = r;
        }

        private VexShiftOp(String opcode, int pp, int mmmmm, int w, int op, int immOp, int r, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
            this.immOp = immOp;
            this.r = r;
        }

        private VexShiftOp(String opcode, VexShiftOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.immOp = vexOp.immOp;
            this.r = vexOp.r;
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexShiftOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexShiftOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emitVexOrEvex(asm, null, dst, src, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.immOp);
            asm.emitModRM(this.r, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexShiftImmOp
    extends VexOp
    implements VexRRIOp {
        public static final VexShiftImmOp VPSLLDQ = new VexShiftImmOp("VPSLLDQ", 1, 1, 0, 115, 7, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftImmOp VPSRLDQ = new VexShiftImmOp("VPSRLDQ", 1, 1, 0, 115, 3, VEXOpAssertion.AVX1_AVX2_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexShiftImmOp EVPSLLDQ = new VexShiftImmOp("EVPSLLDQ", VPSLLDQ);
        public static final VexShiftImmOp EVPSRLDQ = new VexShiftImmOp("EVPSRLDQ", VPSRLDQ);
        private final int r;

        private VexShiftImmOp(String opcode, int pp, int mmmmm, int w, int op, int r, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.r = r;
        }

        private VexShiftImmOp(String opcode, VexShiftImmOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.r = vexOp.r;
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexShiftImmOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexShiftImmOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emitVexOrEvex(asm, null, dst, src, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(this.r, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexMoveMaskOp
    extends VexGeneralMoveOp {
        public static final VexMoveMaskOp KMOVW = new VexMoveMaskOp("KMOVW", 0, 0, 1, 0, 0, VEXOpAssertion.AVX512F_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVB = new VexMoveMaskOp("KMOVB", 1, 1, 1, 0, 0, VEXOpAssertion.AVX512DQ_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVQ = new VexMoveMaskOp("KMOVQ", 0, 3, 1, 1, 1, VEXOpAssertion.AVX512BW_CPU_OR_MASK);
        public static final VexMoveMaskOp KMOVD = new VexMoveMaskOp("KMOVD", 1, 3, 1, 1, 0, VEXOpAssertion.AVX512BW_CPU_OR_MASK);
        private static final int OP_K_FROM_K_MEM = 144;
        private static final int OP_MEM_FROM_K = 145;
        private static final int OP_K_FROM_CPU = 146;
        private static final int OP_CPU_FROM_K = 147;
        private final int ppCPU;
        private final int wCPU;

        private VexMoveMaskOp(String opcode, int pp, int ppCPU, int mmmmm, int w, int wCPU, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, 144, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, w);
            this.ppCPU = ppCPU;
            this.wCPU = wCPU;
        }

        @Override
        public VexMoveMaskOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexMoveMaskOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            GraalError.guarantee(!AMD64BaseAssembler.inRC(AMD64.CPU, dst) || !AMD64BaseAssembler.inRC(AMD64.CPU, src), "source and destination can't both be CPU registers");
            int actualOp = VexMoveMaskOp.op(dst, src);
            int actualPP = this.pp(dst, src);
            int actualW = this.w(dst, src);
            this.emitVexOrEvex(asm, dst, Register.None, src, size, actualPP, this.mmmmm, actualW, this.wEvex);
            asm.emitByte(actualOp);
            asm.emitModRM(dst, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            GraalError.guarantee(AMD64BaseAssembler.inRC(AMD64.MASK, src), "source must be a mask register");
            this.emitVexOrEvex(asm, src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(145);
            asm.emitOperandHelper(src, dst, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            GraalError.guarantee(AMD64BaseAssembler.inRC(AMD64.MASK, dst), "destination must be a mask register");
            this.emitVexOrEvex(asm, dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(144);
            asm.emitOperandHelper(dst, src, 0);
        }

        private static int op(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.MASK, dst)) {
                if (AMD64BaseAssembler.inRC(AMD64.MASK, src)) {
                    return 144;
                }
                assert (AMD64BaseAssembler.inRC(AMD64.CPU, src));
                return 146;
            }
            assert (AMD64BaseAssembler.inRC(AMD64.CPU, dst) && AMD64BaseAssembler.inRC(AMD64.MASK, src)) : String.valueOf(src) + " " + String.valueOf(dst);
            return 147;
        }

        private int pp(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.CPU, dst) || AMD64BaseAssembler.inRC(AMD64.CPU, src)) {
                return this.ppCPU;
            }
            return this.pp;
        }

        private int w(Register dst, Register src) {
            if (AMD64BaseAssembler.inRC(AMD64.CPU, dst) || AMD64BaseAssembler.inRC(AMD64.CPU, src)) {
                return this.wCPU;
            }
            return this.w;
        }
    }

    public static class VexRROp
    extends VexOp {
        public static final VexRROp VMASKMOVDQU = new VexRROp("VMASKMOVDQU", 1, 1, 0, 247, VEXOpAssertion.AVX1_128ONLY);
        public static final VexRROp EVPBROADCASTB_GPR = new VexRROp("EVPBROADCASTB_GPR", 1, 2, 0, 122, VEXOpAssertion.XMM_CPU_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.T1S_8BIT, 0, true);
        public static final VexRROp EVPBROADCASTW_GPR = new VexRROp("EVPBROADCASTW_GPR", 1, 2, 0, 123, VEXOpAssertion.XMM_CPU_AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.T1S_16BIT, 0, true);
        public static final VexRROp EVPBROADCASTD_GPR = new VexRROp("EVPBROADCASTD_GPR", 1, 2, 0, 124, VEXOpAssertion.XMM_CPU_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);
        public static final VexRROp EVPBROADCASTQ_GPR = new VexRROp("EVPBROADCASTQ_GPR", 1, 2, 1, 124, VEXOpAssertion.XMM_CPU_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, true);
        public static final VexRROp KTESTB = new VexRROp("KTESTB", 1, 1, 0, 153, VEXOpAssertion.AVX512DQ_MASK_L0);
        public static final VexRROp KTESTW = new VexRROp("KTESTW", 0, 1, 0, 153, VEXOpAssertion.AVX512DQ_MASK_L0);
        public static final VexRROp KTESTD = new VexRROp("KTESTD", 1, 1, 1, 153, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexRROp KTESTQ = new VexRROp("KTESTQ", 0, 1, 1, 153, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexRROp KORTESTB = new VexRROp("KORTESTB", 1, 1, 0, 152, VEXOpAssertion.AVX512DQ_MASK_L0);
        public static final VexRROp KORTESTW = new VexRROp("KORTESTW", 0, 1, 0, 152, VEXOpAssertion.AVX512F_MASK_L0);
        public static final VexRROp KORTESTD = new VexRROp("KORTESTD", 1, 1, 1, 152, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexRROp KORTESTQ = new VexRROp("KORTESTQ", 0, 1, 1, 152, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexRROp KNOTB = new VexRROp("KNOTB", 1, 1, 0, 68, VEXOpAssertion.AVX512DQ_MASK_L0);
        public static final VexRROp KNOTW = new VexRROp("KNOTW", 0, 1, 0, 68, VEXOpAssertion.AVX512F_MASK_L0);
        public static final VexRROp KNOTD = new VexRROp("KNOTD", 1, 1, 1, 68, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexRROp KNOTQ = new VexRROp("KNOTQ", 0, 1, 1, 68, VEXOpAssertion.AVX512BW_MASK_L0);

        protected VexRROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        protected VexRROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            this(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, false);
        }

        protected VexRROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, w);
        }

        @Override
        public VexRROp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRROp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }
    }

    public static class VexMaskRRIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexMaskRRIOp KSHIFTRB = new VexMaskRRIOp("KSHIFTRB", 1, 3, 0, 48, VEXOpAssertion.AVX512DQ_MASK_L0);
        public static final VexMaskRRIOp KSHIFTRW = new VexMaskRRIOp("KSHIFTRW", 1, 3, 1, 48, VEXOpAssertion.AVX512F_MASK_L0);
        public static final VexMaskRRIOp KSHIFTRD = new VexMaskRRIOp("KSHIFTRD", 1, 3, 0, 49, VEXOpAssertion.AVX512BW_MASK_L0);
        public static final VexMaskRRIOp KSHIFTRQ = new VexMaskRRIOp("KSHIFTRQ", 1, 3, 1, 49, VEXOpAssertion.AVX512BW_MASK_L0);

        protected VexMaskRRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emitVexOrEvex(asm, dst, Register.None, src, Register.None, size, this.pp, this.mmmmm, this.w, this.wEvex, 0, 0);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexMROp
    extends VexRROp {
        public static final VexMROp EVPCOMPRESSD = new VexMROp("EVPCOMPRESSD", 1, 2, 0, 139, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);
        public static final VexMROp EVPMOVWB = new VexMROp("EVPMOVWB", 2, 2, 0, 48, VEXOpAssertion.AVX512BW_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0, true);
        public static final VexMROp EVPMOVDB = new VexMROp("EVPMOVDB", 2, 2, 0, 49, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0, true);
        public static final VexMROp EVPMOVQB = new VexMROp("EVPMOVQB", 2, 2, 0, 50, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.OVM, 0, true);
        public static final VexMROp EVPMOVDW = new VexMROp("EVPMOVDW", 2, 2, 0, 51, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0, true);
        public static final VexMROp EVPMOVQW = new VexMROp("EVPMOVQW", 2, 2, 0, 52, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.QVM, 0, true);
        public static final VexMROp EVPMOVQD = new VexMROp("EVPMOVQD", 2, 2, 0, 53, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.HVM, 0, true);

        private VexMROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        @Override
        public VexMROp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexMROp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, src, Register.None, dst, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(this.isEvex, size));
        }
    }

    public static final class EvexRMIExtendOp
    extends VexRMIOp {
        public static final EvexRMIExtendOp EVPROLQ = new EvexRMIExtendOp("EVPROLQ", 1, 1, 1, 114, 1, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        private final int ext;

        private EvexRMIExtendOp(String opcode, int pp, int mmmmm, int w, int op, int ext, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, true);
            this.ext = ext;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, dst, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, src);
            asm.emitByte(imm8);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, dst, src, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(this.ext, src, 1, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexFloatCompareOp
    extends VexOp {
        public static final VexFloatCompareOp VCMPPS = new VexFloatCompareOp("VCMPPS", 0, 1, 0, 194, VEXOpAssertion.AVX1);
        public static final VexFloatCompareOp VCMPPD = new VexFloatCompareOp("VCMPPD", 1, 1, 0, 194, VEXOpAssertion.AVX1);
        public static final VexFloatCompareOp VCMPSS = new VexFloatCompareOp("VCMPSS", 2, 1, 0, 194, VEXOpAssertion.AVX1_128ONLY);
        public static final VexFloatCompareOp VCMPSD = new VexFloatCompareOp("VCMPSD", 3, 1, 0, 194, VEXOpAssertion.AVX1_128ONLY);
        public static final VexFloatCompareOp EVCMPPS = new VexFloatCompareOp("EVCMPPS", 0, 1, 0, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0, VCMPPS);
        public static final VexFloatCompareOp EVCMPPD = new VexFloatCompareOp("EVCMPPD", 1, 1, 1, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1, VCMPPD);
        public static final VexFloatCompareOp EVCMPSS = new VexFloatCompareOp("EVCMPSS", 2, 1, 0, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, VCMPSS);
        public static final VexFloatCompareOp EVCMPSD = new VexFloatCompareOp("EVCMPSD", 3, 1, 1, 194, VEXOpAssertion.MASK_XMM_XMM_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, VCMPSD);

        private VexFloatCompareOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        private VexFloatCompareOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, VexFloatCompareOp vexCounterPart) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, true);
            this.variant = vexCounterPart;
            assert (vexCounterPart.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexCounterPart);
            vexCounterPart.variant = this;
        }

        @Override
        public VexFloatCompareOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexFloatCompareOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Predicate p) {
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(p.imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Predicate p) {
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(p.imm8);
        }

        public static enum Predicate {
            EQ_OQ(0),
            LT_OS(1),
            LE_OS(2),
            UNORD_Q(3),
            NEQ_UQ(4),
            NLT_US(5),
            NLE_US(6),
            ORD_Q(7),
            EQ_UQ(8),
            NGE_US(9),
            NGT_US(10),
            FALSE_OQ(11),
            NEQ_OQ(12),
            GE_OS(13),
            GT_OS(14),
            TRUE_UQ(15),
            EQ_OS(16),
            LT_OQ(17),
            LE_OQ(18),
            UNORD_S(19),
            NEQ_US(20),
            NLT_UQ(21),
            NLE_UQ(22),
            ORD_S(23),
            EQ_US(24),
            NGE_UQ(25),
            NGT_UQ(26),
            FALSE_OS(27),
            NEQ_OS(28),
            GE_OQ(29),
            GT_OQ(30),
            TRUE_US(31);

            private int imm8;

            private Predicate(int imm8) {
                this.imm8 = imm8;
            }

            public static Predicate getPredicate(Condition condition, boolean unorderedIsTrue) {
                if (unorderedIsTrue) {
                    switch (condition) {
                        case EQ: {
                            return EQ_UQ;
                        }
                        case NE: {
                            return NEQ_UQ;
                        }
                        case LT: {
                            return NGE_UQ;
                        }
                        case LE: {
                            return NGT_UQ;
                        }
                        case GT: {
                            return NLE_UQ;
                        }
                        case GE: {
                            return NLT_UQ;
                        }
                    }
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)condition);
                }
                switch (condition) {
                    case EQ: {
                        return EQ_OQ;
                    }
                    case NE: {
                        return NEQ_OQ;
                    }
                    case LT: {
                        return LT_OQ;
                    }
                    case LE: {
                        return LE_OQ;
                    }
                    case GT: {
                        return GT_OQ;
                    }
                    case GE: {
                        return GE_OQ;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)condition);
            }
        }
    }

    public static final class VexMaskedMoveOp
    extends VexOp {
        public static final VexMaskedMoveOp VMASKMOVPS = new VexMaskedMoveOp("VMASKMOVPS", 1, 2, 0, 44, 46, VEXOpAssertion.AVX1);
        public static final VexMaskedMoveOp VMASKMOVPD = new VexMaskedMoveOp("VMASKMOVPD", 1, 2, 0, 45, 47, VEXOpAssertion.AVX1);
        public static final VexMaskedMoveOp VPMASKMOVD = new VexMaskedMoveOp("VPMASKMOVD", 1, 2, 0, 140, 142, VEXOpAssertion.AVX2);
        public static final VexMaskedMoveOp VPMASKMOVQ = new VexMaskedMoveOp("VPMASKMOVQ", 1, 2, 1, 140, 142, VEXOpAssertion.AVX2);
        private final int opReverse;

        private VexMaskedMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.opReverse = opReverse;
        }

        @Override
        public VexMaskedMoveOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexMaskedMoveOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, AMD64Address src) {
            this.emitVexOrEvex(asm, dst, mask, src, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register mask, Register src) {
            this.emitVexOrEvex(asm, src, mask, dst, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(this.isEvex, size));
        }
    }

    public static final class VexGeneralPurposeRMOp
    extends VexRMOp {
        public static final VexGeneralPurposeRMOp BLSI = new VexGeneralPurposeRMOp("BLSI", 0, 2, 0, 243, 3, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSMSK = new VexGeneralPurposeRMOp("BLSMSK", 0, 2, 0, 243, 2, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSR = new VexGeneralPurposeRMOp("BLSR", 0, 2, 0, 243, 1, VEXOpAssertion.BMI1);
        private final int ext;

        private VexGeneralPurposeRMOp(String opcode, int pp, int mmmmm, int w, int op, int ext, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.ext = ext;
        }

        @Override
        public VexGeneralPurposeRMOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexGeneralPurposeRMOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, null, dst, src, mask, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            this.emit(asm, size, dst, src, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, null, dst, src, mask, AVXKind.AVXSize.XMM, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(this.ext, src, 0);
        }
    }

    public static final class EvexGatherOp
    extends VexOp {
        public static final EvexGatherOp EVPGATHERDD = new EvexGatherOp("EVPGATHERDD", 1, 2, 144, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);
        public static final EvexGatherOp EVPGATHERQD = new EvexGatherOp("EVPGATHERQD", 1, 2, 145, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);
        public static final EvexGatherOp EVPGATHERDQ = new EvexGatherOp("EVPGATHERDQ", 1, 2, 144, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, true);
        public static final EvexGatherOp EVPGATHERQQ = new EvexGatherOp("EVPGATHERQQ", 1, 2, 145, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, true);
        public static final EvexGatherOp EVGATHERDPD = new EvexGatherOp("EVGATHERDPD", 1, 2, 146, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, true);
        public static final EvexGatherOp EVGATHERQPD = new EvexGatherOp("EVGATHERQPD", 1, 2, 147, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1, true);
        public static final EvexGatherOp EVGATHERDPS = new EvexGatherOp("EVGATHERDPS", 1, 2, 146, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);
        public static final EvexGatherOp EVGATHERQPS = new EvexGatherOp("EVGATHERQPS", 1, 2, 147, VEXOpAssertion.AVX512F_VL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0, true);

        protected EvexGatherOp(String opcode, int pp, int mmmmm, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, wEvex, op, assertion, evexTuple, wEvex, isEvex);
        }

        @Override
        public EvexGatherOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (EvexGatherOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask) {
            this.emit(asm, size, dst, address, mask, 0, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask, int z, int b) {
            this.emitVexOrEvex(asm, dst, Register.None, address, mask, size, this.pp, this.mmmmm, this.w, this.wEvex, z, b);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, address, 0);
        }
    }

    public static final class VexGatherOp
    extends VexOp {
        public static final VexGatherOp VPGATHERDD = new VexGatherOp("VPGATHERDD", 1, 2, 0, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQD = new VexGatherOp("VPGATHERQD", 1, 2, 0, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERDQ = new VexGatherOp("VPGATHERDQ", 1, 2, 1, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQQ = new VexGatherOp("VPGATHERQQ", 1, 2, 1, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPD = new VexGatherOp("VGATHERDPD", 1, 2, 1, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPD = new VexGatherOp("VGATHERQPD", 1, 2, 1, 147, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPS = new VexGatherOp("VGATHERDPS", 1, 2, 0, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPS = new VexGatherOp("VGATHERQPS", 1, 2, 0, 147, VEXOpAssertion.AVX2);

        protected VexGatherOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        @Override
        public VexGatherOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexGatherOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask) {
            this.emitVexOrEvex(asm, dst, mask, address, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, address, 0);
        }
    }

    public static final class VexAESOp
    extends VexRVMOp {
        public static final VexAESOp VAESENC = new VexAESOp("VAESENC", 220, VEXOpAssertion.AES_AVX1_128ONLY);
        public static final VexAESOp VAESENCLAST = new VexAESOp("VAESENCLAST", 221, VEXOpAssertion.AES_AVX1_128ONLY);
        public static final VexAESOp VAESDEC = new VexAESOp("VAESDEC", 222, VEXOpAssertion.AES_AVX1_128ONLY);
        public static final VexAESOp VAESDECLAST = new VexAESOp("VAESDECLAST", 223, VEXOpAssertion.AES_AVX1_128ONLY);

        private VexAESOp(String opcode, int op, VEXOpAssertion assertion) {
            super(opcode, 1, 2, 0, op, assertion);
        }

        @Override
        public VexAESOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexAESOp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, Register result, Register state, Register key) {
            this.emit(asm, AVXKind.AVXSize.XMM, result, state, key);
        }

        public void emit(AMD64Assembler asm, Register result, Register state, AMD64Address keyLocation) {
            this.emit(asm, AVXKind.AVXSize.XMM, result, state, keyLocation);
        }
    }

    public static final class VexRVMConvertOp
    extends VexRVMOp {
        public static final VexRVMConvertOp VCVTSD2SS = new VexRVMConvertOp("VCVTSD2SS", 3, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMConvertOp VCVTSS2SD = new VexRVMConvertOp("VCVTSS2SD", 2, 1, 0, 90, VEXOpAssertion.AVX1_AVX512F_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSI2SD = new VexRVMConvertOp("VCVTSI2SD", 3, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSQ2SD = new VexRVMConvertOp("VCVTSQ2SD", 3, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMConvertOp VCVTSI2SS = new VexRVMConvertOp("VCVTSI2SS", 2, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexRVMConvertOp VCVTSQ2SS = new VexRVMConvertOp("VCVTSQ2SS", 2, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU_AVX1_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexRVMConvertOp EVCVTSD2SS = new VexRVMConvertOp("EVCVTSD2SS", VCVTSD2SS);
        public static final VexRVMConvertOp EVCVTSS2SD = new VexRVMConvertOp("EVCVTSS2SD", VCVTSS2SD);
        public static final VexRVMConvertOp EVCVTSI2SD = new VexRVMConvertOp("EVCVTSI2SD", VCVTSI2SD);
        public static final VexRVMConvertOp EVCVTSQ2SD = new VexRVMConvertOp("EVCVTSQ2SD", VCVTSQ2SD);
        public static final VexRVMConvertOp EVCVTSI2SS = new VexRVMConvertOp("EVCVTSI2SS", VCVTSI2SS);
        public static final VexRVMConvertOp EVCVTSQ2SS = new VexRVMConvertOp("EVCVTSQ2SS", VCVTSQ2SS);

        private VexRVMConvertOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        private VexRVMConvertOp(String opcode, VexRVMConvertOp vexOp) {
            super(opcode, vexOp.pp, vexOp.mmmmm, vexOp.w, vexOp.op, vexOp.assertion, vexOp.evexTuple, vexOp.wEvex, true);
            this.variant = vexOp;
            assert (vexOp.variant == null) : "found 2 EVEX variants for VEX instruction " + String.valueOf(vexOp);
            vexOp.variant = this;
        }

        @Override
        public VexRVMConvertOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRVMConvertOp)this.encodingLogic(encoding);
        }
    }

    public static class VexRVROp
    extends VexOp {
        public static final VexRVROp KANDW = new VexRVROp("KANDW", 0, 1, 0, 65, VEXOpAssertion.AVX512F_MASK_L1);
        public static final VexRVROp KANDB = new VexRVROp("KANDB", 1, 1, 0, 65, VEXOpAssertion.AVX512DQ_MASK_L1);
        public static final VexRVROp KANDQ = new VexRVROp("KANDQ", 0, 1, 1, 65, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KANDD = new VexRVROp("KANDD", 1, 1, 1, 65, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KANDNW = new VexRVROp("KANDNW", 0, 1, 0, 66, VEXOpAssertion.AVX512F_MASK_L1);
        public static final VexRVROp KANDNB = new VexRVROp("KANDNB", 1, 1, 0, 66, VEXOpAssertion.AVX512DQ_MASK_L1);
        public static final VexRVROp KANDNQ = new VexRVROp("KANDNQ", 0, 1, 1, 66, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KANDND = new VexRVROp("KANDND", 1, 1, 1, 66, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KORW = new VexRVROp("KORW", 0, 1, 0, 69, VEXOpAssertion.AVX512F_MASK_L1);
        public static final VexRVROp KORB = new VexRVROp("KORB", 1, 1, 0, 69, VEXOpAssertion.AVX512DQ_MASK_L1);
        public static final VexRVROp KORQ = new VexRVROp("KORQ", 0, 1, 1, 69, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KORD = new VexRVROp("KORD", 1, 1, 1, 69, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KXORW = new VexRVROp("KXORW", 0, 1, 0, 71, VEXOpAssertion.AVX512F_MASK_L1);
        public static final VexRVROp KXORB = new VexRVROp("KXORB", 1, 1, 0, 71, VEXOpAssertion.AVX512DQ_MASK_L1);
        public static final VexRVROp KXORQ = new VexRVROp("KXORQ", 0, 1, 1, 71, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KXORD = new VexRVROp("KXORD", 1, 1, 1, 71, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KXNORW = new VexRVROp("KXNORW", 0, 1, 0, 70, VEXOpAssertion.AVX512F_MASK_L1);
        public static final VexRVROp KXNORB = new VexRVROp("KXNORB", 1, 1, 0, 70, VEXOpAssertion.AVX512DQ_MASK_L1);
        public static final VexRVROp KXNORQ = new VexRVROp("KXNORQ", 0, 1, 1, 70, VEXOpAssertion.AVX512BW_MASK_L1);
        public static final VexRVROp KXNORD = new VexRVROp("KXNORD", 1, 1, 1, 70, VEXOpAssertion.AVX512BW_MASK_L1);

        protected VexRVROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public VexRVROp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRVROp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, Register dst, Register src1, Register src2) {
            this.emitVexOrEvex(asm, dst, src1, src2, AVXKind.AVXSize.YMM, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }
    }

    public static class VexRVMROp
    extends VexOp {
        public static final VexRVMROp VPBLENDVB = new VexRVMROp("VPBLENDVB", 1, 3, 0, 76, VEXOpAssertion.AVX1_2);
        public static final VexRVMROp VBLENDVPS = new VexRVMROp("VBLENDVPS", 1, 3, 0, 74, VEXOpAssertion.AVX1);
        public static final VexRVMROp VBLENDVPD = new VexRVMROp("VBLENDVPD", 1, 3, 0, 75, VEXOpAssertion.AVX1);

        protected VexRVMROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public VexRVMROp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (VexRVMROp)this.encodingLogic(encoding);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, Register src2) {
            GraalError.guarantee(mask.getRegisterCategory().equals((Object)AMD64.XMM), "%s", (Object)mask);
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(mask.encoding() << 4);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, AMD64Address src2) {
            GraalError.guarantee(mask.getRegisterCategory().equals((Object)AMD64.XMM), "%s", (Object)mask);
            this.emitVexOrEvex(asm, dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(this.isEvex, size));
            asm.emitByte(mask.encoding() << 4);
        }
    }

    public static final class EvexRMIOp
    extends VexRMIOp {
        public static final EvexRMIOp EVFPCLASSSS = new EvexRMIOp("EVFPCLASS", 1, 3, 0, 103, VEXOpAssertion.MASK_XMM_AVX512DQ_128, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final EvexRMIOp EVFPCLASSSD = new EvexRMIOp("EVFPCLASD", 1, 3, 1, 103, VEXOpAssertion.MASK_XMM_AVX512DQ_128, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);

        private EvexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, true);
        }

        @Override
        public EvexRMIOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return (EvexRMIOp)this.encodingLogic(encoding);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8) {
            this.emit(asm, size, dst, src, imm8, Register.None, 0, 0);
        }
    }

    public static interface VexRRIOp {
        public void emit(AMD64Assembler var1, AVXKind.AVXSize var2, Register var3, Register var4, int var5);
    }

    public static abstract class VexGeneralMoveOp
    extends VexRMOp {
        protected VexGeneralMoveOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        protected VexGeneralMoveOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, isEvex);
        }

        public abstract void emit(AMD64Assembler var1, AVXKind.AVXSize var2, AMD64Address var3, Register var4);
    }

    public static class VexOp {
        protected final int pp;
        protected final int mmmmm;
        protected final int w;
        protected final int op;
        private final String opcode;
        protected final VEXOpAssertion assertion;
        protected final AMD64BaseAssembler.EVEXTuple evexTuple;
        protected final int wEvex;
        protected final boolean isEvex;
        protected VexOp variant;

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex, boolean isEvex) {
            this.pp = pp;
            this.mmmmm = mmmmm;
            this.w = w;
            this.op = op;
            this.opcode = opcode;
            this.assertion = assertion;
            this.evexTuple = evexTuple;
            this.wEvex = wEvex;
            this.isEvex = isEvex;
            assert (isEvex == opcode.startsWith("E")) : "EVEX instructions should start with the letter 'E'! (" + opcode + ")";
            this.variant = null;
        }

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            this(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex, false);
        }

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        public boolean isSupported(AMD64Assembler asm, AVXKind.AVXSize size) {
            return this.assertion.isValid(asm.getFeatures(), size);
        }

        protected final VexOp encodingLogic(AMD64SIMDInstructionEncoding encoding) {
            GraalError.guarantee(this.variant != null || this.isEvex == (encoding == AMD64SIMDInstructionEncoding.EVEX), "%s has no %s variant!", (Object)this, (Object)encoding);
            GraalError.guarantee(this.variant == null || this.isEvex != this.variant.isEvex, "Only pairs of VEX and EVEX instructions are allowed. (%s, %s)", (Object)this, (Object)this.variant);
            return switch (encoding.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (this.isEvex) {
                        yield this.variant;
                    }
                    yield this;
                }
                case 1 -> this.isEvex ? this : this.variant;
            };
        }

        public VexOp encoding(AMD64SIMDInstructionEncoding encoding) {
            return this.encodingLogic(encoding);
        }

        public String toString() {
            return this.opcode;
        }

        protected final int getDisp8Scale(boolean useEvex, AVXKind.AVXSize size) {
            return useEvex ? this.evexTuple.getDisp8ScalingFactor(size) : 1;
        }

        protected final void emitVexOrEvex(AMD64Assembler asm, Register dst, Register nds, Register src, AVXKind.AVXSize size, int actualPP, int actualMMMMM, int actualW, int actualWEvex) {
            this.emitVexOrEvex(asm, dst, nds, src, Register.None, size, actualPP, actualMMMMM, actualW, actualWEvex, 0, 0);
        }

        protected final void emitVexOrEvex(AMD64Assembler asm, Register dst, Register nds, Register src, Register opmask, AVXKind.AVXSize size, int actualPP, int actualMMMMM, int actualW, int actualWEvex, int z, int b) {
            AVXKind.AVXSize avxSize = size;
            if (avxSize == AVXKind.AVXSize.DWORD || avxSize == AVXKind.AVXSize.QWORD) {
                avxSize = AVXKind.AVXSize.XMM;
            }
            if (this.isEvex) {
                this.checkEvex(asm, avxSize, dst, opmask, z, nds, src, b);
                asm.evexPrefix(dst, opmask, nds, src, avxSize, actualPP, actualMMMMM, actualWEvex, z, b);
            } else {
                this.checkVex(asm, avxSize, dst, opmask, z, nds, src, b);
                asm.emitVEX(AMD64BaseAssembler.getLFlag(avxSize), actualPP, actualMMMMM, actualW, AMD64BaseAssembler.getRXB(dst, src), nds.isValid() ? nds.encoding() : 0);
            }
        }

        protected final void emitVexOrEvex(AMD64Assembler asm, Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size, int actualPP, int actualMMMMM, int actualW, int actualWEvex) {
            this.emitVexOrEvex(asm, dst, nds, src, Register.None, size, actualPP, actualMMMMM, actualW, actualWEvex, 0, 0);
        }

        protected final void emitVexOrEvex(AMD64Assembler asm, Register dst, Register nds, AMD64Address src, Register opmask, AVXKind.AVXSize size, int actualPP, int actualMMMMM, int actualW, int actualWEvex, int z, int b) {
            if (this.isEvex) {
                this.checkEvex(asm, size, dst, opmask, z, nds, null, b);
                asm.evexPrefix(dst, opmask, nds, src, size, actualPP, actualMMMMM, actualWEvex, z, b);
            } else {
                this.checkVex(asm, size, dst, opmask, z, nds, null, b);
                asm.emitVEX(AMD64BaseAssembler.getLFlag(size), actualPP, actualMMMMM, actualW, AMD64BaseAssembler.getRXB(dst, src), nds.isValid() ? nds.encoding() : 0);
            }
        }

        private void checkVex(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, int z, Register nds, Register src, int b) {
            GraalError.guarantee(mask.equals((Object)Register.None) && z == 0, "{%s}%s", (Object)(mask.equals((Object)Register.None) ? mask.name : "K0"), (Object)(z == 0 ? "" : " {z}"));
            GraalError.guarantee(b == 0, "illegal EVEX.b");
            GraalError.guarantee(dst == null || !AMD64BaseAssembler.isAVX512Register(dst) && AMD64Assembler.categoryContains(this.assertion.rCategory, dst), "instruction %s illegal operand %s", (Object)this.opcode, (Object)dst);
            GraalError.guarantee(!nds.isValid() || !AMD64BaseAssembler.isAVX512Register(nds) && AMD64Assembler.categoryContains(this.assertion.vCategory, nds), "instruction %s illegal operand %s", (Object)this.opcode, (Object)nds);
            GraalError.guarantee(src == null || !AMD64BaseAssembler.isAVX512Register(src) && AMD64Assembler.categoryContains(this.assertion.mCategory, src), "instruction %s illegal operand %s", (Object)this.opcode, (Object)src);
            GraalError.guarantee(this.assertion.vexFeatures.isValid(asm.getFeatures(), size), "instruction %s not supported for size %s", (Object)this.opcode, (Object)size);
        }

        private void checkEvex(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, int z, Register nds, Register src, int b) {
            GraalError.guarantee(mask.isValid() || z == 0, "illegal EVEX.z for no mask");
            GraalError.guarantee(src == null || b == 0, "illegal EVEX.b for register operand %s", (Object)src);
            GraalError.guarantee(dst == null || AMD64Assembler.categoryContains(this.assertion.rCategory, dst), "instruction %s illegal operand %s", (Object)this.opcode, (Object)dst);
            GraalError.guarantee(!nds.isValid() || AMD64Assembler.categoryContains(this.assertion.vCategory, nds), "instruction %s illegal operand %s", (Object)this.opcode, (Object)nds);
            GraalError.guarantee(src == null || AMD64Assembler.categoryContains(this.assertion.mCategory, src), "instruction %s illegal operand %s", (Object)this.opcode, (Object)src);
            GraalError.guarantee(this.assertion.evexFeatures.isValid(asm.getFeatures(), size), "instruction %s not supported for size %s", (Object)this.opcode, (Object)size);
        }
    }

    public static enum AMD64SIMDInstructionEncoding {
        VEX,
        EVEX;


        public static AMD64SIMDInstructionEncoding forFeatures(EnumSet<AMD64.CPUFeature> features) {
            return AMD64BaseAssembler.supportsFullAVX512(features) ? EVEX : VEX;
        }
    }

    public static enum VectorFeatureAssertion {
        AVX1_AVX512F_VL(VEXOpAssertion.AVX1_AVX512F_VL),
        AVX1_AVX512DQ_VL(VEXOpAssertion.AVX1_AVX512DQ_VL),
        AVX1_AVX2_AVX512F_VL(VEXOpAssertion.AVX1_AVX2_AVX512F_VL),
        AVX1_AVX2_AVX512BW_VL(VEXOpAssertion.AVX1_AVX2_AVX512BW_VL),
        AVX1_AVX2_AVX512DQ_VL(VEXOpAssertion.AVX1_AVX2_AVX512DQ_VL),
        AVX2_AVX512F_VL(VEXOpAssertion.AVX2_AVX512F_VL),
        AVX2_AVX512BW_VL(VEXOpAssertion.AVX2_AVX512BW_VL),
        AVX512F_VL(VEXOpAssertion.AVX512F_VL),
        AVX512BW_VL(VEXOpAssertion.AVX512BW_VL),
        AVX512DQ_VL(VEXOpAssertion.AVX512DQ_VL),
        FMA(VEXOpAssertion.FMA);

        private final VEXOpAssertion opAssertion;

        private VectorFeatureAssertion(VEXOpAssertion opAssertion) {
            this.opAssertion = opAssertion;
        }

        public boolean supports(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size) {
            return this.opAssertion.isValid(features, size);
        }
    }

    private static enum VEXOpAssertion {
        AVX1(VEXFeatureAssertion.AVX1, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_2(VEXFeatureAssertion.AVX1_AVX2, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX2(VEXFeatureAssertion.AVX2, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_128ONLY(VEXFeatureAssertion.AVX1_128, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_256ONLY(VEXFeatureAssertion.AVX1_256, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX2_256ONLY(VEXFeatureAssertion.AVX2_256, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        XMM_CPU(VEXFeatureAssertion.AVX1_128, null, AMD64.XMM, null, AMD64.CPU),
        XMM_XMM_CPU(VEXFeatureAssertion.AVX1_128, null, AMD64.XMM, AMD64.XMM, AMD64.CPU),
        CPU_XMM(VEXFeatureAssertion.AVX1_128, null, AMD64.CPU, null, AMD64.XMM),
        AVX1_CPU_XMM(VEXFeatureAssertion.AVX1, null, AMD64.CPU, null, AMD64.XMM),
        AVX1_2_CPU_XMM(VEXFeatureAssertion.AVX1_AVX2, null, AMD64.CPU, null, AMD64.XMM),
        BMI1(VEXFeatureAssertion.BMI1, null, AMD64.CPU, AMD64.CPU, AMD64.CPU),
        BMI2(VEXFeatureAssertion.BMI2, null, AMD64.CPU, AMD64.CPU, AMD64.CPU),
        FMA(VEXFeatureAssertion.FMA, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        FMA_AVX512F_128ONLY(VEXFeatureAssertion.FMA_128, EVEXFeatureAssertion.AVX512F_128, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX512F_CPU_OR_XMM(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512F_128, CPU_OR_XMM, null, CPU_OR_XMM),
        XMM_CPU_AVX1_AVX512BW_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512BW_128, AMD64.XMM, null, AMD64.CPU),
        XMM_CPU_AVX1_AVX512DQ_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512DQ_128, AMD64.XMM, null, AMD64.CPU),
        CPU_XMM_AVX1_AVX512F_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512F_128, AMD64.CPU, null, AMD64.XMM),
        XMM_XMM_CPU_AVX1_AVX512F_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512F_128, AMD64.XMM, AMD64.XMM, AMD64.CPU),
        XMM_XMM_CPU_AVX1_AVX512BW_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512BW_128, AMD64.XMM, AMD64.XMM, AMD64.CPU),
        XMM_XMM_CPU_AVX1_AVX512DQ_128ONLY(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512DQ_128, AMD64.XMM, AMD64.XMM, AMD64.CPU),
        XMM_CPU_AVX512BW_VL(null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.XMM, null, AMD64.CPU),
        XMM_CPU_AVX512F_VL(null, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, null, AMD64.CPU),
        AVX1_AVX512F_VL(VEXFeatureAssertion.AVX1, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX512DQ_VL(VEXFeatureAssertion.AVX1, EVEXFeatureAssertion.AVX512F_DQ_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX512F_128(VEXFeatureAssertion.AVX1_128, EVEXFeatureAssertion.AVX512F_128, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX512F_VL_256_512(VEXFeatureAssertion.AVX1_256, EVEXFeatureAssertion.AVX512F_VL_256_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX2_AVX512F_VL(VEXFeatureAssertion.AVX1_AVX2, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX2_AVX512BW_VL(VEXFeatureAssertion.AVX1_AVX2, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX1_AVX2_AVX512DQ_VL(VEXFeatureAssertion.AVX1_AVX2, EVEXFeatureAssertion.AVX512F_DQ_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX2_AVX512F_VL(VEXFeatureAssertion.AVX2, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX2_AVX512BW_VL(VEXFeatureAssertion.AVX2, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX2_AVX512F_VL_256_512(VEXFeatureAssertion.AVX2_256, EVEXFeatureAssertion.AVX512F_VL_256_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512F_VL(null, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512BW_VL(null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512DQ_VL(null, EVEXFeatureAssertion.AVX512F_DQ_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512F_VL_256_512(null, EVEXFeatureAssertion.AVX512F_VL_256_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512DQ_VL_256_512(null, EVEXFeatureAssertion.AVX512F_DQ_VL_256_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512F_512ONLY(null, EVEXFeatureAssertion.AVX512F_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512DQ_512ONLY(null, EVEXFeatureAssertion.AVX512F_DQ_512, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512_VBMI_VL(null, EVEXFeatureAssertion.AVX512_VBMI_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AVX512F_CPU_OR_MASK(VEXFeatureAssertion.AVX512F_L0, null, CPU_OR_MASK, null, CPU_OR_MASK),
        AVX512BW_CPU_OR_MASK(VEXFeatureAssertion.AVX512BW_L0, null, CPU_OR_MASK, null, CPU_OR_MASK),
        AVX512DQ_CPU_OR_MASK(VEXFeatureAssertion.AVX512DQ_L0, null, CPU_OR_MASK, null, CPU_OR_MASK),
        AVX512F_MASK_L0(VEXFeatureAssertion.AVX512F_L0, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        AVX512DQ_MASK_L0(VEXFeatureAssertion.AVX512DQ_L0, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        AVX512BW_MASK_L0(VEXFeatureAssertion.AVX512BW_L0, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        AVX512F_MASK_L1(VEXFeatureAssertion.AVX512F_L1, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        AVX512DQ_MASK_L1(VEXFeatureAssertion.AVX512DQ_L1, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        AVX512BW_MASK_L1(VEXFeatureAssertion.AVX512BW_L1, null, AMD64.MASK, AMD64.MASK, AMD64.MASK),
        MASK_XMM_XMM_AVX512F_VL(null, EVEXFeatureAssertion.AVX512F_VL, AMD64.MASK, AMD64.XMM, AMD64.XMM),
        MASK_XMM_XMM_AVX512BW_VL(null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.MASK, AMD64.XMM, AMD64.XMM),
        MASK_XMM_XMM_AVX512F_128(null, EVEXFeatureAssertion.AVX512F_128, AMD64.MASK, AMD64.XMM, AMD64.XMM),
        MASK_XMM_AVX512BW_VL(null, EVEXFeatureAssertion.AVX512F_BW_VL, AMD64.MASK, null, AMD64.XMM),
        MASK_XMM_AVX512DQ_VL(null, EVEXFeatureAssertion.AVX512F_DQ_VL, AMD64.MASK, null, AMD64.XMM),
        MASK_XMM_AVX512DQ_128(null, EVEXFeatureAssertion.AVX512DQ_128, AMD64.MASK, null, AMD64.XMM),
        CLMUL_AVX1_AVX512F_VL(VEXFeatureAssertion.CLMUL_AVX1, EVEXFeatureAssertion.CLMUL_AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        AES_AVX1_128ONLY(VEXFeatureAssertion.AVX1_AES_128, null, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        GFNI_AVX1_AVX512F_VL(VEXFeatureAssertion.GFNI_AVX1, EVEXFeatureAssertion.GFNI_AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM),
        F16C_AVX512F_VL(VEXFeatureAssertion.F16C, EVEXFeatureAssertion.AVX512F_VL, AMD64.XMM, AMD64.XMM, AMD64.XMM);

        private final VEXFeatureAssertion vexFeatures;
        private final EVEXFeatureAssertion evexFeatures;
        private final Register.RegisterCategory rCategory;
        private final Register.RegisterCategory vCategory;
        private final Register.RegisterCategory mCategory;

        private VEXOpAssertion(VEXFeatureAssertion vexFeatures, EVEXFeatureAssertion evexFeatures, Register.RegisterCategory rCategory, Register.RegisterCategory vCategory, Register.RegisterCategory mCategory) {
            this.vexFeatures = vexFeatures;
            this.evexFeatures = evexFeatures;
            this.rCategory = rCategory;
            this.vCategory = vCategory;
            this.mCategory = mCategory;
        }

        private boolean isValid(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size) {
            return this.vexFeatures != null && this.vexFeatures.isValid(features, size) || this.evexFeatures != null && this.evexFeatures.isValid(features, size);
        }
    }

    private static enum EVEXFeatureAssertion {
        AVX512F_128(EnumSet.of(AMD64.CPUFeature.AVX512F), null, null),
        AVX512BW_128(EnumSet.of(AMD64.CPUFeature.AVX512BW), null, null),
        AVX512DQ_128(EnumSet.of(AMD64.CPUFeature.AVX512DQ), null, null),
        AVX512F_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512F_CD_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD)),
        AVX512F_DQ_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_BW_VL(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW)),
        AVX512F_VL_256_512(null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512F_DQ_VL_256_512(null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_DQ_512(null, null, EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ)),
        AVX512F_512(null, null, EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512_VBMI_VL(EnumSet.of(AMD64.CPUFeature.AVX512_VBMI, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512_VBMI, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512_VBMI)),
        CLMUL_AVX512F_VL(EnumSet.of(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.CLMUL), EnumSet.of(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.CLMUL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.CLMUL)),
        GFNI_AVX512F_VL(EnumSet.of(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.GFNI), EnumSet.of(AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.GFNI), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.GFNI));

        private final EnumSet<AMD64.CPUFeature> l128features;
        private final EnumSet<AMD64.CPUFeature> l256features;
        private final EnumSet<AMD64.CPUFeature> l512features;

        private EVEXFeatureAssertion(EnumSet<AMD64.CPUFeature> l128features, EnumSet<AMD64.CPUFeature> l256features, EnumSet<AMD64.CPUFeature> l512features) {
            this.l128features = l128features;
            this.l256features = l256features;
            this.l512features = l512features;
        }

        public boolean isValid(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size) {
            return switch (size) {
                case AVXKind.AVXSize.XMM -> {
                    if (this.l128features != null && features.containsAll(this.l128features)) {
                        yield true;
                    }
                    yield false;
                }
                case AVXKind.AVXSize.YMM -> {
                    if (this.l256features != null && features.containsAll(this.l256features)) {
                        yield true;
                    }
                    yield false;
                }
                case AVXKind.AVXSize.ZMM -> {
                    if (this.l512features != null && features.containsAll(this.l512features)) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(size);
            };
        }
    }

    private static enum VEXFeatureAssertion {
        AVX1(EnumSet.of(AMD64.CPUFeature.AVX), EnumSet.of(AMD64.CPUFeature.AVX)),
        AVX2(EnumSet.of(AMD64.CPUFeature.AVX2), EnumSet.of(AMD64.CPUFeature.AVX2)),
        AVX1_AVX2(EnumSet.of(AMD64.CPUFeature.AVX), EnumSet.of(AMD64.CPUFeature.AVX2)),
        AVX1_128(EnumSet.of(AMD64.CPUFeature.AVX), null),
        AVX2_128(EnumSet.of(AMD64.CPUFeature.AVX2), null),
        AVX1_256(null, EnumSet.of(AMD64.CPUFeature.AVX)),
        AVX2_256(null, EnumSet.of(AMD64.CPUFeature.AVX2)),
        BMI1(EnumSet.of(AMD64.CPUFeature.BMI1), null),
        BMI2(EnumSet.of(AMD64.CPUFeature.BMI2), null),
        FMA(EnumSet.of(AMD64.CPUFeature.FMA), EnumSet.of(AMD64.CPUFeature.FMA)),
        FMA_128(EnumSet.of(AMD64.CPUFeature.FMA), null),
        AVX1_AES_128(EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AES), null),
        F16C(EnumSet.of(AMD64.CPUFeature.F16C), EnumSet.of(AMD64.CPUFeature.F16C)),
        CLMUL_AVX1(EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.CLMUL), EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.CLMUL)),
        GFNI_AVX1(EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.GFNI), EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.GFNI)),
        AVX512F_L0(EnumSet.of(AMD64.CPUFeature.AVX512F), null),
        AVX512BW_L0(EnumSet.of(AMD64.CPUFeature.AVX512BW), null),
        AVX512DQ_L0(EnumSet.of(AMD64.CPUFeature.AVX512DQ), null),
        AVX512F_L1(null, EnumSet.of(AMD64.CPUFeature.AVX512F)),
        AVX512BW_L1(null, EnumSet.of(AMD64.CPUFeature.AVX512BW)),
        AVX512DQ_L1(null, EnumSet.of(AMD64.CPUFeature.AVX512DQ));

        private final EnumSet<AMD64.CPUFeature> l128Features;
        private final EnumSet<AMD64.CPUFeature> l256Features;

        private VEXFeatureAssertion(EnumSet<AMD64.CPUFeature> l128Features, EnumSet<AMD64.CPUFeature> l256Features) {
            this.l128Features = l128Features;
            this.l256Features = l256Features;
        }

        public boolean isValid(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize size) {
            return switch (size) {
                case AVXKind.AVXSize.XMM -> {
                    if (this.l128Features != null && features.containsAll(this.l128Features)) {
                        yield true;
                    }
                    yield false;
                }
                case AVXKind.AVXSize.YMM -> {
                    if (this.l256Features != null && features.containsAll(this.l256Features)) {
                        yield true;
                    }
                    yield false;
                }
                case AVXKind.AVXSize.ZMM -> false;
                default -> throw GraalError.shouldNotReachHereUnexpectedValue(size);
            };
        }
    }

    public static final class AMD64Z0Op
    extends AMD64Op {
        public static final AMD64Z0Op PUSHFQ = new AMD64Z0Op("PUSHFQ", 156);

        protected AMD64Z0Op(String opcode, int op) {
            this(opcode, 0, 0, op, null);
        }

        protected AMD64Z0Op(String opcode, int prefix1, int prefix2, int op, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, OpAssertion.NoOperandAssertion, feature);
        }

        public void emit(AMD64Assembler asm) {
            this.emitOpcode(asm, AMD64BaseAssembler.OperandSize.BYTE, AMD64BaseAssembler.getRXB(null, (Register)null), 0, 0);
        }
    }

    private static enum PreferredNDS {
        NONE,
        DST,
        SRC;


        public Register getNds(Register reg, AMD64Address address) {
            switch (this.ordinal()) {
                case 1: 
                case 2: {
                    return reg;
                }
            }
            return Register.None;
        }

        public Register getNds(Register dst, Register src) {
            switch (this.ordinal()) {
                case 1: {
                    return dst;
                }
                case 2: {
                    return src;
                }
            }
            return Register.None;
        }
    }

    public static abstract class AMD64RROp
    extends AMD64Op {
        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, dstIsByte, srcIsByte, assertion, feature);
        }

        public abstract void emit(AMD64Assembler var1, AMD64BaseAssembler.OperandSize var2, Register var3, Register var4);
    }

    public static class AMD64ImmOp
    extends AMD64Op {
        private final boolean immIsByte;

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion) {
            this(opcode, immIsByte, prefix, op, assertion, null);
        }

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, 0, prefix, op, assertion, feature);
            this.immIsByte = immIsByte;
        }

        protected final void emitImmediate(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int imm) {
            if (this.immIsByte) {
                assert (NumUtil.isUByte(imm) || NumUtil.isByte(imm)) : imm;
                asm.emitByte(imm);
            } else {
                size.emitImmediate(asm, imm);
            }
        }

        public final int immediateSize(AMD64BaseAssembler.OperandSize size) {
            if (this.immIsByte) {
                return 1;
            }
            return size.immediateSize();
        }
    }

    public static class AMD64Op {
        private final String opcode;
        protected final int prefix1;
        protected final int prefix2;
        protected final int op;
        final boolean dstIsByte;
        final boolean srcIsByte;
        private final OpAssertion assertion;
        private final AMD64.CPUFeature feature;

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, prefix1, prefix2, op, assertion == OpAssertion.ByteAssertion, assertion == OpAssertion.ByteAssertion, assertion, feature);
        }

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            this.opcode = opcode;
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
            this.op = op;
            this.dstIsByte = dstIsByte;
            this.srcIsByte = srcIsByte;
            this.assertion = assertion;
            this.feature = feature;
        }

        protected final void emitOpcode(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int rxb, int dstEnc, int srcEnc) {
            if (this.prefix1 != 0) {
                asm.emitByte(this.prefix1);
            }
            if (size.getSizePrefix() != 0) {
                asm.emitByte(size.getSizePrefix());
            }
            int rexPrefix = 0x40 | rxb;
            if (size == AMD64BaseAssembler.OperandSize.QWORD) {
                rexPrefix |= 8;
            }
            if (rexPrefix != 64 || this.dstIsByte && dstEnc >= 4 || this.srcIsByte && srcEnc >= 4) {
                asm.emitByte(rexPrefix);
            }
            if (this.prefix2 > 255) {
                asm.emitShort(this.prefix2);
            } else if (this.prefix2 > 0) {
                asm.emitByte(this.prefix2);
            }
            asm.emitByte(this.op);
        }

        protected final boolean verify(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (this.feature == null || asm.supports(this.feature)) : String.format("unsupported feature %s required for %s", this.feature, this.opcode);
            assert (this.assertion.checkOperands(this, size, resultReg, inputReg)) : "Operands must verify for " + String.valueOf(inputReg) + " " + String.valueOf(resultReg);
            return true;
        }

        public AMD64BaseAssembler.OperandSize[] getAllowedSizes() {
            return this.assertion.allowedSizes;
        }

        protected final boolean isSSEInstruction() {
            if (this.feature == null) {
                return false;
            }
            switch (this.feature) {
                case SSE: 
                case SSE2: 
                case SSE3: 
                case SSSE3: 
                case SSE4A: 
                case SSE4_1: 
                case SSE4_2: 
                case AES: 
                case CLMUL: 
                case GFNI: {
                    return true;
                }
            }
            return false;
        }

        public final OpAssertion getAssertion() {
            return this.assertion;
        }

        public String toString() {
            return this.opcode;
        }
    }

    private static final class OpAssertion
    extends Enum<OpAssertion> {
        public static final /* enum */ OpAssertion NoOperandAssertion = new OpAssertion(null, null, new AMD64BaseAssembler.OperandSize[0]);
        public static final /* enum */ OpAssertion ByteAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE);
        public static final /* enum */ OpAssertion ByteOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion DwordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrQwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion QwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS, AMD64BaseAssembler.OperandSize.SD, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion ScalarFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS, AMD64BaseAssembler.OperandSize.SD);
        public static final /* enum */ OpAssertion PackedFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion SingleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS);
        public static final /* enum */ OpAssertion DoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SD);
        public static final /* enum */ OpAssertion PackedSingleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PS);
        public static final /* enum */ OpAssertion PackedDoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion PackedDoubleIntToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion PackedDoubleFloatToIntAssertion = new OpAssertion(AMD64.CPU, AMD64.XMM, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion IntToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion DwordToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD);
        public static final /* enum */ OpAssertion QwordToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatToIntAssertion = new OpAssertion(AMD64.CPU, AMD64.XMM, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        private final Register.RegisterCategory resultCategory;
        private final Register.RegisterCategory inputCategory;
        private final AMD64BaseAssembler.OperandSize[] allowedSizes;
        private static final /* synthetic */ OpAssertion[] $VALUES;

        public static OpAssertion[] values() {
            return (OpAssertion[])$VALUES.clone();
        }

        public static OpAssertion valueOf(String name) {
            return Enum.valueOf(OpAssertion.class, name);
        }

        private OpAssertion(Register.RegisterCategory resultCategory, Register.RegisterCategory inputCategory, AMD64BaseAssembler.OperandSize ... allowedSizes) {
            this.resultCategory = resultCategory;
            this.inputCategory = inputCategory;
            this.allowedSizes = allowedSizes;
        }

        protected boolean checkOperands(AMD64Op op, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (resultReg == null || this.resultCategory.equals((Object)resultReg.getRegisterCategory())) : "invalid result register " + String.valueOf(resultReg) + " used in " + String.valueOf(op);
            assert (inputReg == null || this.inputCategory.equals((Object)inputReg.getRegisterCategory())) : "invalid input register " + String.valueOf(inputReg) + " used in " + String.valueOf(op);
            for (AMD64BaseAssembler.OperandSize s : this.allowedSizes) {
                if (size != s) continue;
                return true;
            }
            assert (false) : "invalid operand size " + String.valueOf((Object)size) + " used in " + String.valueOf(op);
            return false;
        }

        private static /* synthetic */ OpAssertion[] $values() {
            return new OpAssertion[]{NoOperandAssertion, ByteAssertion, ByteOrLargerAssertion, WordOrLargerAssertion, DwordOrLargerAssertion, WordOrQwordAssertion, QwordAssertion, FloatAssertion, ScalarFloatAssertion, PackedFloatAssertion, SingleAssertion, DoubleAssertion, PackedSingleAssertion, PackedDoubleAssertion, PackedDoubleIntToFloatAssertion, PackedDoubleFloatToIntAssertion, IntToFloatAssertion, DwordToFloatAssertion, QwordToFloatAssertion, FloatToIntAssertion};
        }

        static {
            $VALUES = OpAssertion.$values();
        }
    }
}

