/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.asm.aarch64;

import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.aarch64.AArch64Kind;

public class ASIMDKind {
    public static AArch64Kind getASIMDKind(AArch64Kind base, int length) {
        AArch64Kind returnKind = null;
        int returnLength = Integer.MAX_VALUE;
        for (AArch64Kind kind : AArch64Kind.values()) {
            if (kind.getScalar() != base) continue;
            int kindLength = kind.getVectorLength();
            if (kindLength == length) {
                return kind;
            }
            if (kindLength <= length || kindLength >= returnLength) continue;
            returnKind = kind;
            returnLength = kindLength;
        }
        if (returnKind == null) {
            throw GraalError.shouldNotReachHere(String.format("unsupported vector kind: %d x %s", length, base));
        }
        return returnKind;
    }
}

