import os
from configparser import ConfigParser

def read_solweig_config(config_file_path):
    if not os.path.exists(config_file_path):
        raise ValueError("The config file '{}' could not be found.".format(config_file_path))

    config = ConfigParser()
    config.read(config_file_path)
    return config.defaults()


'''
input: 
TargetDict: dictonary with all relevant inputs
refdir = outputfolder      
'''

def write_solweig_config(configDict, refdir):
    f = open(refdir, "w")

    f.write("\n")
    f.write("[DEFAULT]\n")
    f.write("\n")
    f.write("### INPUTS ###\n")
    f.write("# output path\n")
    f.write("output_dir={}\n".format(configDict['output_dir']))
    f.write("# working path\n")
    f.write("working_dir={}\n".format(configDict['working_dir']))
    f.write("# parameters json file\n")
    f.write("para_json_path={}\n".format(configDict['para_json_path']))
    f.write("# Input ground and building dsm\n")
    f.write("filepath_dsm={}\n".format(configDict['filepath_dsm']))
    f.write("# Input vegetation dsm\n")
    f.write("filepath_cdsm={}\n".format(configDict['filepath_cdsm']))
    f.write("# Input trunkzone vegetation dsm\n")
    f.write("filepath_tdsm={}\n".format(configDict['filepath_tdsm']))    
    f.write("# Input Digital Elevation Model\n")
    f.write("filepath_dem={}\n".format(configDict['filepath_dem'])) 
    f.write("# Input Land cover dataset\n")
    f.write("filepath_lc={}\n".format(configDict['filepath_lc'])) 
    f.write("# Input wall height raster\n")
    f.write("filepath_wh={}\n".format(configDict['filepath_wh'])) 
    f.write("# Input wall aspect raster\n")
    f.write("filepath_wa={}\n".format(configDict['filepath_wa']))
    f.write("# Skyview factor files\n")
    f.write("input_svf={}\n".format(configDict['input_svf']))
    f.write("# Input file for anisotrophic sky\n")
    f.write("input_aniso={}\n".format(configDict['input_aniso']))
    f.write("# Point of Interest file for ground\n")
    f.write("poi_file={}\n".format(configDict['poi_file']))
    f.write("poi_field={}\n".format(configDict['poi_field']))  
    f.write("# Input file for wall temperture scheme (Wallenberg et al. 2025)\n")
    f.write("input_wall={}\n".format(configDict['input_wall']))     
    f.write("# Point of Interest file for walls\n")
    f.write("woi_file={}\n".format(configDict['woi_file']))
    f.write("woi_field={}\n".format(configDict['woi_field']))   
    f.write("# input meteorolgical file (i.e. forcing file)\n")
    f.write("input_met={}\n".format(configDict['input_met']))            
    f.write("\n")
    f.write("## input settings ##\n")
    f.write("# dates\n")
    f.write("# option to execute solweig outside of osgeo/qgis environment\n")
    f.write("standalone={}\n".format(configDict['standalone'])) 
    f.write("# estimate diffuse and global shortwve radiation from global radiation (1)\n")
    f.write("onlyglobal={}\n".format(configDict['onlyglobal'])) 
    f.write("# use vegetation scheme (lindberg and grimmond, 2011, TAAC)\n")
    f.write("usevegdem={}\n".format(configDict['usevegdem'])) 
    f.write("# consider leaf on trees full year (1)\n")
    f.write("conifer_bool={}\n".format(configDict['conifer_bool'])) 
    f.write("# consider person as a cylinder (1) or a box (0)\n")
    f.write("cyl={}\n".format(configDict['cyl'])) 
    f.write("# Location of model domain\n")
    f.write("lat={}\n".format(configDict['lat'])) 
    f.write("lon={}\n".format(configDict['lon'])) 
    f.write("#utc time given in meteorological forcing file\n")
    f.write("utc={}\n".format(configDict['utc'])) 
    f.write("# scale between horisontal and vertical resolution (1 = 1 meter pixel reolution, 0.5 = 2)\n")
    f.write("scale={}\n".format(configDict['scale'])) 
    f.write("# Set to 1 if an EPW file is used as meteorological forcing data\n")
    f.write("useepwfile={}\n".format(configDict['useepwfile']))
    f.write("# land cover scheme activated (1) (Lindberg et al. 2016 UC)\n")
    f.write("landcover={}\n".format(configDict['landcover']))
    f.write("# use dem and dsm to identify building pixels (0) else, land cover will be used (0)\n")
    f.write("demforbuild={}\n".format(configDict['demforbuild']))    
    f.write("# use anisotrphic sky (Wallenberg et al. XXXX and Wallenberg et al. XXXX)\n")
    f.write("aniso={}\n".format(configDict['aniso']))
    f.write("# use wall surface temperature scheme (Wallenberg et al. 2025, GMD)\n")
    f.write("wallscheme={}\n".format(configDict['wallscheme']))
    f.write("# If building materials is not included in lc, then this is used for all buildings (Wood, Brick or Concrete)\n")
    f.write("walltype={}\n".format(configDict['walltype']))
    f.write("# output settings\n")
    f.write("outputtmrt={}\n".format(configDict['outputtmrt']))
    f.write("outputkup={}\n".format(configDict['outputkup']))
    f.write("outputkdown={}\n".format(configDict['outputkdown']))
    f.write("outputlup={}\n".format(configDict['outputlup']))
    f.write("outputldown={}\n".format(configDict['outputldown']))
    f.write("outputsh={}\n".format(configDict['outputsh']))    
    f.write("savebuild={}\n".format(configDict['savebuild']))   
    f.write("outputkdiff={}\n".format(configDict['outputkdiff']))       
    f.write("outputtreeplanter={}\n".format(configDict['outputtreeplanter']))   
    f.write("wallnetcdf={}\n".format(configDict['wallnetcdf']))   
    f.write("#-------------------------------------------------------\n")
    f.write("# dates - used if an EPW-file is used\n")    
    f.write("#-------------------------------------------------------\n")
    f.write("# year,month,day,hour	## the start date/time for period of interest\n")
    f.write("date1={}\n".format(configDict['date1']))
    f.write("# year,month,day,hour	# end date/time\n")
    f.write("date2={}\n".format(configDict['date2']))
    f.write("\n")

    f.close()
