/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.proj4;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.cts.parser.proj.ProjKeyParameters;

public class Proj4Parser {
    static final Pattern regex = Pattern.compile("[ ]\\+|\\s<>");

    public static Map<String, String> readParameters(String projText) {
        if (projText == null || projText.isEmpty()) {
            throw new IllegalArgumentException("Please set a correct proj4 representation");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String[] tokens = regex.split(projText);
        if (tokens[0].startsWith("+proj")) {
            for (String token : tokens) {
                String key;
                String[] keyValue = token.split("=");
                if (keyValue.length == 2) {
                    key = Proj4Parser.formatKey(keyValue[0]);
                    ProjKeyParameters.checkUnsupported(key);
                    params.put(key, keyValue[1]);
                    continue;
                }
                key = Proj4Parser.formatKey(token);
                ProjKeyParameters.checkUnsupported(key);
                params.put(key, null);
            }
            return params;
        }
        throw new IllegalArgumentException("The proj4 representation must startwith +proj");
    }

    private static String formatKey(String key) {
        String formatKey = key;
        if (key.startsWith("+")) {
            formatKey = key.substring(1);
        }
        return formatKey;
    }
}

