/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.postgis_jts;

import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.h2gis.postgis_jts.DataSourceWrapper;
import org.postgresql.ds.PGPoolingDataSource;

public class PostGISDBFactory {
    public static String JDBC_DATABASE_NAME = "databaseName";
    public static String JDBC_DATASOURCE_NAME = "dataSourceName";
    public static String JDBC_PASSWORD = "password";
    public static String JDBC_PORT_NUMBER = "portNumber";
    public static String JDBC_SERVER_NAME = "serverName";
    public static String JDBC_USER = "user";
    public static String JDBC_URL = "url";
    private static AtomicInteger dataSourceCount = new AtomicInteger(0);

    public static DataSource createDataSource(Properties properties) throws SQLException {
        PGPoolingDataSource dataSource;
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.getProperty(JDBC_DATASOURCE_NAME) == null) {
            properties.setProperty(JDBC_DATASOURCE_NAME, PostGISDBFactory.class.getSimpleName() + "_" + dataSourceCount.getAndAdd(1));
        }
        if ((dataSource = PGPoolingDataSource.getDataSource((String)properties.getProperty(JDBC_DATASOURCE_NAME))) == null) {
            dataSource = new PGPoolingDataSource();
            dataSource.setDataSourceName(properties.getProperty(JDBC_DATASOURCE_NAME));
            String url = properties.getProperty(JDBC_URL);
            if (url != null) {
                dataSource.setUrl(url);
            }
            dataSource.setPortNumber(Integer.valueOf(properties.getProperty(JDBC_PORT_NUMBER, Integer.toString(dataSource.getPortNumber()))).intValue());
            dataSource.setServerName(properties.getProperty(JDBC_SERVER_NAME, dataSource.getServerName()));
            dataSource.setUser(properties.getProperty(JDBC_USER, dataSource.getUser()));
            dataSource.setPassword(properties.getProperty(JDBC_PASSWORD, dataSource.getPassword()));
            dataSource.setDatabaseName(properties.getProperty(JDBC_DATABASE_NAME, dataSource.getDatabaseName()));
        }
        return new DataSourceWrapper((DataSource)dataSource);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Driver createDriver(Properties properties) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

