/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.osgi;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.h2gis.api.Function;
import org.h2gis.functions.factory.H2GISFunctions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTracker
extends ServiceTracker<Function, Function> {
    private DataSource dataSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionTracker.class);

    public FunctionTracker(DataSource dataSource, BundleContext bundleContext) {
        super(bundleContext, Function.class, null);
        this.dataSource = dataSource;
    }

    public void open() {
        super.open();
    }

    public Function addingService(ServiceReference<Function> reference) {
        if (reference.getBundle().getBundleId() != this.context.getBundle().getBundleId()) {
            Function function = (Function)super.addingService(reference);
            try (Connection connection = this.dataSource.getConnection();){
                H2GISFunctions.registerFunction((Statement)connection.createStatement(), (Function)function, (String)"");
            }
            catch (SQLException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            return function;
        }
        return (Function)super.addingService(reference);
    }

    public void removedService(ServiceReference<Function> reference, Function service) {
        if (reference.getBundle().getBundleId() != this.context.getBundle().getBundleId()) {
            try (Connection connection = this.dataSource.getConnection();){
                H2GISFunctions.unRegisterFunction((Statement)connection.createStatement(), (Function)service);
            }
            catch (SQLException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            super.removedService(reference, (Object)service);
        }
    }
}

