/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.api.ScalarFunction;
import org.h2gis.network.functions.GraphFunction;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.javanetworkanalyzer.analyzers.UnweightedGraphAnalyzer;
import org.javanetworkanalyzer.analyzers.WeightedGraphAnalyzer;
import org.javanetworkanalyzer.data.VCent;
import org.javanetworkanalyzer.data.VUCent;
import org.javanetworkanalyzer.data.VWCent;
import org.javanetworkanalyzer.model.EdgeCent;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.javanetworkanalyzer.progress.DefaultProgressMonitor;
import org.javanetworkanalyzer.progress.ProgressMonitor;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ST_GraphAnalysis
extends GraphFunction
implements ScalarFunction {
    protected static final int BATCH_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(ST_GraphAnalysis.class);
    public static final String REMARKS = "`ST_GraphAnalysis` calculates closeness and betweenness centrality for nodes,\nas well as betweenness centrality for edges. Possible signatures:\n* `ST_GraphAnalysis('input_edges', 'o[ - eo]')`\n* `ST_GraphAnalysis('input_edges', 'o[ - eo]', 'w')`\n\nwhere\n* `input_edges` = Edges table produced by `ST_Graph` from table `input`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected).\n  Required if global orientation is directed or reversed.\n* `w` = Name of column containing edge weights as doubles\n\n**WARNING**: If ST_GraphAnalysis is called on a graph with more than one\n(strongly) connected component, all closeness centrality scores will be zero.\nSee ST_ConnectedComponents.\n";

    public ST_GraphAnalysis() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "doGraphAnalysis";
    }

    public static boolean doGraphAnalysis(Connection connection, String inputTable, String orientation) throws SQLException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ST_GraphAnalysis.doGraphAnalysis(connection, inputTable, orientation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doGraphAnalysis(Connection connection, String inputTable, String orientation, String weight) throws SQLException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        TableLocation tableName = TableUtilities.parseInputTable((Connection)connection, (String)inputTable);
        TableLocation nodesName = TableUtilities.suffixTableLocation((TableLocation)tableName, (String)"_NODE_CENT");
        TableLocation edgesName = TableUtilities.suffixTableLocation((TableLocation)tableName, (String)"_EDGE_CENT");
        try {
            ST_GraphAnalysis.createTables(connection, nodesName, edgesName);
            KeyedGraph graph = ST_GraphAnalysis.doAnalysisAndReturnGraph(connection, inputTable, orientation, weight);
            ST_GraphAnalysis.storeNodeCentrality(connection, nodesName, graph);
            ST_GraphAnalysis.storeEdgeCentrality(connection, edgesName, graph);
        }
        catch (SQLException e) {
            LOGGER.error("Problem creating centrality tables.");
            try (Statement statement = connection.createStatement();){
                statement.execute("DROP TABLE IF EXISTS " + nodesName);
                statement.execute("DROP TABLE IF EXISTS " + edgesName);
            }
            return false;
        }
        return true;
    }

    private static KeyedGraph doAnalysisAndReturnGraph(Connection connection, String inputTable, String orientation, String weight) throws SQLException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        KeyedGraph graph = ST_GraphAnalysis.prepareGraph(connection, inputTable, orientation, weight, weight == null ? VUCent.class : VWCent.class, EdgeCent.class);
        DefaultProgressMonitor pm = new DefaultProgressMonitor();
        UnweightedGraphAnalyzer analyzer = weight == null ? new UnweightedGraphAnalyzer((Graph)graph, (ProgressMonitor)pm) : new WeightedGraphAnalyzer((WeightedGraph)graph, (ProgressMonitor)pm);
        analyzer.computeAll();
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTables(Connection connection, TableLocation nodesName, TableLocation edgesName) throws SQLException {
        try (Statement st = connection.createStatement();){
            st.execute("CREATE TABLE " + nodesName + "(NODE_ID INTEGER PRIMARY KEY, BETWEENNESS DOUBLE, CLOSENESS DOUBLE);");
            st.execute("CREATE TABLE " + edgesName + "(EDGE_ID INTEGER PRIMARY KEY, BETWEENNESS DOUBLE);");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeNodeCentrality(Connection connection, TableLocation nodesName, KeyedGraph graph) throws SQLException {
        PreparedStatement nodeSt = connection.prepareStatement("INSERT INTO " + nodesName + " VALUES(?,?,?)");
        try {
            connection.setAutoCommit(false);
            int count = 0;
            for (VCent v : graph.vertexSet()) {
                nodeSt.setInt(1, v.getID());
                nodeSt.setDouble(2, v.getBetweenness());
                nodeSt.setDouble(3, v.getCloseness());
                nodeSt.addBatch();
                if (++count < 100) continue;
                nodeSt.executeBatch();
                connection.commit();
                nodeSt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                nodeSt.executeBatch();
                connection.commit();
                nodeSt.clearBatch();
            }
        }
        finally {
            connection.setAutoCommit(true);
            nodeSt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEdgeCentrality(Connection connection, TableLocation edgesName, KeyedGraph graph) throws SQLException {
        PreparedStatement edgeSt = connection.prepareStatement("INSERT INTO " + edgesName + " VALUES(?,?)");
        try {
            connection.setAutoCommit(false);
            int count = 0;
            for (EdgeCent e : graph.edgeSet()) {
                edgeSt.setInt(1, e.getID());
                edgeSt.setDouble(2, e.getBetweenness());
                edgeSt.addBatch();
                if (++count < 100) continue;
                edgeSt.executeBatch();
                connection.commit();
                edgeSt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                edgeSt.executeBatch();
                connection.commit();
                edgeSt.clearBatch();
            }
        }
        finally {
            connection.setAutoCommit(true);
            edgeSt.close();
        }
    }
}

