/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2gis.functions.spatial.aggregate.ST_Accum;
import org.h2gis.functions.spatial.convert.ST_ToMultiLine;
import org.h2gis.functions.spatial.mesh.FullConvexHull;
import org.h2gis.utilities.GeometryMetaData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.poly2tri.Poly2Tri;
import org.poly2tri.geometry.polygon.PolygonPoint;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationAlgorithm;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;
import org.poly2tri.triangulation.point.TPoint;
import org.poly2tri.triangulation.sets.ConstrainedPointSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelaunayData {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelaunayData.class);
    private boolean isInput2D;
    private GeometryFactory gf;
    private Triangulatable convertedInput = null;
    private MathContext mathContext = MathContext.DECIMAL64;

    private double r(double v) {
        return new BigDecimal(v).round(this.mathContext).doubleValue();
    }

    private org.poly2tri.geometry.polygon.Polygon makePolygon(LineString lineString) {
        PolygonPoint[] points = new PolygonPoint[lineString.getNumPoints() - 1];
        for (int idPoint = 0; idPoint < points.length; ++idPoint) {
            Coordinate point = lineString.getCoordinateN(idPoint);
            points[idPoint] = new PolygonPoint(this.r(point.x), this.r(point.y), Double.isNaN(point.getZ()) ? 0.0 : this.r(point.getZ()));
        }
        return new org.poly2tri.geometry.polygon.Polygon(points);
    }

    private org.poly2tri.geometry.polygon.Polygon makePolygon(Polygon polygon) {
        org.poly2tri.geometry.polygon.Polygon poly = this.makePolygon((LineString)polygon.getExteriorRing());
        for (int idHole = 0; idHole < polygon.getNumInteriorRing(); ++idHole) {
            poly.addHole(this.makePolygon((LineString)polygon.getInteriorRingN(idHole)));
        }
        return poly;
    }

    private static Coordinate toJts(boolean is2d, org.poly2tri.geometry.primitives.Point pt) {
        if (is2d) {
            return new Coordinate(pt.getX(), pt.getY());
        }
        return new Coordinate(pt.getX(), pt.getY(), pt.getZ());
    }

    private int getMinDimension(GeometryCollection geometries) {
        int dimension = Integer.MAX_VALUE;
        for (int i = 0; i < geometries.getNumGeometries(); ++i) {
            dimension = Math.min(dimension, geometries.getGeometryN(i).getDimension());
        }
        if (dimension == Integer.MAX_VALUE) {
            dimension = -1;
        }
        return dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(Geometry geom, MODE mode) throws IllegalArgumentException {
        int dim;
        this.gf = geom.getFactory();
        this.convertedInput = null;
        int dimension = geom.getClass().getName().equals(GeometryCollection.class.getName()) ? this.getMinDimension((GeometryCollection)geom) : geom.getDimension();
        if (mode != MODE.TESSELLATION) {
            Geometry convexHull = new FullConvexHull(geom).getConvexHull();
            if (!(convexHull instanceof Polygon) || !convexHull.isValid()) return;
            if (geom.getClass().getName().equals(GeometryCollection.class.getName()) && dimension > 0) {
                try {
                    geom = ST_ToMultiLine.execute(geom).union();
                }
                catch (SQLException ex) {
                    throw new IllegalArgumentException(ex);
                }
                if (geom.getClass().getName().equals(GeometryCollection.class.getName())) {
                    throw new IllegalArgumentException("Delaunay does not support mixed geometry type");
                }
            }
            if (dimension > 0) {
                geom = ((Polygon)convexHull).getExteriorRing().union(geom);
            } else {
                ST_Accum accum = new ST_Accum();
                try {
                    accum.add(geom);
                    accum.add(convexHull);
                    geom = accum.getResult();
                }
                catch (SQLException ex) {
                    LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
        this.isInput2D = (dim = GeometryMetaData.getMetaData((Geometry)geom).dimension) == 2;
        this.convertedInput = null;
        if (mode == MODE.TESSELLATION) {
            if (!(geom instanceof Polygon)) throw new IllegalArgumentException("Only Polygon are accepted for tessellation");
            this.convertedInput = this.makePolygon((Polygon)geom);
            return;
        } else {
            this.addGeometry(geom);
        }
    }

    public void triangulate() {
        if (this.convertedInput != null) {
            Poly2Tri.triangulate((TriangulationAlgorithm)TriangulationAlgorithm.DTSweep, (Triangulatable)this.convertedInput);
        }
    }

    public MultiPolygon getTriangles() {
        if (this.convertedInput != null) {
            List delaunayTriangle = this.convertedInput.getTriangles();
            Polygon[] polygons = new Polygon[delaunayTriangle.size()];
            for (int idTriangle = 0; idTriangle < polygons.length; ++idTriangle) {
                TriangulationPoint[] pts = ((DelaunayTriangle)delaunayTriangle.get((int)idTriangle)).points;
                polygons[idTriangle] = this.gf.createPolygon(new Coordinate[]{DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)pts[0]), DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)pts[1]), DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)pts[2]), DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)pts[0])});
            }
            return this.gf.createMultiPolygon(polygons);
        }
        return this.gf.createMultiPolygon(new Polygon[0]);
    }

    public double get3DArea() {
        if (this.convertedInput != null) {
            List delaunayTriangle = this.convertedInput.getTriangles();
            double sum = 0.0;
            for (DelaunayTriangle triangle : delaunayTriangle) {
                sum += this.computeTriangleArea3D(triangle);
            }
            return sum;
        }
        return 0.0;
    }

    private double computeTriangleArea3D(DelaunayTriangle triangle) {
        TriangulationPoint[] points = triangle.points;
        TriangulationPoint p1 = points[0];
        TriangulationPoint p2 = points[1];
        TriangulationPoint p3 = points[2];
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double uz = p2.getZ() - p1.getZ();
        double vx = p3.getX() - p1.getX();
        double vy = p3.getY() - p1.getY();
        double vz = p3.getZ() - p1.getZ();
        if (Double.isNaN(uz) || Double.isNaN(vz)) {
            uz = 1.0;
            vz = 1.0;
        }
        double crossx = uy * vz - uz * vy;
        double crossy = uz * vx - ux * vz;
        double crossz = ux * vy - uy * vx;
        double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
        return Math.sqrt(absSq) / 2.0;
    }

    private void addSegment(Set<LineSegment> segmentHashMap, TriangulationPoint a, TriangulationPoint b) {
        LineSegment lineSegment = new LineSegment(DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)a), DelaunayData.toJts(this.isInput2D, (org.poly2tri.geometry.primitives.Point)b));
        lineSegment.normalize();
        segmentHashMap.add(lineSegment);
    }

    public MultiLineString getTrianglesSides() {
        List delaunayTriangle = this.convertedInput.getTriangles();
        HashSet<LineSegment> segmentHashMap = new HashSet<LineSegment>(delaunayTriangle.size());
        for (DelaunayTriangle triangle : delaunayTriangle) {
            TriangulationPoint[] pts = triangle.points;
            this.addSegment(segmentHashMap, pts[0], pts[1]);
            this.addSegment(segmentHashMap, pts[1], pts[2]);
            this.addSegment(segmentHashMap, pts[2], pts[0]);
        }
        LineString[] lineStrings = new LineString[segmentHashMap.size()];
        int i = 0;
        for (LineSegment lineSegment : segmentHashMap) {
            lineStrings[i++] = lineSegment.toGeometry(this.gf);
        }
        return this.gf.createMultiLineString(lineStrings);
    }

    private void addGeometry(Geometry geom) throws IllegalArgumentException {
        if (!geom.isValid()) {
            throw new IllegalArgumentException("Provided geometry is not valid !");
        }
        if (geom instanceof GeometryCollection) {
            HashMap<TriangulationPoint, Integer> pts = new HashMap<TriangulationPoint, Integer>(geom.getNumPoints());
            ArrayList<Integer> segments = new ArrayList<Integer>(pts.size());
            AtomicInteger pointsCount = new AtomicInteger(0);
            PointHandler pointHandler = new PointHandler(this, pts, pointsCount);
            LineStringHandler lineStringHandler = new LineStringHandler(this, pts, pointsCount, segments);
            for (int geomId = 0; geomId < geom.getNumGeometries(); ++geomId) {
                this.addSimpleGeometry(geom.getGeometryN(geomId), pointHandler, lineStringHandler);
            }
            int[] index = new int[segments.size()];
            for (int i = 0; i < index.length; ++i) {
                index[i] = (Integer)segments.get(i);
            }
            TriangulationPoint[] ptsArray = new TriangulationPoint[pointsCount.get()];
            for (Map.Entry entry : pts.entrySet()) {
                ptsArray[((Integer)entry.getValue()).intValue()] = (TriangulationPoint)entry.getKey();
            }
            pts.clear();
            this.convertedInput = new ConstrainedPointSet(Arrays.asList(ptsArray), index);
        } else {
            this.addGeometry((Geometry)geom.getFactory().createGeometryCollection(new Geometry[]{geom}));
        }
    }

    private void addSimpleGeometry(Geometry geom, PointHandler pointHandler, LineStringHandler lineStringHandler) throws IllegalArgumentException {
        if (geom instanceof Point) {
            geom.apply((CoordinateFilter)pointHandler);
        } else if (geom instanceof LineString) {
            lineStringHandler.reset();
            geom.apply((CoordinateFilter)lineStringHandler);
        } else if (geom instanceof Polygon) {
            Polygon polygon = (Polygon)geom;
            lineStringHandler.reset();
            polygon.getExteriorRing().apply((CoordinateFilter)lineStringHandler);
            for (int idHole = 0; idHole < polygon.getNumInteriorRing(); ++idHole) {
                lineStringHandler.reset();
                polygon.getInteriorRingN(idHole).apply((CoordinateFilter)lineStringHandler);
            }
        }
    }

    private static class LineStringHandler
    extends PointHandler {
        private List<Integer> segments;
        private int firstPtIndex = -1;

        public LineStringHandler(DelaunayData delaunayData, Map<TriangulationPoint, Integer> pts, AtomicInteger maxIndex, List<Integer> segments) {
            super(delaunayData, pts, maxIndex);
            this.segments = segments;
        }

        public void reset() {
            this.firstPtIndex = -1;
        }

        @Override
        public void filter(Coordinate pt) {
            if (this.firstPtIndex == -1) {
                this.firstPtIndex = this.addPt(pt);
            } else {
                int secondPt = this.addPt(pt);
                if (secondPt != this.firstPtIndex) {
                    this.segments.add(this.firstPtIndex);
                    this.segments.add(secondPt);
                    this.firstPtIndex = secondPt;
                }
            }
        }
    }

    private static class PointHandler
    implements CoordinateFilter {
        private DelaunayData delaunayData;
        private Map<TriangulationPoint, Integer> pts;
        private AtomicInteger maxIndex;

        public PointHandler(DelaunayData delaunayData, Map<TriangulationPoint, Integer> pts, AtomicInteger maxIndex) {
            this.delaunayData = delaunayData;
            this.pts = pts;
            this.maxIndex = maxIndex;
        }

        protected int addPt(Coordinate coordinate) {
            TPoint pt = new TPoint(this.delaunayData.r(coordinate.x), this.delaunayData.r(coordinate.y), Double.isNaN(coordinate.getZ()) ? 0.0 : this.delaunayData.r(coordinate.getZ()));
            Integer index = this.pts.get(pt);
            if (index == null) {
                index = this.maxIndex.getAndAdd(1);
                this.pts.put((TriangulationPoint)pt, index);
            }
            return index;
        }

        public void filter(Coordinate pt) {
            this.addPt(pt);
        }
    }

    public static enum MODE {
        DELAUNAY,
        CONSTRAINED,
        TESSELLATION;

    }
}

