/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueVarchar;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.create.MinimumBoundingRadiusRowSet;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ST_MinimumBoundingRadius
extends DeterministicScalarFunction {
    public ST_MinimumBoundingRadius() {
        this.addProperty("remarks", "Computes the center point and radius of the smallest circle that contains a geometry. Returns a record with fields:\n\ncenter - center point of the circle\n\nradius - radius of the circle.\n The input argument should be a geometry, a table or a select query");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static ResultSet execute(Connection connection, Value value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof ValueVarchar) {
            MinimumBoundingRadiusRowSet mbrd = new MinimumBoundingRadiusRowSet(connection, value.getString());
            return mbrd.getResultSet();
        }
        if (value instanceof ValueGeometry) {
            ValueGeometry valueGeometry = (ValueGeometry)value;
            Geometry geometry = valueGeometry.getGeometry();
            if (geometry.getNumPoints() == 0) {
                return null;
            }
            MinimumBoundingCircle mbc = new MinimumBoundingCircle(geometry);
            SimpleResultSet srs = new SimpleResultSet();
            srs.addColumn("CENTER", 1111, "GEOMETRY", 0, 0);
            srs.addColumn("RADIUS", 8, 10, 0);
            Point geom = geometry.getFactory().createPoint(mbc.getCentre());
            geom.setSRID(geometry.getSRID());
            srs.addRow(new Object[]{geom, mbc.getRadius()});
            return srs;
        }
        throw new SQLException("This function supports only table name, select query or geometry as first argument.");
    }
}

