/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.Column;
import org.h2.value.TypeInfo;
import org.h2gis.functions.io.dbf.internal.DBFDriver;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.file_table.FileEngine;

public class DBFEngine
extends FileEngine<DBFDriver> {
    @Override
    protected DBFDriver createDriver(File filePath, List<String> args) throws IOException {
        DBFDriver driver = new DBFDriver();
        driver.initDriverFromFile(filePath, args.size() > 1 ? args.get(1) : null);
        return driver;
    }

    @Override
    protected void feedCreateTableData(DBFDriver driver, CreateTableData data) throws IOException {
        DbaseFileHeader header = driver.getDbaseFileHeader();
        DBFEngine.feedTableDataFromHeader(header, data);
    }

    public static void feedTableDataFromHeader(DbaseFileHeader header, CreateTableData data) throws IOException {
        int numFields = header.getNumFields();
        for (int i = 0; i < numFields; ++i) {
            String fieldsName = header.getFieldName(i);
            Column column = new Column(fieldsName.toUpperCase(), DBFEngine.dbfTypeToH2Type(header, i));
            data.columns.add(column);
        }
    }

    private static TypeInfo dbfTypeToH2Type(DbaseFileHeader header, int i) throws IOException {
        switch (header.getFieldType(i)) {
            case 'L': 
            case 'l': {
                return TypeInfo.TYPE_BOOLEAN;
            }
            case 'C': 
            case 'c': {
                return TypeInfo.getTypeInfo((int)2, (long)header.getFieldLength(i), (int)0, null);
            }
            case 'D': 
            case 'd': {
                return TypeInfo.TYPE_DATE;
            }
            case 'N': 
            case 'n': {
                if (header.getFieldDecimalCount(i) == 0) {
                    int fieldLength = header.getFieldLength(i);
                    if (fieldLength >= 0 && fieldLength < 10) {
                        return TypeInfo.TYPE_INTEGER;
                    }
                    return TypeInfo.TYPE_BIGINT;
                }
                return new TypeInfo(15, (long)header.getFieldLength(i), 0, null);
            }
            case 'F': 
            case 'O': 
            case 'f': 
            case 'o': {
                return new TypeInfo(15, (long)header.getFieldLength(i), 0, null);
            }
        }
        throw new IOException("Unknown DBF field type " + header.getFieldType(i));
    }
}

