/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class RobustLineIntersector3D
extends RobustLineIntersector {
    protected int computeIntersect(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean collinear;
        this.isProper = false;
        if (!Envelope.intersects((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2)) {
            return 0;
        }
        int Pq1 = Orientation.index((Coordinate)p1, (Coordinate)p2, (Coordinate)q1);
        int Pq2 = Orientation.index((Coordinate)p1, (Coordinate)p2, (Coordinate)q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return 0;
        }
        int Qp1 = Orientation.index((Coordinate)q1, (Coordinate)q2, (Coordinate)p1);
        int Qp2 = Orientation.index((Coordinate)q1, (Coordinate)q2, (Coordinate)p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return 0;
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.isProper = false;
            if (p1.equals2D(q1) || p1.equals2D(q2)) {
                this.intPt[0] = p1;
            } else if (p2.equals2D(q1) || p2.equals2D(q2)) {
                this.intPt[0] = p2;
            } else if (Pq1 == 0) {
                this.intPt[0] = new Coordinate(q1);
            } else if (Pq2 == 0) {
                this.intPt[0] = new Coordinate(q2);
            } else if (Qp1 == 0) {
                this.intPt[0] = new Coordinate(p1);
            } else if (Qp2 == 0) {
                this.intPt[0] = new Coordinate(p2);
            }
        } else {
            this.isProper = true;
            this.intPt[0] = this.intersection(p1, p2, q1, q2);
        }
        return 1;
    }

    private Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = this.intersectionWithNormalization(p1, p2, q1, q2);
        if (!this.isInSegmentEnvelopes(intPt)) {
            intPt = new Coordinate(this.nearestEndpoint(p1, p2, q1, q2));
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(intPt);
        }
        return intPt;
    }

    private Coordinate nearestEndpoint(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate nearestPt = p1;
        double minDist = Distance.pointToSegment((Coordinate)p1, (Coordinate)q1, (Coordinate)q2);
        double dist = Distance.pointToSegment((Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        if (dist < minDist) {
            minDist = dist;
            nearestPt = p2;
        }
        if ((dist = Distance.pointToSegment((Coordinate)q1, (Coordinate)p1, (Coordinate)p2)) < minDist) {
            minDist = dist;
            nearestPt = q1;
        }
        if ((dist = Distance.pointToSegment((Coordinate)q2, (Coordinate)p1, (Coordinate)p2)) < minDist) {
            minDist = dist;
            nearestPt = q2;
        }
        return nearestPt;
    }

    private boolean isInSegmentEnvelopes(Coordinate intPt) {
        Envelope env0 = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope env1 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return env0.contains(intPt) && env1.contains(intPt);
    }

    private Coordinate intersectionWithNormalization(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate n1 = new Coordinate(p1);
        Coordinate n2 = new Coordinate(p2);
        Coordinate n3 = new Coordinate(q1);
        Coordinate n4 = new Coordinate(q2);
        Coordinate normPt = new Coordinate();
        this.normalizeToEnvCentre(n1, n2, n3, n4, normPt);
        Coordinate intPt = this.safeHCoordinateIntersection(n1, n2, n3, n4);
        intPt.x += normPt.x;
        intPt.y += normPt.y;
        intPt.setZ((CoordinateUtils.interpolate(p1, p2, intPt) + CoordinateUtils.interpolate(q1, q2, intPt)) / 2.0);
        return intPt;
    }

    private void normalizeToEnvCentre(Coordinate n00, Coordinate n01, Coordinate n10, Coordinate n11, Coordinate normPt) {
        double minX0 = n00.x < n01.x ? n00.x : n01.x;
        double minY0 = n00.y < n01.y ? n00.y : n01.y;
        double maxX0 = n00.x > n01.x ? n00.x : n01.x;
        double maxY0 = n00.y > n01.y ? n00.y : n01.y;
        double minX1 = n10.x < n11.x ? n10.x : n11.x;
        double minY1 = n10.y < n11.y ? n10.y : n11.y;
        double maxX1 = n10.x > n11.x ? n10.x : n11.x;
        double maxY1 = n10.y > n11.y ? n10.y : n11.y;
        double intMinX = minX0 > minX1 ? minX0 : minX1;
        double intMaxX = maxX0 < maxX1 ? maxX0 : maxX1;
        double intMinY = minY0 > minY1 ? minY0 : minY1;
        double intMaxY = maxY0 < maxY1 ? maxY0 : maxY1;
        double intMidX = (intMinX + intMaxX) / 2.0;
        double intMidY = (intMinY + intMaxY) / 2.0;
        normPt.x = intMidX;
        normPt.y = intMidY;
        n00.x -= normPt.x;
        n00.y -= normPt.y;
        n01.x -= normPt.x;
        n01.y -= normPt.y;
        n10.x -= normPt.x;
        n10.y -= normPt.y;
        n11.x -= normPt.x;
        n11.y -= normPt.y;
    }

    private Coordinate safeHCoordinateIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = Intersection.intersection((Coordinate)p1, (Coordinate)p2, (Coordinate)q1, (Coordinate)q2);
        if (intPt == null) {
            intPt = this.nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean p1q1p2 = Envelope.intersects((Coordinate)p1, (Coordinate)p2, (Coordinate)q1);
        boolean p1q2p2 = Envelope.intersects((Coordinate)p1, (Coordinate)p2, (Coordinate)q2);
        boolean q1p1q2 = Envelope.intersects((Coordinate)q1, (Coordinate)q2, (Coordinate)p1);
        boolean q1p2q2 = Envelope.intersects((Coordinate)q1, (Coordinate)q2, (Coordinate)p2);
        if (p1q1p2 && p1q2p2) {
            this.intPt[0] = q1;
            this.intPt[1] = q2;
            return 2;
        }
        if (q1p1q2 && q1p2q2) {
            this.intPt[0] = p1;
            this.intPt[1] = p2;
            return 2;
        }
        if (p1q1p2 && q1p1q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p1;
            return q1.equals((Object)p1) && !p1q2p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q1p2 && q1p2q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p2;
            return q1.equals((Object)p2) && !p1q2p2 && !q1p1q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p1q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p1;
            return q2.equals((Object)p1) && !p1q1p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p2q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p2;
            return q2.equals((Object)p2) && !p1q1p2 && !q1p1q2 ? 1 : 2;
        }
        return 0;
    }
}

