/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topology;

import java.util.Collection;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.operation.polygonize.Polygonizer;

public class ST_Polygonize
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();

    public ST_Polygonize() {
        this.addProperty("remarks", "Polygonizes a set of Geometry which contain linework that represents the edges of a planar graph");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(geometry);
        Collection pols = polygonizer.getPolygons();
        if (pols.isEmpty()) {
            return null;
        }
        return geometry.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray((Collection)pols));
    }
}

