/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.split;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class ST_SubDivide
extends DeterministicScalarFunction {
    static GeometryFactory FACTORY = new GeometryFactory();

    public ST_SubDivide() {
        this.addProperty("remarks", "Divides geometry into parts using its internal envelope, until each part can be represented using no more than max_vertices.\n If no vertices apply a single recurve");
    }

    public String getJavaStaticMethod() {
        return "divide";
    }

    public static Geometry divide(Geometry geom) {
        return ST_SubDivide.divideOnePass(geom);
    }

    public static Geometry divide(Geometry geom, int maxvertices) {
        Geometry res = FACTORY.buildGeometry(ST_SubDivide.subdivide_recursive(geom, maxvertices));
        res.setSRID(geom.getSRID());
        return res;
    }

    public static List<Geometry> subdivide_recursive(Geometry geom, int maxvertices) {
        if (geom == null) {
            return null;
        }
        maxvertices = Math.max(0, maxvertices);
        Stack<Geometry> stack = new Stack<Geometry>();
        int size = geom.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            stack.add(geom.getGeometryN(i));
        }
        ArrayList<Geometry> results = new ArrayList<Geometry>();
        while (!stack.isEmpty()) {
            Geometry slice = (Geometry)stack.pop();
            int nbPts = 0;
            if (geom instanceof Polygon) {
                nbPts = slice.getNumPoints() - 1;
            } else if (geom instanceof LineString) {
                nbPts = slice.getNumPoints();
            }
            if (nbPts > maxvertices) {
                Envelope urEnv;
                Envelope ulEnv;
                Envelope envelope = slice.getEnvelopeInternal();
                double minX = envelope.getMinX();
                double maxX = envelope.getMaxX();
                double midX = minX + (maxX - minX) / 2.0;
                double minY = envelope.getMinY();
                double maxY = envelope.getMaxY();
                double midY = minY + (maxY - minY) / 2.0;
                if (envelope.getHeight() == 0.0) {
                    ulEnv = new Envelope(minX, midX, midY, maxY);
                    urEnv = new Envelope(midX, maxX, midY, maxY);
                    ST_SubDivide.filterGeom(FACTORY.toGeometry(ulEnv).intersection(slice), maxvertices, stack, results);
                    ST_SubDivide.filterGeom(FACTORY.toGeometry(urEnv).intersection(slice), maxvertices, stack, results);
                    continue;
                }
                if (envelope.getWidth() == 0.0) {
                    Envelope llEnv = new Envelope(minX, midX, minY, midY);
                    ST_SubDivide.filterGeom(FACTORY.toGeometry(llEnv).intersection(slice), maxvertices, stack, results);
                    Envelope lrEnv = new Envelope(midX, maxX, minY, midY);
                    ST_SubDivide.filterGeom(FACTORY.toGeometry(lrEnv).intersection(slice), maxvertices, stack, results);
                    continue;
                }
                ulEnv = new Envelope(minX, midX, midY, maxY);
                urEnv = new Envelope(midX, maxX, midY, maxY);
                Envelope llEnv = new Envelope(minX, midX, minY, midY);
                Envelope lrEnv = new Envelope(midX, maxX, minY, midY);
                ST_SubDivide.filterGeom(FACTORY.toGeometry(ulEnv).intersection(slice), maxvertices, stack, results);
                ST_SubDivide.filterGeom(FACTORY.toGeometry(urEnv).intersection(slice), maxvertices, stack, results);
                ST_SubDivide.filterGeom(FACTORY.toGeometry(llEnv).intersection(slice), maxvertices, stack, results);
                ST_SubDivide.filterGeom(FACTORY.toGeometry(lrEnv).intersection(slice), maxvertices, stack, results);
                continue;
            }
            results.add(slice);
        }
        return results;
    }

    private static Geometry divideOnePass(Geometry geom) {
        if (geom == null) {
            return null;
        }
        ArrayList<Geometry> results = new ArrayList<Geometry>();
        int size = geom.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geom.getGeometryN(i);
            if (subGeom instanceof Polygon || subGeom instanceof LineString) {
                Geometry ur;
                Geometry ul;
                Envelope urEnv;
                Envelope ulEnv;
                Envelope envelope = subGeom.getEnvelopeInternal();
                double minX = envelope.getMinX();
                double maxX = envelope.getMaxX();
                double midX = minX + (maxX - minX) / 2.0;
                double minY = envelope.getMinY();
                double maxY = envelope.getMaxY();
                double midY = minY + (maxY - minY) / 2.0;
                if (envelope.getHeight() == 0.0) {
                    ulEnv = new Envelope(minX, midX, midY, maxY);
                    urEnv = new Envelope(midX, maxX, midY, maxY);
                    ul = FACTORY.toGeometry(ulEnv).intersection(subGeom);
                    ur = FACTORY.toGeometry(urEnv).intersection(subGeom);
                    results.add(ul);
                    results.add(ur);
                    continue;
                }
                if (envelope.getWidth() == 0.0) {
                    Envelope llEnv = new Envelope(minX, midX, minY, midY);
                    Geometry ll = FACTORY.toGeometry(llEnv).intersection(subGeom);
                    Envelope lrEnv = new Envelope(midX, maxX, minY, midY);
                    Geometry lr = FACTORY.toGeometry(lrEnv).intersection(subGeom);
                    results.add(ll);
                    results.add(lr);
                    continue;
                }
                ulEnv = new Envelope(minX, midX, midY, maxY);
                urEnv = new Envelope(midX, maxX, midY, maxY);
                ul = FACTORY.toGeometry(ulEnv).intersection(subGeom);
                ur = FACTORY.toGeometry(urEnv).intersection(subGeom);
                results.add(ul);
                results.add(ur);
                Envelope llEnv = new Envelope(minX, midX, minY, midY);
                Geometry ll = FACTORY.toGeometry(llEnv).intersection(subGeom);
                Envelope lrEnv = new Envelope(midX, maxX, minY, midY);
                Geometry lr = FACTORY.toGeometry(lrEnv).intersection(subGeom);
                results.add(ll);
                results.add(lr);
                continue;
            }
            results.add(subGeom);
        }
        Geometry res = FACTORY.buildGeometry(results);
        res.setSRID(geom.getSRID());
        return res;
    }

    public static void filterGeom(Geometry geom, int maxvertices, Stack stack, List ret) {
        int size = geom.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geom.getGeometryN(i);
            int nbPts = 0;
            if (subGeom.getDimension() == 2) {
                nbPts = subGeom.getNumPoints() - 1;
                if (nbPts <= maxvertices) {
                    ret.add(subGeom);
                    continue;
                }
                stack.add(subGeom);
                continue;
            }
            if (subGeom.getDimension() == 1) {
                nbPts = subGeom.getNumPoints();
                if (nbPts <= maxvertices) {
                    ret.add(subGeom);
                    continue;
                }
                stack.add(subGeom);
                continue;
            }
            ret.add(subGeom);
        }
    }
}

