/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.snap;

import java.sql.SQLException;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ST_Project
extends DeterministicScalarFunction {
    public ST_Project() {
        this.addProperty("remarks", "Returns a point projected from a point along a geodesic using a given distance and azimuth (bearing) when the input geometry has a SRID equal to 4326. Otherwise project the point in cartesian plan.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry, double distance, double azimuth) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Point) {
            if (geometry.getSRID() == 4326) {
                Coordinate coord = geometry.getCoordinate().copy();
                GeodesicData res = Geodesic.WGS84.Direct(coord.getX(), coord.getY(), Math.toDegrees(azimuth), distance);
                coord.setX(res.lon2);
                coord.setY(res.lat2);
                Point geom = geometry.getFactory().createPoint(coord);
                geom.setSRID(4326);
                return geom;
            }
            Coordinate coord = geometry.getCoordinate().copy();
            double angle = Angle.normalizePositive((double)azimuth);
            coord.setX(coord.getX() + distance * Math.cos(angle));
            coord.setY(coord.getY() + distance * Math.sin(angle));
            Point geom = geometry.getFactory().createPoint(coord);
            geom.setSRID(geometry.getSRID());
            return geom;
        }
        throw new SQLException("The input geometry to project must be a point");
    }
}

