/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_NumInteriorRings
extends DeterministicScalarFunction {
    public ST_NumInteriorRings() {
        this.addProperty("remarks", "Return the number of interior rings of the first polygon in the geometry. \nThis will work with both POLYGON and MULTIPOLYGON.\n Return NULL if there is no polygon in the geometry.");
    }

    public String getJavaStaticMethod() {
        return "getHoles";
    }

    public static Integer getHoles(Geometry g) {
        if (g == null) {
            return null;
        }
        if (g instanceof MultiPolygon) {
            Polygon p = (Polygon)g.getGeometryN(0);
            if (p != null) {
                return p.getNumInteriorRing();
            }
        } else if (g instanceof Polygon) {
            return ((Polygon)g).getNumInteriorRing();
        }
        return null;
    }
}

