/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Equals
extends DeterministicScalarFunction {
    public ST_Equals() {
        this.addProperty("remarks", "Return true if Geometry A is equal to Geometry B");
    }

    public String getJavaStaticMethod() {
        return "geomEquals";
    }

    public static Boolean geomEquals(Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        if (a.getSRID() != b.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return a.equals(b);
    }
}

