/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.util.StringUtils;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBUtils;

public class FindGeometryMetadata
extends DeterministicScalarFunction {
    public FindGeometryMetadata() {
        this.addProperty("remarks", "Extract geometry metadata from its create table signature.eg : GEOMETRY; GEOMETRY(POINT); GEOMETRY(POINT Z); GEOMETRY(POINTZ, 4326)...");
    }

    public String getJavaStaticMethod() {
        return "extractMetadata";
    }

    public static String[] extractMetadata(Connection connection, String catalogName, String schemaName, String tableName, String columnName, String data_type, String geometry_type, String srid) throws SQLException {
        if (geometry_type == null) {
            geometry_type = data_type;
        }
        String[] values = new String[4];
        if (srid == null) {
            try (ResultSet rs = connection.createStatement().executeQuery(String.format("select ST_SRID(%s) from %s LIMIT 1;", StringUtils.quoteJavaString((String)columnName), new TableLocation(catalogName, schemaName, tableName, DBUtils.getDBType((Connection)connection))));){
                if (rs.next()) {
                    srid = rs.getString(1);
                }
            }
        }
        GeometryMetaData geomMeta = GeometryMetaData.createMetadataFromGeometryType((String)geometry_type);
        values[0] = String.valueOf(geomMeta.getGeometryTypeCode());
        values[1] = String.valueOf(geomMeta.getDimension());
        values[2] = srid;
        values[3] = geomMeta.getSfs_geometryType();
        return values;
    }
}

