/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.sql.SQLException;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;

public class ST_Delaunay
extends DeterministicScalarFunction {
    public ST_Delaunay() {
        this.addProperty("remarks", "Returns polygons that represent a Delaunay Triangulation from a geometry.\nOutput is a COLLECTION of polygons, for flag=0 (default flag) or a MULTILINESTRING for flag=1\n");
    }

    public String getJavaStaticMethod() {
        return "createDT";
    }

    public static GeometryCollection createDT(Geometry geometry) throws SQLException {
        return ST_Delaunay.createDT(geometry, 0);
    }

    public static GeometryCollection createDT(Geometry geometry, int flag) throws SQLException {
        if (geometry != null) {
            DelaunayTriangulationBuilder triangulationBuilder = new DelaunayTriangulationBuilder();
            triangulationBuilder.setSites(geometry);
            if (flag == 0) {
                return ST_Delaunay.getTriangles(geometry.getFactory(), triangulationBuilder);
            }
            return (GeometryCollection)triangulationBuilder.getEdges(geometry.getFactory());
        }
        return null;
    }

    private static GeometryCollection getTriangles(GeometryFactory geomFact, DelaunayTriangulationBuilder delaunayTriangulationBuilder) {
        QuadEdgeSubdivision subdiv = delaunayTriangulationBuilder.getSubdivision();
        List triPtsList = subdiv.getTriangleCoordinates(false);
        Polygon[] tris = new Polygon[triPtsList.size()];
        int i = 0;
        for (Object aTriPtsList : triPtsList) {
            Coordinate[] triPt = (Coordinate[])aTriPtsList;
            tris[i++] = geomFact.createPolygon(geomFact.createLinearRing(triPt), null);
        }
        return geomFact.createMultiPolygon(tris);
    }
}

