/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.edit.EditUtilities;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.operation.distance.GeometryLocation;

public class ST_InsertPoint
extends DeterministicScalarFunction {
    public static final double PRECISION = 1.0E-5;

    public ST_InsertPoint() {
        this.addProperty("remarks", "Insert a point to a geometry. \nA tolerance could be set to snap the point to the geometry.\nIf the point cannot be inserted it returns the input geometry");
    }

    public String getJavaStaticMethod() {
        return "insertPoint";
    }

    public static Geometry insertPoint(Geometry geometry, Point point) throws SQLException {
        return ST_InsertPoint.insertPoint(geometry, point, 1.0E-5);
    }

    public static Geometry insertPoint(Geometry geometry, Point point, double tolerance) throws SQLException {
        if (geometry == null || point == null) {
            return null;
        }
        if (point.isEmpty() || geometry.isEmpty()) {
            return geometry;
        }
        if (geometry.getSRID() != point.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        GeometryFactory factory = geometry.getFactory();
        if (geometry instanceof Point) {
            throw new SQLException("Cannot insert a point on  : " + geometry.getGeometryType());
        }
        if (geometry instanceof MultiPoint) {
            return ST_InsertPoint.insertVertexInMultipoint(geometry, point, factory);
        }
        if (geometry instanceof LineString) {
            return ST_InsertPoint.insertVertexInLineString((LineString)geometry, point, tolerance, factory);
        }
        if (geometry instanceof MultiLineString) {
            int size = geometry.getNumGeometries();
            LineString[] linestrings = new LineString[size];
            boolean any = false;
            for (int i = 0; i < size; ++i) {
                LineString line = (LineString)geometry.getGeometryN(i);
                LineString inserted = ST_InsertPoint.insertVertexInLineString(line, point, tolerance, factory);
                if (inserted != null) {
                    linestrings[i] = inserted;
                    any = true;
                    continue;
                }
                linestrings[i] = line;
            }
            if (any) {
                return factory.createMultiLineString(linestrings);
            }
            return null;
        }
        if (geometry instanceof Polygon) {
            return ST_InsertPoint.insertVertexInPolygon((Polygon)geometry, point, tolerance, factory);
        }
        if (geometry instanceof MultiPolygon) {
            Polygon[] polygons = new Polygon[geometry.getNumGeometries()];
            boolean any = false;
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)geometry.getGeometryN(i);
                Polygon inserted = ST_InsertPoint.insertVertexInPolygon(polygon, point, tolerance, factory);
                if (inserted != null) {
                    any = true;
                    polygons[i] = inserted;
                    continue;
                }
                polygons[i] = polygon;
            }
            if (any) {
                return factory.createMultiPolygon(polygons);
            }
            return null;
        }
        if (geometry instanceof GeometryCollection) {
            throw new SQLException("Cannot insert a point on  : " + geometry.getGeometryType());
        }
        throw new SQLException("Unknown geometry type : " + geometry.getGeometryType());
    }

    private static Geometry insertVertexInMultipoint(Geometry g, Point vertexPoint, GeometryFactory factory) {
        ArrayList<Point> geoms = new ArrayList<Point>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Point geom = (Point)g.getGeometryN(i);
            geoms.add(geom);
        }
        geoms.add(factory.createPoint(new Coordinate(vertexPoint.getX(), vertexPoint.getY())));
        return factory.createMultiPoint(GeometryFactory.toPointArray(geoms));
    }

    private static LineString insertVertexInLineString(LineString lineString, Point vertexPoint, double tolerance, GeometryFactory factory) throws SQLException {
        GeometryLocation geomLocation = EditUtilities.getVertexToSnap((Geometry)lineString, vertexPoint, tolerance);
        if (geomLocation != null) {
            Coordinate[] coords = lineString.getCoordinates();
            int index = geomLocation.getSegmentIndex();
            Coordinate coord = geomLocation.getCoordinate();
            if (!CoordinateUtils.contains2D((Coordinate[])coords, (Coordinate)coord)) {
                Coordinate[] ret = new Coordinate[coords.length + 1];
                System.arraycopy(coords, 0, ret, 0, index + 1);
                ret[index + 1] = coord;
                System.arraycopy(coords, index + 1, ret, index + 2, coords.length - (index + 1));
                return factory.createLineString(ret);
            }
            return null;
        }
        return lineString;
    }

    private static Polygon insertVertexInPolygon(Polygon polygon, Point vertexPoint, double tolerance, GeometryFactory factory) throws SQLException {
        Polygon geom = polygon;
        LinearRing linearRing = factory.createLinearRing(polygon.getExteriorRing().getCoordinates());
        int index = -1;
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            double distCurr = ST_InsertPoint.computeDistance((Geometry)polygon.getInteriorRingN(i), vertexPoint, tolerance);
            if (!(distCurr < tolerance)) continue;
            index = i;
        }
        if (index == -1) {
            LinearRing inserted = ST_InsertPoint.insertVertexInLinearRing((LineString)linearRing, vertexPoint, tolerance, factory);
            if (inserted != null) {
                LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
                for (int i = 0; i < holes.length; ++i) {
                    holes[i] = factory.createLinearRing(polygon.getInteriorRingN(i).getCoordinates());
                }
                geom = factory.createPolygon(inserted, holes);
            }
        } else {
            LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
            for (int i = 0; i < holes.length; ++i) {
                holes[i] = i == index ? ST_InsertPoint.insertVertexInLinearRing((LineString)polygon.getInteriorRingN(i), vertexPoint, tolerance, factory) : factory.createLinearRing(polygon.getInteriorRingN(i).getCoordinates());
            }
            geom = factory.createPolygon(linearRing, holes);
        }
        if (geom != null && !geom.isValid()) {
            throw new SQLException("Geometry not valid");
        }
        return geom;
    }

    private static double computeDistance(Geometry geometry, Point vertexPoint, double tolerance) {
        DistanceOp distanceOp = new DistanceOp(geometry, (Geometry)vertexPoint, tolerance);
        return distanceOp.distance();
    }

    private static LinearRing insertVertexInLinearRing(LineString lineString, Point vertexPoint, double tolerance, GeometryFactory factory) {
        GeometryLocation geomLocation = EditUtilities.getVertexToSnap((Geometry)lineString, vertexPoint, tolerance);
        if (geomLocation != null) {
            Coordinate[] coords = lineString.getCoordinates();
            int index = geomLocation.getSegmentIndex();
            Coordinate coord = geomLocation.getCoordinate();
            if (!CoordinateUtils.contains2D((Coordinate[])coords, (Coordinate)coord)) {
                Coordinate[] ret = new Coordinate[coords.length + 1];
                System.arraycopy(coords, 0, ret, 0, index + 1);
                ret[index + 1] = coord;
                System.arraycopy(coords, index + 1, ret, index + 2, coords.length - (index + 1));
                return factory.createLinearRing(ret);
            }
            return null;
        }
        return null;
    }
}

