/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class ST_MakePolygon
extends DeterministicScalarFunction {
    public ST_MakePolygon() {
        this.addProperty("remarks", "Creates a Polygon formed by the given shell and optionally holes.\nInput geometries must be closed Linestrings");
    }

    public String getJavaStaticMethod() {
        return "makePolygon";
    }

    public static Polygon makePolygon(Geometry shell) throws IllegalArgumentException {
        if (shell == null) {
            return null;
        }
        LinearRing outerLine = ST_MakePolygon.checkLineString(shell);
        return shell.getFactory().createPolygon(outerLine, null);
    }

    public static Polygon makePolygon(Geometry shell, Geometry holes) throws IllegalArgumentException {
        if (shell == null) {
            return null;
        }
        LinearRing outerLine = ST_MakePolygon.checkLineString(shell);
        if (holes == null) {
            return shell.getFactory().createPolygon(outerLine, null);
        }
        int size = holes.getNumGeometries();
        LinearRing[] interiorlinestrings = new LinearRing[size];
        for (int i = 0; i < size; ++i) {
            interiorlinestrings[i] = ST_MakePolygon.checkLineString(holes.getGeometryN(i));
        }
        return shell.getFactory().createPolygon(outerLine, interiorlinestrings);
    }

    private static LinearRing checkLineString(Geometry geometry) throws IllegalArgumentException {
        if (geometry instanceof LinearRing) {
            return (LinearRing)geometry;
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            if (lineString.isClosed()) {
                return geometry.getFactory().createLinearRing(lineString.getCoordinateSequence());
            }
            throw new IllegalArgumentException("The linestring must be closed.");
        }
        throw new IllegalArgumentException("Only support linestring.");
    }
}

