/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class ST_MakeLine
extends DeterministicScalarFunction {
    public static final int REQUIRED_NUMBER_OF_POINTS = 2;

    public ST_MakeLine() {
        this.addProperty("remarks", "Constructs a LINESTRING from two POINT geometries.");
    }

    public String getJavaStaticMethod() {
        return "createLine";
    }

    public static LineString createLine(Geometry pointA, Geometry ... optionalPoints) throws SQLException {
        if (pointA == null || optionalPoints.length > 0 && optionalPoints[0] == null) {
            return null;
        }
        if (pointA.getNumGeometries() == 1 && !ST_MakeLine.atLeastTwoPoints(optionalPoints, ST_MakeLine.countPoints(pointA))) {
            throw new SQLException("At least two points are required to make a line.");
        }
        LinkedList<Coordinate> coordinateList = new LinkedList<Coordinate>();
        ST_MakeLine.addCoordinatesToList(pointA, coordinateList);
        for (Geometry optionalPoint : optionalPoints) {
            ST_MakeLine.addCoordinatesToList(optionalPoint, coordinateList);
        }
        return pointA.getFactory().createLineString(coordinateList.toArray(new Coordinate[optionalPoints.length]));
    }

    public static LineString createLine(GeometryCollection points) throws SQLException {
        if (points == null) {
            return null;
        }
        int size = points.getNumGeometries();
        if (!ST_MakeLine.atLeastTwoPoints(points)) {
            throw new SQLException("At least two points are required to make a line.");
        }
        LinkedList<Coordinate> coordinateList = new LinkedList<Coordinate>();
        for (int i = 0; i < size; ++i) {
            coordinateList.addAll(Arrays.asList(points.getGeometryN(i).getCoordinates()));
        }
        return points.getGeometryN(0).getFactory().createLineString(coordinateList.toArray(new Coordinate[size]));
    }

    private static void addCoordinatesToList(Geometry puntal, List<Coordinate> list) throws SQLException {
        if (puntal instanceof Point) {
            list.add(puntal.getCoordinate());
        } else if (puntal instanceof MultiPoint) {
            list.addAll(Arrays.asList(puntal.getCoordinates()));
        } else {
            throw new SQLException("Only Points and MultiPoints are accepted.");
        }
    }

    private static boolean atLeastTwoPoints(GeometryCollection points) throws SQLException {
        return ST_MakeLine.atLeastTwoPoints(points, 0);
    }

    private static boolean atLeastTwoPoints(Geometry[] points, int initialNumberOfPoints) throws SQLException {
        if (points.length < 1) {
            throw new SQLException("The geometry collection must not be empty");
        }
        return ST_MakeLine.atLeastTwoPoints(points[0].getFactory().createGeometryCollection(points), initialNumberOfPoints);
    }

    private static boolean atLeastTwoPoints(GeometryCollection points, int initialNumberOfPoints) throws SQLException {
        int numberOfPoints = initialNumberOfPoints;
        for (int i = 0; i < points.getNumGeometries(); ++i) {
            Geometry p = points.getGeometryN(i);
            if (numberOfPoints >= 2) {
                return true;
            }
            numberOfPoints += ST_MakeLine.countPoints(p);
        }
        return numberOfPoints >= 2;
    }

    private static int countPoints(Geometry p) throws SQLException {
        if (p instanceof Point) {
            return 1;
        }
        if (p instanceof MultiPoint) {
            return p.getNumPoints();
        }
        throw new SQLException("Only Points and MultiPoints are accepted.");
    }
}

