/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class UpdateGeometryZ {
    static final GeometryFactory gf = new GeometryFactory();

    public static Geometry force(Geometry geom, double z) {
        Geometry g = geom;
        if (geom instanceof Point) {
            g = gf.createPoint((CoordinateSequence)UpdateGeometryZ.convertSequence(geom.getCoordinates(), z));
        } else if (geom instanceof LineString) {
            g = gf.createLineString((CoordinateSequence)UpdateGeometryZ.convertSequence(geom.getCoordinates(), z));
        } else if (geom instanceof Polygon) {
            g = UpdateGeometryZ.convert((Polygon)geom, z);
        } else if (geom instanceof MultiPoint) {
            g = gf.createMultiPoint((CoordinateSequence)UpdateGeometryZ.convertSequence(geom.getCoordinates(), z));
        } else if (geom instanceof MultiLineString) {
            g = UpdateGeometryZ.convert((MultiLineString)geom, z);
        } else if (geom instanceof MultiPolygon) {
            g = UpdateGeometryZ.convert((MultiPolygon)geom, z);
        } else if (geom instanceof GeometryCollection) {
            g = UpdateGeometryZ.convert((GeometryCollection)geom, z);
        }
        g.setSRID(geom.getSRID());
        return g;
    }

    public static GeometryCollection convert(GeometryCollection gc, double z) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = UpdateGeometryZ.force(gc.getGeometryN(i), z);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, double z) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = UpdateGeometryZ.convert((Polygon)multiPolygon.getGeometryN(i), z);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, double z) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = UpdateGeometryZ.convert((LineString)multiLineString.getGeometryN(i), z);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, double z) {
        LinearRing shell = gf.createLinearRing((CoordinateSequence)UpdateGeometryZ.convertSequence(polygon.getExteriorRing().getCoordinates(), z));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)UpdateGeometryZ.convertSequence(polygon.getInteriorRingN(i).getCoordinates(), z));
        }
        return gf.createPolygon(shell, holes);
    }

    public static LineString convert(LineString lineString, double z) {
        return gf.createLineString((CoordinateSequence)UpdateGeometryZ.convertSequence(lineString.getCoordinates(), z));
    }

    public static LinearRing convert(LinearRing linearRing, double z) {
        return gf.createLinearRing((CoordinateSequence)UpdateGeometryZ.convertSequence(linearRing.getCoordinates(), z));
    }

    private static CoordinateArraySequence convertSequence(Coordinate[] cs, double z) {
        for (int i = 0; i < cs.length; ++i) {
            Coordinate coord = cs[i];
            coord = new Coordinate(coord);
            double currentZ = coord.z;
            if (!Double.isNaN(currentZ)) continue;
            coord.z = Double.isNaN(z) ? 0.0 : z;
            cs[i] = coord;
        }
        return new CoordinateArraySequence(cs, 3);
    }
}

