/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import org.cts.op.CoordinateOperationException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.URIUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ST_OSMDownloader
extends AbstractFunction
implements ScalarFunction {
    private static final String OSM_API_URL = "https://openstreetmap.org/api/0.6/";

    public ST_OSMDownloader() {
        this.addProperty("remarks", "Extract an OSM XML file from the OSM api server using a the bounding box of a given geometry.\nA path must be set to specified where the OSM file will be stored./nSet true to delete the XML file if exists. Default behaviour is false.");
    }

    public String getJavaStaticMethod() {
        return "downloadData";
    }

    public static void downloadData(Connection con, Geometry area, String fileName) throws FileNotFoundException, IOException, SQLException, CoordinateOperationException {
        ST_OSMDownloader.downloadData(con, area, fileName, false);
    }

    public static void downloadData(Connection con, Geometry area, String fileName, boolean deleteFile) throws FileNotFoundException, IOException, SQLException, CoordinateOperationException {
        File file = URIUtilities.fileFromString((String)fileName);
        if (file.exists()) {
            if (deleteFile) {
                file.delete();
            } else {
                throw new FileNotFoundException("The following file already exists:\n" + fileName);
            }
        }
        if (file.getName().toLowerCase().endsWith(".osm")) {
            if (area != null) {
                int srid = area.getSRID();
                if (srid != 0) {
                    ST_OSMDownloader.downloadOSMFile(file, ST_Transform.ST_Transform(con, area, 4326).getEnvelopeInternal());
                } else {
                    ST_OSMDownloader.downloadOSMFile(file, area.getEnvelopeInternal());
                }
            }
        } else {
            throw new SQLException("Supported format is .osm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadOSMFile(File file, Envelope geometryEnvelope) throws IOException {
        HttpURLConnection urlCon = (HttpURLConnection)ST_OSMDownloader.createOsmUrl(geometryEnvelope).openConnection();
        urlCon.setRequestMethod("GET");
        urlCon.connect();
        switch (urlCon.getResponseCode()) {
            case 400: {
                throw new IOException("Error : Cannot query the OSM API with the following bounding box");
            }
            case 509: {
                throw new IOException("Error: You have downloaded too much data. Please try again later");
            }
        }
        InputStream in = urlCon.getInputStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            int numBytes;
            byte[] data = new byte[4096];
            while ((numBytes = in.read(data)) != -1) {
                ((OutputStream)out).write(data, 0, numBytes);
            }
        }
        finally {
            ((OutputStream)out).close();
            in.close();
        }
    }

    private static URL createOsmUrl(Envelope geometryEnvelope) {
        try {
            return new URL("https://openstreetmap.org/api/0.6/map?bbox=" + geometryEnvelope.getMinX() + "," + geometryEnvelope.getMinY() + "," + geometryEnvelope.getMaxX() + "," + geometryEnvelope.getMaxY());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

