/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.fgb.fileTable;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.h2.index.Cursor;
import org.h2.result.DefaultRow;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueReal;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueVarchar;
import org.h2gis.api.FileDriver;
import org.h2gis.functions.io.fgb.fileTable.GeometryConversions;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;
import org.wololo.flatgeobuf.generated.Feature;

public class FGBDriver
implements FileDriver {
    private HeaderMeta headerMeta;
    private int fieldCount;
    private int geometryFieldIndex = 0;
    private int srid = 0;
    private FileInputStream fis;
    private FileChannel fileChannel;
    private Value[] currentRow = new Value[0];
    private long rowIdPrevious = -1L;
    private boolean cacheRowAddress = true;
    private long featuresOffset;
    private NavigableMap<Integer, Long> rowIndexToFileLocation;

    public void initDriverFromFile(File fgbFile) throws IOException {
        this.fis = new FileInputStream(fgbFile);
        this.fileChannel = this.fis.getChannel();
        this.headerMeta = HeaderMeta.read((InputStream)this.fis);
        this.fieldCount = this.headerMeta.columns.size() + 1;
        long treeSize = this.headerMeta.featuresCount > 0L && this.headerMeta.indexNodeSize > 0 ? PackedRTree.calcSize((int)((int)this.headerMeta.featuresCount), (int)this.headerMeta.indexNodeSize) : 0L;
        this.featuresOffset = (long)this.headerMeta.offset + treeSize;
        this.srid = this.headerMeta.srid;
        this.rowIndexToFileLocation = new TreeMap<Integer, Long>();
        this.currentRow = new Value[this.fieldCount];
    }

    public boolean isCacheRowAddress() {
        return this.cacheRowAddress;
    }

    public void setCacheRowAddress(boolean cacheRowAddress) {
        this.cacheRowAddress = cacheRowAddress;
    }

    public HeaderMeta getHeader() {
        return this.headerMeta;
    }

    public long getRowCount() {
        return this.headerMeta.featuresCount;
    }

    public int getEstimatedRowSize(long rowId) {
        int totalSize = 0;
        for (ColumnMeta column : this.headerMeta.columns) {
            totalSize += column.width;
        }
        return totalSize;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void close() throws IOException {
        if (this.fis != null) {
            this.fis.close();
        }
    }

    public Cursor queryIndex(Envelope queryEnvelope) throws IOException {
        this.fileChannel.position(this.headerMeta.offset);
        PackedRTree.SearchResult searchResult = PackedRTree.search((InputStream)this.fis, (int)0, (int)((int)this.headerMeta.featuresCount), (int)this.headerMeta.indexNodeSize, (Envelope)queryEnvelope);
        return new FGBDriverCursor(searchResult, this);
    }

    public void cacheFeatureAddressFromIndex() throws IOException {
        if (this.headerMeta.indexNodeSize > 0) {
            this.fileChannel.position(this.headerMeta.offset);
            LittleEndianDataInputStream data = new LittleEndianDataInputStream(Channels.newInputStream(this.fileChannel));
            long[] fids = new long[(int)this.headerMeta.featuresCount];
            for (long id = 0L; id < (long)fids.length; ++id) {
                fids[(int)id] = id;
            }
            long[] featuresAddress = PackedRTree.readFeatureOffsets((LittleEndianDataInputStream)data, (long[])fids, (HeaderMeta)this.headerMeta);
            int featuresAddressLength = featuresAddress.length;
            for (int i = 0; i < featuresAddressLength; ++i) {
                long address = featuresAddress[i];
                this.rowIndexToFileLocation.put(i, address + this.featuresOffset);
            }
        }
    }

    public static Value[] getFieldsFromFileLocation(FileChannel fileChannel, long featureAddress, long featuresOffset, HeaderMeta headerMeta, int geometryFieldIndex) throws IOException {
        int propertiesLength;
        Value[] values = new Value[headerMeta.columns.size() + 1];
        fileChannel.position(featuresOffset + featureAddress);
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(Channels.newInputStream(fileChannel));
        int featureSize = data.readInt();
        byte[] bytes = new byte[featureSize];
        data.readFully(bytes);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        Feature feature = Feature.getRootAsFeature((ByteBuffer)bb);
        org.wololo.flatgeobuf.generated.Geometry geometry = feature.geometry();
        byte geometryType = headerMeta.geometryType;
        if (geometry != null) {
            Geometry jtsGeometry;
            if (geometryType == 0) {
                geometryType = (byte)geometry.type();
            }
            if ((jtsGeometry = GeometryConversions.deserialize(geometry, geometryType)) != null) {
                jtsGeometry.setSRID(headerMeta.srid);
                values[geometryFieldIndex] = ValueGeometry.getFromGeometry((Object)jtsGeometry);
            } else {
                values[geometryFieldIndex] = ValueNull.INSTANCE;
            }
        }
        if ((propertiesLength = feature.propertiesLength()) > 0) {
            List columns = headerMeta.columns;
            ByteBuffer propertiesBB = feature.propertiesAsByteBuffer();
            block11: while (propertiesBB.hasRemaining()) {
                short propertyIndex = propertiesBB.getShort();
                ColumnMeta columnMeta = (ColumnMeta)columns.get(propertyIndex);
                byte type = columnMeta.type;
                if (propertyIndex >= geometryFieldIndex) {
                    propertyIndex = (short)(propertyIndex + 1);
                }
                switch (type) {
                    case 2: {
                        values[propertyIndex] = ValueBoolean.get((propertiesBB.get() > 0 ? 1 : 0) != 0);
                        continue block11;
                    }
                    case 0: {
                        values[propertyIndex] = ValueSmallint.get((short)propertiesBB.get());
                        continue block11;
                    }
                    case 3: {
                        values[propertyIndex] = ValueSmallint.get((short)propertiesBB.getShort());
                        continue block11;
                    }
                    case 5: {
                        values[propertyIndex] = ValueInteger.get((int)propertiesBB.getInt());
                        continue block11;
                    }
                    case 7: {
                        values[propertyIndex] = ValueBigint.get((long)propertiesBB.getLong());
                        continue block11;
                    }
                    case 9: {
                        values[propertyIndex] = ValueReal.get((float)propertiesBB.getFloat());
                        continue block11;
                    }
                    case 10: {
                        values[propertyIndex] = ValueDouble.get((double)propertiesBB.getDouble());
                        continue block11;
                    }
                    case 13: {
                        values[propertyIndex] = ValueDate.parse((String)FGBDriver.readString(propertiesBB));
                        continue block11;
                    }
                    case 11: {
                        values[propertyIndex] = ValueVarchar.get((String)FGBDriver.readString(propertiesBB));
                        continue block11;
                    }
                }
                throw new RuntimeException("Unknown type");
            }
        }
        return values;
    }

    public Value getField(long rowId, int columnId) throws IOException {
        try {
            if (rowId == 0L) {
                this.fileChannel.position(this.featuresOffset);
                this.rowIdPrevious = -1L;
            } else if (rowId > this.rowIdPrevious + 1L || rowId < this.rowIdPrevious) {
                Integer lowerKey = this.rowIndexToFileLocation.floorKey((int)rowId);
                if (lowerKey == null) {
                    this.fileChannel.position(this.featuresOffset);
                    this.rowIdPrevious = -1L;
                } else {
                    this.fileChannel.position((Long)this.rowIndexToFileLocation.get(lowerKey));
                    this.rowIdPrevious = lowerKey - 1;
                }
                while (this.rowIdPrevious + 1L < rowId) {
                    LittleEndianDataInputStream data = new LittleEndianDataInputStream(Channels.newInputStream(this.fileChannel));
                    int featureSize = data.readInt();
                    this.fileChannel.position(this.fileChannel.position() + (long)featureSize);
                    ++this.rowIdPrevious;
                    if (!this.cacheRowAddress) continue;
                    this.rowIndexToFileLocation.put((int)this.rowIdPrevious + 1, this.fileChannel.position());
                }
            }
            if (this.rowIdPrevious + 1L == rowId) {
                this.rowIdPrevious = rowId;
                this.currentRow = FGBDriver.getFieldsFromFileLocation(this.fileChannel, this.fileChannel.position() - this.featuresOffset, this.featuresOffset, this.headerMeta, this.geometryFieldIndex);
                if (this.cacheRowAddress) {
                    this.rowIndexToFileLocation.put((int)rowId + 1, this.fileChannel.position());
                }
            }
            return this.currentRow[columnId];
        }
        catch (IOException e) {
            throw new NoSuchElementException();
        }
    }

    public long getFeaturesOffset() {
        return this.featuresOffset;
    }

    public void insertRow(Object[] values) throws IOException {
        throw new IOException("Unsupported write operation");
    }

    private static String readString(ByteBuffer bb) {
        int length = bb.getInt();
        byte[] stringBytes = new byte[length];
        bb.get(stringBytes, 0, length);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }

    public int getGeometryFieldIndex() {
        return this.geometryFieldIndex;
    }

    public static class FGBDriverCursor
    implements Cursor {
        static final Logger LOGGER = LoggerFactory.getLogger(FGBDriver.class);
        PackedRTree.SearchResult searchResult;
        FGBDriver fgbDriver;
        int position = -1;
        Row currentRow = null;

        public FGBDriverCursor(PackedRTree.SearchResult searchResult, FGBDriver fgbDriver) {
            this.searchResult = searchResult;
            this.fgbDriver = fgbDriver;
        }

        public Row get() {
            return this.currentRow;
        }

        public SearchRow getSearchRow() {
            return null;
        }

        public boolean next() {
            if (this.position < this.searchResult.hits.size() - 1) {
                ++this.position;
                return this.fetchRow();
            }
            return false;
        }

        private boolean fetchRow() {
            try {
                Value[] values = FGBDriver.getFieldsFromFileLocation(this.fgbDriver.fileChannel, ((PackedRTree.SearchHit)this.searchResult.hits.get((int)this.position)).offset, this.fgbDriver.getFeaturesOffset(), this.fgbDriver.getHeader(), this.fgbDriver.getGeometryFieldIndex());
                this.currentRow = new DefaultRow(values);
            }
            catch (IOException ex) {
                LOGGER.warn("Issue when fetching record", (Throwable)ex);
                return false;
            }
            return true;
        }

        public boolean previous() {
            if (this.position > 0) {
                --this.position;
                return this.fetchRow();
            }
            return false;
        }
    }
}

