/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.fgb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.fgb.FGBDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class FGBWrite
extends AbstractFunction
implements ScalarFunction {
    public FGBWrite() {
        this.addProperty("remarks", "Export a spatial table to a FlatGeobuf file.\n \nFGBWrite(...\n Supported arguments :\n path of the file, table name\n path of the file, table name, true to delete the file if exists\n path of the file, table name, true to delete the file if exists,options default 'createIndex=true nodeSize=16'");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static void execute(Connection connection, String fileName, String tableReference, boolean deleteFile, String option) throws SQLException, IOException {
        FGBDriverFunction geobufDriverFunction = new FGBDriverFunction();
        geobufDriverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), option, deleteFile, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void execute(Connection connection, String fileName, String tableReference, boolean deleteFile) throws SQLException, IOException {
        FGBWrite.execute(connection, fileName, tableReference, deleteFile, "");
    }

    public static void execute(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        FGBWrite.execute(connection, fileName, tableReference, false);
    }
}

