/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class DBFRead
extends AbstractFunction
implements ScalarFunction {
    public DBFRead() {
        this.addProperty("remarks", "Read a DBase III file and copy the content into a new table in the database\n DBFRead(...\n Supported arguments :\n path of the file\n path of the file, table name\n path of the file, table name, true to delete the table name\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the table name");
    }

    public String getJavaStaticMethod() {
        return "importTable";
    }

    public static void importTable(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        DBFRead.importTable(connection, fileName, tableName, null, false);
    }

    public static void importTable(Connection connection, String fileName, Value option) throws IOException, SQLException {
        String tableReference = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
            String name = URIUtilities.fileFromString((String)fileName).getName();
            tableReference = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
            if (!tableReference.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
                throw new SQLException("The file name contains unsupported characters");
            }
        } else if (option instanceof ValueVarchar) {
            tableReference = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        DBFDriverFunction dbfDriverFunction = new DBFDriverFunction();
        dbfDriverFunction.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), null, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void importTable(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        String encoding = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        DBFDriverFunction dbfDriverFunction = new DBFDriverFunction();
        dbfDriverFunction.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void importTable(Connection connection, String fileName, String tableReference, String fileEncoding, boolean deleteTable) throws IOException, SQLException {
        DBFDriverFunction dbfDriverFunction = new DBFDriverFunction();
        dbfDriverFunction.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), fileEncoding, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
    }
}

